/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Image;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientRootChildren;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsRootNode;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class JaxWsClientRootNode
extends AbstractNode {
    private static final Image WEB_SERVICES_BADGE = Utilities.loadImage((String)"org/netbeans/modules/websvc/core/webservices/ui/resources/webservicegroup.png", (boolean)true);
    private final DataFolder srcFolder;

    public JaxWsClientRootNode(JaxWsModel jaxWsModel, FileObject srcRoot) {
        super((Children)new JaxWsClientRootChildren(jaxWsModel, srcRoot), JaxWsClientRootNode.createLookup(srcRoot));
        this.setDisplayName(NbBundle.getBundle(JaxWsClientRootNode.class).getString("LBL_ServiceReferences"));
        this.srcFolder = srcRoot.isFolder() ? DataFolder.findFolder((FileObject)srcRoot) : null;
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    static synchronized Icon getFolderIcon(boolean opened) {
        if (JaxWsRootNode.openedFolderIconCache == null) {
            Node n = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
            JaxWsRootNode.openedFolderIconCache = new ImageIcon(n.getOpenedIcon(1));
            JaxWsRootNode.folderIconCache = new ImageIcon(n.getIcon(1));
        }
        if (opened) {
            return JaxWsRootNode.openedFolderIconCache;
        }
        return JaxWsRootNode.folderIconCache;
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = JaxWsClientRootNode.getFolderIcon(opened);
        Image image = ((ImageIcon)icon).getImage();
        image = Utilities.mergeImages((Image)image, (Image)WEB_SERVICES_BADGE, (int)7, (int)7);
        return image;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(ToolsAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static Lookup createLookup(FileObject srcRoot) {
        Project owner = FileOwnerQuery.getOwner((FileObject)srcRoot);
        return owner != null ? Lookups.fixed((Object[])new Object[]{owner}) : null;
    }
}

