/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.Utilities;
import org.netbeans.modules.websvc.core.client.wizard.WebServiceClientCreator;
import org.netbeans.modules.websvc.core.client.wizard.WebServiceClientWizardDescriptor;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class WebServiceClientWizardIterator
implements TemplateWizard.Iterator {
    private int index = 0;
    private WizardDescriptor.Panel[] panels;
    private TemplateWizard wiz;
    private Project project;

    public static WebServiceClientWizardIterator create() {
        return new WebServiceClientWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new WebServiceClientWizardDescriptor()};
    }

    public void initialize(TemplateWizard wizard) {
        this.wiz = wizard;
        this.project = Templates.getProject((WizardDescriptor)this.wiz);
        this.index = 0;
        this.panels = this.createPanels();
        Object prop = this.wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = Utilities.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            assert (c instanceof JComponent);
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wizard) {
        this.wiz = null;
        this.panels = null;
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
        DataObject dTemplate = DataObject.find((FileObject)template);
        new WebServiceClientCreator(this.project, (WizardDescriptor)wiz).create();
        return Collections.singleton(dTemplate);
    }

    public String name() {
        return NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"LBL_WebServiceClient");
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void previousPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

