/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.BooleanLiteral;
import org.netbeans.jmi.javamodel.CharLiteral;
import org.netbeans.jmi.javamodel.ClassExpression;
import org.netbeans.jmi.javamodel.DoubleLiteral;
import org.netbeans.jmi.javamodel.FloatLiteral;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.IntLiteral;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Literal;
import org.netbeans.jmi.javamodel.LongLiteral;
import org.netbeans.jmi.javamodel.NullLiteral;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class Utils {
    public static boolean isOfType(JavaClass javaClass, Type type) {
        String typeName = type.getName();
        if (javaClass.getName().equals(typeName)) {
            return true;
        }
        if (javaClass.getName().equals("java.lang.Object")) {
            return false;
        }
        for (JavaClass intf : javaClass.getInterfaces()) {
            if (intf.getName().equals(typeName)) {
                return true;
            }
            if (!Utils.isOfType(intf, type)) continue;
            return true;
        }
        return Utils.isOfType(javaClass.getSuperClass(), type);
    }

    public static boolean containsClass(Library library, String className) {
        List roots = library.getContent("classpath");
        for (URL rootUrl : roots) {
            String classRelativePath;
            FileObject archiveRoot;
            FileObject root = URLMapper.findFileObject((URL)rootUrl);
            if (root == null || !"jar".equals(rootUrl.getProtocol()) || (archiveRoot = FileUtil.getArchiveRoot((FileObject)FileUtil.getArchiveFile((FileObject)root))).getFileObject(classRelativePath = className.replace('.', '/') + ".class") == null) continue;
            return true;
        }
        return false;
    }

    public static Map getNNAttributes(Annotation annotation) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (AttributeValue attributeValue : annotation.getAttributeValues()) {
            attributes.put(attributeValue.getDefinition().getName(), Utils.stringValue(attributeValue));
        }
        return attributes;
    }

    public static String stringValue(AttributeValue attrVal) {
        InitialValue value = attrVal.getValue();
        String result = Utils.valueToString(value);
        if (result == null && (result = value.getResource().getSourceText().substring(value.getStartOffset(), value.getEndOffset())).startsWith("\"") && result.endsWith("\"")) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    private static String valueToString(InitialValue value) {
        Type type;
        if (value instanceof Literal) {
            if (value instanceof StringLiteral) {
                return ((StringLiteral)value).getValue();
            }
            if (value instanceof IntLiteral) {
                return Integer.toString(((IntLiteral)value).getValue());
            }
            if (value instanceof BooleanLiteral) {
                return Boolean.toString(((BooleanLiteral)value).isValue());
            }
            if (value instanceof LongLiteral) {
                return Long.toString(((LongLiteral)value).getValue());
            }
            if (value instanceof DoubleLiteral) {
                return Double.toString(((DoubleLiteral)value).getValue());
            }
            if (value instanceof CharLiteral) {
                return ((CharLiteral)value).getValue();
            }
            if (value instanceof FloatLiteral) {
                return Float.toString(((FloatLiteral)value).getValue());
            }
            if (value instanceof NullLiteral) {
                return "null";
            }
        } else if (value instanceof ClassExpression && (type = ((ClassExpression)value).getType()) != null) {
            return type.getName();
        }
        return null;
    }

    public static boolean containsService(Library library, String serviceName) {
        List roots = library.getContent("classpath");
        for (URL rootUrl : roots) {
            String serviceRelativePath;
            FileObject archiveRoot;
            FileObject root = URLMapper.findFileObject((URL)rootUrl);
            if (root == null || !"jar".equals(rootUrl.getProtocol()) || (archiveRoot = FileUtil.getArchiveRoot((FileObject)FileUtil.getArchiveFile((FileObject)root))).getFileObject(serviceRelativePath = "META-INF/services/" + serviceName) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean containsClass(LibraryImplementation library, String className) {
        List roots = library.getContent("classpath");
        for (URL rootUrl : roots) {
            String classRelativePath;
            FileObject archiveRoot;
            FileObject root = URLMapper.findFileObject((URL)rootUrl);
            if (root == null || !"jar".equals(rootUrl.getProtocol()) || (archiveRoot = FileUtil.getArchiveRoot((FileObject)FileUtil.getArchiveFile((FileObject)root))).getFileObject(classRelativePath = className.replace('.', '/') + ".class") == null) continue;
            return true;
        }
        return false;
    }

    public static boolean containsService(LibraryImplementation library, String serviceName) {
        List roots = library.getContent("classpath");
        for (URL rootUrl : roots) {
            String serviceRelativePath;
            FileObject archiveRoot;
            FileObject root = URLMapper.findFileObject((URL)rootUrl);
            if (root == null || !"jar".equals(rootUrl.getProtocol()) || (archiveRoot = FileUtil.getArchiveRoot((FileObject)FileUtil.getArchiveFile((FileObject)root))).getFileObject(serviceRelativePath = "META-INF/services/" + serviceName) == null) continue;
            return true;
        }
        return false;
    }
}

