/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.spi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.ServiceAlreadyExistsExeption;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperGenerator;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperHandler;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportImpl;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.ErrorManager;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.xml.sax.SAXException;

public abstract class ProjectJAXWSSupport
implements JAXWSSupportImpl {
    private Project project;
    private AntProjectHelper antProjectHelper;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ProjectJAXWSSupport(Project project, AntProjectHelper antProjectHelper) {
        this.project = project;
        this.antProjectHelper = antProjectHelper;
    }

    public void removeService(String serviceName) {
        Service service;
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (service = jaxWsModel.findServiceByName(serviceName)) != null) {
            jaxWsModel.removeService(serviceName);
            this.writeJaxWsModel(jaxWsModel);
            WSUtils.removeImplClass((Project)this.project, (String)service.getImplementationClass());
        }
    }

    public void serviceFromJavaRemoved(String serviceName) {
    }

    public boolean isFromWSDL(String serviceName) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        Service service = jaxWsModel.findServiceByName(serviceName);
        return service != null && service.getWsdlUrl() != null;
    }

    public String getServiceImpl(String serviceName) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            Service service = jaxWsModel.findServiceByName(serviceName);
            return service == null ? null : service.getImplementationClass();
        }
        return null;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.antProjectHelper;
    }

    public void addService(String serviceName, String serviceImpl, boolean isJsr109) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            Boolean value = jaxWsModel.getJsr109();
            if ((value == null || Boolean.TRUE.equals(value)) && !isJsr109) {
                jaxWsModel.setJsr109(Boolean.FALSE);
                this.writeJaxWsModel(jaxWsModel);
            } else if (Boolean.FALSE.equals(value) && isJsr109) {
                jaxWsModel.setJsr109(Boolean.TRUE);
                this.writeJaxWsModel(jaxWsModel);
            }
        }
        if (!isJsr109) {
            try {
                this.addJaxwsArtifacts(this.project, serviceName, serviceImpl);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    protected abstract void addJaxwsArtifacts(Project var1, String var2, String var3) throws Exception;

    public String addService(String name, String serviceImpl, String wsdlUrl, String serviceName, String portName, String packageName, boolean isJsr109) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            FileObject serviceArtifactsFolder;
            ArrayList<FileObject> subfolders;
            boolean serviceAdded;
            String finalServiceName;
            block35: {
                finalServiceName = WSUtils.findProperServiceName((String)name, (JaxWsModel)jaxWsModel);
                serviceAdded = false;
                subfolders = null;
                serviceArtifactsFolder = this.project.getProjectDirectory().getFileObject("build/generated/wsimport/service");
                if (serviceArtifactsFolder != null) {
                    Enumeration en = serviceArtifactsFolder.getChildren(true);
                    subfolders = new ArrayList<FileObject>();
                    while (en.hasMoreElements()) {
                        FileObject ch = (FileObject)en.nextElement();
                        if (!ch.isFolder()) continue;
                        subfolders.add(ch);
                    }
                }
                FileObject localWsdl = null;
                try {
                    Boolean value;
                    FileObject xmlResorcesFo = this.getLocalWsdlFolderForService(finalServiceName, true);
                    localWsdl = WSUtils.retrieveResource((FileObject)xmlResorcesFo, (URI)new URI(wsdlUrl));
                    if (localWsdl == null) break block35;
                    WsdlWrapperHandler handler = null;
                    try {
                        handler = WsdlWrapperGenerator.parse(localWsdl.getURL().toExternalForm());
                    }
                    catch (ParserConfigurationException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    catch (SAXException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    if (!handler.isServiceElement()) {
                        StreamSource source = new StreamSource(localWsdl.getURL().toExternalForm());
                        try {
                            File wrapperWsdlFile = new File(FileUtil.toFile((FileObject)localWsdl.getParent()), WsdlWrapperGenerator.getWrapperName(localWsdl.getURL()));
                            if (!wrapperWsdlFile.exists()) {
                                try {
                                    wrapperWsdlFile.createNewFile();
                                }
                                catch (IOException ex) {
                                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                                }
                            }
                            if (wrapperWsdlFile.exists()) {
                                WsdlWrapperGenerator.generateWrapperWSDLContent(wrapperWsdlFile, source, handler.getTargetNsPrefix(), localWsdl.getNameExt());
                                localWsdl = FileUtil.toFileObject((File)wrapperWsdlFile);
                            }
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                    if (((value = jaxWsModel.getJsr109()) == null || Boolean.TRUE.equals(value)) && !isJsr109) {
                        jaxWsModel.setJsr109(Boolean.FALSE);
                    } else if (Boolean.FALSE.equals(value) && isJsr109) {
                        jaxWsModel.setJsr109(Boolean.TRUE);
                    }
                    Service service = null;
                    try {
                        service = jaxWsModel.addService(finalServiceName, serviceImpl, wsdlUrl, serviceName, portName, packageName);
                    }
                    catch (ServiceAlreadyExistsExeption ex) {
                        // empty catch block
                    }
                    String localWsdlUrl = FileUtil.getRelativePath((FileObject)xmlResorcesFo, (FileObject)localWsdl);
                    service.setLocalWsdlFile(localWsdlUrl);
                    FileObject catalog = this.getCatalogFileObject();
                    if (catalog != null) {
                        service.setCatalogFile("catalog.xml");
                    }
                    this.writeJaxWsModel(jaxWsModel);
                    serviceAdded = true;
                    FileObject wsdlFolder = this.getWsdlFolderForService(finalServiceName);
                    WSUtils.copyFiles((FileObject)xmlResorcesFo, (FileObject)wsdlFolder);
                }
                catch (URISyntaxException ex) {
                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                }
                catch (UnknownHostException ex) {
                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                }
            }
            if (serviceAdded) {
                if (!isJsr109) {
                    try {
                        this.addJaxwsArtifacts(this.project, serviceName, serviceImpl);
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                FileObject buildImplFo = this.project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
                try {
                    ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-service-" + finalServiceName}, null);
                    wsimportTask.waitFinished();
                    if (serviceArtifactsFolder == null) {
                        serviceArtifactsFolder = this.project.getProjectDirectory().getFileObject("build/generated/wsimport/service/" + packageName.replace('.', '/'));
                    }
                    if (serviceArtifactsFolder != null) {
                        serviceArtifactsFolder.refresh();
                        if (subfolders != null) {
                            for (int i = 0; i < subfolders.size(); ++i) {
                                ((FileObject)subfolders.get(i)).refresh();
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
                return finalServiceName;
            }
        }
        return null;
    }

    public List getServices() {
        Service[] services;
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (services = jaxWsModel.getServices()) != null) {
            ArrayList<Service> list = new ArrayList<Service>();
            for (int i = 0; i < services.length; ++i) {
                list.add(services[i]);
            }
            return list;
        }
        return new ArrayList();
    }

    private void writeJaxWsModel(final JaxWsModel jaxWsModel) {
        try {
            final FileObject jaxWsFo = this.project.getProjectDirectory().getFileObject("nbproject/jax-ws.xml");
            jaxWsFo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    FileLock lock = null;
                    OutputStream os = null;
                    try {
                        lock = jaxWsFo.lock();
                        os = jaxWsFo.getOutputStream(lock);
                        jaxWsModel.write(os);
                        os.close();
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public FileObject getLocalWsdlFolderForService(String serviceName, boolean createFolder) {
        return this.getArtifactsFolder(serviceName, createFolder, true);
    }

    public FileObject getBindingsFolderForService(String serviceName, boolean createFolder) {
        return this.getArtifactsFolder(serviceName, createFolder, false);
    }

    private FileObject getArtifactsFolder(String serviceName, boolean createFolder, boolean forWsdl) {
        String folderName = forWsdl ? "wsdl" : "bindings";
        FileObject root = this.getXmlArtifactsRoot();
        if (root == null) {
            if (!$assertionsDisabled && createFolder) {
                throw new AssertionError((Object)"Cannot create XML artifacts folder");
            }
            return null;
        }
        FileObject wsdlLocalFolder = root.getFileObject("xml-resources/web-services/" + serviceName + "/" + folderName);
        if (wsdlLocalFolder == null && createFolder) {
            try {
                FileObject serviceLocalFolder;
                FileObject servicesLocalFolder;
                FileObject xmlLocalFolder = root.getFileObject("xml-resources");
                if (xmlLocalFolder == null) {
                    xmlLocalFolder = root.createFolder("xml-resources");
                }
                if ((servicesLocalFolder = xmlLocalFolder.getFileObject("web-services")) == null) {
                    servicesLocalFolder = xmlLocalFolder.createFolder("web-services");
                }
                if ((serviceLocalFolder = servicesLocalFolder.getFileObject(serviceName)) == null) {
                    serviceLocalFolder = servicesLocalFolder.createFolder(serviceName);
                }
                if ((wsdlLocalFolder = serviceLocalFolder.getFileObject(folderName)) == null) {
                    wsdlLocalFolder = serviceLocalFolder.createFolder(folderName);
                }
            }
            catch (IOException ex) {
                return null;
            }
        }
        return wsdlLocalFolder;
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getProjectDirectory();
    }

    private FileObject getCatalogFileObject() {
        return this.project.getProjectDirectory().getFileObject("catalog.xml");
    }

    public URL getCatalog() {
        try {
            FileObject catalog = this.getCatalogFileObject();
            return catalog == null ? null : catalog.getURL();
        }
        catch (FileStateInvalidException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getWsdlFolderForService(String name) throws IOException {
        FileObject globalWsdlFolder = this.getWsdlFolder(true);
        FileObject oldWsdlFolder = globalWsdlFolder.getFileObject(name);
        if (oldWsdlFolder != null) {
            FileLock lock = oldWsdlFolder.lock();
            try {
                oldWsdlFolder.delete(lock);
            }
            finally {
                lock.releaseLock();
            }
        }
        return globalWsdlFolder.createFolder(name);
    }

    public abstract FileObject getWsdlFolder(boolean var1) throws IOException;

    public abstract String getWsdlLocation(String var1);

    static {
        $assertionsDisabled = !ProjectJAXWSSupport.class.desiredAssertionStatus();
    }
}

