/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.watchesfiltering;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.Variable;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class JspElWatch
implements PropertyChangeListener {
    private final Watch watch;
    private boolean evaluated = false;
    private JPDADebugger debugger;
    private Variable variable;
    private Exception exception;

    public JspElWatch(Watch w, JPDADebugger debugger) {
        this.watch = w;
        this.debugger = debugger;
        w.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)w));
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public String getType() {
        if (!this.evaluated) {
            this.evaluate();
        }
        return this.variable == null ? "" : this.variable.getType();
    }

    public String getValue() {
        if (!this.evaluated) {
            this.evaluate();
        }
        return this.variable == null ? "" : this.variable.getValue();
    }

    public String getExceptionDescription() {
        if (!this.evaluated) {
            this.evaluate();
        }
        return this.exception == null ? null : this.exception.getMessage();
    }

    public String getToStringValue() throws InvalidExpressionException {
        return this.getValue().toString();
    }

    public Watch getWatch() {
        return this.watch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void evaluate() {
        String text = this.watch.getExpression();
        text = Utilities.replaceString((String)text, (String)"\"", (String)"\\\"");
        text = "pageContext.getExpressionEvaluator().evaluate(\"" + text + "\", java.lang.String.class, (javax.servlet.jsp.PageContext)pageContext, null)";
        try {
            this.variable = this.debugger.evaluate(text);
            this.exception = null;
        }
        catch (Exception e) {
            this.exception = e;
        }
        finally {
            this.evaluated = true;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setUnevaluated();
    }

    public void setUnevaluated() {
        this.evaluated = false;
    }
}

