/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.welcome.WelcomeOptions;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.CombinationRSSFeed;
import org.netbeans.modules.welcome.content.RSSFeed;
import org.netbeans.modules.welcome.content.RSSFeedReaderPanel;
import org.netbeans.modules.welcome.content.WebLink;

public class ArticlesAndNews
extends RSSFeedReaderPanel {
    private RSSFeed feed;
    private static final boolean firstTimeStart = WelcomeOptions.getDefault().isFirstTimeStart();
    private boolean firstTimeLoad = true;

    public ArticlesAndNews() {
        super("ArticlesAndNews");
        WelcomeOptions.getDefault().setFirstTimeStart(false);
        this.setBottomContent(this.buildBottomContent());
    }

    protected JComponent buildContent(String url) {
        String ideId;
        Settings autoUpdateSettings = (Settings)Settings.findObject((Class)Settings.class);
        if (null != autoUpdateSettings && null != (ideId = autoUpdateSettings.getIdeIdentity()) && ideId.length() > 0) {
            url = url + "?unique=" + ideId;
        }
        this.feed = new ArticlesAndNewsRSSFeed(url, BundleSupport.getURL("News"));
        this.feed.addPropertyChangeListener("feedContent", this);
        return this.feed;
    }

    protected JComponent buildBottomContent() {
        WebLink news = new WebLink("AllNews", false);
        news.setFont(HEADER_FONT);
        WebLink articles = new WebLink("AllArticles", false);
        articles.setFont(HEADER_FONT);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.add((Component)news, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)articles, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 14, 2, new Insets(5, 5, 0, 5), 0, 0));
        return panel;
    }

    protected void feedContentLoaded() {
        if (this.firstTimeLoad) {
            this.firstTimeLoad = false;
            this.requestAttention();
        }
    }

    private class ArticlesAndNewsRSSFeed
    extends CombinationRSSFeed {
        private JPanel contentHeader;

        public ArticlesAndNewsRSSFeed(String url1, String url2) {
            super(url1, url2);
        }

        protected Component getContentHeader() {
            if (firstTimeStart) {
                if (null == this.contentHeader) {
                    this.contentHeader = new JPanel(new GridBagLayout());
                    this.contentHeader.setOpaque(false);
                    JLabel lblHeader = new JLabel(BundleSupport.getLabel("FirstTimeHeader"));
                    lblHeader.setFont(WELCOME_HEADER_FONT);
                    JLabel lblDescription = new JLabel(BundleSupport.getLabel("FirstTimeDescription"));
                    lblDescription.setFont(WELCOME_DESCRIPTION_FONT);
                    this.contentHeader.add((Component)lblHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(15, 10, 5, 10), 0, 0));
                    this.contentHeader.add((Component)lblDescription, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 25, 10), 0, 0));
                }
                return this.contentHeader;
            }
            return null;
        }
    }
}

