/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.common.api.J2eeLibraryTypeProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.J2eePlatformImpl;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DeploymentManagerProperties;
import org.netbeans.modules.j2ee.sun.ide.j2ee.PlatformFactory;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PlatformImpl
extends J2eePlatformImpl {
    private static final Set MODULE_TYPES = new HashSet();
    private static final Set SPEC_VERSIONS = new HashSet();
    private static final Set SPEC_VERSIONS_WITH_5 = new HashSet();
    private static final String APPSERVER_VERSION_9 = "9.0";
    private static final String APPSERVER_VERSION_8_1 = "8.1";
    private static final String APPSERVER_VERSION_8_2 = "8.2";
    private static final String APPSERVER_VERSION_UNKNOWN = "unknown";
    private String version = "unknown";
    private static final String J2EE_14_JAR = "lib/j2ee.jar";
    private static final String JAVA_EE_JAR = "lib/javaee.jar";
    private static final String JSF_API_JAR = "lib/jsf-api.jar";
    private static final String JSF_IMPL_JAR = "lib/jsf-impl.jar";
    private static final String JAX_QNAME_JAR = "lib/jax-qname.jar";
    private static final String JAXRPC_API_JAR = "lib/jaxrpc-api.jar";
    private static final String JAXRPC_IMPL_JAR = "lib/jaxrpc-impl.jar";
    private static final String JAXR_API_JAR = "lib/jaxr-api.jar";
    private static final String JAXR_IMPL_JAR = "lib/jaxr-impl.jar";
    private static final String SAAJ_API_JAR = "lib/saaj-api.jar";
    private static final String SAAJ_IMPL_JAR = "lib/saaj-impl.jar";
    private static final String ACTIVATION_JAR = "lib/activation.jar";
    private static final String TAGS_JAR = "lib/appserv-tags.jar";
    private static final String MAIL_JAR = "lib/mail.jar";
    private static final String JSTL_JAR = "lib/appserv-jstl.jar";
    private static final String APPSERV_WS_JAR = "lib/appserv-ws.jar";
    private static final String TOOLS_JAR = "lib/tools.jar";
    private static final String JWSDP_JAR = "lib/appserv-ws-update.jar";
    private static final String JAXWSA_API_JAR = "lib/jaxwsa-api.jar";
    private static final String JAXWSA_RI_JAR = "lib/jaxwsa-ri.jar";
    private static final String WEBSERVICES_JAR = "lib/webservices.jar";
    private static final String WEBSERVICES_RT_JAR = "lib/webservices-rt.jar";
    private static final String WEBSERVICES_TOOLS_JAR = "lib/webservices-tools.jar";
    private static final String[] KEYSTORE_LOCATION = new String[]{"config/keystore.jks"};
    private static final String[] TRUSTSTORE_LOCATION = new String[]{"config/cacerts.jks"};
    private static final String[] KEYSTORE_CLIENT_LOCATION = new String[]{"config/keystore.jks"};
    private static final String[] TRUSTSTORE_CLIENT_LOCATION = new String[]{"config/cacerts.jks"};
    private static final String PERSISTENCE_PROV_TOPLINK = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    private static final String PERSISTENCE_PROV_TOPLINK_DEFAULT = "toplinkPersistenceProviderIsDefault";
    private final File root;
    private final DeploymentManagerProperties dmProps;
    private LibraryImplementation[] libraries;

    public PlatformImpl(File root, DeploymentManagerProperties dmProps) {
        this.dmProps = dmProps;
        this.root = root;
    }

    public String isValidPlatformRoot(File platformRoot) {
        String result = "";
        if (platformRoot == null || "".equals(platformRoot.getPath())) {
            result = "Install directory cannot be empty.";
        } else if (!platformRoot.exists()) {
            result = "Directory '" + platformRoot.getAbsolutePath() + "' does not exist.";
        } else {
            this.version = this.getAppServerVersion(platformRoot);
            File testF = new File(platformRoot, "bin");
            if (!testF.exists()) {
                result = "'" + platformRoot.getAbsolutePath() + "' is not a SJSAS 8.1 installation directory.";
            }
            if (!(testF = new File(platformRoot, "lib")).exists()) {
                result = "'" + platformRoot.getAbsolutePath() + "' is not a SJSAS 8.1 installation directory.";
            }
        }
        return result;
    }

    public String getAppServerVersion(File asInstallRoot) {
        this.version = APPSERVER_VERSION_UNKNOWN;
        if (asInstallRoot != null && asInstallRoot.exists()) {
            File sunDomain11Dtd = new File(asInstallRoot, "lib/dtds/sun-domain_1_1.dtd");
            File as9 = new File(asInstallRoot + "/lib/dtds/sun-web-app_2_5-0.dtd");
            if (as9.exists()) {
                this.version = APPSERVER_VERSION_9;
            } else if (sunDomain11Dtd.exists()) {
                this.version = APPSERVER_VERSION_8_1;
            }
        }
        return this.version;
    }

    private void initLibraries() {
        ArrayList<LibraryImplementation> libs = new ArrayList<LibraryImplementation>();
        if ("".equals(this.isValidPlatformRoot(this.root))) {
            try {
                List<URL> sources = this.dmProps.getSources();
                List<URL> javadoc = this.dmProps.getJavadocs();
                J2eeLibraryTypeProvider lp = new J2eeLibraryTypeProvider();
                LibraryImplementation lib = lp.createLibrary();
                lib.setName(NbBundle.getMessage(PlatformFactory.class, (String)"j2ee14"));
                ArrayList<URL> l = new ArrayList<URL>();
                File ff = new File(this.root, JAVA_EE_JAR);
                if (!ff.exists()) {
                    l.add(this.fileToUrl(new File(this.root, J2EE_14_JAR)));
                } else {
                    l.add(this.fileToUrl(ff));
                }
                lib.setContent("classpath", l);
                lib.setContent("src", sources);
                lib.setContent("javadoc", javadoc);
                libs.add(lib);
                lib = lp.createLibrary();
                lib.setName(NbBundle.getMessage(PlatformImpl.class, (String)"jsf11"));
                l = new ArrayList();
                l.add(this.fileToUrl(new File(this.root, JSF_API_JAR)));
                l.add(this.fileToUrl(new File(this.root, JSF_IMPL_JAR)));
                l.add(this.fileToUrl(new File(this.root, ACTIVATION_JAR)));
                l.add(this.fileToUrl(new File(this.root, TAGS_JAR)));
                l.add(this.fileToUrl(new File(this.root, MAIL_JAR)));
                l.add(this.fileToUrl(new File(this.root, JSTL_JAR)));
                lib.setContent("classpath", l);
                lib.setContent("src", sources);
                lib.setContent("javadoc", javadoc);
                libs.add(lib);
                lib = lp.createLibrary();
                lib.setName(NbBundle.getMessage(PlatformImpl.class, (String)"jwsdp"));
                l = new ArrayList();
                l.add(this.fileToUrl(new File(this.root, JWSDP_JAR)));
                l.add(this.fileToUrl(new File(this.root, JAXWSA_API_JAR)));
                l.add(this.fileToUrl(new File(this.root, JAXWSA_RI_JAR)));
                lib.setContent("classpath", l);
                libs.add(lib);
                lib = lp.createLibrary();
                lib.setName(NbBundle.getMessage(PlatformImpl.class, (String)"wsit"));
                l.add(this.fileToUrl(new File(this.root, WEBSERVICES_TOOLS_JAR)));
                l.add(this.fileToUrl(new File(this.root, WEBSERVICES_RT_JAR)));
                l.add(this.fileToUrl(new File(this.root, WEBSERVICES_JAR)));
                lib.setContent("classpath", l);
                lib.setContent("src", sources);
                lib.setContent("javadoc", javadoc);
                libs.add(lib);
                lib = lp.createLibrary();
                lib.setName(NbBundle.getMessage(PlatformImpl.class, (String)"jaxqname"));
                l = new ArrayList();
                l.add(this.fileToUrl(new File(this.root, JAX_QNAME_JAR)));
                l.add(this.fileToUrl(new File(this.root, "lib/endorsed/jaxp-api.jar")));
                lib.setContent("classpath", l);
                lib.setContent("src", sources);
                lib.setContent("javadoc", javadoc);
                libs.add(lib);
                lib = lp.createLibrary();
                lib.setName(NbBundle.getMessage(PlatformImpl.class, (String)"jaxrpc11"));
                l = new ArrayList();
                l.add(this.fileToUrl(new File(this.root, APPSERV_WS_JAR)));
                l.add(this.fileToUrl(new File(this.root, JAXRPC_API_JAR)));
                l.add(this.fileToUrl(new File(this.root, JAXRPC_IMPL_JAR)));
                lib.setContent("classpath", l);
                lib.setContent("src", sources);
                lib.setContent("javadoc", javadoc);
                libs.add(lib);
                lib = lp.createLibrary();
                lib.setName(NbBundle.getMessage(PlatformImpl.class, (String)"jaxr10"));
                l = new ArrayList();
                l.add(this.fileToUrl(new File(this.root, JAXR_API_JAR)));
                l.add(this.fileToUrl(new File(this.root, JAXR_IMPL_JAR)));
                lib.setContent("classpath", l);
                lib.setContent("src", sources);
                lib.setContent("javadoc", javadoc);
                libs.add(lib);
                lib = lp.createLibrary();
                lib.setName(NbBundle.getMessage(PlatformImpl.class, (String)"saaj12"));
                l = new ArrayList();
                l.add(this.fileToUrl(new File(this.root, SAAJ_API_JAR)));
                l.add(this.fileToUrl(new File(this.root, SAAJ_IMPL_JAR)));
                lib.setContent("classpath", l);
                lib.setContent("src", sources);
                lib.setContent("javadoc", javadoc);
                libs.add(lib);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        this.libraries = libs.toArray(new LibraryImplementation[libs.size()]);
    }

    public LibraryImplementation[] getLibraries() {
        if (this.libraries == null) {
            this.initLibraries();
        }
        return this.libraries;
    }

    public void notifyLibrariesChanged() {
        this.initLibraries();
        this.firePropertyChange("libraries", null, this.libraries);
    }

    public String getDisplayName() {
        return this.dmProps.getDisplayName();
    }

    public Image getIcon() {
        return Utilities.loadImage((String)"org/netbeans/modules/j2ee/sun/ide/resources/ServerInstanceIcon.png");
    }

    public File[] getPlatformRoots() {
        return new File[]{this.root};
    }

    public File[] getToolClasspathEntries(String toolName) {
        if ("wscompile".equals(toolName) && this.isValidPlatformRoot(this.root).equals("")) {
            return new File[]{new File(this.root, J2EE_14_JAR), new File(this.root, SAAJ_API_JAR), new File(this.root, SAAJ_IMPL_JAR), new File(this.root, JAXRPC_API_JAR), new File(this.root, JAXRPC_IMPL_JAR), new File(this.root, "lib/endorsed/jaxp-api.jar"), new File(this.root, APPSERV_WS_JAR)};
        }
        if ("appClientRuntime".equals(toolName) && this.isValidPlatformRoot(this.root).equals("")) {
            return new File[]{new File(this.root, "lib/appserv-admin.jar"), new File(this.root, "lib/appserv-cmp.jar"), new File(this.root, "lib/appserv-ext.jar"), new File(this.root, "lib/appserv-rt.jar"), new File(this.root, APPSERV_WS_JAR), new File(this.root, "lib/dbschema.jar"), new File(this.root, "lib/fscontext.jar"), new File(this.root, J2EE_14_JAR), new File(this.root, "lib/xalan.jar"), new File(this.root, "lib/xercesImpl.jar"), new File(this.root, "lib/install/applications/jmsra/imqjmsra.jar"), new File(this.root, "lib/dtds"), new File(this.root, "lib/schemas")};
        }
        if ("keystore".equals(toolName) && this.isValidPlatformRoot(this.root).equals("")) {
            File keyStoreLoc = new File(new File(this.dmProps.getInstanceProperties().getProperty("LOCATION")), this.dmProps.getInstanceProperties().getProperty("DOMAIN") + File.separator + KEYSTORE_CLIENT_LOCATION[0]);
            return new File[]{keyStoreLoc};
        }
        if ("keystoreClient".equals(toolName) && this.isValidPlatformRoot(this.root).equals("")) {
            File keyStoreClientLoc = new File(new File(this.dmProps.getInstanceProperties().getProperty("LOCATION")), this.dmProps.getInstanceProperties().getProperty("DOMAIN") + File.separator + KEYSTORE_CLIENT_LOCATION[0]);
            return new File[]{keyStoreClientLoc};
        }
        if ("truststore".equals(toolName) && this.isValidPlatformRoot(this.root).equals("")) {
            File trustStoreLoc = new File(new File(this.dmProps.getInstanceProperties().getProperty("LOCATION")), this.dmProps.getInstanceProperties().getProperty("DOMAIN") + File.separator + TRUSTSTORE_LOCATION[0]);
            return new File[]{trustStoreLoc};
        }
        if ("truststoreClient".equals(toolName) && this.isValidPlatformRoot(this.root).equals("")) {
            File trustStoreClientLoc = new File(new File(this.dmProps.getInstanceProperties().getProperty("LOCATION")), this.dmProps.getInstanceProperties().getProperty("DOMAIN") + File.separator + TRUSTSTORE_CLIENT_LOCATION[0]);
            return new File[]{trustStoreClientLoc};
        }
        if ("wsgen".equals(toolName) || "wsimport".equals(toolName)) {
            File jwsdpJar = new File(this.root, JWSDP_JAR);
            File wsToolsJar = new File(this.root, WEBSERVICES_TOOLS_JAR);
            if (wsToolsJar != null && wsToolsJar.exists()) {
                if (this.isValidPlatformRoot(this.root).equals("")) {
                    return new File[]{new File(this.root, WEBSERVICES_TOOLS_JAR), new File(this.root, WEBSERVICES_RT_JAR), new File(this.root, WEBSERVICES_JAR), new File(this.root, TOOLS_JAR), new File(this.root, JSTL_JAR), new File(this.root, JAVA_EE_JAR), new File(this.root, APPSERV_WS_JAR), new File(this.root, MAIL_JAR), new File(this.root, ACTIVATION_JAR)};
                }
            } else if (jwsdpJar != null && jwsdpJar.exists()) {
                if (this.isValidPlatformRoot(this.root).equals("")) {
                    return new File[]{new File(this.root, JWSDP_JAR), new File(this.root, JAXWSA_API_JAR), new File(this.root, JAXWSA_RI_JAR), new File(this.root, TOOLS_JAR), new File(this.root, JSTL_JAR), new File(this.root, JAVA_EE_JAR), new File(this.root, APPSERV_WS_JAR), new File(this.root, MAIL_JAR), new File(this.root, ACTIVATION_JAR)};
                }
            } else if (this.isValidPlatformRoot(this.root).equals("")) {
                return new File[]{new File(this.root, TOOLS_JAR), new File(this.root, JSTL_JAR), new File(this.root, JAVA_EE_JAR), new File(this.root, APPSERV_WS_JAR), new File(this.root, MAIL_JAR), new File(this.root, ACTIVATION_JAR)};
            }
        }
        return null;
    }

    public boolean isToolSupported(String toolName) {
        if ("wscompile".equals(toolName) || "appClientRuntime".equals(toolName)) {
            return true;
        }
        if (!APPSERVER_VERSION_8_1.equals(this.version) && !APPSERVER_VERSION_8_2.equals(this.version)) {
            if ("wsgen".equals(toolName)) {
                return true;
            }
            if ("wsimport".equals(toolName)) {
                return true;
            }
            if ("jsr109".equals(toolName)) {
                return true;
            }
            if ("jwsdp".equals(toolName) && new File(this.root, JWSDP_JAR).exists()) {
                return true;
            }
            if ("wsit".equals(toolName) && new File(this.root, WEBSERVICES_TOOLS_JAR).exists()) {
                return true;
            }
            if ("keystore".equals(toolName)) {
                return true;
            }
            if ("keystoreClient".equals(toolName)) {
                return true;
            }
            if ("truststore".equals(toolName)) {
                return true;
            }
            if ("truststoreClient".equals(toolName)) {
                return true;
            }
            if ("jaxws-tester".equals(toolName)) {
                return true;
            }
            if (PERSISTENCE_PROV_TOPLINK.equals(toolName)) {
                return true;
            }
            if (PERSISTENCE_PROV_TOPLINK_DEFAULT.equals(toolName)) {
                return true;
            }
            if ("org.hibernate.ejb.HibernatePersistence".equals(toolName) || "kodo.persistence.PersistenceProviderImpl".equals(toolName)) {
                return true;
            }
        }
        return false;
    }

    public Set getSupportedSpecVersions() {
        if (APPSERVER_VERSION_9.equals(this.version)) {
            return SPEC_VERSIONS_WITH_5;
        }
        return SPEC_VERSIONS;
    }

    public Set getSupportedModuleTypes() {
        return MODULE_TYPES;
    }

    public Set getSupportedJavaPlatformVersions() {
        HashSet<String> versions = new HashSet<String>();
        versions.add("1.4");
        versions.add("1.5");
        return versions;
    }

    public JavaPlatform getJavaPlatform() {
        return null;
    }

    private URL fileToUrl(File file) throws MalformedURLException {
        URL url = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        }
        return url;
    }

    private String quotedString(String s) {
        return "\"" + s + "\"";
    }

    public String getToolProperty(String toolName, String propertyName) {
        if ("appClientRuntime".equals(toolName)) {
            if ("main.class".equals(propertyName)) {
                return "com.sun.enterprise.appclient.Main";
            }
            if ("main.class.args".equals(propertyName)) {
                return "-client ${dist.jar} ${j2ee.appclient.tool.args}";
            }
            if ("jvm.opts".equals(propertyName)) {
                StringBuilder sb = new StringBuilder();
                sb.append("-Dcom.sun.aas.configRoot=").append(this.quotedString(new File(this.root, "config").getAbsolutePath()));
                sb.append(" -Dcom.sun.aas.installRoot=").append(this.quotedString(this.root.getAbsolutePath()));
                sb.append(" -Dcom.sun.aas.imqLib=").append(this.quotedString(new File(this.root, "imq/lib").getAbsolutePath()));
                sb.append(" -Djava.security.policy=").append(this.quotedString(new File(this.root, "lib/appclient/client.policy").getAbsolutePath()));
                sb.append(" -Djava.security.auth.login.config=").append(this.quotedString(new File(this.root, "lib/appclient/appclientlogin.conf").getAbsolutePath()));
                sb.append(" -Djava.endorsed.dirs=").append(this.quotedString(new File(this.root, "lib/endorsed").getAbsolutePath()));
                sb.append(" -Djavax.xml.parsers.SAXParserFactory=com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
                sb.append(" -Djavax.xml.parsers.DocumentBuilderFactory=com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
                sb.append(" -Djavax.xml.transform.TransformerFactory=com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
                sb.append(" -Dorg.xml.sax.parser=org.xml.sax.helpers.XMLReaderAdapter");
                sb.append(" -Dorg.xml.sax.driver=com.sun.org.apache.xerces.internal.parsers.SAXParser");
                sb.append(" -Djava.util.logging.manager=com.sun.enterprise.server.logging.ACCLogManager");
                return sb.toString();
            }
            if ("j2ee.appclient.args".equals(propertyName)) {
                return "-configxml " + this.quotedString(new File(this.dmProps.getLocation(), this.dmProps.getDomainName() + "/config/sun-acc.xml").getAbsolutePath());
            }
        }
        return null;
    }

    static {
        MODULE_TYPES.add(J2eeModule.WAR);
        MODULE_TYPES.add(J2eeModule.EAR);
        MODULE_TYPES.add(J2eeModule.EJB);
        MODULE_TYPES.add(J2eeModule.CONN);
        MODULE_TYPES.add(J2eeModule.CLIENT);
        SPEC_VERSIONS.add("1.4");
        SPEC_VERSIONS.add("1.3");
        SPEC_VERSIONS_WITH_5.add("1.5");
        SPEC_VERSIONS_WITH_5.add("1.4");
        SPEC_VERSIONS_WITH_5.add("1.3");
    }
}

