/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.DynamicProperties;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParamType {
    public static final String TYPE = "Type";
    public static final String EDITABLE = "Editable";
    public static final String REQUIRED = "Required";
    public static final String PARAM_VALUE = "ParamValue";
    public static final String PARAM_LOCALE = "ParamLocale";
    public static final String PARAM_CHARSET = "ParamCharset";
    public static final String PARAM_MIN = "ParamMin";
    public static final String PARAM_MAX = "ParamMax";
    private String _Type = "text";
    private String _Editable = "false";
    private String _Required = "true";
    private List _ParamValue = new ArrayList();
    private boolean _ParamLocale;
    private boolean _ParamCharset;
    private String _ParamMin;
    private String _ParamMax;

    public ParamType() {
    }

    public ParamType(String type, String editable, String required) {
        this._Type = type;
        this._Editable = editable;
        this._Required = required;
    }

    public ParamType(ParamType source) {
        this(source, false);
    }

    public ParamType(ParamType source, boolean justData) {
        this._Type = source._Type;
        this._Editable = source._Editable;
        this._Required = source._Required;
        Iterator it = source._ParamValue.iterator();
        while (it.hasNext()) {
            String srcElement = (String)it.next();
            this._ParamValue.add(srcElement);
        }
        this._ParamLocale = source._ParamLocale;
        this._ParamCharset = source._ParamCharset;
        this._ParamMin = source._ParamMin;
        this._ParamMax = source._ParamMax;
    }

    public void setType(String value) {
        this._Type = value;
    }

    public String getType() {
        return this._Type;
    }

    public void setEditable(String value) {
        this._Editable = value;
    }

    public String getEditable() {
        return this._Editable;
    }

    public void setRequired(String value) {
        this._Required = value;
    }

    public String getRequired() {
        return this._Required;
    }

    public void setParamValue(String[] value) {
        if (value == null) {
            value = new String[]{};
        }
        this._ParamValue.clear();
        ((ArrayList)this._ParamValue).ensureCapacity(value.length);
        for (int i = 0; i < value.length; ++i) {
            this._ParamValue.add(value[i]);
        }
        if (value != null && value.length > 0) {
            this.setParamLocale(false);
            this.setParamCharset(false);
        }
    }

    public void setParamValue(int index, String value) {
        this._ParamValue.set(index, value);
    }

    public String[] getParamValue() {
        String[] arr = new String[this._ParamValue.size()];
        return this._ParamValue.toArray(arr);
    }

    public List fetchParamValueList() {
        return this._ParamValue;
    }

    public String getParamValue(int index) {
        return (String)this._ParamValue.get(index);
    }

    public int sizeParamValue() {
        return this._ParamValue.size();
    }

    public int addParamValue(String value) {
        this._ParamValue.add(value);
        int positionOfNewItem = this._ParamValue.size() - 1;
        if (positionOfNewItem == 0) {
            this.setParamLocale(false);
            this.setParamCharset(false);
        }
        return positionOfNewItem;
    }

    public int removeParamValue(String value) {
        int pos = this._ParamValue.indexOf(value);
        if (pos >= 0) {
            this._ParamValue.remove(pos);
        }
        return pos;
    }

    public void setParamLocale(boolean value) {
        this._ParamLocale = value;
        if (value) {
            this.setParamValue(null);
            this.setParamCharset(false);
        }
    }

    public boolean isParamLocale() {
        return this._ParamLocale;
    }

    public void setParamCharset(boolean value) {
        this._ParamCharset = value;
        if (value) {
            this.setParamValue(null);
            this.setParamLocale(false);
        }
    }

    public boolean isParamCharset() {
        return this._ParamCharset;
    }

    public void setParamMin(String value) {
        this._ParamMin = value;
    }

    public String getParamMin() {
        return this._ParamMin;
    }

    public void setParamMax(String value) {
        this._ParamMax = value;
    }

    public String getParamMax() {
        return this._ParamMax;
    }

    public void writeNode(Writer out) throws IOException {
        String myName = "param-type";
        this.writeNode(out, myName, "");
    }

    public void writeNode(Writer out, String nodeName, String indent) throws IOException {
        this.writeNode(out, nodeName, null, indent, new HashMap());
    }

    public void writeNode(Writer out, String nodeName, String namespace, String indent, Map namespaceMap) throws IOException {
        out.write(indent);
        out.write("<");
        if (namespace != null) {
            out.write((String)namespaceMap.get(namespace));
            out.write(":");
        }
        out.write(nodeName);
        if (this._Type != null) {
            out.write(" type='");
            DynamicProperties.writeXML(out, this._Type, true);
            out.write("'");
        }
        if (this._Editable != null) {
            out.write(" editable='");
            DynamicProperties.writeXML(out, this._Editable, true);
            out.write("'");
        }
        if (this._Required != null) {
            out.write(" required='");
            DynamicProperties.writeXML(out, this._Required, true);
            out.write("'");
        }
        out.write(">\n");
        String nextIndent = indent + "\t";
        Iterator it = this._ParamValue.iterator();
        while (it.hasNext()) {
            String element = (String)it.next();
            if (element == null) continue;
            out.write(nextIndent);
            out.write("<param-value");
            out.write(">");
            DynamicProperties.writeXML(out, element, false);
            out.write("</param-value>\n");
        }
        if (this._ParamLocale) {
            out.write(nextIndent);
            out.write("<param-locale");
            out.write("/>\n");
        }
        if (this._ParamCharset) {
            out.write(nextIndent);
            out.write("<param-charset");
            out.write("/>\n");
        }
        if (this._ParamMin != null) {
            out.write(nextIndent);
            out.write("<param-min");
            out.write(">");
            DynamicProperties.writeXML(out, this._ParamMin, false);
            out.write("</param-min>\n");
        }
        if (this._ParamMax != null) {
            out.write(nextIndent);
            out.write("<param-max");
            out.write(">");
            DynamicProperties.writeXML(out, this._ParamMax, false);
            out.write("</param-max>\n");
        }
        out.write(indent);
        out.write("</");
        if (namespace != null) {
            out.write((String)namespaceMap.get(namespace));
            out.write(":");
        }
        out.write(nodeName);
        out.write(">\n");
    }

    public void readNode(Node node) {
        this.readNode(node, new HashMap());
    }

    public void readNode(Node node, Map namespacePrefixes) {
        if (node.hasAttributes()) {
            String attrValue;
            Attr attr;
            NamedNodeMap attrs = node.getAttributes();
            boolean firstNamespaceDef = true;
            for (int attrNum = 0; attrNum < attrs.getLength(); ++attrNum) {
                attr = (Attr)attrs.item(attrNum);
                String attrName = attr.getName();
                if (!attrName.startsWith("xmlns:")) continue;
                if (firstNamespaceDef) {
                    firstNamespaceDef = false;
                    namespacePrefixes = new HashMap<String, String>(namespacePrefixes);
                }
                String attrNSPrefix = attrName.substring(6, attrName.length());
                namespacePrefixes.put(attrNSPrefix, attr.getValue());
            }
            attr = (Attr)attrs.getNamedItem("type");
            if (attr != null) {
                this._Type = attrValue = attr.getValue();
            }
            if ((attr = (Attr)attrs.getNamedItem("editable")) != null) {
                this._Editable = attrValue = attr.getValue();
            }
            if ((attr = (Attr)attrs.getNamedItem("required")) != null) {
                this._Required = attrValue = attr.getValue();
            }
        }
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node childNode = children.item(i);
            String childNodeName = childNode.getLocalName() == null ? childNode.getNodeName().intern() : childNode.getLocalName().intern();
            String childNodeValue = "";
            if (childNode.getFirstChild() != null) {
                childNodeValue = childNode.getFirstChild().getNodeValue();
            }
            if (childNodeName == "param-value") {
                String aParamValue = childNodeValue;
                this._ParamValue.add(aParamValue);
                continue;
            }
            if (childNodeName == "param-locale") {
                if (childNode.getFirstChild() == null) {
                    this._ParamLocale = true;
                    continue;
                }
                this._ParamLocale = Boolean.valueOf(childNodeValue);
                continue;
            }
            if (childNodeName == "param-charset") {
                if (childNode.getFirstChild() == null) {
                    this._ParamCharset = true;
                    continue;
                }
                this._ParamCharset = Boolean.valueOf(childNodeValue);
                continue;
            }
            if (childNodeName == "param-min") {
                this._ParamMin = childNodeValue;
                continue;
            }
            if (childNodeName != "param-max") continue;
            this._ParamMax = childNodeValue;
        }
    }

    public void changePropertyByName(String name, Object value) {
        if (name == null) {
            return;
        }
        if ((name = name.intern()) == "type") {
            this.setType((String)value);
        } else if (name == "editable") {
            this.setEditable((String)value);
        } else if (name == "required") {
            this.setRequired((String)value);
        } else if (name == "paramValue") {
            this.addParamValue((String)value);
        } else if (name == "paramValue[]") {
            this.setParamValue((String[])value);
        } else if (name == "paramLocale") {
            this.setParamLocale((Boolean)value);
        } else if (name == "paramCharset") {
            this.setParamCharset((Boolean)value);
        } else if (name == "paramMin") {
            this.setParamMin((String)value);
        } else if (name == "paramMax") {
            this.setParamMax((String)value);
        } else {
            throw new IllegalArgumentException(name + " is not a valid property name for ParamType");
        }
    }

    public Object fetchPropertyByName(String name) {
        if (name == "type") {
            return this.getType();
        }
        if (name == "editable") {
            return this.getEditable();
        }
        if (name == "required") {
            return this.getRequired();
        }
        if (name == "paramValue[]") {
            return this.getParamValue();
        }
        if (name == "paramLocale") {
            return this.isParamLocale() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name == "paramCharset") {
            return this.isParamCharset() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name == "paramMin") {
            return this.getParamMin();
        }
        if (name == "paramMax") {
            return this.getParamMax();
        }
        throw new IllegalArgumentException(name + " is not a valid property name for ParamType");
    }

    public String nameSelf() {
        return "ParamType";
    }

    public String nameChild(Object childObj) {
        return this.nameChild(childObj, false, false);
    }

    public String nameChild(Object childObj, boolean returnConstName, boolean returnSchemaName) {
        return this.nameChild(childObj, returnConstName, returnSchemaName, false);
    }

    public String nameChild(Object childObj, boolean returnConstName, boolean returnSchemaName, boolean returnXPathName) {
        Object child;
        if (childObj instanceof String) {
            child = (String)childObj;
            if (child == this._Type) {
                if (returnConstName) {
                    return TYPE;
                }
                if (returnSchemaName) {
                    return "type";
                }
                if (returnXPathName) {
                    return "@type";
                }
                return TYPE;
            }
            if (child == this._Editable) {
                if (returnConstName) {
                    return EDITABLE;
                }
                if (returnSchemaName) {
                    return "editable";
                }
                if (returnXPathName) {
                    return "@editable";
                }
                return EDITABLE;
            }
            if (child == this._Required) {
                if (returnConstName) {
                    return REQUIRED;
                }
                if (returnSchemaName) {
                    return "required";
                }
                if (returnXPathName) {
                    return "@required";
                }
                return REQUIRED;
            }
            int index = 0;
            Iterator it = this._ParamValue.iterator();
            while (it.hasNext()) {
                String element = (String)it.next();
                if (child == element) {
                    if (returnConstName) {
                        return PARAM_VALUE;
                    }
                    if (returnSchemaName) {
                        return "param-value";
                    }
                    if (returnXPathName) {
                        return "param-value[position()=" + index + "]";
                    }
                    return "ParamValue." + Integer.toHexString(index);
                }
                ++index;
            }
            if (child == this._ParamMin) {
                if (returnConstName) {
                    return PARAM_MIN;
                }
                if (returnSchemaName) {
                    return "param-min";
                }
                if (returnXPathName) {
                    return "param-min";
                }
                return PARAM_MIN;
            }
            if (child == this._ParamMax) {
                if (returnConstName) {
                    return PARAM_MAX;
                }
                if (returnSchemaName) {
                    return "param-max";
                }
                if (returnXPathName) {
                    return "param-max";
                }
                return PARAM_MAX;
            }
        }
        if (childObj instanceof Boolean) {
            child = (Boolean)childObj;
            if ((Boolean)child == this._ParamLocale) {
                if (returnConstName) {
                    return PARAM_LOCALE;
                }
                if (returnSchemaName) {
                    return "param-locale";
                }
                if (returnXPathName) {
                    return "param-locale";
                }
                return PARAM_LOCALE;
            }
            if ((Boolean)child == this._ParamCharset) {
                if (returnConstName) {
                    return PARAM_CHARSET;
                }
                if (returnSchemaName) {
                    return "param-charset";
                }
                if (returnXPathName) {
                    return "param-charset";
                }
                return PARAM_CHARSET;
            }
        }
        return null;
    }

    public Object[] childBeans(boolean recursive) {
        LinkedList children = new LinkedList();
        this.childBeans(recursive, children);
        Object[] result = new Object[children.size()];
        return children.toArray(result);
    }

    public void childBeans(boolean recursive, List beans) {
    }

    public boolean equals(Object o) {
        return o instanceof ParamType && this.equals((ParamType)o);
    }

    public boolean equals(ParamType inst) {
        if (inst == this) {
            return true;
        }
        if (inst == null) {
            return false;
        }
        if (!(this._Type != null ? this._Type.equals(inst._Type) : inst._Type == null)) {
            return false;
        }
        if (!(this._Editable != null ? this._Editable.equals(inst._Editable) : inst._Editable == null)) {
            return false;
        }
        if (!(this._Required != null ? this._Required.equals(inst._Required) : inst._Required == null)) {
            return false;
        }
        if (this.sizeParamValue() != inst.sizeParamValue()) {
            return false;
        }
        Iterator it = this._ParamValue.iterator();
        Iterator it2 = inst._ParamValue.iterator();
        while (it.hasNext() && it2.hasNext()) {
            String element = (String)it.next();
            String element2 = (String)it2.next();
            if (element != null ? element.equals(element2) : element2 == null) continue;
            return false;
        }
        if (this._ParamLocale != inst._ParamLocale) {
            return false;
        }
        if (this._ParamCharset != inst._ParamCharset) {
            return false;
        }
        if (!(this._ParamMin != null ? this._ParamMin.equals(inst._ParamMin) : inst._ParamMin == null)) {
            return false;
        }
        return this._ParamMax != null ? this._ParamMax.equals(inst._ParamMax) : inst._ParamMax == null;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this._Type == null ? 0 : this._Type.hashCode());
        result = 37 * result + (this._Editable == null ? 0 : this._Editable.hashCode());
        result = 37 * result + (this._Required == null ? 0 : this._Required.hashCode());
        result = 37 * result + (this._ParamValue == null ? 0 : ((Object)this._ParamValue).hashCode());
        result = 37 * result + (this._ParamLocale ? 0 : 1);
        result = 37 * result + (this._ParamCharset ? 0 : 1);
        result = 37 * result + (this._ParamMin == null ? 0 : this._ParamMin.hashCode());
        result = 37 * result + (this._ParamMax == null ? 0 : this._ParamMax.hashCode());
        return result;
    }
}

