/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;
import org.openide.cookies.OpenCookie;

public class ChangeDocTypePanel
extends JPanel {
    protected static final ResourceBundle commonBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private final JPanel customizerPanel;
    private final Base theBean;
    private final SunONEDeploymentConfiguration config;
    private ASDDVersion currentVersion;
    private DefaultComboBoxModel versionModel;
    private JComboBox jCbxAppServerVersion;
    private JLabel jLblAppServerVersion;
    private JLabel jLblDocType;
    private JScrollPane jScrollPane1;
    private JTextArea jTxtDocType;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

    public ChangeDocTypePanel(JPanel cp, Base bean) {
        this.customizerPanel = cp;
        this.theBean = bean;
        this.config = this.theBean.getConfig();
        this.currentVersion = this.config.getAppServerVersion();
        this.initComponents();
        this.initFields();
    }

    public ASDDVersion getOriginalVersion() {
        return this.config.getAppServerVersion();
    }

    public ASDDVersion getCurrentVersion() {
        return this.currentVersion;
    }

    private void initComponents() {
        this.jLblAppServerVersion = new JLabel();
        this.jCbxAppServerVersion = new JComboBox();
        this.jLblDocType = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTxtDocType = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.jLblAppServerVersion.setLabelFor(this.jCbxAppServerVersion);
        this.jLblAppServerVersion.setText(commonBundle.getString("LBL_ServerVersion_1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.jLblAppServerVersion, gridBagConstraints);
        this.jCbxAppServerVersion.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ChangeDocTypePanel.this.jCbxAppServerVersionItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 11, 11);
        this.add((Component)this.jCbxAppServerVersion, gridBagConstraints);
        this.jCbxAppServerVersion.getAccessibleContext().setAccessibleName(commonBundle.getString("ACSN_ServerVersion"));
        this.jCbxAppServerVersion.getAccessibleContext().setAccessibleDescription(commonBundle.getString("ACSD_ServerVersion"));
        this.jLblDocType.setLabelFor(this.jTxtDocType);
        this.jLblDocType.setText(commonBundle.getString("LBL_DocTypeTag_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 12, 1, 5);
        this.add((Component)this.jLblDocType, gridBagConstraints);
        this.jLblDocType.getAccessibleContext().setAccessibleName(commonBundle.getString("ACSN_DocTypeTag"));
        this.jTxtDocType.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.jTxtDocType.setColumns(20);
        this.jTxtDocType.setEditable(false);
        this.jTxtDocType.setRows(3);
        this.jTxtDocType.setTabSize(4);
        this.jScrollPane1.setViewportView(this.jTxtDocType);
        this.jTxtDocType.getAccessibleContext().setAccessibleName(commonBundle.getString("ACSN_DocTypeTag"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void jCbxAppServerVersionItemStateChanged(ItemEvent evt) {
        this.currentVersion = (ASDDVersion)this.versionModel.getSelectedItem();
        this.setDocTypeText(this.getDocType());
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void initFields() {
        this.versionModel = new DefaultComboBoxModel();
        ASDDVersion minVersion = this.config.getMinASVersion();
        ASDDVersion maxVersion = this.config.getMaxASVersion();
        for (int i = 0; i < ASDDVersion.asDDVersions.length; ++i) {
            if (ASDDVersion.asDDVersions[i].compareTo(minVersion) < 0) continue;
            if (ASDDVersion.asDDVersions[i].compareTo(maxVersion) > 0) break;
            this.versionModel.addElement(ASDDVersion.asDDVersions[i]);
        }
        this.jCbxAppServerVersion.setModel(this.versionModel);
        this.jCbxAppServerVersion.setSelectedItem(this.currentVersion);
        this.setDocTypeText(this.getDocType());
    }

    private void setDocTypeText(String doctype) {
        this.jTxtDocType.setText(doctype);
        this.jTxtDocType.getAccessibleContext().setAccessibleDescription(doctype);
        this.jTxtDocType.setRows(Math.min(10, Math.max(3, this.countLines(doctype))));
    }

    private int countLines(String text) {
        int result = 1;
        int max = text.length();
        for (int i = 0; i < max; ++i) {
            if (text.charAt(i) != '\n') continue;
            ++result;
        }
        return result;
    }

    private String getDocType() {
        Base bean = this.theBean;
        while (bean.getParent() != null) {
            bean = bean.getParent();
        }
        BaseRoot rootBean = (BaseRoot)bean;
        return rootBean.generateDocType(this.currentVersion);
    }

    private Collection getErrors() {
        return Collections.EMPTY_SET;
    }

    private Collection getWarnings() {
        ArrayList<String> warnings = new ArrayList<String>();
        ASDDVersion newVersion = this.getCurrentVersion();
        ASDDVersion oldVersion = this.getOriginalVersion();
        if (this.hasUnsavedChanges()) {
            warnings.add(commonBundle.getString("WARN_WillSaveChanges"));
        }
        if (newVersion.compareTo(oldVersion) < 0) {
            warnings.add(commonBundle.getString("WARN_PossibleDataLoss"));
        }
        return warnings;
    }

    private boolean hasUnsavedChanges() {
        boolean result = false;
        ConfigurationStorage storage = this.config.getStorage();
        if (storage != null) {
            ConfigDataObject primaryDO = storage.getPrimaryDataObject();
            result = primaryDO != null && primaryDO.areModified();
        }
        return result;
    }

    private boolean changeVersion(ASDDVersion newVersion) {
        ConfigDataObject primaryDO = null;
        ConfigurationStorage storage = this.config.getStorage();
        if (storage != null) {
            primaryDO = storage.getPrimaryDataObject();
        }
        if (primaryDO == null) {
            return false;
        }
        if (!primaryDO.closeConfigEditors()) {
            return false;
        }
        this.config.setAppServerVersion(newVersion);
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        final ConfigDataObject theDataObject = primaryDO;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OpenCookie opener = (OpenCookie)theDataObject.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ChangeDocTypePanel.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                if (opener != null) {
                    opener.open();
                }
            }
        });
        return true;
    }

    public static void editASVersion(JPanel parent, Base theBean) {
        ChangeDocTypePanel docTypePanel = new ChangeDocTypePanel(parent, theBean);
        docTypePanel.displayDialog(parent, commonBundle.getString("TITLE_ChangeDocType"), "AS_CFG_ChangeDocTypePanelHelp");
    }

    private void displayDialog(JPanel parent, String title, String helpId) {
        ASDDVersion oldVersion;
        ASDDVersion newVersion;
        BetterInputDialog dialog = new BetterInputDialog(parent, title, helpId, this);
        int dialogChoice = dialog.display();
        if (dialogChoice == 1 && (newVersion = this.getCurrentVersion()).compareTo(oldVersion = this.getOriginalVersion()) != 0) {
            this.changeVersion(newVersion);
        }
    }

    private static class BetterInputDialog
    extends InputDialog {
        private final ChangeDocTypePanel dialogPanel;
        private final String panelHelpId;

        public BetterInputDialog(JPanel parent, String title, String helpId, ChangeDocTypePanel childPanel) {
            super(parent, title, false, true);
            this.dialogPanel = childPanel;
            this.panelHelpId = helpId;
            this.dialogPanel.setPreferredSize(new Dimension(parent.getWidth() * 3 / 4, this.dialogPanel.getPreferredSize().height));
            this.getAccessibleContext().setAccessibleName(this.dialogPanel.getAccessibleContext().getAccessibleName());
            this.getAccessibleContext().setAccessibleDescription(this.dialogPanel.getAccessibleContext().getAccessibleDescription());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridwidth = 0;
            constraints.fill = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            this.getContentPane().add(childPanel, constraints, 0);
            this.addListeners();
            this.pack();
            this.setLocationInside(parent);
            this.handleErrorDisplay();
        }

        private void addListeners() {
            this.dialogPanel.addPropertyChangeListener("UserDataChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    BetterInputDialog.this.handleErrorDisplay();
                }
            });
        }

        private void handleErrorDisplay() {
            this.setErrors(this.dialogPanel.getErrors(), this.dialogPanel.getWarnings());
        }

        protected String getHelpId() {
            return this.panelHelpId;
        }
    }
}

