/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.beans.PropertyVetoException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.sun.api.ResourceConfiguratorInterface;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentConfigurationInterface;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.DDException;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.CmpResource;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.MdbConnectionFactory;
import org.netbeans.modules.j2ee.sun.dd.api.web.SunWebApp;
import org.netbeans.modules.j2ee.sun.share.Constants;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.DDFilesListener;
import org.netbeans.modules.j2ee.sun.share.config.DDRoot;
import org.netbeans.modules.j2ee.sun.share.config.StandardDDImpl;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.AppClientRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.AppClientVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.AppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.ApplicationVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.CmpEntityEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.ConfigFinder;
import org.netbeans.modules.j2ee.sun.share.configbean.ConfigParser;
import org.netbeans.modules.j2ee.sun.share.configbean.DCBFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.EjbJarRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.EjbJarVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.J2EEVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.MDEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.ResourceRef;
import org.netbeans.modules.j2ee.sun.share.configbean.ServletVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Snippet;
import org.netbeans.modules.j2ee.sun.share.configbean.StorageBeanFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.WebServices;
import org.netbeans.modules.j2ee.sun.share.plan.DeploymentPlan;
import org.netbeans.modules.j2ee.sun.share.plan.FileEntry;
import org.netbeans.modules.j2ee.sun.share.serverresources.SunDatasource;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXException;

public class SunONEDeploymentConfiguration
implements Constants,
SunDeploymentConfigurationInterface {
    private static WeakHashMap configurationMap;
    private DeployableObject dObj;
    private Map contentMap = new HashMap();
    private Map beanMap = new HashMap();
    private Map priorBeanMap = new HashMap();
    private final Object storageMonitor = new Object();
    private ConfigurationStorage storage = null;
    private String deploymentModuleName = "_default_";
    private File[] configFiles;
    private File resourceDir;
    private boolean keepUpdated;
    private DDFilesListener ddFilesListener;
    private static final RequestProcessor resourceProcessor;
    private ASDDVersion appServerVersion;
    private ASDDVersion minASVersion;
    private ASDDVersion maxASVersion;
    private boolean deferredAppServerChange;
    private Map moduleDCBCache = new LinkedHashMap(13);
    private Map completeDCBCache = new LinkedHashMap(63);
    private Map patchCache = new LinkedHashMap(13);
    private Map dcbFactoryMap = null;
    private static int BUF_LEN;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void addConfiguration(File key, SunONEDeploymentConfiguration config) {
        configurationMap.put(key, new WeakReference<SunONEDeploymentConfiguration>(config));
    }

    public static void removeConfiguration(File key) {
        configurationMap.remove(key);
    }

    public static SunONEDeploymentConfiguration getConfiguration(File key) {
        SunONEDeploymentConfiguration config = null;
        WeakReference ref = (WeakReference)configurationMap.get(key);
        if (ref != null) {
            config = (SunONEDeploymentConfiguration)ref.get();
        }
        return config;
    }

    public SunONEDeploymentConfiguration(DeployableObject dObj) {
        this.dObj = dObj;
        this.appServerVersion = ASDDVersion.SUN_APPSERVER_8_1;
        this.deferredAppServerChange = false;
    }

    public void init(File[] cfgFiles, File resourceDir, boolean keepUpdated) throws ConfigurationException {
        this.configFiles = new File[cfgFiles.length];
        for (int i = 0; i < cfgFiles.length; ++i) {
            this.configFiles[i] = cfgFiles[i];
        }
        if (this.configFiles.length == 2 && this.configFiles[1] != null && "sun-ejb-jar.xml".equals(this.configFiles[1].getName())) {
            File tmp = this.configFiles[0];
            this.configFiles[0] = this.configFiles[1];
            this.configFiles[1] = tmp;
        }
        this.resourceDir = resourceDir;
        this.keepUpdated = keepUpdated;
        SunONEDeploymentConfiguration.addConfiguration(this.configFiles[0], this);
        J2eeModuleProvider provider = this.getProvider(this.configFiles[0].getParentFile());
        if (provider == null) {
            throw new ConfigurationException("No Project and/or J2eeModuleProvider located for " + this.configFiles[0].getPath());
        }
        J2eeModule j2eeModule = provider.getJ2eeModule();
        this.minASVersion = this.computeMinASVersion((ModuleType)j2eeModule.getModuleType(), j2eeModule.getModuleVersion());
        this.appServerVersion = this.maxASVersion = this.computeMaxASVersion();
        if (keepUpdated) {
            if (!this.ensureConfigurationLoaded()) {
                throw new ConfigurationException("DConfigBean storage failed initialization for " + this.configFiles[0].getName());
            }
            BaseRoot masterRoot = this.getMasterDCBRoot();
            if (masterRoot != null && J2EEVersion.J2EE_1_4.compareSpecification(masterRoot.getJ2EEModuleVersion()) >= 0 && !this.configFiles[0].exists()) {
                this.getStorage().setChanged();
            }
            this.ddFilesListener = new DDFilesListener(this, provider);
        }
    }

    public void dispose() {
        SunONEDeploymentConfiguration storedCfg = SunONEDeploymentConfiguration.getConfiguration(this.configFiles[0]);
        if (storedCfg != this) {
            ErrorManager.getDefault().log(1, "Stored DeploymentConfiguration (" + storedCfg + ") instance not the one being disposed of (" + this + ").");
        }
        if (storedCfg != null) {
            SunONEDeploymentConfiguration.removeConfiguration(this.configFiles[0]);
        }
    }

    public void updateResourceDir(File resourceDir) {
        this.resourceDir = resourceDir;
    }

    private void postResourceError(String resourceMsg) {
        String projectName = this.getProjectName(this.configFiles[0]);
        String folderMsg = projectName != null ? NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_NoResourceFolderForProject", (Object)projectName) : NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_NoResourceFolderUnknown");
        final String text = folderMsg + " " + resourceMsg;
        resourceProcessor.post(new Runnable(){

            public void run() {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)text, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
        });
    }

    public void ensureResourceDefined(DDBean ddBean) {
        String type;
        String xpath = ddBean.getXpath();
        int finalSlashIndex = xpath.lastIndexOf(47) + 1;
        String string = type = finalSlashIndex < xpath.length() ? xpath.substring(finalSlashIndex) : "";
        if ("message-driven".equals(type)) {
            BaseEjb theEjbDCB = this.getEjbDConfigBean(ddBean);
            if (theEjbDCB == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("EJB DConfigBean cannot be found for DDBean: " + ddBean));
                return;
            }
            ResourceConfiguratorInterface rci = this.getResourceConfigurator();
            String jndiName = theEjbDCB.getJndiName();
            if (this.isEJB3()) {
                String ejbName = this.getField(ddBean, "ejb-name");
                if (!Utils.notEmpty(jndiName)) {
                    jndiName = this.getField(ddBean, "mapped-name", ejbName);
                }
                if (!rci.isJMSResourceDefined(jndiName, this.resourceDir)) {
                    String destinationType = "javax.jms.Queue";
                    try {
                        DDBean[] activationNameFields = ddBean.getChildBean("activation-config/activation-config-property/activation-config-property-name");
                        for (int i = 0; i < activationNameFields.length; ++i) {
                            String value;
                            DDBean[] activationValueFields;
                            if (!"destinationType".equals(activationNameFields[i].getText()) || (activationValueFields = activationNameFields[i].getChildBean("../activation-config-property-value")).length <= 0 || !Utils.notEmpty(value = activationValueFields[0].getText())) continue;
                            destinationType = value;
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    String messageDestinationName = this.getField(ddBean, "message-destination-link", ejbName);
                    String messageDestinationType = this.getField(ddBean, "message-destination-type", destinationType);
                    if (this.resourceDir == null) {
                        this.postResourceError(NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_NoJMSResource", (Object)theEjbDCB.getEjbName()));
                    } else {
                        rci.createJMSResource(jndiName, messageDestinationType, messageDestinationName, ejbName, this.resourceDir);
                    }
                }
            } else if (!rci.isJMSResourceDefined(jndiName, this.resourceDir)) {
                String ejbName = this.getField(ddBean, "ejb-name");
                String messageDestinationName = this.getField(ddBean, "message-destination-link");
                String messageDestinationType = this.getField(ddBean, "message-destination-type");
                if (this.resourceDir == null) {
                    this.postResourceError(NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_NoJMSResource", (Object)theEjbDCB.getEjbName()));
                } else {
                    rci.createJMSResource(jndiName, messageDestinationType, messageDestinationName, ejbName, this.resourceDir);
                }
                MdbConnectionFactory mcf = this.getStorageFactory().createMdbConnectionFactory();
                String connectionFactoryJndiName = "jms/" + messageDestinationName + "Factory";
                mcf.setJndiName(connectionFactoryJndiName);
                try {
                    ((MDEjb)theEjbDCB).setMdbConnectionFactory(mcf);
                }
                catch (PropertyVetoException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                MessageDestination md = this.getStorageFactory().createMessageDestination();
                md.setMessageDestinationName(messageDestinationName);
                md.setJndiName(theEjbDCB.getJndiName());
                EjbJarRoot root = (EjbJarRoot)theEjbDCB.getParent();
                try {
                    root.addMessageDestination(md);
                }
                catch (PropertyVetoException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        } else if ("resource-ref".equals(type)) {
            if (ddBean instanceof StandardDDImpl) {
                Object o = this.getDCBCache().get(ddBean);
                if (o instanceof ResourceRef) {
                    ResourceRef theResRefDCB = (ResourceRef)o;
                    final String refName = this.getField(ddBean, "res-ref-name");
                    final String description = this.getField(ddBean, "description");
                    final File targetDir = this.resourceDir;
                    if (Utils.notEmpty(description)) {
                        if (this.resourceDir == null) {
                            this.postResourceError(NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_NoRefJdbcDataSource", (Object)theResRefDCB.getResRefName()));
                            return;
                        }
                        resourceProcessor.post(new Runnable(){

                            public void run() {
                                ResourceConfiguratorInterface rci = SunONEDeploymentConfiguration.this.getResourceConfigurator();
                                if (rci != null) {
                                    rci.createJDBCDataSourceFromRef(refName, description, targetDir);
                                }
                            }
                        }, 500);
                    }
                } else {
                    ErrorManager.getDefault().log(1, "No ResourceRef DConfigBean found bound to resource-ref DDBean: " + ddBean);
                }
            } else {
                ErrorManager.getDefault().log(1, "DDBean from wrong tree in ensureResourceDefined: " + ddBean);
            }
        } else if ("entity".equals(type)) {
            this.ensureResourceDefinedForEjb(ddBean, null);
        }
    }

    public void ensureResourceDefinedForEjb(DDBean ddBean, String jndiName) {
        BaseEjb theEjbDCB = this.getEjbDConfigBean(ddBean);
        if (theEjbDCB == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("EJB DConfigBean cannot be found for DDBean: " + ddBean));
            return;
        }
        if (theEjbDCB instanceof CmpEntityEjb) {
            ResourceConfiguratorInterface rci = this.getResourceConfigurator();
            CmpEntityEjb cmpEjbDCB = (CmpEntityEjb)theEjbDCB;
            if (this.resourceDir == null) {
                this.postResourceError(NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_NoCmpOrJdbcDataSource", (Object)cmpEjbDCB.getEjbName()));
                return;
            }
            if (jndiName == null) {
                String description = this.getField(ddBean, "description");
                jndiName = rci.createJDBCDataSourceForCmp(cmpEjbDCB.getEjbName(), description, this.resourceDir);
            }
            if (jndiName != null) {
                Base parentDCB = cmpEjbDCB.getParent();
                if (parentDCB instanceof EjbJarRoot) {
                    EjbJarRoot ejbJarRoot = (EjbJarRoot)parentDCB;
                    CmpResource cmpResource = null;
                    cmpResource = ejbJarRoot.getCmpResource() == null ? this.getStorageFactory().createCmpResource() : (CmpResource)ejbJarRoot.getCmpResource().clone();
                    cmpResource.setJndiName(jndiName);
                    try {
                        ejbJarRoot.setCmpResource(cmpResource);
                    }
                    catch (PropertyVetoException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                } else {
                    ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("CmpEntityBean DConfigBean parent is of wrong type: " + parentDCB));
                }
            }
        }
    }

    private boolean isEJB3() {
        boolean result = false;
        String j2eeModuleVersion = this.dObj.getModuleDTDVersion();
        EjbJarVersion ejbJarVersion = EjbJarVersion.getEjbJarVersion(j2eeModuleVersion);
        if (EjbJarVersion.EJBJAR_3_0.compareTo(ejbJarVersion) <= 0) {
            result = true;
        }
        return result;
    }

    private ASDDVersion computeMinASVersion(ModuleType moduleType, String j2eeModuleVersion) {
        ASDDVersion result = ASDDVersion.SUN_APPSERVER_7_0;
        if (ModuleType.WAR.equals(moduleType)) {
            ServletVersion servletVersion = ServletVersion.getServletVersion(j2eeModuleVersion);
            if (ServletVersion.SERVLET_2_4.equals(servletVersion)) {
                result = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (ServletVersion.SERVLET_2_5.equals(servletVersion)) {
                result = ASDDVersion.SUN_APPSERVER_9_0;
            }
        } else if (ModuleType.EJB.equals(moduleType)) {
            EjbJarVersion ejbJarVersion = EjbJarVersion.getEjbJarVersion(j2eeModuleVersion);
            if (EjbJarVersion.EJBJAR_2_1.equals(ejbJarVersion)) {
                result = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (EjbJarVersion.EJBJAR_3_0.equals(ejbJarVersion)) {
                result = ASDDVersion.SUN_APPSERVER_9_0;
            }
        } else if (ModuleType.EAR.equals(moduleType)) {
            ApplicationVersion applicationVersion = ApplicationVersion.getApplicationVersion(j2eeModuleVersion);
            if (ApplicationVersion.APPLICATION_1_4.equals(applicationVersion)) {
                result = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (ApplicationVersion.APPLICATION_5_0.equals(applicationVersion)) {
                result = ASDDVersion.SUN_APPSERVER_9_0;
            }
        } else if (ModuleType.CAR.equals(moduleType)) {
            AppClientVersion appClientVersion = AppClientVersion.getAppClientVersion(j2eeModuleVersion);
            if (AppClientVersion.APP_CLIENT_1_4.equals(appClientVersion)) {
                result = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (AppClientVersion.APP_CLIENT_5_0.equals(appClientVersion)) {
                result = ASDDVersion.SUN_APPSERVER_9_0;
            }
        } else {
            ErrorManager.getDefault().log(1, "Unsupported J2EE module type: " + moduleType);
            result = ASDDVersion.SUN_APPSERVER_8_1;
        }
        return result;
    }

    private ASDDVersion computeMaxASVersion() {
        ASDDVersion result = this.getTargetAppServerVersion();
        if (result == null) {
            result = ASDDVersion.SUN_APPSERVER_9_0;
            ErrorManager.getDefault().log(16, NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_UnidentifiedTargetServer", (Object)result.toString()));
        }
        return result;
    }

    public ASDDVersion getMinASVersion() {
        return this.minASVersion;
    }

    public ASDDVersion getMaxASVersion() {
        return this.maxASVersion;
    }

    public StorageBeanFactory getStorageFactory() {
        return this.appServerVersion.getStorageFactory();
    }

    public ASDDVersion getAppServerVersion() {
        return this.appServerVersion;
    }

    public void setAppServerVersion(ASDDVersion asVersion) {
        if (asVersion.compareTo(this.getMinASVersion()) < 0) {
            throw new IllegalArgumentException(asVersion.toString() + " is lower than required minimum version " + this.getMinASVersion().toString());
        }
        if (asVersion.compareTo(this.getMaxASVersion()) > 0) {
            throw new IllegalArgumentException(asVersion.toString() + " is higher than required maximum version " + this.getMaxASVersion().toString());
        }
        if (!asVersion.equals(this.appServerVersion) || this.deferredAppServerChange) {
            this.appServerVersion = asVersion;
            ConfigurationStorage storage = this.getStorage();
            if (storage != null) {
                this.deferredAppServerChange = false;
                storage.setChanged();
            }
        }
    }

    void internalSetAppServerVersion(ASDDVersion asVersion) {
        if (!asVersion.equals(this.appServerVersion)) {
            this.appServerVersion = asVersion;
            this.deferredAppServerChange = true;
        }
    }

    public File[] getConfigFiles() {
        return this.configFiles;
    }

    private BaseEjb getEjbDConfigBean(DDBean ejbDDBean) {
        BaseEjb theEjbDCB = null;
        try {
            DDBean realEjbDDBean = this.getStorage().normalizeEjbDDBean(ejbDDBean);
            DDBeanRoot ddBeanRoot = realEjbDDBean.getRoot();
            DConfigBeanRoot dcbRoot = this.getDConfigBeanRoot(ddBeanRoot);
            DConfigBean dcb = dcbRoot.getDConfigBean(realEjbDDBean);
            if (dcb instanceof BaseEjb) {
                theEjbDCB = (BaseEjb)dcb;
            }
        }
        catch (ConfigurationException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (NullPointerException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return theEjbDCB;
    }

    private String getField(DDBean bean, String fieldId) {
        String result = null;
        try {
            DDBean[] childFields = bean.getChildBean(fieldId);
            if (childFields.length > 0) {
                result = childFields[0].getText();
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return result;
    }

    private String getField(DDBean bean, String fieldId, String defaultValue) {
        String result = this.getField(bean, fieldId);
        if (!Utils.notEmpty(result)) {
            result = defaultValue;
        }
        return result;
    }

    private ResourceConfiguratorInterface getResourceConfigurator() {
        ResourceConfiguratorInterface rci = null;
        DeploymentManager dm = this.getDeploymentManager();
        if (dm instanceof SunDeploymentManagerInterface) {
            SunDeploymentManagerInterface sdmi = (SunDeploymentManagerInterface)dm;
            rci = sdmi.getResourceConfigurator();
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Invalid DeploymentManager: " + dm));
        }
        return rci;
    }

    private DeploymentManager getDeploymentManager() {
        DeploymentManager dm = null;
        J2eeModuleProvider provider = this.getProvider(this.configFiles[0]);
        if (provider != null) {
            InstanceProperties ip = provider.getInstanceProperties();
            if (ip != null) {
                dm = ip.getDeploymentManager();
            } else {
                ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Null Server InstanceProperties: " + ip));
            }
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Null J2eeModuleProvider: " + provider));
        }
        return dm;
    }

    private J2eeModuleProvider getProvider(File file) {
        J2eeModuleProvider provider = null;
        if (file != null) {
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo != null) {
                Project project = FileOwnerQuery.getOwner((FileObject)fo);
                if (project != null) {
                    Lookup lookup = project.getLookup();
                    provider = (J2eeModuleProvider)lookup.lookup(J2eeModuleProvider.class);
                }
            } else {
                File parent = file.getParentFile();
                if (parent != null) {
                    provider = this.getProvider(parent);
                }
            }
        }
        return provider;
    }

    private String getProjectName(File file) {
        ProjectInformation info;
        Project project;
        String result = null;
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null && (project = FileOwnerQuery.getOwner((FileObject)fo)) != null && (info = ProjectUtils.getInformation((Project)project)) != null) {
            result = info.getName();
        }
        return result;
    }

    public DConfigBeanRoot getDConfigBeanRoot(DDBeanRoot dDBeanRoot) throws ConfigurationException {
        DCBFactory factory;
        BaseRoot rootDCBean;
        if (null == dDBeanRoot) {
            throw Utils.makeCE("ERR_DDBeanIsNull", null, null);
        }
        if (null == dDBeanRoot.getXpath()) {
            throw Utils.makeCE("ERR_DDBeanHasNullXpath", null, null);
        }
        if (!(dDBeanRoot instanceof DDRoot)) {
            if (this.getDCBRootCache().entrySet().size() == 0) {
                throw Utils.makeCE("ERR_CannotNormalizeDDBean", new Object[]{dDBeanRoot.getClass().getName()}, null);
            }
            dDBeanRoot = this.getStorage().normalizeDDBeanRoot(dDBeanRoot);
        }
        if (null == (rootDCBean = (BaseRoot)this.getDCBRootCache().get(dDBeanRoot)) && (factory = (DCBFactory)this.getDCBFactoryMap().get(dDBeanRoot.getXpath())) != null && (rootDCBean = (BaseRoot)factory.createDCB((DDBean)dDBeanRoot, null)) != null) {
            this.getDCBCache().put(dDBeanRoot, rootDCBean);
            this.getDCBRootCache().put(dDBeanRoot, rootDCBean);
        }
        return rootDCBean;
    }

    public DeployableObject getDeployableObject() {
        return this.dObj;
    }

    public void removeDConfigBean(DConfigBeanRoot dConfigBeanRoot) throws BeanNotFoundException {
        jsr88Logger.entering(this.getClass().toString(), "removeDConfigBean", dConfigBeanRoot);
        if (null != dConfigBeanRoot) {
            DDBeanRoot key = (DDBeanRoot)dConfigBeanRoot.getDDBean();
            BaseRoot deadBean = (BaseRoot)this.getDCBCache().get(key);
            if (deadBean != null) {
                Object[] children = deadBean.getChildren().toArray();
                for (int i = 0; i < children.length; ++i) {
                    try {
                        deadBean.removeDConfigBean((Base)children[i]);
                        continue;
                    }
                    catch (BeanNotFoundException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
                this.getDCBCache().remove(key);
                this.getDCBRootCache().remove(key);
                deadBean.cleanup();
                deadBean = null;
            } else {
                throw new BeanNotFoundException(NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_DConfigBeanRootNotFoundOnRemove", (Object)dConfigBeanRoot.toString()));
            }
        }
        jsr88Logger.exiting(this.getClass().toString(), "removeDConfigBean", dConfigBeanRoot);
    }

    public void restore(InputStream inputStream) throws ConfigurationException {
        jsr88Logger.entering(this.getClass().toString(), "restore", inputStream);
        this.restoreDConfigBean(inputStream, null);
        jsr88Logger.exiting(this.getClass().toString(), "restore", inputStream);
    }

    public DConfigBeanRoot restoreDConfigBean(InputStream inputStream, DDBeanRoot dDBeanRoot) throws ConfigurationException {
        jsr88Logger.finest("S1DepConfig:restoreDConfigBean(jiIS,DDBeanRoot)");
        DeploymentPlan dp = null;
        this.beanMap.clear();
        try {
            FileEntry[] tentries;
            block21: {
                if (null != inputStream) {
                    try {
                        if (this.dObj.getType().equals(ModuleType.WAR)) {
                            try {
                                SunWebApp sunW = DDProvider.getDefault().getWebDDRoot(inputStream);
                                dp = DeploymentPlan.createGraph();
                                FileEntry fe = new FileEntry();
                                fe.setName("sun-web.xml");
                                String s = new String();
                                StringWriter strWriter = new StringWriter();
                                sunW.write((Writer)strWriter);
                                fe.setContent(strWriter.toString());
                                dp.addFileEntry(fe);
                            }
                            catch (DDException ex) {
                                jsr88Logger.finest(((Object)((Object)ex)).getClass().getName() + " while processing sun-web.xml into a deployment plan: " + ex.getLocalizedMessage());
                                dp = DeploymentPlan.createGraph();
                            }
                            catch (SAXException ex) {
                                jsr88Logger.finest(ex.getClass().getName() + " while processing sun-web.xml into a deployment plan: " + ex.getLocalizedMessage());
                                dp = DeploymentPlan.createGraph();
                            }
                            catch (IOException ex) {
                                jsr88Logger.finest(ex.getClass().getName() + " while processing sun-web.xml into a deployment plan: " + ex.getLocalizedMessage());
                                dp = DeploymentPlan.createGraph();
                            }
                            break block21;
                        }
                        dp = DeploymentPlan.createGraph(inputStream);
                    }
                    catch (Schema2BeansRuntimeException s2bre) {
                        jsr88Logger.finest("the stream did not have a deployment plan");
                        dp = DeploymentPlan.createGraph();
                    }
                } else {
                    jsr88Logger.finest("the stream was null");
                }
            }
            FileEntry[] entries = new FileEntry[]{};
            if (null != dp && null != (tentries = dp.getFileEntry())) {
                entries = tentries;
            }
            for (int i = 0; i < entries.length; ++i) {
                String key = Utils.getFQNKey(entries[i].getUri(), entries[i].getName());
                this.contentMap.put(key, entries[i].getContent().getBytes());
            }
        }
        catch (Schema2BeansRuntimeException ex) {
            jsr88Logger.finest("Schema2Beans threw a Runtime Exception");
        }
        catch (Exception ex) {
            jsr88Logger.finest("foo");
            ConfigurationException ce = new ConfigurationException("bad plan stream");
            ce.initCause((Throwable)ex);
        }
        ArrayList<Object> pending = new ArrayList<Object>();
        BaseRoot rootToRestore = null;
        if (null == dDBeanRoot) {
            Iterator rootIter = this.getDCBRootCache().entrySet().iterator();
            while (rootIter.hasNext()) {
                pending.add(rootIter.next().getValue());
            }
            rootToRestore = this.getMasterDCBRoot();
        } else {
            rootToRestore = (BaseRoot)this.getDCBRootCache().get(dDBeanRoot);
            if (null != rootToRestore) {
                pending.add(rootToRestore);
            }
        }
        for (int index = 0; index < pending.size(); ++index) {
            Base current;
            block22: {
                current = (Base)pending.get(index);
                try {
                    current.loadFromPlanFile(this);
                }
                catch (IllegalStateException ise) {
                    jsr88Logger.throwing(current.getClass().toString(), "loadFromPlanFile", ise);
                    if ($assertionsDisabled || ise == null) break block22;
                    throw new AssertionError();
                }
            }
            pending.addAll(current.getChildren());
        }
        return rootToRestore;
    }

    public void save(OutputStream outputStream) throws ConfigurationException {
        jsr88Logger.entering(this.getClass().toString(), "save", outputStream);
        this.saveDConfigBean(outputStream, null);
        jsr88Logger.exiting(this.getClass().toString(), "save", outputStream);
    }

    public void saveDConfigBean(OutputStream outputStream, DConfigBeanRoot rootBean) throws ConfigurationException {
        Object[] params = new Object[]{outputStream, rootBean};
        jsr88Logger.entering(this.getClass().toString(), "save", params);
        boolean useUriDataAtSave = false;
        LinkedHashMap outputGraphs = new LinkedHashMap();
        LinkedHashMap<String, BaseBean> cmpGraphs = new LinkedHashMap<String, BaseBean>();
        try {
            StringWriter strWriter;
            Object k;
            if (rootBean == null) {
                Iterator rootIter = this.getDCBRootCache().entrySet().iterator();
                while (rootIter.hasNext()) {
                    EjbJarRoot ejbJar;
                    Snippet cmpSnippet;
                    Base dcb = (Base)rootIter.next().getValue();
                    dcb.addToGraphs(outputGraphs, null, "");
                    if (!(dcb instanceof EjbJarRoot) || !(cmpSnippet = (ejbJar = (EjbJarRoot)dcb).getCmpMappingSnippet()).hasDDSnippet()) continue;
                    String snippetKey = Utils.getFQNKey(ejbJar.getUriText(), cmpSnippet.getFileName());
                    cmpGraphs.put(snippetKey, cmpSnippet.getCmpDDSnippet());
                }
            } else {
                EjbJarRoot ejbJar;
                Snippet cmpSnippet;
                ((Base)rootBean).addToGraphs(outputGraphs, null, "");
                if (rootBean instanceof EjbJarRoot && (cmpSnippet = (ejbJar = (EjbJarRoot)rootBean).getCmpMappingSnippet()).hasDDSnippet()) {
                    String snippetKey = Utils.getFQNKey(ejbJar.getUriText(), cmpSnippet.getFileName());
                    cmpGraphs.put(snippetKey, cmpSnippet.getCmpDDSnippet());
                }
            }
            Set keys = outputGraphs.keySet();
            Iterator iter = keys.iterator();
            DeploymentPlan dp = new DeploymentPlan();
            CommonDDBean bean = null;
            while (iter.hasNext()) {
                k = iter.next();
                bean = (CommonDDBean)outputGraphs.get(k);
                if (null != bean) {
                    String keyString = (String)k;
                    String uri = Utils.getUriFromKey(keyString);
                    String fname = Utils.getFilenameFromKey(keyString);
                    FileEntry fe = new FileEntry();
                    fe.setName(fname);
                    if (useUriDataAtSave && uri.length() > 0) {
                        fe.setUri(uri);
                    }
                    String s = new String();
                    strWriter = new StringWriter();
                    bean.write((Writer)strWriter);
                    fe.setContent(strWriter.toString());
                    dp.addFileEntry(fe);
                    continue;
                }
                jsr88Logger.warning("no bean for key: " + k);
            }
            keys = cmpGraphs.keySet();
            iter = keys.iterator();
            while (iter.hasNext()) {
                k = iter.next();
                BaseBean cmpRoot = (BaseBean)cmpGraphs.get(k);
                if (null != cmpRoot) {
                    String keyString = (String)k;
                    String uri = Utils.getUriFromKey(keyString);
                    String fname = Utils.getFilenameFromKey(keyString);
                    FileEntry fe = new FileEntry();
                    fe.setName(fname);
                    if (useUriDataAtSave && uri.length() > 0) {
                        fe.setUri(uri);
                    }
                    strWriter = new StringWriter();
                    cmpRoot.write((Writer)strWriter);
                    fe.setContent(strWriter.toString());
                    dp.addFileEntry(fe);
                    continue;
                }
                jsr88Logger.warning("no bean for key: " + k);
            }
            if (this.dObj.getType().equals(ModuleType.WAR)) {
                if (null != bean) {
                    bean.write(outputStream);
                }
            } else {
                dp.write(outputStream);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            ConfigurationException ce = new ConfigurationException("Sun Deployment Descriptor Error");
            ce.initCause((Throwable)ex);
        }
        jsr88Logger.exiting(this.getClass().toString(), "Save", params);
    }

    Object getBeans(String uri, String fileName, ConfigParser parser, ConfigFinder finder) {
        String key = Utils.getFQNKey(uri, fileName);
        Object root = this.beanMap.get(key);
        if (root == null) {
            block5: {
                byte[] content = (byte[])this.contentMap.get(key);
                if (content == null) {
                    return null;
                }
                if (parser == null) {
                    jsr88Logger.severe("Missing parser");
                    return null;
                }
                try {
                    root = parser.parse(new ByteArrayInputStream(content));
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                    root = this.priorBeanMap.remove(key);
                    if (root != null) break block5;
                    return null;
                }
            }
            this.beanMap.put(key, root);
        }
        Object result = finder.find(root);
        return result;
    }

    public boolean ensureConfigurationLoaded() {
        boolean result = this.getStorage() != null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationStorage getStorage() {
        ConfigurationStorage theStorage = null;
        Object object = this.storageMonitor;
        synchronized (object) {
            theStorage = this.storage;
        }
        if (theStorage == null) {
            J2eeModuleProvider provider = this.getProvider(this.configFiles[0].getParentFile());
            if (provider == null) {
                throw new IllegalStateException("No Project and/or J2eeModuleProvider located for " + this.configFiles[0].getPath());
            }
            Object object2 = this.storageMonitor;
            synchronized (object2) {
                if (this.storage == null) {
                    try {
                        this.storage = new ConfigurationStorage(provider, this);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                    catch (InvalidModuleException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    catch (SAXException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    catch (ConfigurationException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
                theStorage = this.storage;
            }
        }
        return theStorage;
    }

    public WebAppRoot getWebAppRoot() {
        WebAppRoot war = null;
        DDBeanRoot root = this.dObj.getDDBeanRoot();
        if (null != root) {
            try {
                DConfigBeanRoot dcbRoot;
                ConfigurationStorage storage = this.getStorage();
                if (storage != null && (dcbRoot = this.getDConfigBeanRoot(storage.normalizeDDBeanRoot(root))) instanceof WebAppRoot) {
                    war = (WebAppRoot)dcbRoot;
                }
            }
            catch (ConfigurationException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
        } else {
            ErrorManager.getDefault().log(1, "DeployableObject with null DDBeanRoot!!!");
        }
        return war;
    }

    public EjbJarRoot getEjbJarRoot() {
        EjbJarRoot ejbJar = null;
        DDBeanRoot root = this.dObj.getDDBeanRoot();
        if (null != root) {
            try {
                DConfigBeanRoot dcbRoot;
                ConfigurationStorage storage = this.getStorage();
                if (storage != null && (dcbRoot = this.getDConfigBeanRoot(storage.normalizeDDBeanRoot(root))) instanceof EjbJarRoot) {
                    ejbJar = (EjbJarRoot)dcbRoot;
                }
            }
            catch (ConfigurationException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
        } else {
            ErrorManager.getDefault().log(1, "DeployableObject with null DDBeanRoot!!!");
        }
        return ejbJar;
    }

    public void setContextRoot(String contextRoot) {
        if (this.dObj.getType().equals(ModuleType.WAR)) {
            WebAppRoot war = this.getWebAppRoot();
            if (war != null) {
                try {
                    war.setContextRoot(contextRoot);
                }
                catch (PropertyVetoException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        } else {
            ErrorManager.getDefault().log(1, "SunONEDeploymentConfiguration.setContextRoot() invoked on incorrect module type: " + this.dObj.getType());
        }
    }

    public String getContextRoot() {
        String contextRoot = null;
        if (this.dObj.getType().equals(ModuleType.WAR)) {
            WebAppRoot war = this.getWebAppRoot();
            if (war != null) {
                contextRoot = war.getContextRoot();
            } else {
                ErrorManager.getDefault().log(1, "SunONEDeploymentConfiguration.getContextRoot(): No WebAppRoot DConfigBean found for module.");
            }
        } else {
            ErrorManager.getDefault().log(1, "SunONEDeploymentConfiguration.getContextRoot() invoked on incorrect module type: " + this.dObj.getType());
        }
        return contextRoot;
    }

    public String getDeploymentModuleName() {
        return this.deploymentModuleName;
    }

    public void setDeploymentModuleName(String s) {
        this.deploymentModuleName = s;
    }

    public WebServices getWebServicesRoot() {
        WebServices wsr = null;
        Map rootMap = this.getDCBRootCache();
        if (rootMap.size() > 1) {
            Iterator rootIterator = rootMap.entrySet().iterator();
            rootIterator.next();
            Object root = rootIterator.next().getValue();
            if (root instanceof WebServices) {
                wsr = (WebServices)root;
            }
        }
        return wsr;
    }

    Map getDCBCache() {
        return this.completeDCBCache;
    }

    Map getDCBRootCache() {
        return this.moduleDCBCache;
    }

    Map getPatchList() {
        return this.patchCache;
    }

    BaseRoot getMasterDCBRoot() {
        BaseRoot masterRoot = null;
        Iterator rootIterator = this.moduleDCBCache.entrySet().iterator();
        while (rootIterator.hasNext()) {
            BaseRoot tmpRoot = (BaseRoot)rootIterator.next().getValue();
            if (tmpRoot instanceof WebServices) continue;
            masterRoot = tmpRoot;
            break;
        }
        return masterRoot;
    }

    private Map getDCBFactoryMap() {
        if (this.dcbFactoryMap == null) {
            this.dcbFactoryMap = new HashMap(17);
            this.dcbFactoryMap.put("/application", new DCBTopRootFactory(AppRoot.class));
            this.dcbFactoryMap.put("/ejb-jar", new DCBTopRootFactory(EjbJarRoot.class));
            this.dcbFactoryMap.put("/web-app", new DCBTopRootFactory(WebAppRoot.class));
            this.dcbFactoryMap.put("/application-client", new DCBTopRootFactory(AppClientRoot.class));
        }
        return this.dcbFactoryMap;
    }

    public void addFileToPlanForModule(File f, DeployableObject mod, ConfigurationStorage storage) throws ConfigurationException {
        String uri = this.getUriForDeployableObject(mod, storage);
        String fname = f.getName();
        String key = Utils.getFQNKey(uri, fname);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream fis = null;
        int totalRead = 0;
        try {
            fis = new FileInputStream(f);
            byte[] buf = new byte[BUF_LEN];
            int lastRead = 0;
            do {
                if ((lastRead = fis.read(buf)) <= -1) continue;
                baos.write(buf, 0, lastRead);
                totalRead += lastRead;
            } while (lastRead > -1);
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            ConfigurationException ce = new ConfigurationException("Failed while reading");
            ce.initCause((Throwable)ioe);
            throw ce;
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (totalRead > 0) {
            this.contentMap.put(key, baos.toByteArray());
        } else {
            this.contentMap.remove(key);
        }
        Object oldMap = this.beanMap.remove(key);
        if (oldMap != null) {
            this.priorBeanMap.put(key, oldMap);
        }
    }

    public void extractFileFromPlanForModule(File f, DeployableObject mod, ConfigurationStorage storage) throws IOException {
        String fname;
        String uri = this.getUriForDeployableObject(mod, storage);
        String key = Utils.getFQNKey(uri, fname = f.getName());
        final byte[] content = (byte[])this.contentMap.get(key);
        if (null != content) {
            FileObject folder;
            File parentFile = f.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if ((folder = FileUtil.toFileObject((File)parentFile)) == null) {
                String errorMsg = NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_SaveError", (Object)fname) + "  " + NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_FailedToCreateConfigFolder", (Object)parentFile.getAbsolutePath());
                throw new IOException(errorMsg);
            }
            if (!folder.isFolder()) {
                String errorMsg = NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_SaveError", (Object)fname) + "  " + NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_ConfigFolderNotDirectory", (Object)parentFile.getAbsolutePath());
                throw new IOException(errorMsg);
            }
            FileSystem fs = folder.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileLock lock = null;
                    OutputStream out = null;
                    try {
                        FileObject configFO = folder.getFileObject(fname);
                        if (configFO == null) {
                            configFO = folder.createData(fname);
                        }
                        lock = configFO.lock();
                        out = new BufferedOutputStream(configFO.getOutputStream(lock), 4096);
                        out.write(content);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
    }

    private String getUriForDeployableObject(DeployableObject mod, ConfigurationStorage storage) {
        String rootUri = "";
        if (ModuleType.EAR.equals(mod.getType())) {
            rootUri = "EAR";
        }
        return rootUri;
    }

    void updateContentMap(DConfigBeanRoot rootBean) throws ConfigurationException {
        jsr88Logger.entering(this.getClass().toString(), "save", rootBean);
        LinkedHashMap outputGraphs = new LinkedHashMap();
        LinkedHashMap<String, BaseBean> cmpGraphs = new LinkedHashMap<String, BaseBean>();
        try {
            ByteArrayOutputStream baos;
            Object k;
            if (rootBean == null) {
                Iterator rootIter = this.getDCBRootCache().entrySet().iterator();
                while (rootIter.hasNext()) {
                    EjbJarRoot ejbJar;
                    Snippet cmpSnippet;
                    Base dcb = (Base)rootIter.next().getValue();
                    dcb.addToGraphs(outputGraphs, null, "");
                    if (!(dcb instanceof EjbJarRoot) || !(cmpSnippet = (ejbJar = (EjbJarRoot)dcb).getCmpMappingSnippet()).hasDDSnippet()) continue;
                    String snippetKey = Utils.getFQNKey(ejbJar.getUriText(), cmpSnippet.getFileName());
                    cmpGraphs.put(snippetKey, cmpSnippet.getCmpDDSnippet());
                }
            } else {
                EjbJarRoot ejbJar;
                Snippet cmpSnippet;
                ((Base)rootBean).addToGraphs(outputGraphs, null, "");
                if (rootBean instanceof EjbJarRoot && (cmpSnippet = (ejbJar = (EjbJarRoot)rootBean).getCmpMappingSnippet()).hasDDSnippet()) {
                    String snippetKey = Utils.getFQNKey(ejbJar.getUriText(), cmpSnippet.getFileName());
                    cmpGraphs.put(snippetKey, cmpSnippet.getCmpDDSnippet());
                }
            }
            Set keys = outputGraphs.keySet();
            Iterator iter = keys.iterator();
            DeploymentPlan dp = new DeploymentPlan();
            while (iter.hasNext()) {
                k = iter.next();
                CommonDDBean bean = (CommonDDBean)outputGraphs.get(k);
                if (null != bean) {
                    baos = new ByteArrayOutputStream();
                    bean.write((OutputStream)baos);
                    this.contentMap.put(k, baos.toByteArray());
                    continue;
                }
                jsr88Logger.warning("no bean for key: " + k);
            }
            keys = cmpGraphs.keySet();
            iter = keys.iterator();
            while (iter.hasNext()) {
                k = iter.next();
                BaseBean cmpRoot = (BaseBean)cmpGraphs.get(k);
                if (null != cmpRoot) {
                    baos = new ByteArrayOutputStream();
                    cmpRoot.write((OutputStream)baos);
                    this.contentMap.put(k, baos.toByteArray());
                    continue;
                }
                jsr88Logger.warning("no bean for key: " + k);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            ConfigurationException ce = new ConfigurationException("Sun Deployment Descriptor Error");
            ce.initCause((Throwable)ex);
        }
        jsr88Logger.exiting(this.getClass().toString(), "save", rootBean);
    }

    private void refreshGraphFromContentMap(BaseRoot br) {
        ArrayList<BaseRoot> pending = new ArrayList<BaseRoot>();
        BaseRoot rootToRestore = br;
        pending.add(rootToRestore);
        for (int index = 0; index < pending.size(); ++index) {
            Base current;
            block3: {
                current = (Base)pending.get(index);
                try {
                    current.loadFromPlanFile(this);
                }
                catch (IllegalStateException ise) {
                    jsr88Logger.throwing(current.getClass().toString(), "loadFromPlanFile", ise);
                    if ($assertionsDisabled || ise == null) break block3;
                    throw new AssertionError();
                }
            }
            pending.addAll(current.getChildren());
        }
    }

    public void readDeploymentPlanFiles(ConfigurationStorage storage, DDBeanRoot masterRootDDBean) throws ConfigurationException {
        boolean loadGraph = false;
        this.contentMap.clear();
        BaseRoot masterRoot = (BaseRoot)this.getDConfigBeanRoot(masterRootDDBean);
        int len = this.getValidatedNumberOfFiles(this.configFiles);
        for (int i = 0; i < len; ++i) {
            if (!this.configFiles[i].exists()) continue;
            this.addFileToPlanForModule(this.configFiles[i], this.dObj, storage);
            loadGraph = true;
        }
        if (loadGraph) {
            if (masterRoot != null) {
                this.refreshGraphFromContentMap(masterRoot);
            } else {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Loaded configuration data from disk but master DConfigBeanRoot is null."));
            }
        }
        for (int j = 0; j < this.configFiles.length; ++j) {
            FileObject fo = FileUtil.toFileObject((File)this.configFiles[j]);
            if (fo == null) continue;
            fo.refresh(true);
        }
    }

    public void writeDeploymentPlanFiles(ConfigurationStorage storage) throws IOException, ConfigurationException {
        this.updateContentMap(null);
        int len = this.getValidatedNumberOfFiles(this.configFiles);
        for (int i = 0; i < len; ++i) {
            this.extractFileFromPlanForModule(this.configFiles[i], this.dObj, storage);
        }
        for (int j = 0; j < this.configFiles.length; ++j) {
            FileObject fo = FileUtil.toFileObject((File)this.configFiles[j]);
            if (fo == null) continue;
            fo.refresh(true);
        }
    }

    int getValidatedNumberOfFiles(File[] files) throws ConfigurationException {
        int len = 0;
        if (null != files) {
            len = files.length;
        }
        if (len < 1) {
            throw new ConfigurationException("file list is too short");
        }
        return len;
    }

    private ASDDVersion getTargetAppServerVersion() {
        ASDDVersion result = null;
        J2eeModuleProvider provider = this.getProvider(this.configFiles[0].getParentFile());
        String serverType = provider.getServerID();
        if ("J2EE".equals(serverType)) {
            String instance = provider.getServerInstanceID();
            if (Utils.notEmpty(instance)) {
                try {
                    String asInstallPath = instance.substring(1, instance.indexOf("deployer") - 1);
                    File asInstallFolder = new File(asInstallPath);
                    if (asInstallFolder.exists()) {
                        result = this.getInstalledAppServerVersion(asInstallFolder);
                    }
                }
                catch (IndexOutOfBoundsException ex) {
                    ErrorManager.getDefault().log(16, NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_NoServerInstallLocation", (Object)instance));
                }
                catch (NullPointerException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        } else if ("SUNWebserver7".equals(serverType)) {
            result = ASDDVersion.SUN_APPSERVER_8_1;
        }
        return result;
    }

    private ASDDVersion getInstalledAppServerVersion(File asInstallFolder) {
        File dtdFolder = new File(asInstallFolder, "lib/dtds/");
        if (dtdFolder.exists()) {
            File domain12dtd = new File(dtdFolder, "sun-domain_1_2.dtd");
            if (domain12dtd.exists()) {
                return ASDDVersion.SUN_APPSERVER_9_0;
            }
            File domain11dtd = new File(dtdFolder, "sun-domain_1_1.dtd");
            if (domain11dtd.exists()) {
                return ASDDVersion.SUN_APPSERVER_8_1;
            }
            File domain10dtd = new File(dtdFolder, "sun-domain_1_0.dtd");
            if (domain10dtd.exists()) {
                return ASDDVersion.SUN_APPSERVER_7_0;
            }
        }
        return null;
    }

    public boolean isDatasourceCreationSupported() {
        return true;
    }

    public Set getDatasources() {
        HashSet datasources = new HashSet();
        ResourceConfiguratorInterface rci = this.getResourceConfigurator();
        if (this.resourceDir != null && this.resourceDir.exists()) {
            datasources = rci.getResources(this.resourceDir);
        }
        return datasources;
    }

    public Datasource createDatasource(String jndiName, String url, String username, String password, String driver) throws OperationUnsupportedException, ConfigurationException, DatasourceAlreadyExistsException {
        SunDatasource ds = null;
        if (this.resourceDir == null) {
            this.postResourceError(NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_NoRefJdbcDataSource", (Object)jndiName));
            throw new ConfigurationException(NbBundle.getMessage((Class)SunONEDeploymentConfiguration.class, (String)"ERR_NoRefJdbcDataSource", (Object)jndiName));
        }
        ResourceConfiguratorInterface rci = this.getResourceConfigurator();
        if (rci != null) {
            ds = rci.createDataSource(jndiName, url, username, password, driver, this.resourceDir);
        }
        return ds;
    }

    static {
        $assertionsDisabled = !SunONEDeploymentConfiguration.class.desiredAssertionStatus();
        configurationMap = new WeakHashMap();
        resourceProcessor = new RequestProcessor("sun-resource-ref");
        BUF_LEN = 1024;
    }

    private class DCBTopRootFactory
    implements DCBFactory {
        private Class dcbRootClass;

        DCBTopRootFactory(Class c) {
            this.dcbRootClass = c;
        }

        public Base createDCB(DDBean ddBean, Base dcbParent) throws ConfigurationException {
            if (ddBean == null) {
                throw Utils.makeCE("ERR_RootDDBeanIsNull", null, null);
            }
            if (!(ddBean instanceof DDBeanRoot)) {
                Object[] args = new Object[]{this.dcbRootClass.getName()};
                throw Utils.makeCE("ERR_RootDDBeanWrongType", args, null);
            }
            DDBeanRoot ddbRoot = (DDBeanRoot)ddBean;
            BaseRoot newDCB = null;
            try {
                newDCB = (BaseRoot)this.dcbRootClass.newInstance();
                newDCB.init(ddbRoot, SunONEDeploymentConfiguration.this, (DDBean)ddbRoot);
            }
            catch (InstantiationException ex) {
                Object[] args = new Object[]{this.dcbRootClass.getName()};
                throw Utils.makeCE("ERR_UnexpectedInstantiateException", args, ex);
            }
            catch (IllegalAccessException ex) {
                Object[] args = new Object[]{this.dcbRootClass.getName()};
                throw Utils.makeCE("ERR_UnexpectedIllegalAccessException", args, ex);
            }
            catch (RuntimeException ex) {
                throw Utils.makeCE("ERR_UnexpectedRuntimeException", null, ex);
            }
            return newDCB;
        }
    }
}

