/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.nodes;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.swing.Action;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.DatabasePropertySupport;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class DatabaseNode
extends AbstractNode
implements Node.Cookie {
    protected DatabaseNodeInfo info;
    private boolean writable = false;
    private boolean cutflag = false;
    private boolean copyflag = false;
    private boolean delflag = false;
    public static final String ROOT = "root";
    public static final String DRIVER_LIST = "driverlist";
    public static final String DRIVER = "driver";
    public static final String CONNECTION = "connection";
    public static final String CATALOG = "catalog";
    public static final String TABLELIST = "tablelist";
    public static final String TABLE = "table";
    public static final String VIEW = "view";
    public static final String VIEWLIST = "viewlist";
    public static final String VIEWCOLUMN = "viewcolumn";
    public static final String INDEX = "index";
    public static final String COLUMN = "column";
    public static final String INDEXCOLUMN = "indexcolumn";
    public static final String PRIMARY_KEY = "pcolumn";
    public static final String INDEXED_COLUMN = "icolumn";
    public static final String FOREIGN_COLUMN = "fcolumn";
    public static final String FOREIGN_KEY = "fcolumn";
    public static final String EXPORTED_KEY = "ekey";
    public static final String IMPORTED_KEY = "fkey";
    public static final String PROCEDURE = "procedure";
    public static final String PROCEDURELIST = "procedurelist";
    public static final String PROCEDURE_COLUMN = "procedurecolumn";
    static /* synthetic */ Class class$java$lang$Boolean;

    public DatabaseNode() {
        super((Children)new DatabaseNodeChildren());
    }

    public DatabaseNode(Children child) {
        super(child);
    }

    public DatabaseNodeInfo getInfo() {
        return this.info;
    }

    public void setInfo(DatabaseNodeInfo nodeinfo) {
        this.info = (DatabaseNodeInfo)nodeinfo.clone();
        this.processInfo();
    }

    protected void processInfo() {
        super.setName(this.info.getName());
        this.setIconBase(this.info.getIconBase());
        Map opts = (Map)this.info.get("options");
        if (opts != null) {
            String str = (String)opts.get("cut");
            if (str != null) {
                this.cutflag = str.toUpperCase().equals("YES");
            }
            if ((str = (String)opts.get("copy")) != null) {
                this.copyflag = str.toUpperCase().equals("YES");
            }
            if ((str = (String)opts.get("delete")) != null) {
                this.delflag = str.toUpperCase().equals("YES");
            }
        }
        try {
            Vector prop = (Vector)this.info.get("properties");
            Enumeration prop_i = prop.elements();
            while (prop_i.hasMoreElements()) {
                Map propmap = (Map)prop_i.nextElement();
                if (!((String)propmap.get("code")).equals("name")) continue;
                this.writable = ((String)propmap.get("writable")).toUpperCase().equals("YES");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setName(String newname) {
        super.setName(newname);
        this.info.setName(newname);
    }

    public boolean canRename() {
        return this.writable;
    }

    public boolean canCut() {
        return this.cutflag;
    }

    public boolean canCopy() {
        return this.copyflag;
    }

    public boolean canDestroy() {
        return this.delflag;
    }

    public void destroy() throws IOException {
        this.info.delete();
        DatabaseNodeInfo parent = this.info.getParent();
        super.destroy();
        try {
            parent.refreshChildren();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public Node.Cookie getCookie(Class cls) {
        if (cls.isInstance(this.info)) {
            return this.info;
        }
        return super.getCookie(cls);
    }

    public Action[] getActions(boolean context) {
        Object[] retacts;
        SystemAction[] sysacts = NodeOp.getDefaultActions();
        Vector actions = this.info.getActions();
        if (actions.size() > 0) {
            Action[] myacts = actions.toArray(new Action[actions.size()]);
            retacts = new Action[sysacts.length + myacts.length];
            System.arraycopy(myacts, 0, retacts, 0, myacts.length);
            System.arraycopy(sysacts, 0, retacts, myacts.length, sysacts.length);
        } else {
            retacts = sysacts;
        }
        return retacts;
    }

    protected Map createProperty(String name) {
        return null;
    }

    protected PropertySupport createPropertySupport(String name, Class type, String displayName, String shortDescription, DatabaseNodeInfo rep, boolean writable) {
        return new DatabasePropertySupport(name, type, displayName, shortDescription, rep, writable);
    }

    protected PropertySupport createPropertySupport(String name, Class type, String displayName, String shortDescription, DatabaseNodeInfo rep, boolean writable, boolean expert) {
        DatabasePropertySupport ps = new DatabasePropertySupport(name, type, displayName, shortDescription, rep, writable);
        ps.setExpert(expert);
        return ps;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        Vector prop = (Vector)this.info.get("properties");
        Enumeration prop_i = prop.elements();
        while (prop_i.hasMoreElements()) {
            boolean expert = false;
            Map propmap = (Map)prop_i.nextElement();
            String key = (String)propmap.get("code");
            String expkey = (String)propmap.get("expert");
            if (expkey != null) {
                expert = expkey.toUpperCase().equals("YES");
            }
            try {
                PropertySupport.Name psitem = null;
                String pname = null;
                String pclass = null;
                String pdesc = null;
                if (propmap == null && (propmap = this.createProperty(key)) != null) {
                    this.info.put(key, propmap);
                }
                if (key.equals("name")) {
                    if (!this.info.isReadOnly()) {
                        psitem = new PropertySupport.Name((Node)this);
                    }
                } else {
                    Class<Object> pc = null;
                    pname = (String)propmap.get("name");
                    if (this.info.canAdd(propmap, pname)) {
                        pclass = (String)propmap.get("class");
                        boolean canWrite = this.info.canWrite(propmap, pname, this.writable);
                        pc = pclass.equals("java.lang.Boolean") ? (class$java$lang$Boolean == null ? DatabaseNode.class$("java.lang.Boolean") : class$java$lang$Boolean) : (pclass.equals("java.lang.Integer") ? Integer.TYPE : Class.forName(pclass));
                        try {
                            pname = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString(pname);
                        }
                        catch (MissingResourceException e) {
                            pdesc = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("DatabaseNodeUntitled");
                        }
                        psitem = this.createPropertySupport(key, pc, pname, pdesc, this.info, canWrite, expert);
                    }
                }
                if (psitem == null) continue;
                ps.put((Node.Property)psitem);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return sheet;
    }

    protected void deleteNode(DatabaseNode node) throws DatabaseException {
        try {
            DatabaseNodeInfo ninfo = node.getInfo();
            DatabaseNodeChildren children = (DatabaseNodeChildren)this.getChildren();
            this.info.getChildren().removeElement(ninfo);
            children.remove(new Node[]{node});
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void deleteNode() throws DatabaseException {
        try {
            DatabaseNode parent = (DatabaseNode)this.getParentNode().getCookie(null);
            if (parent != null) {
                parent.deleteNode(this);
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("dbexpovew");
    }

    public String getShortDescription() {
        String code = this.getInfo().getCode();
        if (code.equals(INDEXCOLUMN)) {
            return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ND_Column");
        }
        if (code.equals("fklist")) {
            return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ND_ForeignKeyList");
        }
        if (code.equals("ilist")) {
            return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ND_IndexList");
        }
        return "";
    }
}

