/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.DatabaseSpecificationFactory;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.util.PListReader;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.DbMetaDataListenerSupport;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableListNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class DatabaseNodeInfo
extends Hashtable
implements Node.Cookie {
    public static final String SPECIFICATION_FACTORY = "specfactory";
    public static final String SPECIFICATION = "spec";
    public static final String DRIVER_SPECIFICATION = "drvspec";
    public static final String DBPRODUCT = "dbproduct";
    public static final String DBVERSION = "dbversion";
    public static final String SUPPORTED_DBS = "suppdbs";
    public static final String DRIVER = "driver";
    public static final String DBDRIVER = "dbdriver";
    public static final String DATABASE = "db";
    public static final String URL = "url";
    public static final String PREFIX = "prefix";
    public static final String CONNECTION = "connection";
    public static final String CODE = "code";
    public static final String NODE = "node";
    public static final String CLASS = "class";
    public static final String INFOCLASS = "infoclass";
    public static final String NAME = "name";
    public static final String USER = "user";
    public static final String SCHEMA = "schema";
    public static final String PASSWORD = "password";
    public static final String CHILDREN = "children";
    public static final String ACTIONS = "actions";
    public static final String ICONBASE = "iconbase";
    public static final String PROPERTIES = "properties";
    public static final String RESULTSET = "resultset";
    public static final String REMEMBER_PWD = "rememberpwd";
    public static final String WRITABLE = "writable";
    public static final String DELETABLE = "deletable";
    public static final String DESCRIPTION = "description";
    public static final String READONLYDB = "readonlydatabase";
    public static final String GROUPSUP = "groupbysupport";
    public static final String OJOINSUP = "outerjoinsupport";
    public static final String UNIONSUP = "unionsupport";
    public static final String SYSTEM_ACTION = "system";
    public static final String CHILDREN_ORDERING = "children_ordering";
    public static final String READONLY = "readOnly";
    public static final String PERM = "perm";
    public static final String ADAPTOR = "adaptor";
    public static final String ADAPTOR_CLASSNAME = "adaptorClass";
    private static Map gtab = null;
    static final String gtabfile = "org/netbeans/modules/db/resources/explorer.plist";
    private boolean connected = false;
    transient boolean passwordWasSet = false;
    private DatabaseNodeInfo parent = null;
    WeakReference nodewr = null;
    private PropertyChangeSupport pcs = null;
    private Set connectionpcsKeys = null;
    private PropertyChangeSupport driverpcs = null;
    private Set driverpcsKeys = null;
    static final long serialVersionUID = 1176243907461868244L;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    protected static ResourceBundle bundle() {
        return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    }

    public static Map getGlobalNodeInfo() {
        if (gtab == null) {
            gtab = DatabaseNodeInfo.readInfo();
        }
        return gtab;
    }

    public static Map readInfo() {
        HashMap data;
        try {
            ClassLoader cl = DatabaseNodeInfo.class.getClassLoader();
            InputStream stream = cl.getResourceAsStream(gtabfile);
            if (stream == null) {
                String message = MessageFormat.format(DatabaseNodeInfo.bundle().getString("EXC_UnableToOpenStream"), gtabfile);
                throw new Exception(message);
            }
            PListReader reader = new PListReader(stream);
            data = reader.getData();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            data = null;
        }
        return data;
    }

    public static Object getGlobalNodeInfo(String key) {
        return DatabaseNodeInfo.getGlobalNodeInfo().get(key);
    }

    public static DatabaseNodeInfo createNodeInfo(DatabaseNodeInfo parent, String nodecode) throws DatabaseException {
        DatabaseNodeInfo e_ni = null;
        try {
            String nodec = (String)((Map)DatabaseNodeInfo.getGlobalNodeInfo().get(nodecode)).get(INFOCLASS);
            if (nodec == null) {
                String message = MessageFormat.format(DatabaseNodeInfo.bundle().getString("EXC_UnableToFindClassInfo"), nodecode);
                throw new Exception(message);
            }
            e_ni = (DatabaseNodeInfo)Class.forName(nodec).newInstance();
        }
        catch (Exception exc) {
            throw new DatabaseException(exc.getMessage());
        }
        if (e_ni == null) {
            String message = MessageFormat.format(DatabaseNodeInfo.bundle().getString("EXC_UnableToCreateNodeInfo"), nodecode);
            throw new DatabaseException(message);
        }
        e_ni.setParentInfo(parent, nodecode);
        return e_ni;
    }

    public static DatabaseNodeInfo createNodeInfo(DatabaseNodeInfo parent, String nodecode, HashMap rset) throws DatabaseException {
        int colidx = 1;
        String key = null;
        DatabaseNodeInfo nfo = DatabaseNodeInfo.createNodeInfo(parent, nodecode);
        Vector rsnames = (Vector)nfo.get(RESULTSET);
        Iterator rsnames_i = rsnames.iterator();
        Hashtable data = new Hashtable();
        while (rsnames_i.hasNext()) {
            Object value;
            key = (String)rsnames_i.next();
            if (!key.equals("unused") && (value = rset.get(new Integer(colidx))) != null) {
                data.put(key, value);
            }
            ++colidx;
        }
        nfo.putAll(data);
        nfo.put(nodecode, nfo.getName());
        if (parent != null && parent.isReadOnly()) {
            nfo.setReadOnly(true);
        }
        return nfo;
    }

    public DatabaseNodeInfo() {
    }

    public DatabaseNodeInfo(DatabaseNodeInfo parent, String sname) throws DatabaseException {
        DatabaseNodeInfo nfo = new DatabaseNodeInfo();
        nfo.setParentInfo(parent, sname);
    }

    public void setParentInfo(DatabaseNodeInfo parent, String sname) throws DatabaseException {
        Map ltab;
        if (parent != null) {
            this.putAll(parent);
            this.parent = parent;
        }
        if ((ltab = (Map)DatabaseNodeInfo.getGlobalNodeInfo(sname)) == null) {
            String message = MessageFormat.format(DatabaseNodeInfo.bundle().getString("EXC_UnableToReadInfo"), sname);
            throw new DatabaseException(message);
        }
        this.putAll(ltab);
        this.put(CODE, sname);
        if (parent != null && parent.isReadOnly()) {
            this.setReadOnly(true);
        }
    }

    public DatabaseNodeInfo getParent() {
        return this.parent;
    }

    public DatabaseNodeInfo getParent(String code) {
        DatabaseNodeInfo iinfo;
        if (code != null) {
            for (iinfo = this; iinfo != null; iinfo = iinfo.getParent()) {
                String iicode = iinfo.getCode();
                if (!iicode.equals(code)) continue;
                return iinfo;
            }
        }
        return iinfo;
    }

    public boolean canAdd(Map propmap, String propname) {
        return true;
    }

    public boolean canWrite(Map propmap, String propname, boolean defa) {
        if (this.isReadOnly()) {
            return false;
        }
        String wflag = (String)propmap.get(WRITABLE);
        if (wflag != null) {
            return wflag.toUpperCase().equals("YES");
        }
        return defa;
    }

    public DatabaseNode getNode() {
        if (this.nodewr != null) {
            return (DatabaseNode)((Object)this.nodewr.get());
        }
        return null;
    }

    public void setNode(DatabaseNode node) {
        this.nodewr = new WeakReference<DatabaseNode>(node);
    }

    private PropertyChangeSupport getConnectionPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    private PropertyChangeSupport getDriverPCS() {
        if (this.driverpcs == null) {
            this.driverpcs = new PropertyChangeSupport(this);
        }
        return this.driverpcs;
    }

    private Set getDriverPCSKeys() {
        if (this.driverpcsKeys == null) {
            this.driverpcsKeys = new HashSet();
            this.driverpcsKeys.add(NAME);
            this.driverpcsKeys.add(URL);
            this.driverpcsKeys.add(PREFIX);
            this.driverpcsKeys.add(ADAPTOR_CLASSNAME);
        }
        return this.driverpcsKeys;
    }

    private Set getConnectionPCSKeys() {
        if (this.connectionpcsKeys == null) {
            this.connectionpcsKeys = new HashSet();
            this.connectionpcsKeys.add(SCHEMA);
            this.connectionpcsKeys.add(USER);
            this.connectionpcsKeys.add(DATABASE);
        }
        return this.connectionpcsKeys;
    }

    public Object put(Object key, Object obj) {
        Object old = this.get(key);
        if (key == null) {
            throw new NullPointerException();
        }
        if (obj != null) {
            super.put(key, obj);
        } else {
            this.remove(key);
        }
        if (key.equals(PASSWORD)) {
            this.passwordWasSet = true;
        }
        if (this.getDriverPCSKeys().contains(key)) {
            this.getDriverPCS().firePropertyChange((String)key, old, obj);
        }
        if (this.getConnectionPCSKeys().contains(key)) {
            this.getConnectionPCS().firePropertyChange((String)key, null, obj);
        }
        return old;
    }

    public void delete() throws IOException {
    }

    public void refreshChildren() throws DatabaseException {
        Vector charr = new Vector();
        this.put(CHILDREN, charr);
        this.initChildren(charr);
        try {
            final Node[] subTreeNodes = new Node[charr.size()];
            final DatabaseNodeChildren children = (DatabaseNodeChildren)this.getNode().getChildren();
            for (int i = 0; i < charr.size(); ++i) {
                subTreeNodes[i] = children.createNode((DatabaseNodeInfo)charr.elementAt(i));
            }
            Children.MUTEX.postWriteRequest(new Runnable(){

                public void run() {
                    children.remove(children.getNodes());
                    children.add(subTreeNodes);
                }
            });
            this.fireRefresh();
        }
        catch (ClassCastException ex) {
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    protected void fireRefresh() {
        ConnectionNodeInfo cnnfo;
        boolean allTables = true;
        if (!(this instanceof TableListNodeInfo)) {
            allTables = false;
            if (!(this instanceof TableNodeInfo)) {
                return;
            }
        }
        if ((cnnfo = (ConnectionNodeInfo)this.getParent(CONNECTION)) == null) {
            return;
        }
        DatabaseConnection dbconn = ConnectionList.getDefault().getConnection(cnnfo.getDatabaseConnection());
        if (dbconn != null) {
            if (allTables) {
                DbMetaDataListenerSupport.fireTablesChanged(dbconn.getDatabaseConnection());
            } else {
                String tableName = (String)this.get("table");
                DbMetaDataListenerSupport.fireTableChanged(dbconn.getDatabaseConnection(), tableName);
            }
        }
    }

    public Object getProperty(String key) {
        return this.get(key);
    }

    public void setProperty(String key, Object obj) {
        this.put(key, obj);
    }

    public void addConnectionListener(PropertyChangeListener l) {
        this.getConnectionPCS().addPropertyChangeListener(l);
    }

    public void removeConnectionListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addDriverListener(PropertyChangeListener l) {
        this.getDriverPCS().addPropertyChangeListener(l);
    }

    public void removeDriverListener(PropertyChangeListener l) {
        this.getDriverPCS().removePropertyChangeListener(l);
    }

    public DatabaseSpecificationFactory getSpecificationFactory() {
        return (DatabaseSpecificationFactory)this.get(SPECIFICATION_FACTORY);
    }

    public void setSpecificationFactory(DatabaseSpecificationFactory fac) {
        this.put(SPECIFICATION_FACTORY, fac);
        this.put(SUPPORTED_DBS, fac.supportedDatabases());
    }

    protected String getDatabaseAdaptorClassName() {
        return "org.netbeans.lib.ddl.adaptors.DefaultAdaptor";
    }

    public DatabaseSpecification getSpecification() {
        DatabaseSpecification spec = (DatabaseSpecification)this.get(SPECIFICATION);
        if (spec == null) {
            return spec;
        }
        String adaname = this.getDatabaseAdaptorClassName();
        if (!spec.getMetaDataAdaptorClassName().equals(adaname)) {
            spec.setMetaDataAdaptorClassName(adaname);
        }
        return spec;
    }

    public void setSpecification(DatabaseSpecification spec) {
        this.put(SPECIFICATION, spec);
    }

    public String getDriver() {
        return (String)this.get(DRIVER);
    }

    public void setDriver(String drv) {
        this.put(DRIVER, drv);
    }

    public Connection getConnection() {
        return (Connection)this.get(CONNECTION);
    }

    public void setConnection(Connection con) throws DatabaseException {
        Connection oldval = this.getConnection();
        if (con != null) {
            if (oldval != null && oldval.equals(con)) {
                return;
            }
            this.put(CONNECTION, con);
            this.setConnected(true);
        } else {
            this.remove(CONNECTION);
            this.setConnected(false);
        }
        if (con != null && this.isReadOnly()) {
            Enumeration enu = this.getChildren().elements();
            while (enu.hasMoreElements()) {
                DatabaseNodeInfo ninfo = (DatabaseNodeInfo)enu.nextElement();
                ninfo.setReadOnly(true);
            }
        }
        this.getConnectionPCS().firePropertyChange(CONNECTION, oldval, con);
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public DatabaseConnection getDatabaseConnection() {
        DatabaseConnection con = new DatabaseConnection(this.getDriver(), this.getDatabase(), this.getUser(), this.getPassword());
        if (this.get(REMEMBER_PWD) != null) {
            con.setRememberPassword((Boolean)this.get(REMEMBER_PWD));
        } else {
            con.setRememberPassword(Boolean.FALSE);
        }
        con.setSchema(this.getSchema());
        con.setDriverName((String)this.get("drivername"));
        return con;
    }

    public DatabaseDriver getDatabaseDriver() {
        return (DatabaseDriver)this.get(DBDRIVER);
    }

    public void setDatabaseConnection(DBConnection cinfo) {
        String pwd = cinfo.getPassword();
        this.put(DRIVER, cinfo.getDriver());
        this.put(DATABASE, cinfo.getDatabase());
        this.put(USER, cinfo.getUser());
        this.put(SCHEMA, cinfo.getSchema());
        if (pwd != null) {
            this.put(PASSWORD, pwd);
        }
        this.put(REMEMBER_PWD, cinfo.rememberPassword() ? Boolean.TRUE : Boolean.FALSE);
        this.put("drivername", cinfo.getDriverName());
    }

    public String getCode() {
        return (String)this.get(CODE);
    }

    public void setCode(String nam) {
        this.put(CODE, nam);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public void setName(String nam) {
        this.put(NAME, nam);
    }

    public String getUser() {
        return (String)this.get(USER);
    }

    public void setUser(String usr) {
        this.put(USER, usr);
    }

    public String getSchema() {
        return (String)this.get(SCHEMA);
    }

    public void setSchema(String schema) {
        this.put(SCHEMA, schema);
    }

    public String getDatabase() {
        return (String)this.get(DATABASE);
    }

    public void setDatabase(String db) {
        this.put(DATABASE, db);
    }

    public String getPassword() {
        return (String)this.get(PASSWORD);
    }

    public void setPassword(String pwd) {
        this.put(PASSWORD, pwd);
    }

    public String getTable() {
        return (String)this.get("table");
    }

    public String getView() {
        return (String)this.get("view");
    }

    public void setTable(String nam) {
        this.put("table", nam);
    }

    public String getIconBase() {
        return (String)this.get(ICONBASE);
    }

    public void setIconBase(String base) {
        this.put(ICONBASE, base);
    }

    public String getDisplayname() {
        return (String)this.get("displayname");
    }

    public void setDisplayname(String name) {
        this.put("displayname", name);
    }

    public String getURL() {
        return (String)this.get(URL);
    }

    public void setURL(String url) {
        this.put(URL, url);
    }

    public Properties getConnectionProperties() {
        Properties props = new Properties();
        try {
            props.put(USER, this.getUser());
            props.put(PASSWORD, this.getPassword());
            props.put(SCHEMA, this.getSchema());
        }
        catch (Exception e) {
            props = null;
        }
        return props;
    }

    protected void initChildren(Vector children) throws DatabaseException {
    }

    public Vector getChildren() throws DatabaseException {
        Vector children = (Vector)this.get(CHILDREN);
        if (children.size() > 0 && children.elementAt(0) instanceof DatabaseNodeInfo) {
            return children;
        }
        Vector chalt = new Vector();
        this.initChildren(chalt);
        chalt.addAll(children);
        try {
            for (int i = 0; i < chalt.size(); ++i) {
                Object e_child = chalt.elementAt(i);
                if (!(e_child instanceof String)) continue;
                DatabaseNodeInfo e_ni = DatabaseNodeInfo.createNodeInfo(this, (String)e_child);
                chalt.setElementAt(e_ni, i);
            }
            children = chalt;
            this.put(CHILDREN, children);
        }
        catch (Exception exc) {
            String message = MessageFormat.format(DatabaseNodeInfo.bundle().getString("EXC_UnableToCreateChildren"), exc.getMessage());
            throw new DatabaseException(message);
        }
        return children;
    }

    public void setChildren(Vector chvec) {
        this.put(CHILDREN, chvec);
    }

    public Vector getActions() {
        Vector<SystemAction> actions = (Vector<SystemAction>)this.get(ACTIONS);
        if ((actions = (Vector)actions.clone()) == null) {
            actions = new Vector<SystemAction>();
            this.put(ACTIONS, actions);
        }
        if (actions.size() == 0) {
            return actions;
        }
        boolean ro = this.isReadOnly();
        for (int i = 0; i < actions.size(); ++i) {
            SystemAction action;
            block12: {
                Object e_act = actions.elementAt(i);
                action = null;
                if (e_act instanceof Map) {
                    Map e_action = (Map)e_act;
                    try {
                        String perm = (String)e_action.get(PERM);
                        if (ro && perm != null && perm instanceof String && perm.indexOf("write") != -1) {
                            actions.setElementAt(null, i);
                            continue;
                        }
                        boolean systemact = false;
                        String sysactstr = (String)e_action.get(SYSTEM_ACTION);
                        if (sysactstr != null) {
                            systemact = sysactstr.toUpperCase().equals("YES");
                        }
                        String actnode = (String)e_action.get(NODE);
                        String actcn = (String)e_action.get(CLASS);
                        if (!systemact) {
                            String locname;
                            String xname = (String)e_action.get(NAME);
                            try {
                                locname = DatabaseNodeInfo.bundle().getString(xname);
                            }
                            catch (MissingResourceException e) {
                                locname = xname;
                                String message = MessageFormat.format(DatabaseNodeInfo.bundle().getString("ERR_UnableToLocateLocalizedMenuItem"), xname);
                                System.out.println(message);
                            }
                            action = SystemAction.get(Class.forName(actcn));
                            ((DatabaseAction)action).setName(locname);
                            ((DatabaseAction)action).setNode(actnode);
                            break block12;
                        }
                        ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? DatabaseNodeInfo.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader);
                        if (l == null) {
                            l = this.getClass().getClassLoader();
                        }
                        action = SystemAction.get(Class.forName(actcn, true, l));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            actions.setElementAt(action, i);
        }
        return actions;
    }

    public String toString() {
        String result = "";
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            result = result + key + ": " + this.get(key) + "\n";
        }
        return result;
    }

    public boolean isDebugMode() {
        return RootNode.getOption().getDebugMode();
    }

    public void setDebugMode(boolean mode) {
        RootNode.getOption().setDebugMode(mode);
    }

    public boolean isReadOnly() {
        Boolean roobj = (Boolean)this.get(READONLY);
        if (roobj != null) {
            return roobj;
        }
        return false;
    }

    public void setReadOnly(boolean flag) {
        this.put(READONLY, flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public DriverSpecification getDriverSpecification() {
        return (DriverSpecification)this.get(DRIVER_SPECIFICATION);
    }

    public void setDriverSpecification(DriverSpecification driverSpecification) {
        this.put(DRIVER_SPECIFICATION, driverSpecification);
    }

    public boolean isPasswordSet() {
        return this.passwordWasSet;
    }
}

