/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

public final class SourceForBinaryImpl
implements SourceForBinaryQueryImplementation {
    private final NbModuleProject project;
    private String clusterPath;
    private URL classesUrl;
    private URL testClassesUrl;
    private Map cache = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public SourceForBinaryImpl(NbModuleProject project) {
        this.project = project;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        SourceForBinaryQuery.Result res = (SourceForBinaryQuery.Result)this.cache.get(binaryRoot);
        if (res == null) {
            FileObject srcDir;
            File binaryJarF;
            URL binaryJar = FileUtil.getArchiveFile((URL)binaryRoot);
            if (binaryJar != null && (binaryJarF = new File(URI.create(binaryJar.toExternalForm()))).getAbsolutePath().endsWith(this.getModuleJarClusterPath()) && (srcDir = this.project.getSourceDirectory()) != null) {
                res = new Result(new FileObject[]{srcDir});
                return res;
            }
            if (binaryRoot.equals(this.getClassesUrl())) {
                FileObject srcDir2 = this.project.getSourceDirectory();
                if (srcDir2 != null) {
                    res = new Result(new FileObject[]{srcDir2});
                }
            } else if (binaryRoot.equals(this.getTestClassesUrl())) {
                FileObject testSrcDir = this.project.getTestSourceDirectory();
                if (testSrcDir != null) {
                    res = new Result(new FileObject[]{testSrcDir});
                }
            } else {
                Iterator ecus = this.project.getExtraCompilationUnits().entrySet().iterator();
                block0: while (ecus.hasNext()) {
                    Map.Entry entry = ecus.next();
                    Element pkgrootEl = (Element)entry.getValue();
                    Iterator pkgrootKids = Util.findSubElements(pkgrootEl).iterator();
                    while (pkgrootKids.hasNext()) {
                        File loc;
                        URL u;
                        Element kid = (Element)pkgrootKids.next();
                        if (!kid.getLocalName().equals("built-to")) continue;
                        String rawtext = Util.findText(kid);
                        if (!$assertionsDisabled && rawtext == null) {
                            throw new AssertionError((Object)("Null content for <built-to> in " + this.project));
                        }
                        String text = this.project.evaluator().evaluate(rawtext);
                        if (text == null || !(u = Util.urlForDirOrJar(loc = this.project.getHelper().resolveFile(text))).equals(binaryRoot)) continue;
                        res = new Result(new FileObject[]{(FileObject)entry.getKey()});
                        break block0;
                    }
                }
            }
            if (res != null) {
                this.cache.put(binaryRoot, res);
            }
        }
        return res;
    }

    private String getModuleJarClusterPath() {
        if (this.clusterPath == null) {
            File cluster = this.project.getHelper().resolveFile(this.project.evaluator().evaluate("${cluster}"));
            this.clusterPath = PropertyUtils.relativizeFile((File)cluster.getParentFile(), (File)this.project.getModuleJarLocation()).replace('/', File.separatorChar);
        }
        return this.clusterPath;
    }

    private URL getClassesUrl() {
        if (this.classesUrl == null) {
            File classesDir = this.project.getClassesDirectory();
            this.classesUrl = Util.urlForDir(classesDir);
        }
        return this.classesUrl;
    }

    private URL getTestClassesUrl() {
        if (this.testClassesUrl == null && this.project.supportsUnitTests()) {
            File testClassesDir = this.project.getTestClassesDirectory();
            this.testClassesUrl = Util.urlForDir(testClassesDir);
        }
        return this.testClassesUrl;
    }

    static {
        $assertionsDisabled = !SourceForBinaryImpl.class.desiredAssertionStatus();
    }

    private static class Result
    implements SourceForBinaryQuery.Result {
        private FileObject[] res;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Result(FileObject[] res) {
            this.res = res;
            if (!$assertionsDisabled && (res == null || Arrays.asList(res).contains(null))) {
                throw new AssertionError();
            }
        }

        public FileObject[] getRoots() {
            return this.res;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$queries$SourceForBinaryImpl == null ? (class$org$netbeans$modules$apisupport$project$queries$SourceForBinaryImpl = SourceForBinaryImpl.class$("org.netbeans.modules.apisupport.project.queries.SourceForBinaryImpl")) : class$org$netbeans$modules$apisupport$project$queries$SourceForBinaryImpl).desiredAssertionStatus();
        }
    }
}

