/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.nodes.Node;
import org.openidex.search.DataObjectSearchGroup;
import org.openidex.search.FileObjectSearchGroup;
import org.openidex.search.SearchType;

public abstract class SearchGroup {
    public static final String PROP_FOUND = "org.openidex.search.found";
    public static final String PROP_RESULT = "org.openidex.search.result";
    private PropertyChangeSupport propChangeSupport;
    protected SearchType[] searchTypes = new SearchType[0];
    protected final Set searchRoots = new HashSet(5);
    protected final Set resultObjects = new LinkedHashSet(50);
    protected volatile boolean stopped = false;
    private PropertyChangeListener propListener;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$filesystems$FileObject;

    protected void add(SearchType searchType) {
        for (int i = 0; i < this.searchTypes.length; ++i) {
            if (!searchType.equals(this.searchTypes[i])) continue;
            return;
        }
        SearchType[] temp = new SearchType[this.searchTypes.length + 1];
        System.arraycopy(this.searchTypes, 0, temp, 0, this.searchTypes.length);
        temp[this.searchTypes.length] = searchType;
        this.searchTypes = temp;
    }

    public SearchType[] getSearchTypes() {
        return this.searchTypes;
    }

    public void setSearchRootNodes(Node[] roots) {
        for (int i = 0; i < this.searchTypes.length; ++i) {
            roots = this.searchTypes[i].acceptSearchRootNodes(roots);
        }
        this.searchRoots.clear();
        this.searchRoots.addAll(Arrays.asList(roots));
    }

    public Node[] getSearchRoots() {
        return this.searchRoots.toArray(new Node[this.searchRoots.size()]);
    }

    public final void stopSearch() {
        this.stopped = true;
    }

    public void search() {
        this.resultObjects.clear();
        this.prepareSearch();
        this.doSearch();
    }

    protected void prepareSearch() {
    }

    protected abstract void doSearch();

    protected void processSearchObject(Object searchObject) {
        int i;
        for (i = 0; i < this.searchTypes.length; ++i) {
            if (this.searchTypes[i].acceptSearchObject(searchObject)) continue;
            return;
        }
        for (i = 0; i < this.searchTypes.length; ++i) {
            this.searchTypes[i].prepareSearchObject(searchObject);
        }
        for (i = 0; i < this.searchTypes.length; ++i) {
            if (this.searchTypes[i].testObject(searchObject)) continue;
            return;
        }
        this.resultObjects.add(searchObject);
        this.firePropertyChange(PROP_FOUND, null, searchObject);
    }

    public abstract Node getNodeForFoundObject(Object var1);

    public Set getResultObjects() {
        return new LinkedHashSet(this.resultObjects);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPropertySupport().addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPropertySupport().removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.getPropertySupport().firePropertyChange(name, oldValue, newValue);
    }

    private synchronized PropertyChangeSupport getPropertySupport() {
        if (this.propChangeSupport == null) {
            this.propChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propChangeSupport;
    }

    public static SearchGroup[] createSearchGroups(SearchType[] items) {
        HashSet<Class> classSet = new HashSet<Class>(items.length);
        for (int i = 0; i < items.length; ++i) {
            List<Class> classes = Arrays.asList(items[i].getSearchTypeClasses());
            if (i == 0) {
                classSet.addAll(classes);
                continue;
            }
            classSet.retainAll(classes);
        }
        if (classSet.isEmpty()) {
            return new SearchGroup[0];
        }
        HashSet<SearchGroup> groupSet = new HashSet<SearchGroup>(classSet.size());
        Iterator it = classSet.iterator();
        while (it.hasNext()) {
            SearchGroup group = Registry.createSearchGroup((Class)it.next());
            if (group == null) continue;
            for (int i = 0; i < items.length; ++i) {
                group.add(items[i]);
            }
            groupSet.add(group);
        }
        return groupSet.toArray(new SearchGroup[groupSet.size()]);
    }

    public static final class Registry {
        private static final Map registry = new HashMap(2);

        private Registry() {
        }

        public static synchronized boolean registerSearchGroupFactory(Class searchObjectClass, Factory factory) {
            Factory oldFactory = registry.put(searchObjectClass, factory);
            if (oldFactory != null) {
                registry.put(searchObjectClass, oldFactory);
                return false;
            }
            return true;
        }

        public static SearchGroup createSearchGroup(Class searchObjectType) {
            Factory factory = (Factory)registry.get(searchObjectType);
            if (factory == null) {
                return null;
            }
            return factory.createSearchGroup();
        }

        public static boolean hasFactory(Class searchObjectType) {
            return registry.containsKey(searchObjectType);
        }

        static {
            registry.put(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SearchGroup.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, new Factory(){

                public SearchGroup createSearchGroup() {
                    return new DataObjectSearchGroup();
                }
            });
            registry.put(class$org$openide$filesystems$FileObject == null ? (class$org$openide$filesystems$FileObject = SearchGroup.class$("org.openide.filesystems.FileObject")) : class$org$openide$filesystems$FileObject, new Factory(){

                public SearchGroup createSearchGroup() {
                    return new FileObjectSearchGroup();
                }
            });
        }
    }

    public static interface Factory {
        public SearchGroup createSearchGroup();
    }
}

