/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.openide.util.NbBundle;

class ServletData
extends DeployData {
    private String errorMessage = null;
    private String name = null;
    private String[] urlMappings = null;
    private ArrayList filterMappings = null;
    private String[][] initparams = null;
    private boolean paramOK = true;
    private FileType fileType = null;
    private static final boolean debug = false;
    private boolean addToDD = true;

    ServletData(FileType fileType) {
        this.fileType = fileType;
    }

    String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    void setName(String name) {
        if (name != this.name) {
            if (this.fileType == FileType.FILTER) {
                this.updateFilterMappings(this.getName(), name);
            }
            this.name = name;
        }
    }

    String[] getServletNames() {
        if (this.webApp == null) {
            return new String[0];
        }
        Servlet[] ss = this.webApp.getServlet();
        String[] names = new String[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            try {
                names[i] = ss[i].getServletName();
                continue;
            }
            catch (Exception e) {
                names[i] = "";
            }
        }
        return names;
    }

    List getUrlPatterns() {
        if (this.webApp == null) {
            return new ArrayList();
        }
        ServletMapping[] maps = this.webApp.getServletMapping();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < maps.length; ++i) {
            l.add(maps[i].getUrlPattern());
        }
        return l;
    }

    ArrayList getFilterMappings() {
        if (this.webApp == null) {
            return new ArrayList();
        }
        if (this.filterMappings != null) {
            return this.filterMappings;
        }
        FilterMapping[] fm = this.webApp.getFilterMapping();
        this.filterMappings = new ArrayList();
        this.filterMappings.add(new FilterMappingData(this.getName()));
        String[] d = null;
        for (int i = 0; i < fm.length; ++i) {
            FilterMappingData.Dispatcher[] dispatchList;
            FilterMappingData fmd;
            block13: {
                fmd = new FilterMappingData();
                fmd.setName(fm[i].getFilterName());
                String string = fm[i].getUrlPattern();
                if (string == null || string.length() == 0) {
                    fmd.setType(FilterMappingData.Type.SERVLET);
                    fmd.setPattern(fm[i].getServletName());
                } else {
                    fmd.setType(FilterMappingData.Type.URL);
                    fmd.setPattern(string);
                }
                try {
                    if (fm[i].sizeDispatcher() == 0) {
                        this.filterMappings.add(fmd);
                    }
                    break block13;
                }
                catch (Exception ex) {
                    this.filterMappings.add(fmd);
                }
                continue;
            }
            try {
                d = fm[i].getDispatcher();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (d == null) {
                dispatchList = new FilterMappingData.Dispatcher[]{};
            } else {
                dispatchList = new FilterMappingData.Dispatcher[d.length];
                for (int j = 0; j < d.length; ++j) {
                    dispatchList[j] = FilterMappingData.Dispatcher.findDispatcher(d[j]);
                }
            }
            fmd.setDispatcher(dispatchList);
            this.filterMappings.add(fmd);
        }
        return this.filterMappings;
    }

    void setFilterMappings(ArrayList fmds) {
        this.filterMappings = fmds;
    }

    void updateFilterMappings(String oldName, String newName) {
        Iterator i = this.getFilterMappings().iterator();
        if (i == null) {
            return;
        }
        while (i.hasNext()) {
            FilterMappingData fmd = (FilterMappingData)i.next();
            if (!fmd.getName().equals(oldName)) continue;
            fmd.setName(newName);
        }
    }

    boolean isNameUnique() {
        if (this.webApp == null) {
            return true;
        }
        Servlet[] ss = this.webApp.getServlet();
        for (int i = 0; i < ss.length; ++i) {
            if (!this.name.equals(ss[i].getServletName())) continue;
            return false;
        }
        Filter[] ff = this.webApp.getFilter();
        for (int i = 0; i < ff.length; ++i) {
            if (!this.name.equals(ff[i].getFilterName())) continue;
            return false;
        }
        return true;
    }

    String[] getUrlMappings() {
        if (this.urlMappings == null) {
            return new String[0];
        }
        return this.urlMappings;
    }

    String createDDServletName(String className) {
        if (this.webApp == null) {
            return null;
        }
        String result = className;
        Servlet servlet = (Servlet)this.webApp.findBeanByName("Servlet", "ServletName", result);
        while (servlet != null) {
            result = this.findNextId(result);
            servlet = (Servlet)this.webApp.findBeanByName("Servlet", "ServletName", result);
        }
        this.setName(result);
        return result;
    }

    void createDDServletMapping(String servletName) {
        if (this.webApp == null) {
            return;
        }
        String result = "/" + servletName;
        ServletMapping mapping = (ServletMapping)this.webApp.findBeanByName("ServletMapping", "UrlPattern", result);
        while (mapping != null) {
            result = this.findNextId(result);
            mapping = (ServletMapping)this.webApp.findBeanByName("ServletMapping", "UrlPattern", result);
        }
        this.urlMappings = new String[]{result};
    }

    private String findNextId(String id) {
        char ch = id.charAt(id.length() - 1);
        String result = null;
        if (!Character.isDigit(ch)) {
            result = id + "_1";
            return result;
        }
        String lastDigit = id.substring(id.length() - 1);
        int num = new Integer(lastDigit) + 1;
        result = id.substring(0, id.length() - 1) + new Integer(num).toString();
        return result;
    }

    String getUrlMappingsAsString() {
        int index;
        if (this.urlMappings == null || this.urlMappings.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (index = 0; index < this.urlMappings.length - 1; ++index) {
            buf.append(this.urlMappings[index]);
            buf.append(", ");
        }
        buf.append(this.urlMappings[index]);
        return buf.toString();
    }

    void parseUrlMappingString(String raw) {
        this.urlMappings = null;
        StringTokenizer st = new StringTokenizer(raw, ",");
        ArrayList<String> list = new ArrayList<String>();
        String[] names = this.getServletNames();
        while (st.hasMoreTokens()) {
            String mapping = st.nextToken().trim();
            if (mapping.length() == 0) continue;
            list.add(mapping);
        }
        this.urlMappings = new String[list.size()];
        list.toArray(this.urlMappings);
    }

    String[][] getInitParams() {
        if (this.initparams == null) {
            return new String[0][2];
        }
        return this.initparams;
    }

    void setInitParams(String[][] initparams, boolean paramOK) {
        this.initparams = initparams;
        this.paramOK = paramOK;
    }

    int getNumInitParams() {
        if (this.initparams == null) {
            return 0;
        }
        return this.initparams.length;
    }

    boolean isParamOK() {
        return this.paramOK;
    }

    void setParamOK(boolean paramOK) {
        this.paramOK = paramOK;
    }

    boolean isValid() {
        this.errorMessage = new String();
        if (this.webApp == null) {
            return true;
        }
        if (!this.isAddToDD()) {
            return true;
        }
        if (this.getName().length() == 0) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_no_name");
            return false;
        }
        if (!this.isNameUnique()) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_name_unique");
            return false;
        }
        if (this.fileType == FileType.SERVLET) {
            if (!this.checkMappingsForServlet()) {
                return false;
            }
            if (!this.checkServletDuplicitMappings()) {
                return false;
            }
        } else if (this.fileType == FileType.FILTER && !this.checkMappingsForFilter()) {
            return false;
        }
        if (!this.isParamOK()) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_invalid_param");
            return false;
        }
        return true;
    }

    boolean checkMappingsForServlet() {
        this.errorMessage = new String();
        String[] mappings = this.getUrlMappings();
        if (mappings == null || mappings.length == 0) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_no_mapping");
            return false;
        }
        for (int i = 0; i < mappings.length; ++i) {
            String errMessage = this.checkServletMappig(mappings[i]);
            if (errMessage == null) continue;
            this.errorMessage = errMessage;
            return false;
        }
        return true;
    }

    boolean checkServletDuplicitMappings() {
        this.errorMessage = new String();
        String[] newMappings = this.getUrlMappings();
        List urlPatterns = this.getUrlPatterns();
        for (int i = 0; i < newMappings.length; ++i) {
            for (String urlPattern : urlPatterns) {
                if (!newMappings[i].equals(urlPattern)) continue;
                this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_url_pattern_unique");
                return false;
            }
            urlPatterns.add(newMappings[i]);
        }
        return true;
    }

    boolean checkMappingsForFilter() {
        this.errorMessage = new String();
        if (this.filterMappings == null || this.filterMappings.size() == 0) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_no_mapping");
            return false;
        }
        Iterator i = this.getFilterMappings().iterator();
        boolean found = false;
        while (i.hasNext()) {
            FilterMappingData fmd = (FilterMappingData)i.next();
            if (!fmd.getName().equals(this.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_no_mapping");
            return false;
        }
        return true;
    }

    void createDDEntries() {
        boolean added;
        if (this.webApp == null) {
            return;
        }
        if (this.fileType == FileType.SERVLET) {
            boolean added2 = this.addServlet();
            if (added2) {
                this.addUrlMappings();
                try {
                    this.writeChanges();
                }
                catch (IOException ex) {}
            }
        } else if (this.fileType == FileType.FILTER && (added = this.addFilter())) {
            this.addFilterMappings();
            try {
                this.writeChanges();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean addServlet() {
        Servlet s;
        if (this.webApp == null) {
            return false;
        }
        try {
            s = (Servlet)this.webApp.createBean("Servlet");
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        s.setServletName(this.name);
        s.setServletClass(this.className);
        int numInitParams = this.getInitParams().length;
        for (int i = 0; i < numInitParams; ++i) {
            InitParam param;
            try {
                param = (InitParam)s.createBean("InitParam");
            }
            catch (ClassNotFoundException cnfe) {
                continue;
            }
            param.setParamName(this.initparams[i][0]);
            param.setParamValue(this.initparams[i][1]);
            s.addInitParam(param);
        }
        this.webApp.addServlet(s);
        return true;
    }

    private boolean addFilter() {
        Filter f;
        if (this.webApp == null) {
            return false;
        }
        try {
            f = (Filter)this.webApp.createBean("Filter");
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        f.setFilterName(this.name);
        f.setFilterClass(this.className);
        int numInitParams = this.getInitParams().length;
        for (int i = 0; i < numInitParams; ++i) {
            InitParam param;
            try {
                param = (InitParam)f.createBean("InitParam");
            }
            catch (ClassNotFoundException cnfe) {
                continue;
            }
            param.setParamName(this.initparams[i][0]);
            param.setParamValue(this.initparams[i][1]);
            f.addInitParam(param);
        }
        this.webApp.addFilter(f);
        return true;
    }

    private void addUrlMappings() {
        if (this.webApp == null) {
            return;
        }
        int numMappings = this.getUrlMappings().length;
        for (int i = 0; i < numMappings; ++i) {
            ServletMapping m;
            try {
                m = (ServletMapping)this.webApp.createBean("ServletMapping");
            }
            catch (ClassNotFoundException cnfe) {
                return;
            }
            m.setServletName(this.name);
            m.setUrlPattern(this.urlMappings[i]);
            this.webApp.addServletMapping(m);
        }
    }

    private void addFilterMappings() {
        if (this.webApp == null) {
            return;
        }
        int numFilterMappings = this.filterMappings.size();
        Iterator iterator = this.filterMappings.iterator();
        FilterMapping[] fm = new FilterMapping[numFilterMappings];
        for (int i = 0; i < numFilterMappings; ++i) {
            FilterMappingData fmd = (FilterMappingData)iterator.next();
            try {
                fm[i] = (FilterMapping)this.webApp.createBean("FilterMapping");
            }
            catch (ClassNotFoundException cnfe) {
                return;
            }
            fm[i].setFilterName(fmd.getName());
            if (fmd.getType() == FilterMappingData.Type.URL) {
                fm[i].setUrlPattern(fmd.getPattern());
            } else {
                fm[i].setServletName(fmd.getPattern());
            }
            int length = fmd.getDispatcher().length;
            if (length == 0) continue;
            String[] s = new String[length];
            FilterMappingData.Dispatcher[] d = fmd.getDispatcher();
            for (int j = 0; j < length; ++j) {
                s[j] = d[j].toString();
            }
            try {
                fm[i].setDispatcher(s);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.webApp.setFilterMapping(fm);
    }

    void setAddToDD(boolean addToDD) {
        this.addToDD = addToDD;
    }

    boolean isAddToDD() {
        return this.addToDD;
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    void log(String s) {
        System.out.println("ServletData" + s);
    }

    private String checkServletMappig(String uri) {
        if (!uri.matches("[\\*/].*")) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_WrongUriStart");
        }
        if (uri.length() > 1 && uri.endsWith("/")) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_WrongUriEnd");
        }
        if (uri.matches(".*\\*.*\\*.*")) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_TwoAsterisks");
        }
        if (uri.matches("..*\\*..*")) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_AsteriskInTheMiddle");
        }
        return null;
    }
}

