/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.web.wizards.BaseWizardPanel;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.InitParamPanel;
import org.netbeans.modules.web.wizards.MappingPanel;
import org.netbeans.modules.web.wizards.ServletData;
import org.netbeans.modules.web.wizards.TargetEvaluator;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class DeployDataPanel
extends BaseWizardPanel
implements ItemListener,
KeyListener {
    private TargetEvaluator evaluator = null;
    private ServletData deployData;
    private FileType fileType;
    private boolean edited = false;
    private static final boolean debug = false;
    private JCheckBox jCBservlet;
    private JTextField jTFclassname;
    private JTextField jTFname;
    private JTextField jTFmapping;
    private JLabel jLinstruction;
    private JLabel jLclassname;
    private JLabel jLname;
    private JLabel jLmapping;
    private InitParamPanel paramPanel;
    private MappingPanel mappingPanel;
    private static final long serialVersionUID = -2704206901170711687L;

    public DeployDataPanel(TargetEvaluator e) {
        this.evaluator = e;
        this.fileType = this.evaluator.getFileType();
        this.deployData = (ServletData)this.evaluator.getDeployData();
        this.setName(NbBundle.getMessage(DeployDataPanel.class, (String)"TITLE_ddpanel_".concat(this.fileType.toString())));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_deployment"));
        this.initComponents();
        this.fireChangeEvent();
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(450, 250));
        this.setLayout(new GridBagLayout());
        GridBagConstraints fullRowC = new GridBagConstraints();
        fullRowC.gridx = 0;
        fullRowC.gridy = -1;
        fullRowC.gridwidth = 8;
        fullRowC.anchor = 17;
        fullRowC.fill = 2;
        fullRowC.insets = new Insets(4, 0, 4, 60);
        GridBagConstraints firstC = new GridBagConstraints();
        firstC.gridx = 0;
        firstC.gridy = -1;
        firstC.gridwidth = 1;
        firstC.anchor = 17;
        firstC.insets = new Insets(4, 20, 4, 0);
        GridBagConstraints tfC = new GridBagConstraints();
        tfC.gridx = -1;
        tfC.gridy = 0;
        tfC.gridwidth = 7;
        tfC.fill = 2;
        tfC.insets = new Insets(4, 20, 4, 60);
        GridBagConstraints stfC = new GridBagConstraints();
        stfC.gridx = -1;
        stfC.gridy = 0;
        stfC.gridwidth = 5;
        stfC.weightx = 1.0;
        stfC.fill = 2;
        stfC.insets = new Insets(4, 20, 4, 0);
        GridBagConstraints tablePanelC = new GridBagConstraints();
        tablePanelC.gridx = 0;
        tablePanelC.gridy = -1;
        tablePanelC.gridwidth = 8;
        tablePanelC.fill = 1;
        tablePanelC.weightx = 1.0;
        tablePanelC.weighty = 1.0;
        tablePanelC.insets = new Insets(4, 20, 4, 0);
        this.jLinstruction = new JLabel(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_dd_".concat(this.fileType.toString())));
        this.add((Component)this.jLinstruction, fullRowC);
        ++tfC.gridy;
        this.jCBservlet = new JCheckBox(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_addtodd"), true);
        this.jCBservlet.setMnemonic(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_add_mnemonic").charAt(0));
        this.jCBservlet.addItemListener(this);
        this.jCBservlet.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_addtodd"));
        this.add((Component)this.jCBservlet, fullRowC);
        ++tfC.gridy;
        this.jTFclassname = new JTextField(25);
        this.jTFclassname.setEnabled(false);
        this.jTFclassname.setBackground(this.getBackground());
        this.jLclassname = new JLabel(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_ClassName"));
        this.jLclassname.setLabelFor(this.jTFclassname);
        this.jLclassname.setDisplayedMnemonic(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_Class_Mnemonic").charAt(0));
        this.jTFclassname.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_ClassName"));
        this.add((Component)this.jLclassname, firstC);
        this.add((Component)this.jTFclassname, tfC);
        ++tfC.gridy;
        this.jTFname = new JTextField(25);
        this.jTFname.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_name_".concat(this.fileType.toString())));
        this.jTFname.addKeyListener(this);
        this.jTFname.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.jTFname.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                DeployDataPanel.this.jTFname.selectAll();
            }
        });
        this.jLname = new JLabel(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_name_".concat(this.fileType.toString())));
        this.jLname.setLabelFor(this.jTFname);
        this.jLname.setDisplayedMnemonic(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_name_".concat(this.fileType.toString()).concat("_mnem")).charAt(0));
        this.add((Component)this.jLname, firstC);
        this.add((Component)this.jTFname, tfC);
        if (this.fileType == FileType.SERVLET) {
            ++tfC.gridy;
            this.jTFmapping = new JTextField(25);
            this.jTFmapping.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_url_mapping"));
            this.jTFmapping.addKeyListener(this);
            this.jTFmapping.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            this.jTFmapping.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent evt) {
                    DeployDataPanel.this.jTFmapping.selectAll();
                }

                public void focusLost(FocusEvent evt) {
                    DeployDataPanel.this.deployData.parseUrlMappingString(DeployDataPanel.this.jTFmapping.getText().trim());
                    DeployDataPanel.this.fireChangeEvent();
                }
            });
            this.jLmapping = new JLabel(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_url_mapping"));
            this.jLmapping.setLabelFor(this.jTFmapping);
            this.jLmapping.setDisplayedMnemonic(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_mapping_mnemonic").charAt(0));
            this.add((Component)this.jLmapping, firstC);
            this.add((Component)this.jTFmapping, tfC);
        }
        if (this.fileType == FileType.SERVLET) {
            this.paramPanel = new InitParamPanel(this.deployData, this);
            this.add((Component)this.paramPanel, tablePanelC);
        } else if (this.fileType == FileType.FILTER) {
            this.mappingPanel = new MappingPanel(this.deployData, this);
            this.add((Component)this.mappingPanel, tablePanelC);
        }
        GridBagConstraints fillerC = new GridBagConstraints();
        fillerC.gridx = 0;
        fillerC.gridy = -1;
        fillerC.weighty = 1.0;
        fillerC.fill = 1;
        this.add((Component)new JPanel(), fillerC);
    }

    void setData() {
        this.deployData.setClassName(this.evaluator.getClassName());
        this.jTFclassname.setText(this.deployData.getClassName());
        if (!this.edited) {
            this.deployData.setName(this.evaluator.getFileName());
            if (this.fileType == FileType.SERVLET) {
                this.deployData.parseUrlMappingString("/" + this.evaluator.getFileName());
            }
        }
        this.jTFname.setText(this.deployData.getName());
        if (this.fileType == FileType.SERVLET) {
            this.jTFmapping.setText(this.deployData.getUrlMappingsAsString());
        } else if (this.fileType == FileType.FILTER) {
            this.mappingPanel.setData();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.jCBservlet) {
            boolean enabled = itemEvent.getStateChange() == 1;
            this.enableInput(enabled);
            this.deployData.setMakeEntry(enabled);
            this.deployData.setAddToDD(enabled);
            if (this.fileType == FileType.SERVLET) {
                this.paramPanel.setEnabled();
            }
        }
        this.fireChangeEvent();
    }

    private void enableInput(boolean enable) {
        this.jTFname.setEnabled(enable);
        this.jLinstruction.setEnabled(enable);
        this.jLclassname.setEnabled(enable);
        this.jLname.setEnabled(enable);
        if (this.fileType == FileType.SERVLET) {
            this.jTFmapping.setEnabled(enable);
            this.jLmapping.setEnabled(enable);
            this.paramPanel.setEnabled(enable);
        } else if (this.fileType == FileType.FILTER) {
            this.mappingPanel.setEnabled(enable);
        }
        if (enable) {
            this.jTFclassname.setDisabledTextColor(Color.black);
            this.jTFclassname.repaint();
            this.jTFname.setBackground(Color.white);
            if (this.fileType == FileType.SERVLET) {
                this.jTFmapping.setBackground(Color.white);
            }
        } else {
            this.jTFclassname.setDisabledTextColor(this.jTFname.getDisabledTextColor());
            this.jTFclassname.repaint();
            this.jTFname.setBackground(this.getBackground());
            if (this.fileType == FileType.SERVLET) {
                this.jTFmapping.setBackground(this.getBackground());
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.edited = true;
        if (keyEvent.getSource() == this.jTFname) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DeployDataPanel.this.deployData.setName(DeployDataPanel.this.jTFname.getText().trim());
                    if (DeployDataPanel.this.fileType == FileType.FILTER) {
                        DeployDataPanel.this.mappingPanel.setData();
                    }
                    DeployDataPanel.this.fireChangeEvent();
                }
            });
            return;
        }
        if (keyEvent.getSource() == this.jTFmapping) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DeployDataPanel.this.deployData.parseUrlMappingString(DeployDataPanel.this.jTFmapping.getText().trim());
                    DeployDataPanel.this.fireChangeEvent();
                }
            });
            return;
        }
        this.fireChangeEvent();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void log(String s) {
        System.out.println("DeployDataPanel" + s);
    }

    public HelpCtx getHelp() {
        return new HelpCtx(this.getClass().getName() + "." + this.evaluator.getFileType().toString());
    }
}

