/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javadoc.search.IndexBuilder;
import org.netbeans.modules.javadoc.search.JavadocURLMapper;
import org.openide.ErrorManager;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class IndexOverviewAction
extends SystemAction
implements Presenter.Menu {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.javadoc.search.IndexOverviewAction.IndexMenu");

    public IndexOverviewAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public String getName() {
        return NbBundle.getMessage((Class)IndexOverviewAction.class, (String)"CTL_INDICES_MenuItem");
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("javadoc.search");
    }

    public JMenuItem getMenuPresenter() {
        return new IndexMenu();
    }

    private final class IndexMenuItem
    extends JMenuItem
    implements ActionListener,
    HelpCtx.Provider {
        private URL u;
        private final Reference fsRef;
        private String foPath;
        static final /* synthetic */ boolean $assertionsDisabled;

        public IndexMenuItem(String display, FileObject index) throws FileStateInvalidException {
            super(display);
            this.fsRef = new WeakReference<FileSystem>(index.getFileSystem());
            this.foPath = index.getPath();
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent ev) {
            URL loc = this.getURL();
            HtmlBrowser.URLDisplayer.getDefault().showURL(loc);
        }

        private URL getURL() {
            if (this.u == null) {
                FileSystem fs = (FileSystem)this.fsRef.get();
                if (!$assertionsDisabled && fs == null) {
                    throw new AssertionError();
                }
                FileObject index = fs.findResource(this.foPath);
                if (!$assertionsDisabled && index == null) {
                    throw new AssertionError((Object)this.foPath);
                }
                this.u = JavadocURLMapper.findURL(index);
            }
            return this.u;
        }

        public HelpCtx getHelpCtx() {
            return IndexOverviewAction.this.getHelpCtx();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$javadoc$search$IndexOverviewAction == null ? (class$org$netbeans$modules$javadoc$search$IndexOverviewAction = IndexOverviewAction.class$("org.netbeans.modules.javadoc.search.IndexOverviewAction")) : class$org$netbeans$modules$javadoc$search$IndexOverviewAction).desiredAssertionStatus();
        }
    }

    private final class IndexMenu
    extends JMenu
    implements HelpCtx.Provider,
    DynamicMenuContent {
        private int itemHash = 0;

        public IndexMenu() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)IndexOverviewAction.this.getName());
            this.getModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (IndexMenu.this.getModel().isSelected()) {
                        IndexMenu.this.getPopupMenu2();
                    }
                }
            });
        }

        public HelpCtx getHelpCtx() {
            return IndexOverviewAction.this.getHelpCtx();
        }

        public JComponent[] getMenuPresenters() {
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return items;
        }

        public void getPopupMenu2() {
            List[] data = IndexBuilder.getDefault().getIndices();
            int newHash = this.computeDataHash(data);
            if (newHash != this.itemHash) {
                if (err.isLoggable(1)) {
                    err.log("recreating popup menu (" + this.itemHash + " -> " + newHash + ")");
                }
                this.itemHash = newHash;
                this.removeAll();
                List names = data[0];
                List indices = data[1];
                int size = names.size();
                if (size != indices.size()) {
                    throw new IllegalStateException();
                }
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        try {
                            this.add(new IndexMenuItem((String)names.get(i), (FileObject)indices.get(i)));
                            continue;
                        }
                        catch (FileStateInvalidException e) {
                            err.notify(1, (Throwable)e);
                        }
                    }
                } else {
                    JMenuItem dummy = new JMenuItem(NbBundle.getMessage((Class)(class$org$netbeans$modules$javadoc$search$IndexOverviewAction == null ? (class$org$netbeans$modules$javadoc$search$IndexOverviewAction = IndexOverviewAction.class$("org.netbeans.modules.javadoc.search.IndexOverviewAction")) : class$org$netbeans$modules$javadoc$search$IndexOverviewAction), (String)"CTL_no_indices_found"));
                    dummy.setEnabled(false);
                    this.add(dummy);
                }
            }
        }

        private int computeDataHash(List[] data) {
            int x = ((Object)data[0]).hashCode();
            Iterator it = data[1].iterator();
            while (it.hasNext()) {
                FileObject fo = (FileObject)it.next();
                try {
                    x += fo.getURL().hashCode();
                }
                catch (FileStateInvalidException e) {
                    err.notify(1, (Throwable)e);
                }
            }
            return x;
        }
    }
}

