/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.project;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.search.SearchPerformer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.lookup.Lookups;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

public final class ProjectsSearchAction
extends CallableSystemAction
implements PropertyChangeListener {
    static final long serialVersionUID = 4554342565076372610L;
    private static final String VAR_FIRST_ISENABLED = "first call of isEnabled()";
    private static final String VAR_TOOLBAR_COMP_REF = "toolbar presenter ref";
    private static final String VAR_LISTENING = "listening";

    protected void initialize() {
        super.initialize();
        this.putProperty(VAR_FIRST_ISENABLED, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getToolbarPresenter() {
        Object object = this.getLock();
        synchronized (object) {
            Component presenter = this.getStoredToolbarPresenter();
            if (this.putProperty(VAR_LISTENING, Boolean.TRUE) == null) {
                OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
                this.putProperty(VAR_FIRST_ISENABLED, null);
                this.updateState();
            }
            return presenter;
        }
    }

    private Component getStoredToolbarPresenter() {
        Reference ref;
        Object presenterObj;
        Object refObj = this.getProperty(VAR_TOOLBAR_COMP_REF);
        if (refObj != null && (presenterObj = (ref = (Reference)refObj).get()) != null) {
            return (Component)presenterObj;
        }
        Component presenter = super.getToolbarPresenter();
        this.putProperty(VAR_TOOLBAR_COMP_REF, new WeakReference<Component>(presenter));
        return presenter;
    }

    private boolean checkToolbarPresenterExists() {
        Object refObj = this.getProperty(VAR_TOOLBAR_COMP_REF);
        if (refObj == null) {
            return false;
        }
        return ((Reference)refObj).get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent e) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getProperty(VAR_LISTENING) == null) {
                return;
            }
            if (this.checkToolbarPresenterExists()) {
                this.updateState();
            } else {
                OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                this.putProperty(VAR_LISTENING, null);
                this.putProperty(VAR_TOOLBAR_COMP_REF, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getProperty(VAR_LISTENING) != null) {
                return super.isEnabled();
            }
            if (this.getProperty(VAR_FIRST_ISENABLED) == null) {
                return OpenProjects.getDefault().getOpenProjects().length != 0;
            }
            this.putProperty(VAR_FIRST_ISENABLED, null);
            return false;
        }
    }

    private synchronized void updateState() {
        final boolean enabled = OpenProjects.getDefault().getOpenProjects().length != 0;
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                ProjectsSearchAction.this.setEnabled(enabled);
            }
        });
    }

    protected String iconResource() {
        return "org/openide/resources/actions/find.gif";
    }

    public String getName() {
        return NbBundle.getMessage((Class)ProjectsSearchAction.class, (String)"LBL_SearchProjects");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProjectsSearchAction.class);
    }

    private Node[] getNodesToSearch() {
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        if (openProjects.length == 0) {
            return new Node[0];
        }
        ArrayList<FileObject> rootFolders = new ArrayList<FileObject>();
        for (int i = 0; i < openProjects.length; ++i) {
            Sources sources = ProjectUtils.getSources((Project)openProjects[i]);
            SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
            for (int j = 0; j < sourceGroups.length; ++j) {
                rootFolders.add(sourceGroups[j].getRootFolder());
            }
        }
        if (rootFolders.isEmpty()) {
            return new Node[0];
        }
        SearchInfo searchInfo = SearchInfoFactory.createSearchInfo((FileObject[])rootFolders.toArray(new FileObject[rootFolders.size()]), (boolean)true, (FileObjectFilter[])new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER, SearchInfoFactory.SHARABILITY_FILTER});
        AbstractNode nodeToSearch = new AbstractNode(Children.LEAF, Lookups.singleton((Object)searchInfo));
        nodeToSearch.setValue("Find Files dialog title", (Object)NbBundle.getMessage((Class)ProjectsSearchAction.class, (String)"LBL_Title_SearchProjects"));
        return new Node[]{nodeToSearch};
    }

    public void performAction() {
        SearchPerformer performer = (SearchPerformer)SharedClassObject.findObject((Class)SearchPerformer.class, (boolean)true);
        performer.performAction(this.getNodesToSearch());
    }

    protected boolean asynchronous() {
        return false;
    }
}

