/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderListListener;
import org.openide.loaders.FolderOrder;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

final class FolderList
implements FileChangeListener,
DataObject.Container {
    static final long serialVersionUID = -592616022226761148L;
    private static final int LATER_PRIORITY = 5;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Folder recognizer");
    private static final Map map = new WeakHashMap(101);
    private static int REFRESH_TIME = -1;
    protected FileObject folder;
    private transient RequestProcessor.Task refreshTask;
    private volatile transient RequestProcessor.Task comparatorTask;
    private transient HashMap primaryFiles = null;
    private transient List order;
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.loaders.FolderList");
    private transient PropertyChangeSupport pcs;
    private transient boolean folderCreated = false;

    private FolderList(FileObject folder, boolean attach) {
        this.folder = folder;
        if (attach) {
            folder.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)folder));
        }
    }

    public String toString() {
        return "FolderList{" + this.folder + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FolderList find(FileObject folder, boolean create) {
        FolderList list = null;
        Class clazz = FolderList.class;
        synchronized (clazz) {
            Reference ref = (Reference)map.get(folder);
            FolderList folderList = list = ref == null ? null : (FolderList)ref.get();
            if (list == null && create) {
                list = new FolderList(folder, true);
                map.put(folder, new SoftReference<FolderList>(list));
            }
        }
        return list;
    }

    public boolean isCreated() {
        return this.folderCreated;
    }

    public static boolean isFolderRecognizerThread() {
        return PROCESSOR.isRequestProcessorThread();
    }

    public static void changedFolderOrder(FileObject folder) {
        FolderList list = FolderList.find(folder, false);
        if (list != null) {
            list.changeComparator();
        }
    }

    public static void changedDataSystem(FileObject folder) {
        FolderList list = FolderList.find(folder, false);
        if (err.isLoggable(1)) {
            err.log("changedDataSystem: " + folder + " on " + Thread.currentThread());
        }
        if (list != null) {
            list.refresh();
        }
    }

    public DataObject[] getChildren() {
        List res = this.getChildrenList();
        DataObject[] arr = new DataObject[res.size()];
        res.toArray(arr);
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildrenList() {
        ListTask lt;
        try {
            DataObjectPool.getPOOL().enterPriviledgedProcessor(PROCESSOR);
            lt = this.getChildrenList(null);
            lt.task.waitFinished();
            Object var3_2 = null;
            DataObjectPool.getPOOL().exitPriviledgedProcessor(PROCESSOR);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            DataObjectPool.getPOOL().exitPriviledgedProcessor(PROCESSOR);
            throw throwable;
        }
        return lt.result;
    }

    public void waitProcessingFinished() {
        RequestProcessor.Task t = this.comparatorTask;
        if (t != null) {
            t.waitFinished();
        }
        if ((t = this.refreshTask) != null) {
            t.waitFinished();
        }
    }

    public RequestProcessor.Task computeChildrenList(FolderListListener filter) {
        return this.getChildrenList((FolderListListener)filter).task;
    }

    private ListTask getChildrenList(FolderListListener filter) {
        ListTask lt = new ListTask(filter);
        int priority = Thread.currentThread().getPriority();
        lt.task = PROCESSOR.post((Runnable)lt, 0, priority);
        return lt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void changeComparator() {
        RequestProcessor.Task[] COMP;
        final boolean LOG = err.isLoggable(1);
        if (LOG) {
            err.log("changeComparator on " + this.folder);
        }
        final RequestProcessor.Task previous = this.comparatorTask;
        RequestProcessor.Task[] taskArray = COMP = new RequestProcessor.Task[1];
        synchronized (COMP) {
            COMP[0] = this.comparatorTask = PROCESSOR.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    RequestProcessor.Task[] taskArray = COMP;
                    synchronized (COMP) {
                        if (previous != null) {
                            previous.waitFinished();
                        }
                        if (FolderList.this.primaryFiles != null) {
                            List v;
                            if (LOG) {
                                err.log("changeComparator on " + FolderList.this.folder + ": get old");
                            }
                            if ((v = FolderList.this.getObjects(null)).size() != 0) {
                                FolderList.this.order = null;
                                if (LOG) {
                                    err.log("changeComparator: get new");
                                }
                                List r = FolderList.this.getObjects(null);
                                if (LOG) {
                                    err.log("changeComparator: fire change");
                                }
                                FolderList.this.fireChildrenChange(r, v);
                            }
                        }
                        FolderList folderList = FolderList.this;
                        synchronized (folderList) {
                            if (FolderList.this.comparatorTask == COMP[0]) {
                                FolderList.this.comparatorTask = null;
                            }
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, 0, 1);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        final long now = System.currentTimeMillis();
        final boolean LOG = err.isLoggable(1);
        if (LOG) {
            err.log("refresh on " + this.folder + " @" + now);
        }
        FolderList folderList = this;
        synchronized (folderList) {
            if (this.refreshTask == null) {
                this.refreshTask = PROCESSOR.post(new Runnable(){

                    public void run() {
                        RequestProcessor.Task t = FolderList.this.comparatorTask;
                        if (t != null) {
                            t.waitFinished();
                        }
                        if (LOG) {
                            err.log("-- refresh on " + FolderList.this.folder + ": now=" + now);
                        }
                        if (FolderList.this.primaryFiles != null) {
                            FolderList.this.createBoth(null, true);
                        }
                    }
                }, FolderList.getRefreshTime(), 5);
            } else {
                this.refreshTask.schedule(FolderList.getRefreshTime());
            }
        }
    }

    private static int getRefreshTime() {
        if (REFRESH_TIME >= 0) {
            return REFRESH_TIME;
        }
        String sysProp = System.getProperty("org.openide.loaders.FolderList.refresh.interval");
        if (sysProp != null) {
            try {
                REFRESH_TIME = Integer.parseInt(sysProp);
            }
            catch (NumberFormatException nfe) {
                ErrorManager.getDefault().notify(1, (Throwable)nfe);
            }
        }
        if (REFRESH_TIME < 0) {
            REFRESH_TIME = 10;
        }
        return REFRESH_TIME;
    }

    public void fileChanged(FileEvent fe) {
        FileObject fo;
        boolean LOG = err.isLoggable(1);
        if (LOG) {
            err.log("fileChanged: " + fe);
        }
        if ((fo = fe.getFile()).isData() && fo.isValid()) {
            DataFolder.SortMode sortMode;
            if (this.primaryFiles != null) {
                try {
                    DataObject obj = DataObject.find(fo);
                    if (!this.primaryFiles.containsKey(obj.getPrimaryFile())) {
                        this.refresh();
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            if ((sortMode = this.getComparator().getSortMode()) == DataFolder.SortMode.LAST_MODIFIED || sortMode == DataFolder.SortMode.SIZE) {
                this.changeComparator();
            }
        }
    }

    public void fileDeleted(FileEvent fe) {
        boolean LOG = err.isLoggable(1);
        if (LOG) {
            err.log("fileDeleted: " + fe);
        }
        if (this.primaryFiles == null || this.primaryFiles.containsKey(fe.getFile())) {
            this.refresh();
        }
    }

    public void fileDataCreated(FileEvent fe) {
        boolean LOG = err.isLoggable(1);
        if (LOG) {
            err.log("fileDataCreated: " + fe);
        }
        this.refresh();
    }

    public void fileFolderCreated(FileEvent fe) {
        boolean LOG = err.isLoggable(1);
        if (LOG) {
            err.log("fileFolderCreated: " + fe);
        }
        this.refresh();
    }

    public void fileRenamed(FileRenameEvent fe) {
        boolean LOG = err.isLoggable(1);
        if (LOG) {
            err.log("fileRenamed: " + fe);
        }
        this.refresh();
        this.changeComparator();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        boolean LOG = err.isLoggable(1);
        if (LOG) {
            err.log("fileAttributeChanged: " + fe);
        }
        if (fe.getFile() == this.folder) {
            if (fe.getName() == null) {
                this.changeComparator();
                return;
            }
            if ("OpenIDE-Folder-Order".equals(fe.getName()) || "OpenIDE-Folder-SortMode".equals(fe.getName()) || -1 != fe.getName().indexOf("/")) {
                this.changeComparator();
            }
        }
    }

    private FolderOrder getComparator() {
        return FolderOrder.findFor(this.folder);
    }

    private List getObjects(FolderListListener f) {
        List res;
        boolean LOG = err.isLoggable(1);
        if (LOG) {
            err.log("getObjects on " + this.folder);
        }
        if (this.primaryFiles == null) {
            res = this.createBoth(f, false);
        } else if (this.order != null) {
            res = this.createObjects(this.order, this.primaryFiles, f);
        } else {
            res = this.createObjects(this.primaryFiles.keySet(), this.primaryFiles, f);
            res = this.carefullySort(res, this.getComparator());
            this.order = FolderList.createOrder(res);
        }
        return res;
    }

    private List carefullySort(List l, FolderOrder c) {
        boolean LOG = err.isLoggable(1);
        if (LOG) {
            err.log("carefullySort on " + this.folder);
        }
        Collections.sort(l, c);
        Map constraints = c.getOrderingConstraints(l);
        if (constraints == null) {
            return l;
        }
        if (LOG) {
            err.log("carefullySort: partial orders");
        }
        try {
            return Utilities.topologicalSort((Collection)l, (Map)constraints);
        }
        catch (TopologicalSortException ex) {
            List corrected = ex.partialSort();
            if (err.isLoggable(16)) {
                err.log(16, "Note: folder " + this.folder + " cannot be consistently sorted due to ordering conflicts.");
                err.notify(1, (Throwable)ex);
                err.log(16, "Using partial sort: " + corrected);
            }
            return corrected;
        }
    }

    private static List createOrder(List list) {
        int size = list.size();
        ArrayList<FileObject> res = new ArrayList<FileObject>(size);
        for (int i = 0; i < size; ++i) {
            res.add(((DataObject)list.get(i)).getPrimaryFile());
        }
        return res;
    }

    private List createObjects(Collection order, Map map, FolderListListener f) {
        boolean LOG = err.isLoggable(1);
        if (LOG) {
            err.log("createObjects on " + this.folder);
        }
        int size = order.size();
        Iterator it = order.iterator();
        ArrayList<DataObject> res = new ArrayList<DataObject>(size);
        for (int i = 0; i < size; ++i) {
            DataObject obj;
            FileObject fo = (FileObject)it.next();
            if (!fo.isValid()) continue;
            SoftReference<DataObject> ref = (SoftReference<DataObject>)map.get(fo);
            DataObject dataObject = obj = ref != null ? (DataObject)((Reference)ref).get() : null;
            if (obj == null) {
                try {
                    obj = DataObject.find(fo);
                    ref = new SoftReference<DataObject>(obj);
                }
                catch (DataObjectNotFoundException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            if (obj == null) continue;
            if (f == null) {
                res.add(obj);
                continue;
            }
            f.process(obj, res);
        }
        if (f != null) {
            f.finished(res);
        }
        return res;
    }

    private List createBoth(FolderListListener filter, boolean notify) {
        boolean LOG = err.isLoggable(1);
        if (LOG) {
            err.log("createBoth on " + this.folder);
        }
        HashMap<FileObject, WeakReference<DataObject>> file = new HashMap<FileObject, WeakReference<DataObject>>();
        List<DataObject> all = new ArrayList();
        List<DataObject> res = new ArrayList();
        HashMap remove = this.primaryFiles == null ? new HashMap() : (HashMap)this.primaryFiles.clone();
        ArrayList<DataObject> add = new ArrayList<DataObject>();
        DataLoaderPool pool = DataLoaderPool.getDefault();
        final HashSet marked = new HashSet();
        DataLoader.RecognizedFiles recog = new DataLoader.RecognizedFiles(){

            public void markRecognized(FileObject fo) {
                if (fo != null) {
                    marked.add(fo);
                }
            }
        };
        Enumeration en = this.folder.getChildren(false);
        while (en.hasMoreElements()) {
            DataObject obj;
            FileObject fo = (FileObject)en.nextElement();
            if (marked.contains(fo)) continue;
            try {
                obj = pool.findDataObject(fo, recog);
            }
            catch (DataObjectExistsException ex) {
                obj = ex.getDataObject();
            }
            catch (IOException ex) {
                obj = null;
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            if (obj == null) continue;
            obj.recognizedByFolder();
            FileObject primary = obj.getPrimaryFile();
            boolean doNotRemovePrimaryFile = false;
            if (!file.containsKey(primary)) {
                boolean goIn;
                boolean bl = goIn = this.primaryFiles == null;
                if (!goIn) {
                    Reference r = (Reference)this.primaryFiles.get(primary);
                    boolean bl2 = goIn = r == null;
                    if (!goIn) {
                        DataObject obj2 = (DataObject)r.get();
                        boolean bl3 = goIn = obj2 == null || obj2 != obj;
                        if (goIn) {
                            doNotRemovePrimaryFile = true;
                        }
                    }
                }
                if (goIn) {
                    add.add(obj);
                }
                all.add(obj);
                if (filter == null) {
                    res.add(obj);
                } else {
                    filter.process(obj, res);
                }
            }
            if (!doNotRemovePrimaryFile) {
                remove.remove(primary);
            }
            file.put(primary, new WeakReference<DataObject>(obj));
        }
        this.primaryFiles = file;
        all = this.carefullySort(all, this.getComparator());
        this.order = FolderList.createOrder(all);
        res = all.size() == res.size() ? all : this.carefullySort(res, this.getComparator());
        if (notify) {
            this.fireChildrenChange(add, remove.keySet());
        }
        if (filter != null) {
            filter.finished(res);
        }
        return res;
    }

    private void fireChildrenChange(Collection add, Collection removed) {
        if (!(this.pcs == null || add.isEmpty() && removed.isEmpty())) {
            this.pcs.firePropertyChange("children", null, null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs == null) {
            FolderList folderList = this;
            synchronized (folderList) {
                if (this.pcs == null) {
                    this.pcs = new PropertyChangeSupport(this);
                }
            }
        }
        this.pcs.addPropertyChangeListener(l);
    }

    private final class ListTask
    implements Runnable {
        private FolderListListener filter;
        public List result;
        public RequestProcessor.Task task;

        public ListTask(FolderListListener filter) {
            this.filter = filter;
        }

        public void run() {
            boolean LOG = err.isLoggable(1);
            if (LOG) {
                err.log("ListTask.run 1 on " + FolderList.this.folder);
            }
            if (FolderList.this.comparatorTask != null) {
                FolderList.this.comparatorTask.waitFinished();
            }
            if (FolderList.this.refreshTask != null) {
                FolderList.this.refreshTask.waitFinished();
            }
            err.log("ListTask.run 2");
            this.result = FolderList.this.getObjects(this.filter);
            err.log("ListTask.run 3");
            FolderList.this.folderCreated = true;
        }

        public String toString() {
            return "ListTask@" + Integer.toHexString(System.identityHashCode(this)) + "[" + FolderList.this.folder + "]";
        }
    }
}

