/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.LinkedList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.openide.util.Task;

public interface UndoRedo {
    public static final UndoRedo NONE = new Empty();

    public boolean canUndo();

    public boolean canRedo();

    public void undo() throws CannotUndoException;

    public void redo() throws CannotRedoException;

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public String getUndoPresentationName();

    public String getRedoPresentationName();

    static class 1 {
        static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    }

    public static final class Empty
    implements UndoRedo {
        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        public void undo() throws CannotUndoException {
            throw new CannotUndoException();
        }

        public void redo() throws CannotRedoException {
            throw new CannotRedoException();
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }
    }

    public static class Manager
    extends UndoManager
    implements UndoRedo {
        static final long serialVersionUID = 6721367974521509720L;
        private final EventListenerList list = new EventListenerList();
        private LinkedList runus = new LinkedList();
        private Task task = Task.EMPTY;

        private void superUndoableEditHappened(UndoableEditEvent ue) {
            super.undoableEditHappened(ue);
        }

        private void superDiscardAllEdits() {
            super.discardAllEdits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undoableEditHappened(UndoableEditEvent ue) {
            LinkedList linkedList = this.runus;
            synchronized (linkedList) {
                this.runus.add(ue);
            }
            this.updateTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discardAllEdits() {
            LinkedList linkedList = this.runus;
            synchronized (linkedList) {
                this.runus.add(null);
            }
            this.updateTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canUndo() {
            boolean empty;
            LinkedList linkedList = this.runus;
            synchronized (linkedList) {
                empty = this.runus.isEmpty();
            }
            if (!empty) {
                this.task.waitFinished();
            }
            return super.canUndo();
        }

        private void fireChange() {
            Object[] l = this.list.getListenerList();
            if (l.length == 0) {
                return;
            }
            ChangeEvent ev = new ChangeEvent(this);
            for (int i = l.length - 1; i >= 0; i -= 2) {
                ((ChangeListener)l[i]).stateChanged(ev);
            }
        }

        private void updateTask() {
            class R
            implements Runnable {
                R() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        UndoableEditEvent ue;
                        LinkedList linkedList = Manager.this.runus;
                        synchronized (linkedList) {
                            if (Manager.this.runus.isEmpty()) {
                                break;
                            }
                            ue = (UndoableEditEvent)Manager.this.runus.removeFirst();
                        }
                        if (ue == null) {
                            Manager.this.superDiscardAllEdits();
                        } else {
                            Manager.this.superUndoableEditHappened(ue);
                        }
                        Manager.this.fireChange();
                    }
                }
            }
            R r = new R();
            r.run();
        }

        public void addChangeListener(ChangeListener l) {
            this.list.add(1.class$javax$swing$event$ChangeListener == null ? (1.class$javax$swing$event$ChangeListener = 1.class$("javax.swing.event.ChangeListener")) : 1.class$javax$swing$event$ChangeListener, l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.list.remove(1.class$javax$swing$event$ChangeListener == null ? (1.class$javax$swing$event$ChangeListener = 1.class$("javax.swing.event.ChangeListener")) : 1.class$javax$swing$event$ChangeListener, l);
        }

        public String getUndoPresentationName() {
            return this.canUndo() ? super.getUndoPresentationName() : "";
        }

        public String getRedoPresentationName() {
            return this.canRedo() ? super.getRedoPresentationName() : "";
        }
    }
}

