/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Node;
import org.openide.src.Type;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class JavaWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -1987345873459L;
    private transient WizardDescriptor.Panel[] panels;
    private static String[] panelNames;
    private static JavaWizardIterator instance;
    private transient int panelIndex = 0;
    private transient TemplateWizard wizardInstance;

    public static synchronized JavaWizardIterator singleton() {
        if (instance == null) {
            instance = new JavaWizardIterator();
        }
        return instance;
    }

    public Set instantiate(TemplateWizard wiz) throws IOException, IllegalArgumentException {
        DataObject obj = this.instantiateTemplate(wiz.getTemplate(), wiz.getTargetFolder(), wiz.getTargetName());
        final Node node = obj.getNodeDelegate();
        final SystemAction sa = node.getDefaultAction();
        if (sa != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    sa.actionPerformed(new ActionEvent(node, 1001, ""));
                }
            });
        }
        return Collections.singleton(obj);
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.panelIndex];
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void initialize(TemplateWizard wizard) {
        this.wizardInstance = wizard;
        if (this.panels == null) {
            Component panel = wizard.targetChooser().getComponent();
            panelNames = new String[]{panel.getName()};
            if (panel instanceof JComponent) {
                ((JComponent)panel).putClientProperty("WizardPanel_contentData", panelNames);
            }
            this.panels = new WizardDescriptor.Panel[]{this.wizardInstance.targetChooser()};
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
        this.wizardInstance = null;
    }

    private Object readResolve() {
        return JavaWizardIterator.singleton();
    }

    private DataObject instantiateTemplate(DataObject tpl, DataFolder target, String name) throws IOException {
        if (name == null) {
            name = this.getDefaultName(tpl, target);
        }
        this.checkValidPackageName(target);
        this.checkTargetName(target, name);
        return tpl.createFromTemplate(target, name);
    }

    private boolean isValidPackageName(String s) {
        if ("".equals(s)) {
            return true;
        }
        try {
            Type t = Type.parse((String)s);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private void checkValidPackageName(DataFolder targetFolder) throws IllegalStateException {
        FileObject folder = targetFolder.getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        String msg = null;
        if (cp != null) {
            String fullTarget = cp.getResourceName(folder, '.', false);
            if (this.isValidPackageName(fullTarget)) {
                return;
            }
            msg = MessageFormat.format(JavaWizardIterator.getString("FMTERR_IllegalFolderName"), folder.getPath(), fullTarget);
        } else {
            msg = JavaWizardIterator.getString("ERR_NotInSourcePath");
        }
        throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(msg), 256, null, msg, null, null);
    }

    private boolean checkTargetName(DataFolder folder, String desiredName) {
        if (!Utilities.isJavaIdentifier((String)desiredName)) {
            String msg = MessageFormat.format(JavaWizardIterator.getString("FMTERR_IllegalTargetName"), desiredName);
            this.notifyError(msg);
            return false;
        }
        FileObject f = folder.getPrimaryFile();
        if (f.getFileObject(desiredName, "java") != null) {
            String msg = MessageFormat.format(JavaWizardIterator.getString("FMTERR_TargetExists"), desiredName);
            this.notifyError(msg);
            return false;
        }
        return true;
    }

    private void notifyError(String msg) {
        this.wizardInstance.putProperty("WizardPanel_errorMessage", (Object)msg);
        IllegalStateException ex = new IllegalStateException(msg);
        ErrorManager.getDefault().annotate((Throwable)ex, 256, null, msg, null, null);
        throw ex;
    }

    private String getDefaultName(DataObject template, DataFolder targetFolder) {
        String desiredName = FileUtil.findFreeFileName((FileObject)targetFolder.getPrimaryFile(), (String)template.getName(), (String)"java");
        return desiredName;
    }

    static String getString(String key) {
        return NbBundle.getMessage((Class)JavaWizardIterator.class, (String)key);
    }

    static char getMnemonic(String key) {
        return JavaWizardIterator.getString(key).charAt(0);
    }
}

