/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.JmiException;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.GenericElement;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.modules.java.ui.nodes.editors.IdentifierArrayEditor;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.java.ui.nodes.elements.IconResolver;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.datatransfer.NewType;

public final class ClassNode
extends ElementNode {
    private static final String[] ICON_AFFECTING_PROPERTIES = new String[]{"modifiers"};
    private static final Map mapClassAttributeName;
    private static final Map mapInterfaceAttributeName;
    private boolean isInterface;
    private boolean isSheetCreated = false;
    private DataObject sourceDO;
    static /* synthetic */ Class array$Lorg$netbeans$jmi$javamodel$MultipartId;

    public ClassNode(JavaClass element, Children children, boolean writeable) {
        super((Element)element, children, writeable);
        this.init(element);
    }

    private void init(JavaClass element) {
        this.isInterface = element.isInterface();
        this.setElementFormat0(ClassNode.getElementFormat(this.isInterface));
        this.superSetName(element.getSimpleName());
        this.setIconBase(this.resolveIconBase());
        this.sourceDO = JavaMetamodel.getManager().getDataObject(element.getResource());
    }

    private JavaClass getJavaClass() {
        return (JavaClass)this.element;
    }

    protected String resolveIconBase() {
        return IconResolver.getIconBaseForJavaClass(this.getJavaClass());
    }

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    protected ElementFormat getElementFormatProperty() {
        return ClassNode.getElementFormat(this.isInterface);
    }

    protected ElementFormat getHintElementFormat() {
        return this.isInterface ? ClassNode.getSourceOptions().getInterfaceElementLongFormat() : ClassNode.getSourceOptions().getClassElementLongFormat();
    }

    private static ElementFormat getElementFormat(boolean isInterface) {
        return isInterface ? ClassNode.getSourceOptions().getInterfaceElementFormat() : ClassNode.getSourceOptions().getClassElementFormat();
    }

    protected Map getAttributeNameMap() {
        return this.isInterface ? mapInterfaceAttributeName : mapClassAttributeName;
    }

    protected ElementNode.ChangeDescriptor handleAttributeChange(AttributeEvent ae) {
        ElementNode.ChangeDescriptor cd = super.handleAttributeChange(ae);
        Object src = ae.getSource();
        if (src != this.element || !((JavaClass)src).isValid()) {
            return cd;
        }
        String attrName = ae.getAttributeName();
        JavaClass jc = this.getJavaClass();
        if ("modifiers".equals(attrName) && jc.isInterface() != this.isInterface) {
            this.isInterface = !this.isInterface;
            this.elementFormat = ClassNode.getElementFormat(this.isInterface);
            cd.iconBase = this.resolveIconBase();
            cd.displayName = this.getElementFormat().format((Element)jc);
            cd.shortDescription = this.getShortDescription();
            if (this.isSheetCreated) {
                cd.sheet = new Sheet();
            }
        }
        return cd;
    }

    protected void processChange(ElementNode.ChangeDescriptor desc) {
        if (desc.sheet != null) {
            Sheet.Set ps = this.getSheet().get("properties");
            this.configureSheetSet(ps, this.isInterface);
            desc.sheet = null;
        }
        super.processChange(desc);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        this.configureSheetSet(ps, this.isInterface);
        this.isSheetCreated = true;
        return sheet;
    }

    private void configureSheetSet(Sheet.Set ps, boolean isInterface) {
        ps.put(this.createModifiersProperty(this.writeable));
        ps.put(ClassNode.createNameProperty((NamedElement)this.getJavaClass()));
        ps.put(this.createTypeParametersProperty());
        if (isInterface) {
            ps.remove("superclass");
        } else {
            ps.put(this.createSuperclassProperty(this.writeable));
        }
        ps.put(this.createInterfacesProperty(this.writeable));
    }

    protected Node.Property createSuperclassProperty(boolean canW) {
        return new ElementNode.ElementProp("superclass", String.class, canW){

            public Object getValue() {
                MultipartId mid = ClassNode.this.getJavaClass().getSuperClassName();
                return mid == null ? "" : IdentifierArrayEditor.multipartIdToName(mid);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException();
                }
                String str = ((String)val).trim();
                if (str != null && !"".equals(str)) {
                    boolean fail = true;
                    try {
                        JavaMetamodel.getDefaultRepository().beginTrans(true);
                        try {
                            JavaModelPackage model = JavaMetamodel.getManager().getJavaExtent((Element)ClassNode.this.getJavaClass());
                            MultipartId mid = model.getMultipartId().createMultipartId(str, null, null);
                            ClassNode.this.getJavaClass().setSuperClassName(mid);
                            fail = false;
                        }
                        finally {
                            JavaMetamodel.getDefaultRepository().endTrans(fail);
                        }
                    }
                    catch (JmiException ex) {
                        IllegalArgumentException iaex = new IllegalArgumentException();
                        iaex.initCause(ex);
                        throw ex;
                    }
                }
            }
        };
    }

    protected Node.Property createInterfacesProperty(boolean canW) {
        Node.Property prop = ClassNode.createInterfacesProperty(this.getJavaClass(), canW);
        if (this.isInterface) {
            prop.setDisplayName(ClassNode.getString("PROP_superInterfaces"));
            prop.setShortDescription(ClassNode.getString("HINT_superInterfaces"));
        }
        prop.setValue("changeImmediate", (Object)Boolean.FALSE);
        ClassNode.setModel((Element)this.getJavaClass(), (FeatureDescriptor)prop);
        return prop;
    }

    Node.Property createTypeParametersProperty() {
        Node.Property np = ClassNode.createTypeParametersProperty("typeParameters", (GenericElement)this.getJavaClass(), false);
        np.setValue("changeImmediate", (Object)Boolean.FALSE);
        return np;
    }

    public NewType[] getNewTypes() {
        if (this.writeable) {
            boolean jdk15;
            boolean bl = jdk15 = this.sourceDO != null ? SourceEditSupport.isJDK15Supported(this.sourceDO.getPrimaryFile()) : false;
            if (this.isInterface) {
                return SourceEditSupport.createInterfaceNewTypes(this.getJavaClass(), jdk15);
            }
            return SourceEditSupport.createClassNewTypes(this.getJavaClass(), jdk15);
        }
        return super.getNewTypes();
    }

    public static Node.Property createInterfacesProperty(JavaClass element, boolean canW) {
        InterfacesProperty prop = new InterfacesProperty(element, canW);
        ClassNode.setModel((Element)element, (FeatureDescriptor)((Object)prop));
        return prop;
    }

    static {
        mapInterfaceAttributeName = new HashMap();
        mapInterfaceAttributeName.put("modifiers", "modifiers");
        mapInterfaceAttributeName.put("name", "name");
        mapInterfaceAttributeName.put("interfaceNames", "interfaces");
        mapClassAttributeName = new HashMap(mapInterfaceAttributeName);
        mapClassAttributeName.put("superClassName", "superclass");
    }

    private static final class InterfacesProperty
    extends ElementNode.ElementProp {
        private final JavaClass element;

        public InterfacesProperty(JavaClass element, boolean canW) {
            super("interfaces", array$Lorg$netbeans$jmi$javamodel$MultipartId == null ? (array$Lorg$netbeans$jmi$javamodel$MultipartId = ClassNode.class$("[Lorg.netbeans.jmi.javamodel.MultipartId;")) : array$Lorg$netbeans$jmi$javamodel$MultipartId, canW);
            this.element = element;
        }

        protected PropertyEditor createPropertyEditor() {
            return new IdentifierArrayEditor();
        }

        public Object getValue() {
            return this.element.getInterfaceNames().toArray(new MultipartId[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            super.setValue(val);
            if (!(val instanceof MultipartId[])) {
                throw new IllegalArgumentException();
            }
            boolean fail = true;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(true);
                try {
                    List l = this.element.getInterfaceNames();
                    l.clear();
                    l.addAll(Arrays.asList((MultipartId[])val));
                    fail = false;
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans(fail);
                }
            }
            catch (JmiException ex) {
                IllegalArgumentException iaex = new IllegalArgumentException();
                iaex.initCause(ex);
                throw ex;
            }
        }
    }
}

