/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.ErrConsumer;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.ParserEngine;
import org.netbeans.modules.java.Parsing;
import org.netbeans.modules.java.bridge.CommitListener;
import org.netbeans.modules.java.bridge.LangModel;
import org.netbeans.modules.java.bridge.SrcElementImpl;
import org.netbeans.modules.java.codegen.DocumentBinding;
import org.netbeans.modules.java.parser.JavaParser;
import org.netbeans.modules.java.parser.ParsableObjectRequest;
import org.netbeans.modules.java.parser.ParseObjectRequest;
import org.netbeans.modules.java.parser.Util;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.src.Element;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;

public class ParsingSupport
implements JavaParser {
    private static final int READ_THRESHOLD = 2048;
    private PropertyChangeSupport propSupport;
    public static final String PROP_STATUS = "status";
    private static final boolean DEBUG = false;
    private boolean valid;
    private boolean updating;
    private boolean clean;
    private JavaParser.Env parsingEnv;
    private ParserEngine engine;
    private SourceException savedException;
    private SourceElement src;
    private Processor currentRequest;
    private Processor runningRequest;
    LangModel model;
    LangModel.Updater updater;
    private Reference refImplementation;
    private int status;
    Collection changeList;
    DocumentBinding docBinding;
    JavaDataObject jdo;
    static final Runnable EMPTY_RUNNABLE = new Runnable(){

        public void run() {
        }
    };
    static RequestProcessor PARSING_RP;
    private static RequestProcessor EVENT_RP;

    public ParsingSupport(JavaParser.Env parsingEnv, JavaDataObject jdo, DocumentBinding docBinding, LangModel.Updater updater, LangModel model) {
        this.parsingEnv = parsingEnv;
        this.jdo = jdo;
        this.docBinding = docBinding;
        this.updater = updater;
        this.model = model;
        this.valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Object object;
        if (this.changeList == null) {
            object = this;
            synchronized (object) {
                if (this.changeList == null) {
                    this.changeList = new LinkedList();
                }
            }
        }
        object = this.changeList;
        synchronized (object) {
            this.changeList.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        if (this.changeList == null) {
            return;
        }
        Collection collection = this.changeList;
        synchronized (collection) {
            this.changeList.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propSupport == null) {
            ParsingSupport parsingSupport = this;
            synchronized (parsingSupport) {
                if (this.propSupport == null) {
                    this.propSupport = new PropertyChangeSupport(this);
                }
            }
        }
        this.propSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.removePropertyChangeListener(l);
    }

    public Task parse(int priority, boolean ignoreClean, boolean acceptErrors) {
        Thread.dumpStack();
        return Task.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Task parse(int priority, boolean ignoreClean, boolean acceptErrors, ParsableObjectRequest req) {
        Processor immediate;
        if (req.getParserType() == "mdr") {
            return new FinishedTask(null);
        }
        SourceElement.Impl i = null;
        CloneableEditorSupport editSupport = this.docBinding.getEditorSupport();
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (this.currentRequest != null) {
                if (!PARSING_RP.isRequestProcessorThread()) {
                    this.currentRequest.enableErrors(acceptErrors);
                    this.currentRequest.setPriority(priority);
                    return this.currentRequest.getClientTask();
                }
                immediate = this.currentRequest;
            } else {
                i = this.getSourceImpl();
                if (i != null && this.clean && !ignoreClean) {
                    return new FinishedTask(i);
                }
                Processor proc = new Processor(priority, this.parsingEnv, editSupport, req);
                proc.enableErrors(acceptErrors);
                if (PARSING_RP != null && PARSING_RP.isRequestProcessorThread()) {
                    immediate = proc;
                } else {
                    this.addRequest(proc, priority);
                    return proc.getClientTask();
                }
            }
        }
        immediate.run();
        i = this.getSourceImpl();
        return new FinishedTask(i);
    }

    public synchronized Task getCurrentTask() {
        if (this.currentRequest != null) {
            return this.currentRequest.getClientTask();
        }
        return new FinishedTask(null);
    }

    public void fireElementPropertyChange(Element source, PropertyChangeEvent evt) {
        if (source == this.getSource()) {
            ((SrcElementImpl)this.getSourceImpl()).propertyChange(evt);
        } else {
            this.updater.firePropertyChange(source, evt);
        }
    }

    public ParserEngine getParserEngine() {
        return this.engine;
    }

    public void setParserEngine(ParserEngine eng) {
        this.engine = eng;
    }

    public Task prepare() {
        return Task.EMPTY;
    }

    public SourceElement getSource() {
        if (this.src == null) {
            this.src = this.jdo.getSource();
        }
        return this.src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (!this.valid) {
                return;
            }
            SourceElement.Impl impl = this.getSourceImpl();
            if (impl == null) {
                return;
            }
            this.valid = false;
        }
        this.updater.invalidateModel(this.getSource());
        parsingSupport = this;
        synchronized (parsingSupport) {
            if (!this.updating) {
                this.refImplementation = null;
            }
        }
        this.changeStatus(0);
    }

    protected void changeStatus(int newStatus) {
        int oldStatus = this.status;
        this.status = newStatus;
        if (this.propSupport != null && this.propSupport.hasListeners(null)) {
            this.propSupport.firePropertyChange(PROP_STATUS, oldStatus, newStatus);
        }
        this.fireStateChange();
    }

    private void fireParsingEvent(final Collection messages) {
        SourceElement.Impl hook = this.getSourceImpl();
        EVENT_RP.post(new Runnable(){

            public void run() {
                Parsing.fireEvent(ParsingSupport.this.jdo, messages);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChange() {
        ArrayList copy;
        if (this.changeList == null) {
            return;
        }
        Collection collection = this.changeList;
        synchronized (collection) {
            if (this.changeList.isEmpty()) {
                return;
            }
            copy = new ArrayList(this.changeList);
        }
        ChangeEvent e = new ChangeEvent(this);
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            try {
                ((ChangeListener)it.next()).stateChanged(e);
            }
            catch (RuntimeException x) {
                ErrorManager.getDefault().notify(16, (Throwable)x);
            }
        }
    }

    public SourceElement.Impl getSourceImpl() {
        SourceElement sourceElem = this.getSource();
        if (sourceElem == null) {
            return null;
        }
        return (SourceElement.Impl)sourceElem.getCookie(SourceElement.Impl.class);
    }

    public LangModel getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceElement.Impl findSourceImpl() throws SourceException {
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            SourceElement.Impl impl = this.getSourceImpl();
            if (impl != null) {
                return impl;
            }
            Util.log("impl = null");
            if (this.savedException != null) {
                throw this.savedException;
            }
        }
        throw new SourceException("Cannot acquire source");
    }

    public void sourceChanged(int from, int to) {
        Processor req = this.currentRequest;
        this.clean = false;
        if (req != null) {
            req.sourceChanged();
        }
    }

    public SourceException getErrorCause() {
        return this.savedException;
    }

    Node.Cookie findCookieForSource(Class type) {
        if (this.src == null) {
            return null;
        }
        return this.parsingEnv.findCookie(this.getSource(), type);
    }

    public int getStatus() {
        int s = this.status;
        if (s != 3) {
            return s;
        }
        SourceElement.Impl impl = this.getSourceImpl();
        if (impl == null) {
            this.changeStatus(0);
        }
        return this.status;
    }

    public Task addParsingRunnable(Runnable r, int priority) {
        return PARSING_RP.post(r, 0, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(Processor proc, int priority) {
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (PARSING_RP == null) {
                PARSING_RP = new RequestProcessor("Java source parsing");
                EVENT_RP = new RequestProcessor("Java Parser Event Queue");
            }
            if (this.currentRequest != proc) {
                if (this.currentRequest != null) {
                    proc.chainRequest(this.currentRequest);
                }
                this.currentRequest = proc;
            }
            proc.setProcessorTask(PARSING_RP.post((Runnable)proc, 0, priority));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerData(SourceElement.Impl data) {
        DataFinalizer newRef;
        Object object = ParsingSupport.class;
        synchronized (object) {
            newRef = new DataFinalizer(this, data, Utilities.activeReferenceQueue());
        }
        object = this;
        synchronized (object) {
            this.refImplementation = newRef;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFinalized(Reference refImpl) {
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (this.refImplementation != refImpl) {
                return;
            }
            this.refImplementation = null;
        }
        this.changeStatus(0);
    }

    private static class DataFinalizer
    extends WeakReference
    implements Runnable {
        Reference refSupp;

        DataFinalizer(ParsingSupport supp, Object data, ReferenceQueue rqueue) {
            super(data, rqueue);
            this.refSupp = new WeakReference<ParsingSupport>(supp);
        }

        public void run() {
            ParsingSupport supp = (ParsingSupport)this.refSupp.get();
            if (supp != null) {
                supp.notifyFinalized(this);
            }
        }
    }

    class Processor
    implements Runnable,
    CommitListener,
    ParseObjectRequest {
        Processor chained;
        int priority;
        RequestProcessor.Task ownTask;
        boolean errorsOK;
        int stage;
        int resultStatus;
        ParsableObjectRequest request;
        T task;

        Processor(int priority, JavaParser.Env env, CloneableEditorSupport supp, ParsableObjectRequest req) {
            this.request = req;
            this.task = new T();
            this.request.setEnvironment(env);
            this.request.setEditorSupport(supp);
        }

        protected void directRun() {
            do {
                this.run();
            } while (this.stage >= 0);
        }

        public void setPriority(int prior) {
            if (this.priority > prior) {
                return;
            }
            this.priority = prior;
            if (this.ownTask.cancel()) {
                ParsingSupport.this.addRequest(this, prior);
            }
        }

        public void enableErrors(boolean enable) {
            this.errorsOK |= enable;
        }

        public void chainRequest(Processor other) {
            this.chained = other;
        }

        public void setProcessorTask(RequestProcessor.Task t) {
            this.ownTask = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            Util.log("processing request " + this + " stage " + this.stage);
            try {
                switch (this.stage++) {
                    case 0: {
                        this.parseLockModel();
                        ** break;
lbl7:
                        // 1 sources

                        break;
                    }
                    ** default:
lbl9:
                    // 1 sources

                    break;
                }
            }
            catch (SourceException.IO e) {
                this.resultStatus = 1;
            }
            catch (Throwable e) {
                ParsingSupport.access$102(ParsingSupport.this, new SourceException(e.getLocalizedMessage()));
                ParsingSupport.access$200(ParsingSupport.this).annotateThrowable(ParsingSupport.access$100(ParsingSupport.this), e);
                ParsingSupport.access$200(ParsingSupport.this).annotateThrowable(ParsingSupport.access$100(ParsingSupport.this), "Parser error", false);
                ErrorManager.getDefault().notify(e);
                this.resultStatus = 1;
            }
            finally {
                --this.stage;
            }
            Util.log("request " + this + " stage " + (this.stage + 1) + " end");
            if (this.stage > 0) {
                return;
            }
            if (this.resultStatus != -1) {
                this.complete();
            } else {
                this.request.notifyReschedule();
                Util.log("Rescheduling request");
                this.stage = 0;
                ParsingSupport.access$000(ParsingSupport.this, this, this.priority);
            }
        }

        private void updateModel() throws SourceException {
            ParsingSupport.this.model.removePreCommitListener(this);
            if (this.getSyntaxErrors() > 0 && !this.errorsOK) {
                this.resultStatus = 2;
                return;
            }
            if (this.isValid()) {
                this.resultStatus = this.getSyntaxErrors() > 0 ? 2 : 3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseLockModel() throws SourceException {
            ParsingSupport.this.model.addPreCommitListener(this);
            this.resultStatus = -1;
            ParsingSupport parsingSupport = ParsingSupport.this;
            synchronized (parsingSupport) {
                ParsingSupport.this.runningRequest = this;
                Util.log("Running request = " + this);
            }
            ParsingSupport.this.savedException = null;
            try {
                ParsingSupport.this.runningRequest = this;
                this.process(ParsingSupport.this.getParserEngine());
                if (this.isValid()) {
                    Util.log("Request " + this + " processed. Still valid");
                    this.stage = 1;
                    Util.log("trying to run update");
                    this.resultStatus = 3;
                }
            }
            catch (IOException ex) {
                ParsingSupport.this.savedException = (SourceException)((Object)new SourceException.IO(ex));
                ParsingSupport.this.parsingEnv.annotateThrowable(ParsingSupport.this.savedException, ex);
                this.resultStatus = 1;
            }
            catch (InternalError er) {
                ParsingSupport.this.savedException = new SourceException(er.getMessage());
                ParsingSupport.this.parsingEnv.annotateThrowable(ParsingSupport.this.savedException, er);
                this.resultStatus = 1;
            }
            finally {
                ParsingSupport.this.model.removePreCommitListener(this);
            }
            ParsingSupport.this.runningRequest = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete() {
            Collection messages;
            ParsingSupport parsingSupport = ParsingSupport.this;
            synchronized (parsingSupport) {
                if (ParsingSupport.this.currentRequest == this) {
                    ParsingSupport.this.currentRequest = null;
                }
                messages = this.request.getMessages();
            }
            ParsingSupport.this.changeStatus(this.resultStatus);
            ParsingSupport.this.fireParsingEvent(messages);
            this.task.complete();
            if (this.chained != null) {
                this.chained.complete();
            }
            this.stage = -1;
        }

        public void changesCommited(Set created, Set removed, Map changed) {
            this.request.modelChanged();
        }

        public void process(ParserEngine eng) throws IOException {
            eng.process(this);
        }

        public Task getClientTask() {
            return this.task;
        }

        public void sourceChanged() {
            this.request.sourceChanged();
        }

        public void setSyntaxErrors(int errors) {
            this.request.setSyntaxErrors(errors);
        }

        public void setSemanticErrors(int errors) {
            this.request.setSemanticErrors(errors);
        }

        public void notifyStart() {
            this.request.notifyStart();
        }

        public void notifyComplete() {
            this.request.notifyComplete();
        }

        public boolean isValid() {
            return this.request.isValid();
        }

        public boolean needsProcessing() {
            return this.request.needsProcessing();
        }

        public int getSyntaxErrors() {
            return this.request.getSyntaxErrors();
        }

        public Collection getMessages() {
            return this.request.getMessages();
        }

        public ElementFactory getFactory() {
            return this.request.getFactory();
        }

        public char[] getSource() throws IOException {
            ParsingSupport.this.clean = true;
            return this.request.getSource();
        }

        public InputStream findCompiledClass(String className) {
            return this.request.findCompiledClass(className);
        }

        public Object getParserType() {
            return this.request.getParserType();
        }

        public ErrConsumer getErrConsumer() {
            return this.request.getErrConsumer();
        }

        public String getSourceName() {
            return this.request.getSourceName();
        }

        public ClassPath getSourcePath() {
            return this.request.getSourcePath();
        }

        public ClassPath getLibraryPath() {
            return this.request.getLibraryPath();
        }

        public ClassPath getBootClassPath() {
            return this.request.getBootClassPath();
        }

        private class T
        extends Task {
            T() {
                super(EMPTY_RUNNABLE);
            }

            public void run() {
                Processor.this.directRun();
            }

            protected void complete() {
                super.notifyFinished();
            }
        }
    }

    private static class FinishedTask
    extends Task {
        private Object hook;

        public FinishedTask(Object o) {
            super(null);
            this.hook = o;
        }
    }
}

