/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.InvalidObjectException;
import org.netbeans.jmi.javamodel.ErrorInfo;
import org.netbeans.jmi.javamodel.ErrorTypeEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataLoader;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.ParserMessage;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ParsingListener;
import org.openide.src.SourceElement;

public class Parsing {
    private static ParsingListener listener = new ParsingListener(){

        public void resourceParsed(Resource rsc) {
            try {
                JavaDataObject jdo = (JavaDataObject)JavaMetamodel.getManager().getDataObject(rsc);
                if (jdo != null) {
                    Parsing.fireEvent(jdo, rsc);
                }
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParsingListener(Listener l) {
        ArrayList arrayList = JavaDataLoader.parsingListeners;
        synchronized (arrayList) {
            JavaDataLoader.parsingListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeParsingListener(Listener l) {
        ArrayList arrayList = JavaDataLoader.parsingListeners;
        synchronized (arrayList) {
            JavaDataLoader.parsingListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireEvent(JavaDataObject jdo, Resource rsc) {
        Event evt = new Event(jdo, rsc);
        Iterator it = null;
        ArrayList arrayList = JavaDataLoader.parsingListeners;
        synchronized (arrayList) {
            List list = (List)JavaDataLoader.parsingListeners.clone();
            it = list.iterator();
        }
        while (it.hasNext()) {
            ((Listener)it.next()).objectParsed(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireEvent(JavaDataObject jdo, Collection messages) {
        Event evt = new Event(jdo, messages);
        Iterator it = null;
        ArrayList arrayList = JavaDataLoader.parsingListeners;
        synchronized (arrayList) {
            List list = (List)JavaDataLoader.parsingListeners.clone();
            it = list.iterator();
        }
        while (it.hasNext()) {
            ((Listener)it.next()).objectParsed(evt);
        }
    }

    static {
        JavaMetamodel.addParsingListener((ParsingListener)listener);
    }

    public static class Event
    extends EventObject {
        static final long serialVersionUID = 8512232095851109211L;
        private Collection messages;
        private final Resource rsc;

        Event(JavaDataObject jdo, Collection msg) {
            super((Object)jdo);
            this.messages = msg;
            this.rsc = null;
        }

        Event(JavaDataObject jdo, Resource rsc) {
            super((Object)jdo);
            this.rsc = rsc;
        }

        public JavaDataObject getJavaDataObject() {
            return (JavaDataObject)((Object)this.getSource());
        }

        public SourceElement getSourceElement() {
            return this.getJavaDataObject().getSource();
        }

        public synchronized ParserMessage[] getMessages() {
            if (this.messages == null) {
                if (this.rsc == null) {
                    return null;
                }
                List errors = this.rsc.getErrors();
                this.messages = new ArrayList();
                Iterator it = errors.iterator();
                while (it.hasNext()) {
                    this.messages.add(new ParserMessageImpl((ErrorInfo)it.next()));
                }
            }
            ParserMessage[] copy = new ParserMessage[this.messages.size()];
            this.messages.toArray(copy);
            return copy;
        }
    }

    public static interface Listener
    extends EventListener {
        public void objectParsed(Event var1);
    }

    private static class ParserMessageImpl
    extends ParserMessage {
        private final ErrorInfo errorInfo;

        ParserMessageImpl(ErrorInfo ei) {
            this.errorInfo = ei;
        }

        public Object getSeverity() {
            return this.errorInfo.getSeverity() == ErrorTypeEnum.WARNING ? ParserMessage.WARNING : ParserMessage.ERROR;
        }

        public int getLineNumber() {
            return this.errorInfo.getLineNumber();
        }

        public int getColumn() {
            return this.errorInfo.getColumn();
        }

        public String getDescription() {
            return this.errorInfo.getDescription();
        }
    }
}

