/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.api;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.structure.DocumentModelProviderFactory;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.editor.structure.api.DocumentModelListener;
import org.netbeans.modules.editor.structure.api.DocumentModelUtils;
import org.netbeans.modules.editor.structure.spi.DocumentModelProvider;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class DocumentModel {
    private static int MODEL_UPDATE_TIMEOUT = 500;
    private BaseDocument doc;
    private DocumentModelProvider provider;
    private DocumentChangesWatcher changesWatcher;
    private RequestProcessor requestProcessor;
    private RequestProcessor.Task task;
    private TreeSet elements = new TreeSet(ELEMENTS_COMPARATOR);
    private DocumentElement rootElement;
    private DocumentModelModificationTransaction modelUpdateTransaction = null;
    boolean documentDirty = true;
    private Hashtable childrenCache = null;
    private Hashtable parentsCache = null;
    private int numReaders = 0;
    private int numWriters = 0;
    private Thread currWriter = null;
    private Thread currReader = null;
    private HashSet dmListeners = new HashSet();
    private static final int ELEMENT_ADDED = 1;
    private static final int ELEMENT_REMOVED = 2;
    private static final int ELEMENT_CHANGED = 3;
    private static final int ELEMENT_ATTRS_CHANGED = 4;
    private static Map locks = new WeakHashMap();
    private static final Comparator ELEMENTS_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            DocumentElement de1 = (DocumentElement)o1;
            DocumentElement de2 = (DocumentElement)o2;
            if (de1.isRootElement() && !de2.isRootElement()) {
                return -1;
            }
            if (!de1.isRootElement() && de2.isRootElement()) {
                return 1;
            }
            if (de2.isRootElement() && de1.isRootElement()) {
                return 0;
            }
            int startOffsetDelta = de1.getStartOffset() - de2.getStartOffset();
            if (startOffsetDelta != 0) {
                return startOffsetDelta;
            }
            int endOffsetDelta = de2.getEndOffset() - de1.getEndOffset();
            if (endOffsetDelta != 0) {
                return de1.isEmpty() || de2.isEmpty() ? -endOffsetDelta : endOffsetDelta;
            }
            int typesDelta = de1.getType().compareTo(de2.getType());
            if (typesDelta != 0) {
                return typesDelta;
            }
            int namesDelta = de1.getName().compareTo(de2.getName());
            if (namesDelta != 0) {
                return namesDelta;
            }
            int attrsComp = ((DocumentElement.Attributes)de1.getAttributes()).compareTo(de2.getAttributes());
            if (attrsComp != 0) {
                return attrsComp;
            }
            return de1.isEmpty() ? de2.hashCode() - de1.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            return obj.equals(ELEMENTS_COMPARATOR);
        }
    };
    private static final String DOCUMENT_ROOT_ELEMENT_TYPE = "ROOT_ELEMENT";
    private static final boolean debug = Boolean.getBoolean("org.netbeans.editor.model.debug");
    private static final boolean measure = Boolean.getBoolean("org.netbeans.editor.model.measure");
    private static final String GENERATING_MODEL_PROPERTY = "generating_document_model";

    DocumentModel(Document doc, DocumentModelProvider provider) throws DocumentModelException {
        this.doc = (BaseDocument)doc;
        this.provider = provider;
        this.childrenCache = new Hashtable();
        this.parentsCache = new Hashtable();
        this.requestProcessor = new RequestProcessor(DocumentModel.class.getName());
        this.task = null;
        this.addRootElement();
        this.initDocumentModel();
        this.changesWatcher = new DocumentChangesWatcher();
        this.getDocument().addDocumentListener(WeakListeners.document((DocumentListener)this.changesWatcher, (Object)doc));
    }

    public static DocumentModel getDocumentModel(Document doc) throws DocumentModelException {
        Object object = DocumentModel.getLock(doc);
        synchronized (object) {
            DocumentModel cachedInstance;
            if (!(doc instanceof BaseDocument)) {
                throw new ClassCastException("Currently it is necessary to pass org.netbeans.editor.BaseDocument instance into the DocumentModel.getDocumentProvider(j.s.t.Document) method.");
            }
            WeakReference modelWR = (WeakReference)doc.getProperty(DocumentModel.class);
            DocumentModel documentModel = cachedInstance = modelWR == null ? null : (DocumentModel)modelWR.get();
            if (cachedInstance != null) {
                return cachedInstance;
            }
            Class editorKitClass = ((BaseDocument)doc).getKitClass();
            BaseKit kit = BaseKit.getKit((Class)editorKitClass);
            if (kit != null) {
                String mimeType = kit.getContentType();
                DocumentModelProvider provider = DocumentModelProviderFactory.getDefault().getDocumentModelProvider(mimeType);
                if (provider != null) {
                    DocumentModel model = new DocumentModel(doc, provider);
                    doc.putProperty(DocumentModel.class, new WeakReference<DocumentModel>(model));
                    return model;
                }
                return null;
            }
            throw new IllegalStateException("No editor kit for document " + doc + "!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getLock(Document doc) {
        Map map = locks;
        synchronized (map) {
            Object lock = locks.get(doc);
            if (lock == null) {
                lock = new Object();
                locks.put(doc, lock);
            }
            return lock;
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public DocumentElement getRootElement() {
        return this.rootElement;
    }

    public void addDocumentModelListener(DocumentModelListener dml) {
        this.dmListeners.add(dml);
    }

    public void removeDocumentModelListener(DocumentModelListener dml) {
        this.dmListeners.remove(dml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDescendantOf(DocumentElement ancestor, DocumentElement descendant) {
        this.readLock();
        try {
            if (ancestor == descendant) {
                if (debug) {
                    System.out.println("ERROR in " + ancestor);
                }
                this.debugElements();
                throw new IllegalArgumentException("ancestor == descendant!!!");
            }
            if (ancestor == this.getRootElement()) {
                boolean bl = true;
                return bl;
            }
            int ancestorSO = ancestor.getStartOffset();
            int descendantSO = descendant.getStartOffset();
            int ancestorEO = ancestor.getEndOffset();
            int descendantEO = descendant.getEndOffset();
            if (!descendant.isEmpty() && (ancestorSO == descendantSO && ancestorEO > descendantEO || ancestorEO == descendantEO && ancestorSO < descendantSO)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = ancestorSO < descendantSO && ancestorEO > descendantEO;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentElement getLeafElementForOffset(int offset) {
        this.readLock();
        try {
            DocumentElement de;
            if (this.getDocument().getLength() == 0) {
                DocumentElement documentElement = this.getRootElement();
                return documentElement;
            }
            Iterator itr = this.getElementsSet().iterator();
            DocumentElement leaf = null;
            while (itr.hasNext() && (de = (DocumentElement)itr.next()).getStartOffset() <= offset) {
                if (de.getEndOffset() < offset) continue;
                if (de.getStartOffset() == de.getEndOffset() && de.getStartOffset() == offset) break;
                leaf = de;
            }
            if (leaf == null) {
                leaf = this.getRootElement();
            }
            DocumentElement documentElement = leaf;
            return documentElement;
        }
        finally {
            this.readUnlock();
        }
    }

    static void setModelUpdateTimout(int timeout) {
        MODEL_UPDATE_TIMEOUT = timeout;
    }

    private synchronized TreeSet getElementsSet() {
        if (this.documentDirty) {
            this.resortAndMarkEmptyElements();
        }
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentElement getDocumentElement(int startOffset, int endOffset) throws BadLocationException {
        this.readLock();
        try {
            for (DocumentElement de : this.getElementsSet()) {
                if (de.getStartOffset() == startOffset && de.getEndOffset() == endOffset) {
                    DocumentElement documentElement = de;
                    return documentElement;
                }
                if (de.getStartOffset() <= startOffset) continue;
                break;
            }
            DocumentElement documentElement = null;
            return documentElement;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getDocumentElements(int startOffset) throws BadLocationException {
        this.readLock();
        try {
            ArrayList<DocumentElement> found = new ArrayList<DocumentElement>();
            for (DocumentElement de : this.getElementsSet()) {
                if (de.getStartOffset() == startOffset) {
                    found.add(de);
                }
                if (de.getStartOffset() <= startOffset) continue;
                break;
            }
            ArrayList<DocumentElement> arrayList = found;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    private DocumentModelModificationTransaction createTransaction(boolean init) {
        return new DocumentModelModificationTransaction(init);
    }

    private void initDocumentModel() throws DocumentModelException {
        block2: {
            try {
                DocumentModelModificationTransaction trans = this.createTransaction(true);
                this.provider.updateModel(trans, this, new DocumentChange[]{new DocumentChange(this.getDocument().getStartPosition(), this.getDocument().getLength(), 0)});
                trans.commit();
            }
            catch (DocumentModelTransactionCancelledException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"We should never get here");
            }
        }
    }

    private void requestModelUpdate() {
        if (this.modelUpdateTransaction != null) {
            this.modelUpdateTransaction.setTransactionCancelled();
        }
        if (this.requestProcessor == null) {
            return;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        Runnable modelUpdate = new Runnable(){

            public void run() {
                DocumentModel.this.updateModel();
            }
        };
        this.task = this.requestProcessor.post(modelUpdate, MODEL_UPDATE_TIMEOUT);
    }

    private void updateModel() {
        block8: {
            this.modelUpdateTransaction = this.createTransaction(false);
            DocumentChange[] changes = this.changesWatcher.getDocumentChanges();
            if (debug) {
                this.debugElements();
            }
            try {
                this.provider.updateModel(this.modelUpdateTransaction, this, changes);
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                DocumentModel.this.writeLock();
                                DocumentModel.this.modelUpdateTransaction.commit();
                                DocumentModel.this.changesWatcher.clearChanges();
                                DocumentModel.this.modelUpdateTransaction = null;
                            }
                            catch (DocumentModelTransactionCancelledException dmte) {
                            }
                            catch (Exception e) {
                                ErrorManager.getDefault().notify(4096, (Throwable)e);
                            }
                            finally {
                                DocumentModel.this.writeUnlock();
                            }
                        }
                    });
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
            }
            catch (DocumentModelException e) {
                if (debug) {
                    System.err.println("[DocumentModelUpdate] " + e.getMessage());
                }
            }
            catch (DocumentModelTransactionCancelledException dmcte) {
                if (!debug) break block8;
                System.out.println("[document model] update transaction cancelled.");
            }
        }
        if (debug) {
            DocumentModelUtils.dumpElementStructure(this.getRootElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resortAndMarkEmptyElements() {
        this.writeLock();
        try {
            this.doc.readLock();
            try {
                ArrayList list = new ArrayList(this.elements);
                this.elements.clear();
                for (DocumentElement de : list) {
                    if (DocumentModel.isEmpty(de)) {
                        de.setElementIsEmptyState(true);
                    }
                    this.elements.add(de);
                }
            }
            finally {
                this.doc.readUnlock();
            }
        }
        finally {
            this.writeUnlock();
        }
        this.documentDirty = false;
        this.clearChildrenCache();
        this.clearParentsCache();
    }

    private void addRootElement() {
        block3: {
            try {
                DocumentModelModificationTransaction dmt = this.createTransaction(false);
                this.rootElement = dmt.addDocumentElement("root", DOCUMENT_ROOT_ELEMENT_TYPE, Collections.EMPTY_MAP, 0, this.getDocument().getLength());
                this.rootElement.setRootElement(true);
                dmt.commit();
            }
            catch (BadLocationException e) {
                throw new IllegalStateException("Adding of root document element failed - strange!");
            }
            catch (DocumentModelTransactionCancelledException dmtce) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"We should never get here");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getChildren(DocumentElement de) {
        List cachedChildren = this.getCachedChildren(de);
        if (cachedChildren != null) {
            return cachedChildren;
        }
        this.readLock();
        try {
            if (!this.getElementsSet().contains(de)) {
                if (debug) {
                    System.out.println("Warning: DocumentModel.getChildren(...) called for " + de + " which has already been removed!");
                }
                List list = Collections.EMPTY_LIST;
                return list;
            }
            if (!de.isRootElement() && de.isEmpty()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            if (de.isRootElement() && de.isEmpty()) {
                ArrayList al = new ArrayList((Collection)this.getElementsSet().clone());
                al.remove(de);
                ArrayList arrayList = al;
                return arrayList;
            }
            ArrayList<DocumentElement> children = new ArrayList<DocumentElement>();
            SortedSet<DocumentElement> tail = this.getElementsSet().tailSet(de);
            Iterator pchi = tail.iterator();
            pchi.next();
            if (pchi.hasNext()) {
                DocumentElement docel;
                DocumentElement firstChild = (DocumentElement)pchi.next();
                children.add(firstChild);
                if (!this.isDescendantOf(de, firstChild)) {
                    List list = this.cacheChildrenList(de, Collections.EMPTY_LIST);
                    return list;
                }
                DocumentElement nextChild = firstChild;
                while (pchi.hasNext() && (docel = (DocumentElement)pchi.next()).getStartOffset() <= de.getEndOffset()) {
                    if (docel.getStartOffset() < nextChild.getEndOffset()) continue;
                    children.add(docel);
                    nextChild = docel;
                }
            }
            assert (!children.contains(de)) : "getChildren(de) contains the de itself!";
            List list = this.cacheChildrenList(de, children);
            return list;
        }
        catch (Exception e) {
            System.err.println("Error in getCHildren!!!! for " + de);
            this.debugElements();
            DocumentModelUtils.dumpElementStructure(this.getRootElement());
            e.printStackTrace();
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    private List getCachedChildren(DocumentElement de) {
        return (List)this.childrenCache.get(de);
    }

    private List cacheChildrenList(DocumentElement de, List children) {
        this.childrenCache.put(de, children);
        return children;
    }

    private void clearChildrenCache() {
        this.childrenCache = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentElement getParent(DocumentElement de) {
        DocumentElement cachedParent = this.getCachedParent(de);
        if (cachedParent != null) {
            return cachedParent;
        }
        this.readLock();
        try {
            if (!this.getElementsSet().contains(de)) {
                this.debugElements();
                throw new IllegalArgumentException("getParent() called for " + de + " which is not in the elements list!");
            }
            if (de.isRootElement()) {
                DocumentElement documentElement = null;
                return documentElement;
            }
            SortedSet<DocumentElement> head = this.getElementsSet().headSet(de);
            if (head.isEmpty()) {
                DocumentElement documentElement = null;
                return documentElement;
            }
            DocumentElement[] headarr = head.toArray(new DocumentElement[0]);
            for (int i = headarr.length - 1; i >= 0; --i) {
                DocumentElement el = headarr[i];
                if (el.isEmpty() || !this.isDescendantOf(el, de) || el.getStartOffset() >= de.getStartOffset()) continue;
                DocumentElement documentElement = this.cacheParent(de, el);
                return documentElement;
            }
            DocumentElement documentElement = this.cacheParent(de, this.getRootElement());
            return documentElement;
        }
        finally {
            this.readUnlock();
        }
    }

    private DocumentElement getCachedParent(DocumentElement de) {
        return (DocumentElement)this.parentsCache.get(de);
    }

    private DocumentElement cacheParent(DocumentElement de, DocumentElement parent) {
        this.parentsCache.put(de, parent);
        return parent;
    }

    private void clearParentsCache() {
        this.parentsCache = new Hashtable();
    }

    private void generateParentsCache() {
        Stack<DocumentElement> path = new Stack<DocumentElement>();
        block0: for (DocumentElement de : this.getElementsSet()) {
            if (path.empty()) {
                path.push(de);
                continue;
            }
            DocumentElement ancestor = (DocumentElement)path.pop();
            while (true) {
                if (this.isDescendantOf(ancestor, de)) {
                    this.cacheParent(de, ancestor);
                    path.push(ancestor);
                    path.push(de);
                    continue block0;
                }
                ancestor = (DocumentElement)path.pop();
            }
        }
    }

    private DocumentElement createDocumentElement(String name, String type, Map attributes, int startOffset, int endOffset) throws BadLocationException {
        return new DocumentElement(name, type, attributes, startOffset, endOffset, this);
    }

    private void fireDocumentModelEvent(DocumentElement de, int type) {
        for (DocumentModelListener cl : this.dmListeners) {
            switch (type) {
                case 1: {
                    cl.documentElementAdded(de);
                    break;
                }
                case 2: {
                    cl.documentElementRemoved(de);
                    break;
                }
                case 3: {
                    cl.documentElementChanged(de);
                    break;
                }
                case 4: {
                    cl.documentElementAttributesChanged(de);
                }
            }
        }
    }

    public final synchronized void readLock() {
        try {
            while (this.currWriter != null) {
                if (this.currWriter == Thread.currentThread()) {
                    return;
                }
                this.wait();
            }
            this.currReader = Thread.currentThread();
            ++this.numReaders;
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted attempt to aquire read lock");
        }
    }

    public final synchronized void readUnlock() {
        if (this.currWriter == Thread.currentThread()) {
            return;
        }
        assert (this.numReaders > 0) : "Bad read lock state!";
        --this.numReaders;
        if (this.numReaders == 0) {
            this.currReader = null;
        }
        this.notify();
    }

    private final synchronized void writeLock() {
        try {
            while (this.numReaders > 0 || this.currWriter != null) {
                if (Thread.currentThread() == this.currWriter) {
                    ++this.numWriters;
                    return;
                }
                if (Thread.currentThread() == this.currReader) {
                    return;
                }
                this.wait();
            }
            this.currWriter = Thread.currentThread();
            this.numWriters = 1;
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted attempt to aquire write lock");
        }
    }

    private final synchronized void writeUnlock() {
        if (--this.numWriters <= 0) {
            this.numWriters = 0;
            this.currWriter = null;
            this.notifyAll();
        }
    }

    void debugElements() {
        System.out.println("DEBUG ELEMENTS:");
        Iterator i = this.getElementsSet().iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
        System.out.println("*****\n");
    }

    static final boolean isEmpty(DocumentElement de) {
        return de.getStartOffset() == de.getEndOffset();
    }

    public class DocumentChange {
        public static final int INSERT = 0;
        public static final int REMOVE = 1;
        private Position changeStart;
        private int changeLength;
        private int type;

        DocumentChange(Position changeStart, int changeLength, int type) {
            this.changeStart = changeStart;
            this.changeLength = changeLength;
            this.type = type;
        }

        public Position getChangeStart() {
            return this.changeStart;
        }

        public int getChangeLength() {
            return this.changeLength;
        }

        public int getChangeType() {
            return this.type;
        }

        public String toString() {
            return "Change[" + this.getChangeStart().getOffset() + "-" + (this.getChangeStart().getOffset() + this.getChangeLength()) + "-" + (this.type == 0 ? "INSERT" : "REMOVE") + "] text: " + this.getChangeText();
        }

        private String getChangeText() {
            try {
                String text = DocumentModel.this.getDocument().getText(this.getChangeStart().getOffset(), this.getChangeLength());
                if (this.type == 0) {
                    return text;
                }
                if (this.type == 1) {
                    return "[cannot provide removed text]; the text on remove offset: " + text;
                }
                assert (false) : "Wrong document change type!";
            }
            catch (BadLocationException e) {
                return "BadLocationException thrown: " + e.getMessage();
            }
            return null;
        }
    }

    private final class DocumentChangesWatcher
    implements DocumentListener {
        private ArrayList documentChanges = new ArrayList();

        private DocumentChangesWatcher() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        private void documentChanged(DocumentEvent documentEvent) {
            DocumentModel.this.documentDirty = true;
            try {
                if (DocumentModel.this.getRootElement().getStartOffset() > 0 || DocumentModel.this.getRootElement().getEndOffset() < DocumentModel.this.getDocument().getLength()) {
                    DocumentModel.this.getRootElement().setStartPosition(0);
                    DocumentModel.this.getRootElement().setEndPosition(DocumentModel.this.getDocument().getLength());
                }
                int change_offset = documentEvent.getOffset();
                int change_length = documentEvent.getLength();
                int type = documentEvent.getType().equals(DocumentEvent.EventType.REMOVE) ? 1 : 0;
                DocumentChange dchi = new DocumentChange(DocumentModel.this.getDocument().createPosition(change_offset), change_length, type);
                this.documentChanges.add(dchi);
                if (debug) {
                    System.out.println(dchi);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            DocumentModel.this.requestModelUpdate();
        }

        public DocumentChange[] getDocumentChanges() {
            List changes = (List)this.documentChanges.clone();
            return changes.toArray(new DocumentChange[0]);
        }

        public void clearChanges() {
            this.documentChanges.clear();
        }
    }

    public final class DocumentModelTransactionCancelledException
    extends Exception {
    }

    public final class DocumentModelModificationTransaction {
        private ArrayList modifications = new ArrayList();
        private boolean transactionCancelled = false;
        private boolean init;

        DocumentModelModificationTransaction(boolean init) {
            this.init = init;
        }

        public DocumentElement addDocumentElement(String name, String type, Map attributes, int startOffset, int endOffset) throws BadLocationException, DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            DocumentElement de = DocumentModel.this.createDocumentElement(name, type, attributes, startOffset, endOffset);
            if (!DocumentModel.this.getElementsSet().contains(de)) {
                if (debug) {
                    System.out.println("# ADD " + de + " adding into transaction");
                }
                DocumentModelModification dmm = new DocumentModelModification(de, 1);
                this.modifications.add(dmm);
            }
            return de;
        }

        public void removeDocumentElement(DocumentElement de, boolean removeAllItsDescendants) throws DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            if (de.isRootElement()) {
                if (debug) {
                    System.out.println("WARNING: root element cannot be removed!");
                }
                return;
            }
            if (debug) {
                System.out.println("# REMOVE " + de + " adding into transaction ");
            }
            if (removeAllItsDescendants) {
                for (DocumentElement child : DocumentModel.this.getChildren(de)) {
                    this.removeDocumentElement(child, true);
                }
            }
            DocumentModelModification dmm = new DocumentModelModification(de, 2);
            this.modifications.add(dmm);
        }

        public void updateDocumentElementText(DocumentElement de) throws DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            DocumentModelModification dmm = new DocumentModelModification(de, 3);
            if (!this.modifications.contains(dmm)) {
                this.modifications.add(dmm);
            }
        }

        public void updateDocumentElementAttribs(DocumentElement de, Map attrs) throws DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            DocumentModelModification dmm = new DocumentModelModification(de, 4, attrs);
            if (!this.modifications.contains(dmm)) {
                this.modifications.add(dmm);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commit() throws DocumentModelTransactionCancelledException {
            long a = System.currentTimeMillis();
            DocumentModel.this.writeLock();
            try {
                if (this.transactionCancelled) {
                    throw new DocumentModelTransactionCancelledException();
                }
                long r = System.currentTimeMillis();
                if (debug) {
                    System.out.println("\n# commiting REMOVEs");
                }
                Iterator mods = this.modifications.iterator();
                int removes = 0;
                while (mods.hasNext()) {
                    DocumentModelModification dmm = (DocumentModelModification)mods.next();
                    if (dmm.type != 2) continue;
                    this.removeDE(dmm.de);
                    ++removes;
                }
                if (measure) {
                    System.out.println("[xmlmodel] " + removes + " removes commited in " + (System.currentTimeMillis() - r));
                }
                DocumentModel.this.getRootElement().setElementIsEmptyState(false);
                long adds = System.currentTimeMillis();
                if (debug) {
                    System.out.println("\n# commiting ADDs");
                }
                mods = this.modifications.iterator();
                TreeSet<DocumentElement> sortedAdds = new TreeSet<DocumentElement>(ELEMENTS_COMPARATOR);
                while (mods.hasNext()) {
                    DocumentModelModification dmm = (DocumentModelModification)mods.next();
                    if (dmm.type != 1) continue;
                    sortedAdds.add(dmm.de);
                }
                ArrayList<DocumentElement> reallyAdded = new ArrayList<DocumentElement>(sortedAdds.size());
                int addsNum = sortedAdds.size();
                for (DocumentElement de : sortedAdds) {
                    if (!this.addDE(de)) continue;
                    reallyAdded.add(de);
                }
                DocumentModel.this.clearChildrenCache();
                DocumentModel.this.clearParentsCache();
                if (!this.init) {
                    DocumentModel.this.generateParentsCache();
                    for (DocumentElement de : reallyAdded) {
                        this.fireElementAddedEvent(de);
                    }
                }
                if (measure) {
                    System.out.println("[xmlmodel] " + addsNum + " adds commited in " + (System.currentTimeMillis() - adds));
                }
                long upds = System.currentTimeMillis();
                if (debug) {
                    System.out.println("\n# commiting text UPDATESs");
                }
                for (DocumentModelModification dmm : this.modifications) {
                    if (dmm.type != 3) continue;
                    this.updateDEText(dmm.de);
                }
                if (debug) {
                    System.out.println("\n# commiting attribs UPDATESs");
                }
                for (DocumentModelModification dmm : this.modifications) {
                    if (dmm.type != 4) continue;
                    this.updateDEAttrs(dmm.de, dmm.attrs);
                }
                if (measure) {
                    System.out.println("[xmlmodel] updates commit done in " + (System.currentTimeMillis() - upds));
                }
            }
            finally {
                DocumentModel.this.writeUnlock();
            }
            if (debug) {
                System.out.println("# commit finished\n");
            }
            if (measure) {
                System.out.println("[xmlmodel] commit done in " + (System.currentTimeMillis() - a));
            }
        }

        private void updateDEText(DocumentElement de) {
            DocumentModel.this.fireDocumentModelEvent(de, 3);
            de.contentChanged();
        }

        private void updateDEAttrs(DocumentElement de, Map attrs) {
            de.setAttributes(attrs);
            DocumentModel.this.fireDocumentModelEvent(de, 4);
            de.attributesChanged();
        }

        private boolean addDE(DocumentElement de) {
            return DocumentModel.this.getElementsSet().add(de);
        }

        private void fireElementAddedEvent(DocumentElement de) {
            List children = de.getChildren();
            DocumentElement parent = de.getParentElement();
            if (parent != null) {
                parent.childAdded(de);
                for (DocumentElement child : children) {
                    parent.childRemoved(child);
                    de.childAdded(child);
                }
            }
            DocumentModel.this.fireDocumentModelEvent(de, 1);
        }

        private void removeDE(DocumentElement de) {
            if (debug) {
                System.out.println("[DTM] removing " + de);
            }
            DocumentElement parent = null;
            if (de.isRootElement()) {
                return;
            }
            if (!DocumentModel.this.getElementsSet().contains(de)) {
                return;
            }
            parent = DocumentModel.this.getParent(de);
            Iterator childrenIterator = de.getChildren().iterator();
            if (debug) {
                System.out.println("[DMT] removed element " + de + " ;parent = " + parent);
            }
            if (parent == null) {
                if (debug) {
                    System.out.println("[DTM] WARNING: element has no parent (no events are fired to it!!!) " + de);
                }
                if (debug) {
                    System.out.println("[DTM] Trying to recover by returning root element...");
                }
                parent = DocumentModel.this.getRootElement();
            }
            DocumentModel.this.clearChildrenCache();
            DocumentModel.this.clearParentsCache();
            DocumentModel.this.getElementsSet().remove(de);
            while (childrenIterator.hasNext()) {
                DocumentElement child = (DocumentElement)childrenIterator.next();
                if (debug) {
                    System.out.println("switching child " + child + "from removed " + de + "to parent " + parent);
                }
                de.childRemoved(child);
                parent.childAdded(child);
            }
            if (parent != null) {
                parent.childRemoved(de);
            }
            DocumentModel.this.fireDocumentModelEvent(de, 2);
        }

        private void setTransactionCancelled() {
            this.transactionCancelled = true;
        }

        private final class DocumentModelModification {
            public static final int ELEMENT_ADD = 1;
            public static final int ELEMENT_REMOVED = 2;
            public static final int ELEMENT_CHANGED = 3;
            public static final int ELEMENT_ATTRS_CHANGED = 4;
            public int type;
            public DocumentElement de;
            public Map attrs = null;

            public DocumentModelModification(DocumentElement de, int type) {
                this.de = de;
                this.type = type;
            }

            public DocumentModelModification(DocumentElement de, int type, Map attrs) {
                this(de, type);
                this.attrs = attrs;
            }

            public boolean equals(Object o) {
                if (!(o instanceof DocumentModelModification)) {
                    return false;
                }
                DocumentModelModification dmm = (DocumentModelModification)o;
                return dmm.type == this.type && dmm.de.equals(this.de);
            }
        }
    }
}

