/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class LibrariesChooser
extends JPanel
implements HelpCtx.Provider {
    private JButton edit;
    private JLabel jLabel1;
    private JList jList1;
    private JScrollPane jScrollPane1;

    public LibrariesChooser(final JButton addLibraryOption, String j2eePlatform) {
        this.initComponents();
        this.jList1.setPrototypeCellValue("0123456789012345678901234");
        this.jList1.setModel(new LibrariesListModel(j2eePlatform));
        this.jList1.setCellRenderer(new LibraryRenderer());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                addLibraryOption.setEnabled(LibrariesChooser.this.jList1.getSelectedIndices().length != 0);
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(LibrariesChooser.class);
    }

    public Library[] getSelectedLibraries() {
        Object[] selected = this.jList1.getSelectedValues();
        Library[] libraries = new Library[selected.length];
        System.arraycopy(selected, 0, libraries, 0, selected.length);
        return libraries;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.edit = new JButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LibrariesChooser.class).getString("AD_LibrariesChooser"));
        this.jLabel1.setDisplayedMnemonic(NbBundle.getBundle(LibrariesChooser.class).getString("MNE_InstalledLibraries").charAt(0));
        this.jLabel1.setLabelFor(this.jList1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(LibrariesChooser.class).getString("CTL_InstalledLibraries"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jList1);
        this.jList1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LibrariesChooser.class).getString("AD_jScrollPaneLibraries"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.edit, (String)NbBundle.getBundle(LibrariesChooser.class).getString("CTL_EditLibraries"));
        this.edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibrariesChooser.this.editLibraries(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.edit, gridBagConstraints);
        this.edit.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LibrariesChooser.class).getString("AD_jButtonManageLibraries"));
    }

    private void editLibraries(ActionEvent evt) {
        LibrariesListModel model = (LibrariesListModel)this.jList1.getModel();
        List<Library> oldLibraries = Arrays.asList(model.getLibraries());
        LibrariesCustomizer.showCustomizer((Library)((Library)this.jList1.getSelectedValue()));
        List<Library> currentLibraries = Arrays.asList(model.getLibraries());
        ArrayList<Library> newLibraries = new ArrayList<Library>(currentLibraries);
        newLibraries.removeAll(oldLibraries);
        int[] indexes = new int[newLibraries.size()];
        Iterator it = newLibraries.iterator();
        int i = 0;
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            indexes[i] = currentLibraries.indexOf(lib);
            ++i;
        }
        this.jList1.setSelectedIndices(indexes);
    }

    private final class LibraryRenderer
    extends DefaultListCellRenderer {
        private static final String LIBRARY_ICON = "org/netbeans/modules/web/project/ui/resources/libraries.gif";
        private Icon cachedIcon;

        private LibraryRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayName = null;
            Object toolTip = null;
            Object color = null;
            if (value instanceof Library) {
                Library lib = (Library)value;
                displayName = lib.getDisplayName();
            }
            super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
            this.setIcon(this.createIcon());
            return this;
        }

        private synchronized Icon createIcon() {
            if (this.cachedIcon == null) {
                Image img = Utilities.loadImage((String)LIBRARY_ICON);
                this.cachedIcon = new ImageIcon(img);
            }
            return this.cachedIcon;
        }
    }

    private static final class LibrariesListModel
    extends AbstractListModel
    implements PropertyChangeListener {
        private Library[] cache;
        private String j2eePlatform;
        private int numberOfLibs;
        private static ArrayList filter13 = new ArrayList();

        public LibrariesListModel(String j2eePlatform) {
            this.j2eePlatform = j2eePlatform;
            LibraryManager manager = LibraryManager.getDefault();
            manager.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)manager));
        }

        public synchronized int getSize() {
            if (this.cache == null) {
                this.cache = this.createLibraries();
            }
            return this.cache.length;
        }

        public synchronized Object getElementAt(int index) {
            if (this.cache == null) {
                this.cache = this.createLibraries();
            }
            if (index >= 0 && index < this.cache.length) {
                return this.cache[index];
            }
            return null;
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            int oldSize = this.cache == null ? 0 : this.numberOfLibs;
            this.cache = this.createLibraries();
            int newSize = this.numberOfLibs;
            this.fireContentsChanged(this, 0, Math.min(oldSize - 1, newSize - 1));
            if (oldSize > newSize) {
                this.fireIntervalRemoved(this, newSize, oldSize - 1);
            } else if (oldSize < newSize) {
                this.fireIntervalAdded(this, oldSize, newSize - 1);
            }
        }

        public synchronized Library[] getLibraries() {
            if (this.cache == null) {
                this.cache = this.createLibraries();
            }
            return this.cache;
        }

        private Library[] createLibraries() {
            Library[] libs = LibraryManager.getDefault().getLibraries();
            this.numberOfLibs = libs.length;
            ArrayList<Library> asList = new ArrayList<Library>();
            for (int i = 0; i < libs.length; ++i) {
                if (this.j2eePlatform.equals("1.3") && filter13.contains(libs[i])) continue;
                asList.add(libs[i]);
            }
            libs = asList.toArray(new Library[asList.size()]);
            Arrays.sort(libs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    assert (o1 instanceof Library && o2 instanceof Library);
                    String name1 = ((Library)o1).getDisplayName();
                    String name2 = ((Library)o2).getDisplayName();
                    return name1.compareToIgnoreCase(name2);
                }
            });
            return libs;
        }

        static {
            filter13.add(LibraryManager.getDefault().getLibrary("jstl11"));
            filter13.add(LibraryManager.getDefault().getLibrary("jaxrpc16"));
            filter13.add(LibraryManager.getDefault().getLibrary("toplink"));
            filter13.add(LibraryManager.getDefault().getLibrary("Spring"));
            filter13.add(LibraryManager.getDefault().getLibrary("jaxws20"));
            filter13.add(LibraryManager.getDefault().getLibrary("jaxb20"));
            filter13.add(LibraryManager.getDefault().getLibrary("struts"));
            filter13.add(LibraryManager.getDefault().getLibrary("jsf"));
        }
    }
}

