/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.SourceRoots;
import org.netbeans.modules.web.project.WebActionProvider;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.classpath.WebProjectClassPathExtender;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class WebProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private WebProject project;

    public WebProjectOperations(WebProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList files = new ArrayList();
        WebProjectOperations.addFile(projectDirectory, "nbproject", files);
        WebProjectOperations.addFile(projectDirectory, "build.xml", files);
        WebProjectOperations.addFile(projectDirectory, "catalog.xml", files);
        return files;
    }

    public List getDataFiles() {
        FileObject srcDir;
        FileObject projectDirectory;
        FileObject confDir;
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        FileObject docRoot = this.project.getAPIWebModule().getDocumentBase();
        if (docRoot != null) {
            files.add(docRoot);
        }
        if ((confDir = this.project.getWebModule().getConfDir()) != null) {
            files.add(confDir);
        }
        SourceRoots src = this.project.getSourceRoots();
        FileObject[] srcRoots = src.getRoots();
        for (int cntr = 0; cntr < srcRoots.length; ++cntr) {
            files.add(srcRoots[cntr]);
        }
        PropertyEvaluator evaluator = this.project.evaluator();
        String prop = evaluator.getProperty("source.root");
        if (prop != null && (projectDirectory = this.project.getProjectDirectory()) != (srcDir = this.project.getAntProjectHelper().resolveFileObject(prop)) && !files.contains(srcDir)) {
            files.add(srcDir);
        }
        SourceRoots test = this.project.getTestSourceRoots();
        FileObject[] testRoots = test.getRoots();
        for (int cntr = 0; cntr < testRoots.length; ++cntr) {
            files.add(testRoots[cntr]);
        }
        return files;
    }

    public void notifyDeleting() throws IOException {
        WebActionProvider ap = (WebActionProvider)this.project.getLookup().lookup(WebActionProvider.class);
        assert (ap != null);
        Lookup context = Lookups.fixed((Object[])new Object[0]);
        Properties p = new Properties();
        String[] targetNames = ap.getTargetNames("clean", context, p);
        FileObject buildXML = this.project.getProjectDirectory().getFileObject("build.xml");
        assert (targetNames != null);
        assert (targetNames.length > 0);
        ActionUtils.runTarget((FileObject)buildXML, (String[])targetNames, (Properties)p).waitFinished();
        WebProjectClassPathExtender extender = (WebProjectClassPathExtender)this.project.getLookup().lookup(WebProjectClassPathExtender.class);
        extender.notifyDeleting();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
    }

    public void notifyCopied(Project original, File originalPath, final String newName) {
        if (original == null) {
            return;
        }
        final String oldProjectName = this.project.getName();
        this.project.getReferenceHelper().fixReferences(originalPath);
        this.project.setName(newName);
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                ProjectWebModule wm;
                AntProjectHelper helper = WebProjectOperations.this.project.getAntProjectHelper();
                EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                String warName = (String)projectProps.get((Object)"war.name");
                String warEarName = (String)projectProps.get((Object)"war.ear.name");
                String oldName = warName.substring(0, warName.length() - 4);
                if (warName.endsWith(".war") && oldName.equals(oldProjectName)) {
                    projectProps.put((Object)"war.name", (Object)(PropertyUtils.getUsablePropertyName((String)newName) + ".war"));
                }
                if (warEarName.endsWith(".war") && oldName.equals(oldProjectName)) {
                    projectProps.put((Object)"war.ear.name", (Object)(PropertyUtils.getUsablePropertyName((String)newName) + ".war"));
                }
                if ((wm = (ProjectWebModule)WebProjectOperations.this.project.getLookup().lookup(ProjectWebModule.class)) != null) {
                    wm.setContextPath("/" + newName);
                }
                helper.putProperties("nbproject/project.properties", projectProps);
            }
        });
    }

    public void notifyMoving() throws IOException {
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalPath, final String newName) {
        if (original == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        final String oldProjectName = this.project.getName();
        this.project.setName(newName);
        this.project.getReferenceHelper().fixReferences(originalPath);
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                String serverId;
                ProjectWebModule wm;
                String oldCP;
                AntProjectHelper helper = WebProjectOperations.this.project.getAntProjectHelper();
                EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                EditableProperties privateProps = helper.getProperties("nbproject/private/private.properties");
                String warName = (String)projectProps.get((Object)"war.name");
                String warEarName = (String)projectProps.get((Object)"war.ear.name");
                String oldName = warName.substring(0, warName.length() - 4);
                if (warName.endsWith(".war") && oldName.equals(oldProjectName)) {
                    projectProps.put((Object)"war.name", (Object)(newName + ".war"));
                }
                if (warEarName.endsWith(".war") && oldName.equals(oldProjectName)) {
                    projectProps.put((Object)"war.ear.name", (Object)(newName + ".war"));
                }
                if ((oldCP = (wm = (ProjectWebModule)WebProjectOperations.this.project.getLookup().lookup(ProjectWebModule.class)).getContextPath(serverId = privateProps.getProperty("j2ee.server.instance"))) != null && oldName.equals(oldCP.substring(1))) {
                    wm.setContextPath(serverId, "/" + newName);
                }
                helper.putProperties("nbproject/project.properties", projectProps);
            }
        });
    }

    private static boolean isParent(File folder, File fo) {
        if (folder.equals(fo)) {
            return false;
        }
        while (fo != null) {
            if (fo.equals(folder)) {
                return true;
            }
            fo = fo.getParentFile();
        }
        return false;
    }
}

