/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.webservices.DDProvider;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.web.project.UpdateHelper;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class ProjectWebModule
extends J2eeModuleProvider
implements WebModuleImplementation,
J2eeModule,
ModuleChangeReporter,
EjbChangeDescriptor,
PropertyChangeListener {
    public static final String FOLDER_WEB_INF = "WEB-INF";
    public static final String FOLDER_CLASSES = "classes";
    public static final String FOLDER_LIB = "lib";
    public static final String FILE_DD = "web.xml";
    private WebProject project;
    private UpdateHelper helper;
    private Set versionListeners = null;
    private String fakeServerInstId = null;
    private long notificationTimeout = 0L;

    ProjectWebModule(WebProject project, UpdateHelper helper) {
        this.project = project;
        this.helper = helper;
        project.evaluator().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public FileObject getDeploymentDescriptor() {
        return this.getDeploymentDescriptor(false);
    }

    public FileObject getDeploymentDescriptor(boolean silent) {
        FileObject webInfFo = this.getWebInf(silent);
        if (webInfFo == null) {
            return null;
        }
        FileObject dd = webInfFo.getFileObject(FILE_DD);
        if (dd == null && !silent && ("1.3".equals(this.getJ2eePlatformVersion()) || "1.4".equals(this.getJ2eePlatformVersion()))) {
            this.showErrorMessage(NbBundle.getMessage(ProjectWebModule.class, (String)"MSG_WebXmlNotFound", (Object)webInfFo.getPath()));
        }
        return dd;
    }

    public String getContextPath() {
        if (this.getDeploymentDescriptor() == null) {
            return null;
        }
        return this.getConfigSupport().getWebContextRoot();
    }

    public void setContextPath(String path) {
        if (this.getDeploymentDescriptor() != null) {
            this.getConfigSupport().setWebContextRoot(path);
        }
    }

    public String getContextPath(String serverInstId) {
        this.fakeServerInstId = serverInstId;
        String result = this.getContextPath();
        this.fakeServerInstId = null;
        return result;
    }

    public void setContextPath(String serverInstId, String path) {
        this.fakeServerInstId = serverInstId;
        this.setContextPath(path);
        this.fakeServerInstId = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showErrorMessage(final String message) {
        ProjectWebModule projectWebModule = this;
        synchronized (projectWebModule) {
            if (new Date().getTime() <= this.notificationTimeout || !this.isProjectOpened()) {
                return;
            }
            this.notificationTimeout = new Date().getTime() + 20000L;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(this);
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                }
            }
        };
        r.run();
    }

    public FileObject getDocumentBase() {
        return this.getDocumentBase(false);
    }

    public FileObject getDocumentBase(boolean silent) {
        FileObject docBase = this.getFileObject("web.docbase.dir");
        if (docBase == null && !silent) {
            String relativePath = this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("web.docbase.dir");
            String path = relativePath != null ? this.helper.getAntProjectHelper().resolvePath(relativePath) : null;
            String errorMessage = path != null ? NbBundle.getMessage(ProjectWebModule.class, (String)"MSG_DocBase_Corrupted", (Object)this.project.getName(), (Object)path) : NbBundle.getMessage(ProjectWebModule.class, (String)"MSG_DocBase_Corrupted_Unknown", (Object)this.project.getName());
            this.showErrorMessage(errorMessage);
        }
        return docBase;
    }

    public FileObject[] getJavaSources() {
        return this.project.getSourceRoots().getRoots();
    }

    public FileObject getWebInf() {
        return this.getWebInf(false);
    }

    public File getEnterpriseResourceDirectory() {
        return this.getFile("resource.dir");
    }

    public FileObject getWebInf(boolean silent) {
        FileObject documentBase = this.getDocumentBase(silent);
        if (documentBase == null) {
            return null;
        }
        FileObject webInf = documentBase.getFileObject(FOLDER_WEB_INF);
        if (webInf == null && !silent) {
            this.showErrorMessage(NbBundle.getMessage(ProjectWebModule.class, (String)"MSG_WebInfCorrupted", (Object)documentBase.getPath()));
        }
        return webInf;
    }

    public FileObject getConfDir() {
        return this.getFileObject("conf.dir");
    }

    public File getConfDirAsFile() {
        return this.getFile("conf.dir");
    }

    public ClassPathProvider getClassPathProvider() {
        return (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
    }

    public FileObject getArchive() {
        return this.getFileObject("dist.war");
    }

    private FileObject getFileObject(String propname) {
        String prop = this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.getAntProjectHelper().resolveFileObject(prop);
        }
        return null;
    }

    private File getFile(String propname) {
        String prop = this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.getAntProjectHelper().resolveFile(prop);
        }
        return null;
    }

    public J2eeModule getJ2eeModule() {
        return this;
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        return this;
    }

    public FileObject findDeploymentConfigurationFile(String name) {
        if (name == null) {
            return null;
        }
        name = this.getConfigSupport().getContentRelativePath(name);
        if (name == null) {
            return null;
        }
        FileObject documentBase = this.getDocumentBase();
        if (documentBase == null) {
            return null;
        }
        return documentBase.getFileObject(name);
    }

    public File getDeploymentConfigurationFile(String name) {
        FileObject documentBase;
        assert (name != null) : "File name of the deployement configuration file can't be null";
        String path = this.getConfigSupport().getContentRelativePath(name);
        if (path == null) {
            path = name;
        }
        if ((documentBase = this.getDocumentBase()) == null) {
            return new File(this.getConfDirAsFile(), name);
        }
        return new File(FileUtil.toFile((FileObject)documentBase), path);
    }

    public FileObject getModuleFolder() {
        return this.getDocumentBase();
    }

    public boolean useDefaultServer() {
        return false;
    }

    public String getServerID() {
        String id;
        String inst = this.getServerInstanceID();
        if (inst != null && (id = Deployment.getDefault().getServerID(inst)) != null) {
            return id;
        }
        return this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.type");
    }

    public String getServerInstanceID() {
        if (this.fakeServerInstId != null) {
            return this.fakeServerInstId;
        }
        return this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
    }

    public void setServerInstanceID(String severInstanceID) {
        WebProjectProperties.setServerInstance(this.project, this.helper, severInstanceID);
    }

    public Iterator getArchiveContents() throws IOException {
        return new IT(this.getContentDirectory());
    }

    public FileObject getContentDirectory() {
        return this.getFileObject("build.web.dir");
    }

    public FileObject getBuildDirectory() {
        return this.getFileObject("build.dir");
    }

    public File getContentDirectoryAsFile() {
        return this.getFile("build.web.dir");
    }

    public BaseBean getDeploymentDescriptor(String location) {
        Webservices webServices;
        if ("WEB-INF/web.xml".equals(location)) {
            WebApp webApp = this.getWebApp();
            if (webApp != null) {
                return org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getBaseBean((CommonDDBean)webApp);
            }
        } else if ("WEB-INF/webservices.xml".equals(location) && (webServices = this.getWebservices()) != null) {
            return DDProvider.getDefault().getBaseBean((CommonDDBean)webServices);
        }
        return null;
    }

    public void uncacheDescriptors() {
        this.notificationTimeout = 0L;
    }

    private WebApp getWebApp() {
        try {
            FileObject deploymentDescriptor = this.getDeploymentDescriptor();
            if (deploymentDescriptor != null) {
                return org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getMergedDDRoot(deploymentDescriptor);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().log(e.getLocalizedMessage());
        }
        return null;
    }

    private Webservices getWebservices() {
        if (Util.isJavaEE5orHigher((Project)this.project)) {
            WebServicesSupport wss = WebServicesSupport.getWebServicesSupport((FileObject)this.project.getProjectDirectory());
            try {
                return DDProvider.getDefault().getMergedDDRoot((MetadataUnit)wss);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        } else {
            FileObject wsdd = this.getDD();
            if (wsdd != null) {
                try {
                    return DDProvider.getDefault().getDDRoot(this.getDD());
                }
                catch (IOException e) {
                    ErrorManager.getDefault().log(e.getLocalizedMessage());
                }
            }
        }
        return null;
    }

    public EjbChangeDescriptor getEjbChanges(long timestamp) {
        return this;
    }

    public Object getModuleType() {
        return J2eeModule.WAR;
    }

    public String getModuleVersion() {
        WebApp wapp = this.getWebApp();
        String version = "2.5";
        if (wapp != null) {
            version = wapp.getVersion();
        }
        return version;
    }

    private Set versionListeners() {
        if (this.versionListeners == null) {
            this.versionListeners = new HashSet();
            WebApp webApp = this.getWebApp();
            if (webApp != null) {
                PropertyChangeListener l = (PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)webApp);
                webApp.addPropertyChangeListener(l);
            }
        }
        return this.versionListeners;
    }

    public void addVersionListener(J2eeModule.VersionListener vl) {
        this.versionListeners().add(vl);
    }

    public void removeVersionListener(J2eeModule.VersionListener vl) {
        if (this.versionListeners != null) {
            this.versionListeners.remove(vl);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dd_version")) {
            for (J2eeModule.VersionListener vl : this.versionListeners) {
                String oldVersion = (String)evt.getOldValue();
                String newVersion = (String)evt.getNewValue();
                vl.versionChanged(oldVersion, newVersion);
            }
        } else if (evt.getPropertyName().equals("j2ee.server.instance")) {
            Deployment d = Deployment.getDefault();
            String oldServerID = evt.getOldValue() == null ? null : d.getServerID((String)evt.getOldValue());
            String newServerID = evt.getNewValue() == null ? null : d.getServerID((String)evt.getNewValue());
            this.fireServerChange(oldServerID, newServerID);
        } else if ("resource.dir".equals(evt.getPropertyName())) {
            String oldValue = (String)evt.getOldValue();
            String newValue = (String)evt.getNewValue();
            this.firePropertyChange("resourceDir", oldValue == null ? null : new File(oldValue), newValue == null ? null : new File(newValue));
        }
    }

    public String getUrl() {
        EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
        String warName = ep.getProperty("war.name");
        return warName == null ? "" : "/" + warName;
    }

    public boolean isManifestChanged(long timestamp) {
        return false;
    }

    public void setUrl(String url) {
        throw new UnsupportedOperationException("Cannot customize URL of web module");
    }

    public boolean ejbsChanged() {
        return false;
    }

    public String[] getChangedEjbs() {
        return new String[0];
    }

    public String getJ2eePlatformVersion() {
        return this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.platform");
    }

    public FileObject getDD() {
        FileObject webInfFo = this.getWebInf();
        if (webInfFo == null) {
            this.showErrorMessage(NbBundle.getMessage(ProjectWebModule.class, (String)"MSG_WebInfCorrupted"));
            return null;
        }
        return this.getWebInf().getFileObject("webservices", "xml");
    }

    public FileObject[] getSourceRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        LinkedList<FileObject> roots = new LinkedList<FileObject>();
        FileObject documentBase = this.getDocumentBase();
        if (documentBase != null) {
            roots.add(documentBase);
        }
        for (int i = 0; i < groups.length; ++i) {
            roots.add(groups[i].getRootFolder());
        }
        FileObject[] rootArray = new FileObject[roots.size()];
        return roots.toArray(rootArray);
    }

    private boolean isProjectOpened() {
        if (OpenProjects.getDefault() == null) {
            return true;
        }
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].equals(this.project)) continue;
            return true;
        }
        return false;
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        FileObject f;
        FileObject root;

        FSRootRE(FileObject root, FileObject f) {
            this.f = f;
            this.root = root;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static class IT
    implements Iterator {
        ArrayList ch = new ArrayList();
        FileObject root;

        private IT(FileObject f) {
            this.ch.add(f);
            this.root = f;
        }

        public boolean hasNext() {
            return !this.ch.isEmpty();
        }

        public Object next() {
            FileObject f = (FileObject)this.ch.get(0);
            this.ch.remove(0);
            if (f.isFolder()) {
                f.refresh();
                FileObject[] chArr = f.getChildren();
                for (int i = 0; i < chArr.length; ++i) {
                    this.ch.add(chArr[i]);
                }
            }
            return new FSRootRE(this.root, f);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

