/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.core.Utilities;
import org.netbeans.modules.websvc.core.wseditor.spi.SaveSetter;
import org.netbeans.modules.websvc.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.customization.model.JavaClass;
import org.netbeans.modules.websvc.customization.model.PortTypeOperationFaultCustomization;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.WeakListeners;

public class PortTypeOperationFaultPanel
extends SaveableSectionInnerPanel {
    private Fault fault;
    private SaveSetter setter;
    private WSDLModel model;
    private boolean wsdlDirty;
    private DefaultItemListener defaultListener;
    private JCheckBox defaultJavaClassCB;
    private JLabel javaClassLabel;
    private JTextField javaClassText;
    private JLabel operationLabel;
    private JLabel operationName;

    public PortTypeOperationFaultPanel(SectionView view, Fault fault) {
        super(view);
        this.fault = fault;
        this.model = this.fault.getModel();
        this.initComponents();
        this.operationLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.operationName.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.operationName.setText(this.getParentOfFault(fault));
        this.javaClassLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.javaClassText.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.defaultJavaClassCB.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.sync();
        this.addModifier(this.javaClassText);
        this.addModifier(this.defaultJavaClassCB);
        this.addValidatee(this.javaClassText);
        this.defaultListener = new DefaultItemListener();
        ItemListener il = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.defaultListener, (Object)this.defaultJavaClassCB);
        this.defaultJavaClassCB.addItemListener(il);
    }

    private String getParentOfFault(Fault fault) {
        Operation op = (Operation)fault.getParent();
        return op.getName();
    }

    private void sync() {
        List ee = this.fault.getExtensibilityElements(PortTypeOperationFaultCustomization.class);
        if (ee.size() == 1) {
            PortTypeOperationFaultCustomization ptof = (PortTypeOperationFaultCustomization)ee.get(0);
            JavaClass jc = ptof.getJavaClass();
            if (jc != null) {
                this.setJavaClass(jc.getName());
            } else {
                this.defaultJavaClassCB.setSelected(true);
                this.javaClassText.setEnabled(false);
                this.javaClassText.setBackground(Color.LIGHT_GRAY);
            }
        } else {
            this.defaultJavaClassCB.setSelected(true);
            this.javaClassText.setEnabled(false);
            this.javaClassText.setBackground(Color.LIGHT_GRAY);
        }
    }

    public void setJavaClass(String name) {
        this.javaClassText.setText(name);
    }

    public String getJavaClass() {
        return this.javaClassText.getText();
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List ee = this.fault.getExtensibilityElements(PortTypeOperationFaultCustomization.class);
        CustomizationComponentFactory factory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.javaClassText || jComponent == this.defaultJavaClassCB) {
            String text = this.javaClassText.getText();
            if (text != null && !text.trim().equals("") && !this.defaultJavaClassCB.isSelected()) {
                if (!Utilities.isJavaIdentifier((String)text)) {
                    return;
                }
                if (ee.size() == 1) {
                    PortTypeOperationFaultCustomization ptofc = (PortTypeOperationFaultCustomization)ee.get(0);
                    JavaClass jc = ptofc.getJavaClass();
                    if (jc == null) {
                        try {
                            jc = factory.createJavaClass(this.model);
                            this.model.startTransaction();
                            jc.setName(text);
                            ptofc.setJavaClass(jc);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    } else {
                        try {
                            this.model.startTransaction();
                            jc.setName(text);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                } else {
                    PortTypeOperationFaultCustomization ptofc = factory.createPortTypeOperationFaultCustomization(this.model);
                    JavaClass jc = factory.createJavaClass(this.model);
                    try {
                        this.model.startTransaction();
                        jc.setName(text);
                        ptofc.setJavaClass(jc);
                        this.fault.addExtensibilityElement((ExtensibilityElement)ptofc);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else if (ee.size() == 1) {
                try {
                    PortTypeOperationFaultCustomization ptofc = (PortTypeOperationFaultCustomization)ee.get(0);
                    JavaClass jc = ptofc.getJavaClass();
                    if (jc != null) {
                        this.model.startTransaction();
                        ptofc.removeJavaClass(jc);
                        if (ptofc.getChildren().size() == 0) {
                            this.fault.removeExtensibilityElement((ExtensibilityElement)ptofc);
                        }
                        this.wsdlDirty = true;
                    }
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public void documentChanged(JTextComponent comp, String val) {
        if (comp == this.javaClassText && !Utilities.isJavaIdentifier((String)val)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, val, (JComponent)comp));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.javaClassText) {
            PortTypeOperationFaultCustomization ptc;
            JavaClass jc;
            String className = "";
            List ee = this.fault.getExtensibilityElements(PortTypeOperationFaultCustomization.class);
            if (ee.size() == 1 && (jc = (ptc = (PortTypeOperationFaultCustomization)ee.get(0)).getJavaClass()) != null) {
                className = jc.getName();
            }
            this.javaClassText.setText(className);
        }
    }

    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.javaClassLabel = new JLabel();
        this.javaClassText = new JTextField();
        this.defaultJavaClassCB = new JCheckBox();
        this.operationLabel = new JLabel();
        this.operationName = new JLabel();
        this.javaClassLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_JAVA_CLASS"));
        this.javaClassLabel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_JAVA_CLASS"));
        this.javaClassText.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("TOOLTIP_PORTTYPE_FAULT_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_JAVA_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_JAVA_CLASS"));
        this.defaultJavaClassCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultJavaClassCB.setText("Use Default");
        this.defaultJavaClassCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultJavaClassCB.setMargin(new Insets(0, 0, 0, 0));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_DEFAULT"));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_DEFAULT"));
        this.operationLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENCLOSING_OPERATION"));
        this.operationLabel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENCLOSING_OPERATION"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.javaClassLabel).add(15, 15, 15).add((Component)this.javaClassText, -2, 227, -2).add(20, 20, 20).add((Component)this.defaultJavaClassCB)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.operationLabel).add(15, 15, 15).add((Component)this.operationName, -2, 165, -2))).addContainerGap(76, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.operationLabel).add((Component)this.operationName)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.javaClassLabel).add((Component)this.javaClassText, -2, 16, -2).add((Component)this.defaultJavaClassCB)).addContainerGap(19, Short.MAX_VALUE)));
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (PortTypeOperationFaultPanel.this.defaultJavaClassCB.isSelected()) {
                PortTypeOperationFaultPanel.this.javaClassText.setEnabled(false);
                PortTypeOperationFaultPanel.this.javaClassText.setBackground(Color.LIGHT_GRAY);
            } else {
                PortTypeOperationFaultPanel.this.javaClassText.setEnabled(true);
                PortTypeOperationFaultPanel.this.javaClassText.setBackground(Color.WHITE);
                PortTypeOperationFaultPanel.this.javaClassText.requestFocus();
            }
        }
    }
}

