/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.awt.Image;
import java.util.ResourceBundle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.nodes.AntProjectChildren;
import org.apache.tools.ant.module.nodes.AntProperty;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;

public final class AntProjectNode
extends DataNode
implements ChangeListener {
    public AntProjectNode(DataObject obj) {
        this(obj, (AntProjectCookie)obj.getCookie(AntProjectCookie.class));
    }

    private AntProjectNode(DataObject obj, AntProjectCookie cookie) {
        super(obj, (Children)new AntProjectChildren(cookie));
        cookie.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)cookie));
    }

    public Image getIcon(int type) {
        Image i = this.getBasicIcon();
        try {
            i = this.getDataObject().getPrimaryFile().getFileSystem().getStatus().annotateIcon(i, type, this.getDataObject().files());
        }
        catch (FileStateInvalidException fsie) {
            AntModule.err.notify(1, (Throwable)fsie);
        }
        return i;
    }

    private Image getBasicIcon() {
        AntProjectCookie.ParseStatus cookie = (AntProjectCookie.ParseStatus)this.getCookie(AntProjectCookie.ParseStatus.class);
        if (cookie.getFile() == null && cookie.getFileObject() == null) {
            return Utilities.loadImage((String)"org/apache/tools/ant/module/resources/AntIconError.gif");
        }
        if (!cookie.isParsed()) {
            return Utilities.loadImage((String)"org/apache/tools/ant/module/resources/AntIcon.gif");
        }
        Throwable exc = cookie.getParseException();
        if (exc != null) {
            return Utilities.loadImage((String)"org/apache/tools/ant/module/resources/AntIconError.gif");
        }
        return Utilities.loadImage((String)"org/apache/tools/ant/module/resources/AntIcon.gif");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getShortDescription() {
        AntProjectCookie cookie = (AntProjectCookie)this.getCookie(AntProjectCookie.class);
        if (cookie.getFile() == null && cookie.getFileObject() == null) {
            return super.getShortDescription();
        }
        Throwable exc = cookie.getParseException();
        if (exc != null) {
            String m = exc.getLocalizedMessage();
            if (m != null) {
                return m;
            }
            return exc.toString();
        }
        Element pel = cookie.getProjectElement();
        if (pel != null) {
            String projectName = pel.getAttribute("name");
            if (!projectName.equals("")) {
                return NbBundle.getMessage((Class)AntProjectNode.class, (String)"LBL_named_script_description", (Object)projectName);
            }
            return NbBundle.getMessage((Class)AntProjectNode.class, (String)"LBL_anon_script_description");
        }
        return super.getShortDescription();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set props = new Sheet.Set();
        props.setName("project");
        props.setDisplayName(NbBundle.getMessage((Class)AntProjectNode.class, (String)"LBL_proj_sheet"));
        props.setShortDescription(NbBundle.getMessage((Class)AntProjectNode.class, (String)"HINT_proj_sheet"));
        this.add2Sheet(props);
        sheet.put(props);
        return sheet;
    }

    private void add2Sheet(Sheet.Set props) {
        ResourceBundle bundle = NbBundle.getBundle((Class)AntProjectNode.class);
        AntProjectCookie proj = (AntProjectCookie)this.getCookie(AntProjectCookie.class);
        AntProperty prop = new ProjectNameProperty("name", proj);
        prop.setName("projectName");
        prop.setDisplayName(bundle.getString("PROP_projectName"));
        prop.setShortDescription(bundle.getString("HINT_projectName"));
        props.put((Node.Property)prop);
        prop = new ProjectTargetProperty("default", proj);
        prop.setDisplayName(bundle.getString("PROP_default"));
        prop.setShortDescription(bundle.getString("HINT_default"));
        props.put((Node.Property)prop);
    }

    public void stateChanged(ChangeEvent ev) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                AntProjectNode.this.fireIconChange();
                AntProjectNode.this.fireOpenedIconChange();
                AntProjectNode.this.fireShortDescriptionChange(null, null);
                AntProjectNode.this.fireCookieChange();
                AntProjectNode.this.firePropertyChange(null, null, null);
            }
        });
    }

    private class ProjectTargetProperty
    extends AntProperty {
        public ProjectTargetProperty(String name, AntProjectCookie proj) {
            super(name, proj);
        }

        protected Element getElement() {
            return ((AntProjectCookie)AntProjectNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = AntProjectNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie)).getProjectElement();
        }
    }

    private class ProjectNameProperty
    extends AntProperty {
        public ProjectNameProperty(String name, AntProjectCookie proj) {
            super(name, proj);
        }

        protected Element getElement() {
            return ((AntProjectCookie)AntProjectNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = AntProjectNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie)).getProjectElement();
        }
    }
}

