/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.loader;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.w3c.dom.Element;

public class AntActionInstance
implements InstanceCookie,
Action,
Presenter.Menu,
Presenter.Toolbar,
ChangeListener {
    private final AntProjectCookie proj;
    private transient PropertyChangeSupport changeSupport;

    public AntActionInstance(AntProjectCookie proj) {
        this.proj = proj;
        proj.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)proj));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.changeSupport = null;
    }

    public Class instanceClass() {
        return AntActionInstance.class;
    }

    public String instanceName() {
        FileObject fo = this.proj.getFileObject();
        if (fo != null) {
            return fo.getName();
        }
        return "";
    }

    public Object instanceCreate() {
        return this;
    }

    public void actionPerformed(ActionEvent ignore) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TargetExecutor exec = new TargetExecutor(AntActionInstance.this.proj, null);
                try {
                    exec.execute();
                }
                catch (IOException ioe) {
                    AntModule.err.notify((Throwable)ioe);
                }
            }
        });
    }

    public boolean isEnabled() {
        return this.proj.getParseException() == null && this.proj.getFile() != null;
    }

    public void setEnabled(boolean b) {
    }

    public Object getValue(String key) {
        if ("Name".equals(key)) {
            Element el = this.proj.getProjectElement();
            if (el != null) {
                String pname = el.getAttribute("name");
                return Actions.cutAmpersand((String)pname);
            }
        } else {
            if ("SmallIcon".equals(key)) {
                try {
                    return new ImageIcon(new URL("nbresloc:/org/apache/tools/ant/module/resources/AntIcon.gif"));
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if ("MnemonicKey".equals(key)) {
                String pname;
                int idx;
                Element el = this.proj.getProjectElement();
                if (el != null && (idx = Mnemonics.findMnemonicAmpersand((String)(pname = el.getAttribute("name")))) != -1) {
                    return new Integer(pname.charAt(idx + 1));
                }
                return new Integer(0);
            }
        }
        return null;
    }

    public void putValue(String key, Object value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        AntActionInstance antActionInstance = this;
        synchronized (antActionInstance) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public JMenuItem getMenuPresenter() {
        return new JMenuItem(this);
    }

    public Component getToolbarPresenter() {
        return new JButton(this);
    }

    public void stateChanged(ChangeEvent ignore) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange("Name", null, this.getValue("Name"));
        this.changeSupport.firePropertyChange("enabled", null, this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
        this.changeSupport.firePropertyChange("MnemonicKey", null, this.getValue("MnemonicKey"));
    }
}

