/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.strings;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.netbeans.modules.java.navigation.spi.strings.WeightedStringPainter;
import org.netbeans.modules.java.navigation.strings.Entry;
import org.netbeans.modules.java.navigation.strings.WeightedStringImpl;

final class WeightedStringPainterImpl
implements WeightedStringPainter {
    private int currSeg = 0;
    private boolean willAbbreviate = false;
    private ArrayList abbrevInfos = new ArrayList(20);

    WeightedStringPainterImpl() {
    }

    public void paint(Graphics g, int x, int y, WeightedString ws, int maxChars, boolean useColors) {
        this.doPaint(g, x, y, (WeightedStringImpl)ws, maxChars, useColors);
    }

    private void doPaint(Graphics g, int x, int y, WeightedStringImpl ws, int maxChars, boolean useColors) {
        this.willAbbreviate = this.configureFrom(ws, maxChars);
        Font defFont = g.getFont();
        Color defFg = g.getColor();
        if ((ws.allMarkupTypes() & 2) != 0) {
            maxChars = Math.max(2, maxChars - maxChars / 3);
        }
        Map rhints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        Graphics2D g2 = (Graphics2D)g;
        if (rhints == null && Boolean.getBoolean("swing.aatext")) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (rhints != null) {
            g2.addRenderingHints(rhints);
        }
        char[] seg = this.first(ws);
        int types = 0;
        while (seg != null) {
            types = ws.getMarkupFor(this.index());
            this.setupGraphics(g, types, defFont, defFg, useColors);
            FontMetrics fm = g.getFontMetrics();
            g.drawChars(seg, 0, seg.length, x, y);
            int dist = g.getFontMetrics().charsWidth(seg, 0, seg.length);
            if ((types & 0x100) != 0) {
                g.drawLine(x, y + 1, x + dist, y + 1);
            }
            if ((types & 1) != 0) {
                int ly = y - (fm.getAscent() - 2) / 2;
                g.setColor(defFg);
                g.drawLine(x, ly, x + dist, ly);
            }
            x += dist;
            seg = this.next(ws);
        }
    }

    private void setupGraphics(Graphics g, int type, Font defFont, Color defFg, boolean useColors) {
        if (type == 0) {
            g.setColor(defFg);
            g.setFont(defFont);
        }
        Font f = g.getFont();
        if ((type & 2) != 0) {
            if ((type & 0x80) != 0) {
                if (f.getStyle() != 3) {
                    g.setFont(g.getFont().deriveFont(3));
                }
            } else if (f.getStyle() != 1) {
                g.setFont(g.getFont().deriveFont(1));
            }
        } else if ((type & 0x80) != 0) {
            if (f.getStyle() != 2) {
                g.setFont(g.getFont().deriveFont(2));
            }
        } else if (g.getFont().getStyle() != 0) {
            g.setFont(g.getFont().deriveFont(0));
        }
        if (useColors) {
            if ((type & 4) != 0) {
                g.setColor(Color.GRAY);
            } else if ((type & 8) != 0) {
                g.setColor(Color.LIGHT_GRAY);
            } else if ((type & 0x200) != 0) {
                g.setColor(Color.RED);
            } else if ((type & 0x10) != 0) {
                g.setColor(Color.BLUE);
            } else if ((type & 0x20) != 0) {
                g.setColor(new Color(0, 150, 0));
            } else if ((type & 0x40) != 0) {
                g.setColor(new Color(150, 0, 150));
            } else {
                g.setColor(defFg);
            }
        }
    }

    private boolean configureFrom(WeightedStringImpl ws, int maxChars) {
        return this.config(ws, maxChars) != null;
    }

    Entry[] config(WeightedStringImpl ws, int maxChars) {
        this.currSeg = 0;
        if (maxChars >= ws.length) {
            return null;
        }
        this.ensureCapacity(ws);
        return this.weightAndElide(ws, maxChars);
    }

    private void ensureCapacity(WeightedStringImpl ws) {
    }

    private char[] first(WeightedStringImpl ws) {
        this.currSeg = 0;
        while (this.currSeg <= ws.getCount() && this.willAbbreviate && ((AbbrevInfo)this.abbrevInfos.get((int)this.currSeg)).isSkip) {
            ++this.currSeg;
        }
        return this.current(ws);
    }

    private char[] current(WeightedStringImpl ws) {
        char[] result;
        if (this.currSeg > ws.getCount()) {
            this.currSeg = ws.getCount() + 1;
            result = null;
        } else {
            result = this.willAbbreviate ? this.seg(ws) : ws.getCharsSegment(this.currSeg);
        }
        return result;
    }

    private char[] next(WeightedStringImpl ws) {
        ++this.currSeg;
        while (this.currSeg <= ws.getCount() && this.willAbbreviate && ((AbbrevInfo)this.abbrevInfos.get((int)this.currSeg)).isSkip) {
            ++this.currSeg;
        }
        return this.current(ws);
    }

    private int index() {
        return this.currSeg;
    }

    private char[] seg(WeightedStringImpl ws) {
        char[] abbrevSeg = ((AbbrevInfo)this.abbrevInfos.get((int)this.currSeg)).abbrev;
        char[] result = abbrevSeg != null ? abbrevSeg : ws.getCharsSegment(this.currSeg);
        return result;
    }

    private Entry[] weightAndElide(WeightedStringImpl ws, int maxChars) {
        AbbrevInfo curAbbrev;
        int i;
        Object[] entries = new Entry[ws.getCount() + 1];
        this.abbrevInfos.clear();
        int[] lengths = new int[11];
        int[] lengthsExcludingImportant = new int[11];
        for (int i2 = 0; i2 < entries.length; ++i2) {
            char[] c = ws.getCharsSegment(i2);
            float importance = ws.getImportance(i2);
            entries[i2] = new Entry(c, importance, i2);
            this.abbrevInfos.add(new AbbrevInfo());
            int[] l = ((Entry)entries[i2]).getLengths();
            for (int j = 0; j <= 10; ++j) {
                int n = j;
                lengths[n] = lengths[n] + l[j];
                int n2 = j;
                lengthsExcludingImportant[n2] = lengthsExcludingImportant[n2] + (importance == 1.0f ? ((Entry)entries[i2]).fullLength() : l[j]);
            }
        }
        Arrays.sort(entries);
        boolean exImp = true;
        int tg = 0;
        for (tg = 0; tg <= 10 && lengthsExcludingImportant[tg] > maxChars; ++tg) {
        }
        if (tg > 10) {
            exImp = false;
            for (tg = 0; tg <= 10 && lengths[tg] > maxChars; ++tg) {
            }
        }
        if (tg >= 10) {
            tg = 9;
        }
        float weight = (float)(tg + 1) / 10.0f;
        Object mostImp = null;
        int len = 0;
        for (i = 0; i < entries.length; ++i) {
            if (!exImp || ((Entry)entries[i]).getImportance() < 1.0f) {
                ((Entry)entries[i]).setTargetWeight(weight);
                curAbbrev = (AbbrevInfo)this.abbrevInfos.get(((Entry)entries[i]).getIndex());
                curAbbrev.abbrev = ((Entry)entries[i]).elide(-1);
                len += curAbbrev.abbrev.length;
                continue;
            }
            mostImp = entries[i];
            len += ((Entry)entries[i]).length();
        }
        Arrays.sort(entries, new IndexComparator());
        if (len > maxChars) {
            for (i = entries.length - 1; i >= 0 && !(((Entry)entries[i]).getImportance() >= 1.0f); --i) {
                ((AbbrevInfo)this.abbrevInfos.get((int)i)).isSkip = true;
                ((Entry)entries[i]).setSkip(true);
                len -= ((Entry)entries[i]).getLengthAtTarget();
            }
        }
        if (mostImp != null && len > maxChars) {
            ((Entry)mostImp).setTargetWeight(0.56f);
            curAbbrev = (AbbrevInfo)this.abbrevInfos.get(((Entry)mostImp).getIndex());
            curAbbrev.abbrev = ((Entry)mostImp).elide(-1);
        }
        return entries;
    }

    private static final class IndexComparator
    implements Comparator {
        private IndexComparator() {
        }

        public int compare(Object a, Object b) {
            Entry ea = (Entry)a;
            Entry eb = (Entry)b;
            return ea.index - eb.index;
        }
    }

    private static class AbbrevInfo {
        boolean isSkip = false;
        char[] abbrev = null;

        private AbbrevInfo() {
        }
    }
}

