/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;

class FieldVariable
extends AbstractVariable
implements org.netbeans.api.debugger.jpda.Field {
    protected Field field;
    private ObjectReference objectReference;

    FieldVariable(JPDADebuggerImpl debugger, Value value, Field field, String parentID, ObjectReference objectReference) {
        super(debugger, value, parentID + '.' + field.name() + (value instanceof ObjectReference ? "^" : ""));
        this.field = field;
        this.objectReference = objectReference;
    }

    FieldVariable(JPDADebuggerImpl debugger, Value value, Field field, String parentID, String genericSignature) {
        super(debugger, value, genericSignature, parentID + '.' + field.name() + (value instanceof ObjectReference ? "^" : ""));
        this.field = field;
    }

    public String getName() {
        return this.field.name();
    }

    public String getClassName() {
        return this.field.declaringType().name();
    }

    public String getDeclaredType() {
        return this.field.typeName();
    }

    public boolean isStatic() {
        return this.field.isStatic();
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        try {
            this.objectReference.setValue(this.field, value);
        }
        catch (InvalidTypeException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (ClassNotLoadedException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
    }

    public String toString() {
        return "FieldVariable " + this.field.name();
    }
}

