/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import org.netbeans.modules.debugger.jpda.expr.JavaParserConstants;
import org.netbeans.modules.debugger.jpda.expr.Token;

class Operators
implements JavaParserConstants {
    private VirtualMachine vm;

    public Operators(VirtualMachine vm) {
        this.vm = vm;
    }

    public PrimitiveValue evaluate(Token operator, PrimitiveValue value) {
        switch (operator.kind) {
            case 95: {
                if (!(value instanceof BooleanValue)) break;
                return this.vm.mirrorOf(!value.booleanValue());
            }
            case 96: {
                if (value instanceof BooleanValue || value instanceof DoubleValue || value instanceof FloatValue) break;
                if (value instanceof LongValue) {
                    return this.vm.mirrorOf(value.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                }
                return this.vm.mirrorOf(~value.intValue());
            }
            case 107: {
                if (value instanceof BooleanValue) break;
                return value;
            }
            case 108: {
                if (value instanceof BooleanValue) break;
                if (value instanceof DoubleValue) {
                    return this.vm.mirrorOf(-value.doubleValue());
                }
                if (value instanceof FloatValue) {
                    return this.vm.mirrorOf(-value.floatValue());
                }
                if (value instanceof LongValue) {
                    return this.vm.mirrorOf(-value.longValue());
                }
                return this.vm.mirrorOf(-value.intValue());
            }
            case 105: 
            case 106: {
                int val;
                int n = val = operator.kind == 105 ? 1 : -1;
                if (value instanceof BooleanValue) break;
                if (value instanceof DoubleValue) {
                    return this.vm.mirrorOf(value.doubleValue() + (double)val);
                }
                if (value instanceof FloatValue) {
                    return this.vm.mirrorOf(value.floatValue() + (float)val);
                }
                if (value instanceof LongValue) {
                    return this.vm.mirrorOf(value.longValue() + (long)val);
                }
                return this.vm.mirrorOf(value.intValue() + val);
            }
        }
        throw new IllegalArgumentException("badUnarySemantics");
    }

    public Value evaluate(Value left, Token operator, Value right) {
        boolean isRightNumeric;
        if (left instanceof BooleanValue && right instanceof BooleanValue) {
            boolean op1 = ((BooleanValue)left).booleanValue();
            boolean op2 = ((BooleanValue)right).booleanValue();
            boolean res = false;
            switch (operator.kind) {
                case 99: {
                    res = op1 == op2;
                    break;
                }
                case 102: {
                    res = op1 != op2;
                    break;
                }
                case 112: {
                    res = op1 | op2;
                    break;
                }
                case 111: {
                    res = op1 & op2;
                    break;
                }
                case 113: {
                    res = op1 ^ op2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("badBinarySemantics");
                }
            }
            return this.vm.mirrorOf(res);
        }
        boolean isLeftNumeric = left instanceof PrimitiveValue && !(left instanceof BooleanValue);
        boolean bl = isRightNumeric = right instanceof PrimitiveValue && !(right instanceof BooleanValue);
        if (isLeftNumeric && isRightNumeric) {
            switch (operator.kind) {
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 114: {
                    return this.evaluateAddOperator((PrimitiveValue)left, (PrimitiveValue)right, operator.kind);
                }
                case 115: 
                case 116: 
                case 117: {
                    return this.evaluateShiftOperator((PrimitiveValue)left, (PrimitiveValue)right, operator.kind);
                }
                case 111: 
                case 112: 
                case 113: {
                    return this.evaluateBitOperator((PrimitiveValue)left, (PrimitiveValue)right, operator.kind);
                }
                case 93: 
                case 94: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    return this.evaluateComparisonOperator((PrimitiveValue)left, (PrimitiveValue)right, operator.kind);
                }
            }
        }
        if (operator.kind == 99 || operator.kind == 102) {
            if (left == null) {
                if (right == null) {
                    return this.vm.mirrorOf(operator.kind == 99);
                }
                if (right instanceof ObjectReference) {
                    return this.vm.mirrorOf(operator.kind == 102);
                }
            }
            if (left instanceof ObjectReference) {
                if (right == null) {
                    return this.vm.mirrorOf(operator.kind == 102);
                }
                if (right instanceof ObjectReference) {
                    if (operator.kind == 99) {
                        return this.vm.mirrorOf(right.equals(left));
                    }
                    return this.vm.mirrorOf(!right.equals(left));
                }
            }
        }
        if ((left == null || left instanceof StringReference || right == null || right instanceof StringReference) && operator.kind == 107) {
            String s1 = null;
            String s2 = null;
            s1 = left instanceof StringReference ? ((StringReference)left).value() : (left == null ? "null" : left.toString());
            s2 = right instanceof StringReference ? ((StringReference)right).value() : (right == null ? "null" : right.toString());
            return this.vm.mirrorOf(s1 + s2);
        }
        throw new IllegalArgumentException("Bad semantics for binary operator");
    }

    private PrimitiveValue evaluateAddOperator(PrimitiveValue op1, PrimitiveValue op2, int id) {
        if (op1 instanceof DoubleValue || op2 instanceof DoubleValue) {
            double d1 = op1.doubleValue();
            double d2 = op2.doubleValue();
            double res = 0.0;
            switch (id) {
                case 107: {
                    res = d1 + d2;
                    break;
                }
                case 108: {
                    res = d1 - d2;
                    break;
                }
                case 114: {
                    res = d1 % d2;
                    break;
                }
                case 109: {
                    res = d1 * d2;
                    break;
                }
                case 110: {
                    res = d1 / d2;
                }
            }
            return this.vm.mirrorOf(res);
        }
        if (op1 instanceof FloatValue || op2 instanceof FloatValue) {
            float f1 = op1.floatValue();
            float f2 = op2.floatValue();
            float res_f = 0.0f;
            switch (id) {
                case 107: {
                    res_f = f1 + f2;
                    break;
                }
                case 108: {
                    res_f = f1 - f2;
                    break;
                }
                case 114: {
                    res_f = f1 % f2;
                    break;
                }
                case 109: {
                    res_f = f1 * f2;
                    break;
                }
                case 110: {
                    res_f = f1 / f2;
                }
            }
            return this.vm.mirrorOf(res_f);
        }
        if (op1 instanceof LongValue || op2 instanceof LongValue) {
            long long1 = op1.longValue();
            long long2 = op2.longValue();
            long res_long = 0L;
            switch (id) {
                case 107: {
                    res_long = long1 + long2;
                    break;
                }
                case 108: {
                    res_long = long1 - long2;
                    break;
                }
                case 114: {
                    res_long = long1 % long2;
                    break;
                }
                case 109: {
                    res_long = long1 * long2;
                    break;
                }
                case 110: {
                    res_long = long1 / long2;
                }
            }
            return this.vm.mirrorOf(res_long);
        }
        int i1 = op1.intValue();
        int i2 = op2.intValue();
        int res_i = 0;
        switch (id) {
            case 107: {
                res_i = i1 + i2;
                break;
            }
            case 108: {
                res_i = i1 - i2;
                break;
            }
            case 114: {
                res_i = i1 % i2;
                break;
            }
            case 109: {
                res_i = i1 * i2;
                break;
            }
            case 110: {
                res_i = i1 / i2;
            }
        }
        return this.vm.mirrorOf(res_i);
    }

    private PrimitiveValue evaluateShiftOperator(PrimitiveValue op1, PrimitiveValue op2, int id) {
        if (op1 instanceof FloatValue || op1 instanceof DoubleValue || op2 instanceof FloatValue || op2 instanceof DoubleValue) {
            throw new IllegalArgumentException("Bad semantics for shift operator");
        }
        if (op1 instanceof LongValue) {
            long n1 = op1.longValue();
            long n2 = op2.longValue();
            long res = 0L;
            switch (id) {
                case 115: {
                    res = n1 << (int)n2;
                    break;
                }
                case 116: {
                    res = n1 >> (int)n2;
                    break;
                }
                case 117: {
                    res = n1 >>> (int)n2;
                }
            }
            return this.vm.mirrorOf(res);
        }
        int i1 = op1.intValue();
        long i2 = op2.longValue();
        int res_i = 0;
        switch (id) {
            case 115: {
                res_i = i1 << (int)i2;
                break;
            }
            case 116: {
                res_i = i1 >> (int)i2;
                break;
            }
            case 117: {
                res_i = i1 >>> (int)i2;
            }
        }
        return this.vm.mirrorOf(res_i);
    }

    private PrimitiveValue evaluateBitOperator(PrimitiveValue op1, PrimitiveValue op2, int id) {
        if (op1 instanceof FloatValue || op1 instanceof DoubleValue || op2 instanceof FloatValue || op2 instanceof DoubleValue) {
            throw new IllegalArgumentException("Bad semantics for bit operator");
        }
        if (op1 instanceof LongValue || op2 instanceof LongValue) {
            long n1 = op1.longValue();
            long n2 = op2.longValue();
            long res = 0L;
            switch (id) {
                case 111: {
                    res = n1 & n2;
                    break;
                }
                case 112: {
                    res = n1 | n2;
                    break;
                }
                case 113: {
                    res = n1 ^ n2;
                }
            }
            return this.vm.mirrorOf(res);
        }
        int i1 = op1.intValue();
        int i2 = op2.intValue();
        int res_i = 0;
        switch (id) {
            case 111: {
                res_i = i1 & i2;
                break;
            }
            case 112: {
                res_i = i1 | i2;
                break;
            }
            case 113: {
                res_i = i1 ^ i2;
            }
        }
        return this.vm.mirrorOf(res_i);
    }

    private BooleanValue evaluateComparisonOperator(PrimitiveValue op1, PrimitiveValue op2, int id) {
        boolean res = false;
        if (op1 instanceof DoubleValue || op2 instanceof DoubleValue) {
            double d1 = op1.doubleValue();
            double d2 = op2.doubleValue();
            switch (id) {
                case 94: {
                    res = d1 < d2;
                    break;
                }
                case 93: {
                    res = d1 > d2;
                    break;
                }
                case 100: {
                    res = d1 <= d2;
                    break;
                }
                case 101: {
                    res = d1 >= d2;
                    break;
                }
                case 99: {
                    res = d1 == d2;
                    break;
                }
                case 102: {
                    res = d1 != d2;
                }
            }
        } else if (op1 instanceof FloatValue || op2 instanceof FloatValue) {
            float f1 = op1.floatValue();
            float f2 = op2.floatValue();
            switch (id) {
                case 94: {
                    res = f1 < f2;
                    break;
                }
                case 93: {
                    res = f1 > f2;
                    break;
                }
                case 100: {
                    res = f1 <= f2;
                    break;
                }
                case 101: {
                    res = f1 >= f2;
                    break;
                }
                case 99: {
                    res = f1 == f2;
                    break;
                }
                case 102: {
                    res = f1 != f2;
                }
            }
        } else if (op1 instanceof LongValue || op1 instanceof LongValue) {
            long n1 = op1.longValue();
            long n2 = op2.longValue();
            switch (id) {
                case 94: {
                    res = n1 < n2;
                    break;
                }
                case 93: {
                    res = n1 > n2;
                    break;
                }
                case 100: {
                    res = n1 <= n2;
                    break;
                }
                case 101: {
                    res = n1 >= n2;
                    break;
                }
                case 99: {
                    res = n1 == n2;
                    break;
                }
                case 102: {
                    res = n1 != n2;
                }
            }
        } else {
            float i1 = op1.intValue();
            float i2 = op2.intValue();
            switch (id) {
                case 94: {
                    res = i1 < i2;
                    break;
                }
                case 93: {
                    res = i1 > i2;
                    break;
                }
                case 100: {
                    res = i1 <= i2;
                    break;
                }
                case 101: {
                    res = i1 >= i2;
                    break;
                }
                case 99: {
                    res = i1 == i2;
                    break;
                }
                case 102: {
                    res = i1 != i2;
                }
            }
        }
        return this.vm.mirrorOf(res);
    }
}

