/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class LineBreakpointImpl
extends ClassBasedBreakpoint {
    private static boolean verbose = System.getProperty("netbeans.debugger.breakpoints") != null;
    private LineBreakpoint breakpoint;
    private SourcePath sourcePath;
    private int lineNumber;
    private BreakpointsReader reader;

    public LineBreakpointImpl(LineBreakpoint breakpoint, BreakpointsReader reader, JPDADebuggerImpl debugger, Session session, SourcePath sourcePath) {
        super((JPDABreakpoint)breakpoint, reader, debugger, session);
        this.reader = reader;
        this.breakpoint = breakpoint;
        this.sourcePath = sourcePath;
        this.lineNumber = breakpoint.getLineNumber();
        this.set();
    }

    void fixed() {
        if (verbose) {
            System.out.println("B fix breakpoint impl: " + this);
        }
        this.lineNumber = this.breakpoint.getLineNumber();
        super.fixed();
    }

    protected void setRequests() {
        this.lineNumber = this.breakpoint.getLineNumber();
        String className = this.reader.findCachedClassName((JPDABreakpoint)this.breakpoint);
        if (className == null && (className = EditorContextBridge.getClassName(this.breakpoint.getURL(), this.lineNumber)) != null) {
            this.reader.storeCachedClassName((JPDABreakpoint)this.breakpoint, className);
        }
        if (className == null) {
            className = this.breakpoint.getURL();
            this.setClassRequests(new String[]{className}, new String[0], 1);
            this.checkLoadedClasses(className, true);
        } else {
            int i = className.indexOf(36);
            if (i > 0 && Character.isDigit(className.charAt(i + 1))) {
                className = className.substring(0, i);
            }
            this.setClassRequests(new String[]{className, className + ".*", className + "$*"}, new String[0], 1);
            this.checkLoadedClasses(className, false);
        }
    }

    protected void classLoaded(ReferenceType referenceType) {
        List locations;
        if (verbose) {
            System.out.println("B class loaded: " + referenceType);
        }
        if ((locations = LineBreakpointImpl.getLocations(referenceType, this.breakpoint.getStratum(), this.breakpoint.getSourceName(), this.breakpoint.getSourcePath(), this.lineNumber)).isEmpty()) {
            return;
        }
        Iterator it = locations.iterator();
        while (it.hasNext()) {
            Location location = (Location)it.next();
            try {
                BreakpointRequest br = this.getEventRequestManager().createBreakpointRequest(location);
                this.addEventRequest(br);
            }
            catch (VMDisconnectedException e) {}
        }
    }

    public boolean exec(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.perform(this.breakpoint.getCondition(), ((BreakpointEvent)event).thread(), ((LocatableEvent)event).location().declaringType(), null);
        }
        return super.exec(event);
    }

    private static List getLocations(ReferenceType referenceType, String stratum, String sourceName, String bpSourcePath, int lineNumber) {
        try {
            List<Location> list = new ArrayList<Location>(referenceType.locationsOfLine(stratum, sourceName, lineNumber));
            if (verbose) {
                System.out.println("B   get location: referenceType=" + referenceType + " stratum=" + stratum + " source name=" + sourceName + " lineNumber " + lineNumber + " (#" + list.size() + ")");
            }
            if (!list.isEmpty()) {
                if (bpSourcePath == null) {
                    return list;
                }
                bpSourcePath = bpSourcePath.replace(File.separatorChar, '/');
                if (verbose) {
                    System.out.println("B   source path: " + bpSourcePath);
                }
                ArrayList<Location> locations = new ArrayList<Location>();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Location l = (Location)it.next();
                    String lSourcePath = l.sourcePath().replace(File.separatorChar, '/');
                    if (!(lSourcePath = LineBreakpointImpl.normalize(lSourcePath)).equals(bpSourcePath)) continue;
                    locations.add(l);
                }
                if (verbose) {
                    System.out.println("B   relevant location(s) for path '" + bpSourcePath + "': " + locations);
                }
                if (!locations.isEmpty()) {
                    return locations;
                }
            }
            Iterator<ReferenceType> i = referenceType.nestedTypes().iterator();
            while (i.hasNext()) {
                ReferenceType rt = i.next();
                list = rt.locationsOfLine(stratum, sourceName, lineNumber);
                if (verbose) {
                    System.out.println("B   get location2: referenceType=" + referenceType + " stratum=" + stratum + " source name=" + sourceName + " lineNumber" + lineNumber + ":= " + list.size());
                }
                if (list.isEmpty()) continue;
                return list;
            }
        }
        catch (AbsentInformationException ex) {
        }
        catch (ObjectCollectedException ex) {
        }
        catch (ClassNotPreparedException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
        }
        catch (InternalException iex) {
            ErrorManager.getDefault().annotate((Throwable)iex, NbBundle.getMessage((Class)LineBreakpointImpl.class, (String)"MSG_jdi_internal_error"));
            ErrorManager.getDefault().notify((Throwable)iex);
        }
        return new ArrayList();
    }

    private static String normalize(String path) {
        Pattern thisDirectoryPattern = Pattern.compile("(/|\\A)\\./");
        Pattern parentDirectoryPattern = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
        Matcher m = thisDirectoryPattern.matcher(path);
        while (m.find()) {
            path = m.replaceAll("$1");
            m = thisDirectoryPattern.matcher(path);
        }
        m = parentDirectoryPattern.matcher(path);
        while (m.find()) {
            if (m.group(2).equals("..")) continue;
            path = path.substring(0, m.start()) + m.group(1) + path.substring(m.end());
            m = parentDirectoryPattern.matcher(path);
        }
        return path;
    }
}

