/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.breakpoints.PersistenceManager;

public class BreakpointsReader
implements Properties.Reader {
    private Map cachedClassNames = new WeakHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public String[] getSupportedClassNames() {
        return new String[]{JPDABreakpoint.class.getName()};
    }

    synchronized String findCachedClassName(JPDABreakpoint b) {
        return (String)this.cachedClassNames.get(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeCachedClassName(JPDABreakpoint b, String className) {
        BreakpointsReader breakpointsReader = this;
        synchronized (breakpointsReader) {
            this.cachedClassNames.put(b, className);
        }
        PersistenceManager.storeBreakpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(String typeID, Properties properties) {
        LineBreakpoint b = null;
        if (typeID.equals(LineBreakpoint.class.getName()) || typeID.equals(LineBreakpoint.class.getName() + "$LineBreakpointImpl")) {
            LineBreakpoint lb = LineBreakpoint.create((String)properties.getString(LineBreakpoint.PROP_URL, null), (int)properties.getInt(LineBreakpoint.PROP_LINE_NUMBER, 1));
            lb.setCondition(properties.getString(LineBreakpoint.PROP_CONDITION, ""));
            BreakpointsReader breakpointsReader = this;
            synchronized (breakpointsReader) {
                this.cachedClassNames.put(lb, properties.getString("className", null));
            }
            b = lb;
        }
        if (typeID.equals(MethodBreakpoint.class.getName())) {
            MethodBreakpoint mb = MethodBreakpoint.create();
            mb.setClassFilters((String[])properties.getArray("classFilters", (Object[])new String[0]));
            mb.setClassExclusionFilters((String[])properties.getArray("classExclusionFilters", (Object[])new String[0]));
            mb.setMethodName(properties.getString("methodName", ""));
            mb.setCondition(properties.getString("condition", ""));
            mb.setBreakpointType(properties.getInt("breakpointtType", 1));
            b = mb;
        }
        if (typeID.equals(ClassLoadUnloadBreakpoint.class.getName())) {
            ClassLoadUnloadBreakpoint cb = ClassLoadUnloadBreakpoint.create((int)properties.getInt("breakpointType", 1));
            cb.setClassFilters((String[])properties.getArray("classFilters", (Object[])new String[0]));
            cb.setClassExclusionFilters((String[])properties.getArray("classExclusionFilters", (Object[])new String[0]));
            b = cb;
        }
        if (typeID.equals(ExceptionBreakpoint.class.getName())) {
            ExceptionBreakpoint eb = ExceptionBreakpoint.create((String)properties.getString("exceptionClassName", null), (int)properties.getInt("catchType", 3));
            eb.setCondition(properties.getString("condition", ""));
            b = eb;
        }
        if (typeID.equals(FieldBreakpoint.class.getName())) {
            FieldBreakpoint fb = FieldBreakpoint.create((String)properties.getString("className", null), (String)properties.getString("fieldName", null), (int)properties.getInt("breakpointType", 1));
            fb.setCondition(properties.getString("condition", ""));
            b = fb;
        }
        if (typeID.equals(ThreadBreakpoint.class.getName())) {
            ThreadBreakpoint tb = ThreadBreakpoint.create();
            tb.setBreakpointType(properties.getInt("breakpointtType", 3));
            b = tb;
        }
        if (!$assertionsDisabled && b == null) {
            throw new AssertionError((Object)("Unknown breakpoint type: \"" + typeID + "\""));
        }
        b.setPrintText(properties.getString("printText", ""));
        b.setGroupName(properties.getString("groupName", ""));
        b.setSuspend(properties.getInt("suspend", 2));
        if (properties.getBoolean("enabled", true)) {
            b.enable();
        } else {
            b.disable();
        }
        return b;
    }

    public void write(Object object, Properties properties) {
        JPDABreakpoint b = (JPDABreakpoint)object;
        properties.setString("printText", b.getPrintText());
        properties.setString("groupName", b.getGroupName());
        properties.setInt("suspend", b.getSuspend());
        properties.setBoolean("enabled", b.isEnabled());
        if (object instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)object;
            properties.setString(LineBreakpoint.PROP_URL, lb.getURL());
            properties.setInt(LineBreakpoint.PROP_LINE_NUMBER, lb.getLineNumber());
            properties.setString(LineBreakpoint.PROP_CONDITION, lb.getCondition());
            String className = this.findCachedClassName((JPDABreakpoint)lb);
            properties.setString("className", className);
            return;
        }
        if (object instanceof MethodBreakpoint) {
            MethodBreakpoint mb = (MethodBreakpoint)object;
            properties.setArray("classFilters", (Object[])mb.getClassFilters());
            properties.setArray("classExclusionFilters", (Object[])mb.getClassExclusionFilters());
            properties.setString("methodName", mb.getMethodName());
            properties.setString("condition", mb.getCondition());
            properties.setInt("breakpointtType", mb.getBreakpointType());
            return;
        }
        if (object instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint cb = (ClassLoadUnloadBreakpoint)object;
            properties.setArray("classFilters", (Object[])cb.getClassFilters());
            properties.setArray("classExclusionFilters", (Object[])cb.getClassExclusionFilters());
            properties.setInt("breakpointType", cb.getBreakpointType());
            return;
        }
        if (object instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint eb = (ExceptionBreakpoint)object;
            properties.setString("exceptionClassName", eb.getExceptionClassName());
            properties.setInt("catchType", eb.getCatchType());
            properties.setString("condition", eb.getCondition());
            return;
        }
        if (object instanceof FieldBreakpoint) {
            FieldBreakpoint fb = (FieldBreakpoint)object;
            properties.setString("className", fb.getClassName());
            properties.setString("fieldName", fb.getFieldName());
            properties.setString("condition", fb.getCondition());
            properties.setInt("breakpointType", fb.getBreakpointType());
            return;
        }
        if (object instanceof ThreadBreakpoint) {
            ThreadBreakpoint tb = (ThreadBreakpoint)object;
            properties.setInt("breakpointtType", tb.getBreakpointType());
            return;
        }
    }

    static {
        $assertionsDisabled = !BreakpointsReader.class.desiredAssertionStatus();
    }
}

