/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.expr.Expression;
import org.netbeans.modules.debugger.jpda.expr.ParseException;
import org.netbeans.modules.debugger.jpda.util.Executor;

public abstract class BreakpointImpl
implements Executor,
PropertyChangeListener {
    private static boolean verbose = System.getProperty("netbeans.debugger.breakpoints") != null;
    private JPDADebuggerImpl debugger;
    private JPDABreakpoint breakpoint;
    private BreakpointsReader reader;
    private final Session session;
    private Expression compiledCondition;
    private List requests = new ArrayList();

    protected BreakpointImpl(JPDABreakpoint p, BreakpointsReader reader, JPDADebuggerImpl debugger, Session session) {
        this.debugger = debugger;
        this.reader = reader;
        this.breakpoint = p;
        this.session = session;
    }

    final void set() {
        this.breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
        this.update();
    }

    void fixed() {
        if (this.reader != null) {
            this.reader.storeCachedClassName(this.breakpoint, null);
        }
        this.update();
    }

    final void update() {
        if (this.getVirtualMachine() == null || this.getDebugger().getState() == 4) {
            return;
        }
        this.removeAllEventRequests();
        if (this.breakpoint.isEnabled()) {
            this.setRequests();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("disposed".equals(evt.getPropertyName())) {
            this.remove();
        } else {
            if (this.reader != null) {
                this.reader.storeCachedClassName(this.breakpoint, null);
            }
            this.update();
        }
    }

    protected abstract void setRequests();

    protected final void remove() {
        this.removeAllEventRequests();
        this.breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
    }

    protected JPDABreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    protected VirtualMachine getVirtualMachine() {
        return this.getDebugger().getVirtualMachine();
    }

    protected EventRequestManager getEventRequestManager() {
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            throw new VMDisconnectedException();
        }
        return vm.eventRequestManager();
    }

    protected synchronized void addEventRequest(EventRequest r) {
        if (verbose) {
            System.out.println("B   addEventRequest: " + r);
        }
        this.requests.add(r);
        this.getDebugger().getOperator().register(r, this);
        if (r instanceof ClassPrepareRequest) {
            r.setSuspendPolicy(1);
        } else if (this.getBreakpoint().getSuspend() == 2) {
            r.setSuspendPolicy(2);
        } else {
            r.setSuspendPolicy(1);
        }
        r.enable();
    }

    private synchronized void removeAllEventRequests() {
        if (this.requests.size() == 0) {
            return;
        }
        if (this.getDebugger().getVirtualMachine() == null) {
            return;
        }
        int k = this.requests.size();
        try {
            for (int i = 0; i < k; ++i) {
                EventRequest r = (EventRequest)this.requests.get(i);
                if (verbose) {
                    System.out.println("B   removeEventRequest: " + r);
                }
                this.getDebugger().getVirtualMachine().eventRequestManager().deleteEventRequest(r);
                this.getDebugger().getOperator().unregister(r);
            }
        }
        catch (VMDisconnectedException e) {
        }
        catch (InternalException internalException) {
            // empty catch block
        }
        this.requests = new LinkedList();
    }

    public boolean perform(String condition, ThreadReference thread, ReferenceType referenceType, Value value) {
        boolean resume;
        try {
            this.getDebugger().setAltCSF(thread.frame(0));
        }
        catch (IncompatibleThreadStateException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (condition == null || condition.equals("")) {
            JPDABreakpointEvent e = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, 0, this.debugger.getThread(thread), referenceType, this.debugger.getVariable(value));
            this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), e);
            boolean bl = resume = this.getBreakpoint().getSuspend() == 0 || e.getResume();
            if (verbose) {
                System.out.println("B perform breakpoint (no condition): " + this + " resume: " + resume);
            }
        } else {
            resume = this.evaluateCondition(condition, thread, referenceType, value);
            resume = this.getBreakpoint().getSuspend() == 0 || resume;
        }
        this.getDebugger().setAltCSF(null);
        if (!resume) {
            DebuggerManager.getDebuggerManager().setCurrentSession(this.session);
            this.getDebugger().setStoppedState(thread);
        }
        return resume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateCondition(String condition, ThreadReference thread, ReferenceType referenceType, Value value) {
        try {
            try {
                JPDABreakpointEvent ev;
                boolean result;
                Object object = this.debugger.LOCK;
                synchronized (object) {
                    StackFrame sf = thread.frame(0);
                    result = this.evaluateConditionIn(condition, sf);
                    ev = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, result ? 1 : 2, this.debugger.getThread(thread), referenceType, this.debugger.getVariable(value));
                }
                this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), ev);
                if (verbose) {
                    System.out.println("B perform breakpoint (condition = " + result + "): " + this + " resume: " + (!result || ev.getResume()));
                }
                return !result || ev.getResume();
            }
            catch (ParseException ex) {
                JPDABreakpointEvent ev = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, (Throwable)ex, this.debugger.getThread(thread), referenceType, this.debugger.getVariable(value));
                this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), ev);
                if (verbose) {
                    System.out.println("B perform breakpoint (bad condition): " + this + " resume: " + ev.getResume());
                }
                return ev.getResume();
            }
            catch (InvalidExpressionException ex) {
                JPDABreakpointEvent ev = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, (Throwable)ex, this.debugger.getThread(thread), referenceType, this.debugger.getVariable(value));
                this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), ev);
                return ev.getResume();
            }
        }
        catch (IncompatibleThreadStateException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean evaluateConditionIn(String condExpr, StackFrame frame) throws ParseException, InvalidExpressionException {
        if (this.compiledCondition == null || !this.compiledCondition.getExpression().equals(condExpr)) {
            this.compiledCondition = Expression.parse(condExpr, "1.5.0");
        }
        Value value = this.getDebugger().evaluateIn(this.compiledCondition, frame);
        try {
            return ((BooleanValue)value).booleanValue();
        }
        catch (ClassCastException e) {
            throw new InvalidExpressionException((Throwable)e);
        }
    }

    static boolean match(String name, String pattern) {
        if (pattern.startsWith("*")) {
            return name.endsWith(pattern.substring(1));
        }
        if (pattern.endsWith("*")) {
            return name.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return name.equals(pattern);
    }
}

