/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.tasklist.core.Background;
import org.netbeans.modules.tasklist.core.CancellableRunnable;
import org.netbeans.modules.tasklist.docscan.Settings;
import org.netbeans.modules.tasklist.docscan.SourceTasksAction;
import org.netbeans.modules.tasklist.docscan.SourceTasksProviderAcceptor;
import org.netbeans.modules.tasklist.docscan.SourceTasksView;
import org.netbeans.modules.tasklist.suggestions.ProviderAcceptor;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionsScanner;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Utilities;

final class SourceTasksScanner {
    SourceTasksScanner() {
    }

    public static Background scanTasksAsync(SourceTasksView view) {
        SuggestionList list = (SuggestionList)view.getList();
        Bg bg = new Bg(view, list, null);
        return Background.execute((Runnable)((Object)bg));
    }

    public static Background scanTasksAsync(SourceTasksView view, DataObject.Container[] folders) {
        SuggestionList list = (SuggestionList)view.getList();
        Bg bg = new Bg(view, list, folders);
        return Background.execute((Runnable)((Object)bg));
    }

    static void scanProjectSuggestions(SuggestionList list, SourceTasksAction.ScanProgressMonitor view, Bg bg) {
        DataObject.Container[] projectFolders = bg.ctx;
        if (projectFolders == null) {
            ArrayList project = new ArrayList(23);
            boolean enabled = false;
            if ("project".equals(System.getProperty("todos.project", "repository"))) {
                enabled = SourceTasksScanner.project(project);
            }
            if (!enabled) {
                project.clear();
                SourceTasksScanner.repository(project);
            }
            projectFolders = new DataObject.Container[project.size()];
            project.toArray(projectFolders);
        }
        SuggestionsScanner c = SuggestionsScanner.getDefault();
        c.setUsabilityLimit(Settings.getDefault().getUsabilityLimit());
        bg.cancellable = (Cancellable)c;
        c.scan(projectFolders, list, (SuggestionsScanner.ScanProgress)view, (ProviderAcceptor)new SourceTasksProviderAcceptor());
    }

    static void repository(List folders) {
        Repository repository = Repository.getDefault();
        Enumeration en = repository.fileSystems();
        while (en.hasMoreElements()) {
            FileSystem next = (FileSystem)en.nextElement();
            if (next.isDefault() || next.isHidden() || next.isReadOnly() || !next.isValid()) continue;
            FileObject fo = next.getRoot();
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                if (!(dobj instanceof DataObject.Container)) continue;
                folders.add(dobj);
            }
            catch (DataObjectNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    static boolean project(List folders) {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject registration = fs.findResource("Services/Hidden/org-netbeans-modules-projects-ProjectCookieImpl.instance");
        if (registration == null) {
            return false;
        }
        try {
            DataObject dobj = DataObject.find((FileObject)registration);
            InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
            Object obj = ic.instanceCreate();
            Method method = obj.getClass().getMethod("projectDesktop", new Class[0]);
            Node node = (Node)method.invoke(obj, new Object[0]);
            DataObject prjDO = (DataObject)node.getCookie(DataObject.class);
            if (prjDO instanceof DataObject.Container) {
                DataObject[] kids = ((DataObject.Container)prjDO).getChildren();
                for (int i = 0; i < kids.length; ++i) {
                    if (!(kids[i] instanceof DataObject.Container)) continue;
                    folders.add(kids[i]);
                }
            }
            return true;
        }
        catch (DataObjectNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    static class Bg
    implements CancellableRunnable {
        private Cancellable cancellable;
        private final SourceTasksView view;
        private final SuggestionList list;
        private final DataObject.Container[] ctx;

        Bg(SourceTasksView view, SuggestionList list, DataObject.Container[] ctx) {
            this.view = view;
            this.list = list;
            this.ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            Bg.this.view.setCursor(Utilities.createProgressCursor((Component)((Object)Bg.this.view)));
                        }
                    });
                }
                catch (InterruptedException ignore) {
                }
                catch (InvocationTargetException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                SourceTasksScanner.scanProjectSuggestions(this.list, this.view, this);
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Bg.this.view.statistics(Bg.this.list.size());
                        Bg.this.view.setCursor(null);
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public boolean cancel() {
            if (this.cancellable != null) {
                return this.cancellable.cancel();
            }
            return false;
        }
    }
}

