/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.tasklist.core.ObservableList;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskList;
import org.netbeans.modules.tasklist.core.TaskListener;
import org.netbeans.modules.tasklist.docscan.SourceTaskProvider;

final class FilteredTasksList
implements ObservableList {
    private final TaskList peer;
    private List listeners = new ArrayList(1);
    private List tasks = new LinkedList();
    private EventHandler handler;
    private boolean silent = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FilteredTasksList(TaskList peer) {
        this.peer = peer;
    }

    public List getTasks() {
        return this.tasks;
    }

    public synchronized void addTaskListener(TaskListener l) {
        if (!$assertionsDisabled && l == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.listeners.contains(l)) {
            throw new AssertionError();
        }
        ArrayList<TaskListener> clisteners = new ArrayList<TaskListener>(this.listeners);
        clisteners.add(l);
        if (clisteners.size() == 1) {
            this.handler = new EventHandler();
            this.peer.addTaskListener((TaskListener)this.handler);
        }
        this.listeners = clisteners;
    }

    public synchronized void removeTaskListener(TaskListener l) {
        ArrayList clisteners = new ArrayList(this.listeners);
        clisteners.remove(l);
        if (clisteners.size() == 0) {
            this.peer.removeTaskListener((TaskListener)this.handler);
            this.handler = null;
        }
        this.listeners = clisteners;
    }

    synchronized void byebye() {
        if (this.listeners.size() > 0) {
            // empty if block
        }
        this.listeners.clear();
        this.peer.removeTaskListener((TaskListener)this.handler);
        this.handler = null;
    }

    private void fireStructureChanged(Task task) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            TaskListener listener = (TaskListener)it.next();
            listener.structureChanged(task);
        }
    }

    private void refreshSnapshot() {
        this.tasks.clear();
        this.loadSourceTasks(this.peer.getTasks());
    }

    private void loadSourceTasks(List tasks) {
        if (tasks.size() == 0) {
            return;
        }
        Iterator it = tasks.iterator();
        while (it.hasNext()) {
            Task task = (Task)it.next();
            if (task.getSeed() instanceof SourceTaskProvider) {
                tasks.add(task);
                continue;
            }
            if (!task.hasSubtasks()) continue;
            this.loadSourceTasks(task.getSubtasks());
        }
    }

    static {
        $assertionsDisabled = !FilteredTasksList.class.desiredAssertionStatus();
    }

    private class EventHandler
    implements TaskListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        private EventHandler() {
        }

        public void selectedTask(Task t) {
            if (FilteredTasksList.this.getTasks().contains(t)) {
                Iterator it = FilteredTasksList.this.listeners.iterator();
                while (it.hasNext()) {
                    TaskListener listener = (TaskListener)it.next();
                    listener.selectedTask(t);
                }
            }
        }

        public void warpedTask(Task t) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Not implemented");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addedTask(Task t) {
            block7: {
                block6: {
                    if (!(t.getSeed() instanceof SourceTaskProvider)) break block6;
                    try {
                        FilteredTasksList.this.silent = true;
                        FilteredTasksList.this.tasks.add(t);
                    }
                    finally {
                        FilteredTasksList.this.silent = false;
                    }
                    Iterator it = FilteredTasksList.this.listeners.iterator();
                    while (it.hasNext()) {
                        TaskListener listener = (TaskListener)it.next();
                        listener.addedTask(t);
                    }
                    break block7;
                }
                if (!t.hasSubtasks()) break block7;
                Iterator it = t.subtasksIterator();
                while (it.hasNext()) {
                    Task task = (Task)it.next();
                    this.addedTask(task);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedTask(Task pt, Task t, int index) {
            block8: {
                block7: {
                    if (!(t.getSeed() instanceof SourceTaskProvider)) break block7;
                    boolean removed = false;
                    try {
                        FilteredTasksList.this.silent = true;
                        removed = FilteredTasksList.this.tasks.remove(t);
                    }
                    finally {
                        FilteredTasksList.this.silent = false;
                    }
                    if (!removed) break block8;
                    Iterator it = FilteredTasksList.this.listeners.iterator();
                    while (it.hasNext()) {
                        TaskListener listener = (TaskListener)it.next();
                        listener.removedTask(null, t, index);
                    }
                    break block8;
                }
                if (t.hasSubtasks()) {
                    Iterator it = t.subtasksIterator();
                    int ind = 0;
                    while (it.hasNext()) {
                        Task task = (Task)it.next();
                        this.removedTask(null, task, ind++);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void structureChanged(Task t) {
            try {
                FilteredTasksList.this.silent = true;
                FilteredTasksList.this.refreshSnapshot();
            }
            finally {
                FilteredTasksList.this.silent = false;
            }
            FilteredTasksList.this.fireStructureChanged(t);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$tasklist$docscan$FilteredTasksList == null ? (class$org$netbeans$modules$tasklist$docscan$FilteredTasksList = FilteredTasksList.class$("org.netbeans.modules.tasklist.docscan.FilteredTasksList")) : class$org$netbeans$modules$tasklist$docscan$FilteredTasksList).desiredAssertionStatus();
        }
    }
}

