/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.ResultItem;
import org.netbeans.modules.web.core.syntax.completion.ResultItemPaintComponent;
import org.openide.util.NbBundle;

public class JspCompletionItem {
    private static final int DIRECTIVE_SORT_PRIORITY = 5;
    private static final int DEFAULT_SORT_PRIORITY = 10;

    private static String constructHelp(URL url) {
        if (url == null) {
            return null;
        }
        try {
            InputStream is = url.openStream();
            byte[] buffer = new byte[1000];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int count = 0;
            do {
                if ((count = is.read(buffer)) <= 0) continue;
                baos.write(buffer, 0, count);
            } while (count > 0);
            is.close();
            String text = baos.toString();
            baos.close();
            return text;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String constructHelp(TagInfo tagInfo) {
        if (tagInfo == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<h2>").append(JspCompletionItem.getString("LBL_TagName")).append(" ");
        sb.append(tagInfo.getTagName()).append("</h2>");
        String val = tagInfo.getDisplayName();
        if (val != null) {
            sb.append("<p>").append(JspCompletionItem.getString("LBL_DisplayName"));
            sb.append("<i>").append(val).append("</i>");
        }
        if ((val = tagInfo.getInfoString()) != null) {
            sb.append("<hr>").append(val).append("<hr>");
        }
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"1\">");
        sb.append("<tr bgcolor=\"#CCCCFF\"><td colspan=\"2\"><font size=\"+2\"><b>");
        sb.append("Tag Information</b></font></td></tr>");
        sb.append("<tr><td>Tag Class</td><td>");
        if (tagInfo.getTagClassName() != null && !tagInfo.getClass().equals("")) {
            sb.append(tagInfo.getTagClassName());
        } else {
            sb.append("<i>None</i>");
        }
        sb.append("</td></tr><tr><td>Body Content</td><td>");
        sb.append(tagInfo.getBodyContent());
        sb.append("</td></tr><tr><td>Display Name</td><td>");
        if (tagInfo.getDisplayName() != null && !tagInfo.getDisplayName().equals("")) {
            sb.append(tagInfo.getDisplayName());
        } else {
            sb.append("<i>None</i>");
        }
        sb.append("</td></tr></table><br>");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"1\">");
        sb.append("<tr bgcolor=\"#CCCCFF\"><td colspan=\"3\"><font size=\"+2\"><b>Attributes</b></font></td></tr>");
        TagAttributeInfo[] attrs = tagInfo.getAttributes();
        if (attrs != null && attrs.length > 0) {
            sb.append("<tr><td><b>Name</b></td><td><b>Required</b></td><td><b>Request-time</b></td></tr>");
            for (int i = 0; i < attrs.length; ++i) {
                sb.append("<tr><td>");
                sb.append(attrs[i].getName());
                sb.append("</td><td>");
                sb.append(attrs[i].isRequired());
                sb.append("</td><td>");
                sb.append(attrs[i].canBeRequestTime());
                sb.append("</td></tr>");
            }
        } else {
            sb.append("<tr><td colspan=\"3\"><i>No Attributes Defined.</i></td></tr>");
        }
        sb.append("</table><br>");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"1\">");
        sb.append("<tr bgcolor=\"#CCCCFF\"><td colspan=\"4\"><font size=\"+2\"><b>Variables</b></font></td></tr>");
        TagVariableInfo[] variables = tagInfo.getTagVariableInfos();
        if (variables != null && variables.length > 0) {
            sb.append("<tr><td><b>Name</b></td><td><b>Type</b></td><td><b>Declare</b></td><td><b>Scope</b></td></tr>");
            for (int i = 0; i < variables.length; ++i) {
                sb.append("<tr><td>");
                if (variables[i].getNameGiven() != null && !variables[i].getNameGiven().equals("")) {
                    sb.append(variables[i].getNameGiven());
                } else if (variables[i].getNameFromAttribute() != null && !variables[i].getNameFromAttribute().equals("")) {
                    sb.append("<i>From attribute '").append(variables[i].getNameFromAttribute()).append("'</i>");
                } else {
                    sb.append("<i>Unknown</i>");
                }
                sb.append("</td><td><code>");
                if (variables[i].getClassName() == null || variables[i].getClassName().equals("")) {
                    sb.append("java.lang.String");
                } else {
                    sb.append(variables[i].getClassName());
                }
                sb.append("</code></td></tr>");
                sb.append("</td><td>");
                sb.append(variables[i].getDeclare());
                sb.append("</td></tr>");
                sb.append("</td><td>");
                switch (variables[i].getScope()) {
                    case 1: {
                        sb.append("AT_BEGIN");
                        break;
                    }
                    case 2: {
                        sb.append("AT_END");
                        break;
                    }
                    default: {
                        sb.append("NESTED");
                    }
                }
                sb.append("</td></tr>");
            }
        } else {
            sb.append("<tr><td colspan=\"4\"><i>No Variables Defined.</i></td></tr>");
        }
        sb.append("</table><br>");
        return sb.toString();
    }

    private static String getString(String key) {
        return NbBundle.getMessage(JspCompletionItem.class, (String)key);
    }

    public static class ELFunction
    extends ELBean
    implements ELItem {
        private static ResultItemPaintComponent.ELFunctionPaintComponent paintComponent = null;
        private String prefix;
        private String parameters;

        public ELFunction(String prefix, String name, String type, String parameters) {
            super(name, type);
            this.prefix = prefix;
            this.parameters = parameters;
        }

        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new ResultItemPaintComponent.ELFunctionPaintComponent();
            }
            paintComponent.setString(this.text);
            paintComponent.setTypeName(this.type);
            paintComponent.setPrefix(this.prefix);
            paintComponent.setParameters(this.parameters);
            return paintComponent;
        }

        public int getSortPriority() {
            return 12;
        }

        public String getItemText() {
            return this.prefix + ":" + this.text + "()";
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            return this.substituteText(c, offset, len, this.getItemText(), 1);
        }
    }

    public static class ELProperty
    extends ELBean
    implements ELItem {
        private static ResultItemPaintComponent.ELPropertyPaintComponent paintComponent = null;

        public ELProperty(String text, String type) {
            super(text, type);
        }

        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new ResultItemPaintComponent.ELPropertyPaintComponent();
            }
            paintComponent.setString(this.text);
            paintComponent.setTypeName(this.type);
            return paintComponent;
        }
    }

    public static class ELBean
    extends JspResultItem
    implements ELItem {
        private static ResultItemPaintComponent.ELBeanPaintComponent paintComponent = null;
        protected String type;

        public ELBean(String text, String type) {
            super(text);
            this.type = type.lastIndexOf(46) > -1 ? type.substring(type.lastIndexOf(46) + 1) : type;
        }

        public int getSortPriority() {
            return 10;
        }

        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new ResultItemPaintComponent.ELBeanPaintComponent();
            }
            paintComponent.setString(this.text);
            paintComponent.setTypeName(this.type);
            return paintComponent;
        }
    }

    public static class ELImplicitObject
    extends JspResultItem
    implements ELItem {
        private static ResultItemPaintComponent.ELImplicitObjectPaintComponent paintComponent = null;
        int type;

        ELImplicitObject(String text, int type) {
            super(text);
            this.type = type;
        }

        public int getSortPriority() {
            return 15;
        }

        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new ResultItemPaintComponent.ELImplicitObjectPaintComponent();
            }
            paintComponent.setString(this.text);
            paintComponent.setType(this.type);
            return paintComponent;
        }

        public String getItemText() {
            String result = this.text;
            if (this.type == 1) {
                result = result + "[]";
            }
            return result;
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            if (this.type == 1) {
                return this.substituteText(c, offset, len, this.getItemText(), 1);
            }
            return this.substituteText(c, offset, len, this.getItemText(), 0);
        }
    }

    public static interface ELItem {
    }

    public static class FileAttributeValue
    extends JspResultItem {
        private ImageIcon icon;
        private Color color;

        FileAttributeValue(String text, Color color) {
            this(text, color, null);
        }

        FileAttributeValue(String text, Color color, ImageIcon icon) {
            super(text);
            this.color = color;
            this.icon = icon;
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            return this.substituteText(c, offset, len, this.getItemText(), 0);
        }

        public Component getPaintComponent(final boolean isSelected) {
            return new ResultItemPaintComponent(){

                public void draw(Graphics g) {
                    this.drawIcon(g, FileAttributeValue.this.icon);
                    this.drawString(g, FileAttributeValue.this.text, FileAttributeValue.this.color);
                }

                public boolean isSelected() {
                    return isSelected;
                }
            };
        }
    }

    static class AttributeValue
    extends JspResultItem {
        public CharSequence getInsertPrefix() {
            return null;
        }

        AttributeValue(String text) {
            super(text);
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            return this.substituteText(c, offset, len, this.getItemText(), 0);
        }
    }

    public static class Attribute
    extends JspResultItem {
        private TagAttributeInfo tagAttributeInfo;
        private boolean required;
        private static ResultItemPaintComponent.JspTagPaintComponent component = null;
        private static ResultItemPaintComponent.JspTagPaintComponent componentRequired = null;

        Attribute(String text) {
            super(text);
            this.tagAttributeInfo = null;
            this.required = false;
        }

        Attribute(TagAttributeInfo tai) {
            super(tai.getName());
            this.required = tai.isRequired();
            this.tagAttributeInfo = tai;
            if (tai.getTypeName() == null && tai.isFragment()) {
                this.setHelp("fragment");
            } else {
                this.setHelp(tai.getTypeName());
            }
        }

        public Component getPaintComponent(boolean isSelected) {
            ResultItemPaintComponent comp;
            ResultItemPaintComponent.JspTagPaintComponent jspTagPaintComponent = comp = this.required ? componentRequired : component;
            if (comp == null) {
                comp = new ResultItemPaintComponent.AttributePaintComponent(this.required);
            }
            comp.setSelected(isSelected);
            comp.setString(this.getItemText());
            return comp;
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            return this.substituteText(c, offset, len, this.getItemText() + "=\"\"", 1);
        }

        public String getHelp() {
            URL url = super.getHelpURL();
            if (url != null) {
                String to;
                int last;
                String surl = url.toString();
                int first = surl.indexOf(35) + 1;
                String from = first < (last = surl.lastIndexOf(35) + 1) ? surl.substring(first, last - 1) : surl.substring(first);
                String text = JspCompletionItem.constructHelp(this.getHelpURL());
                first = text.indexOf(from);
                if (first > 0 && (first = first + from.length() + 2) < text.length()) {
                    text = text.substring(first);
                }
                if ((last = text.indexOf(to = surl.substring(last))) > 0) {
                    text = text.substring(0, last);
                }
                return text;
            }
            if (this.tagAttributeInfo != null) {
                StringBuffer text = new StringBuffer();
                text.append("<table border=\"0\"><tr><td><b>Name:</b></td><td>");
                text.append(this.tagAttributeInfo.getName());
                text.append("</td></tr><tr><td><b>Required:</b></td><td>");
                text.append(this.tagAttributeInfo.isRequired());
                text.append("</td></tr><tr><td><b>Request-time:</b></td><td>");
                text.append(this.tagAttributeInfo.canBeRequestTime());
                text.append("</td></tr><tr><td><b>Fragment:</b></td><td>");
                text.append(this.tagAttributeInfo.isFragment());
                text.append("</td></tr></table>");
                return text.toString();
            }
            return super.getHelp();
        }

        public URL getHelpURL() {
            URL url = super.getHelpURL();
            if (url != null) {
                String surl = url.toString();
                int index = surl.lastIndexOf(35);
                if (index > 0) {
                    surl = surl.substring(0, index);
                }
                try {
                    url = new URL(surl);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            return url;
        }
    }

    static class Directive
    extends TagDirective {
        TagInfo tagInfo;

        Directive(String text) {
            super(text);
            this.tagInfo = null;
        }

        Directive(String text, TagInfo tagInfo) {
            super(text);
            this.tagInfo = tagInfo;
            if (tagInfo != null) {
                this.setHelp(tagInfo.getInfoString());
            }
        }

        public CharSequence getInsertPrefix() {
            return null;
        }

        public int getSortPriority() {
            return 5;
        }

        public String getHelp() {
            String text;
            if (this.getHelpURL() != null && (text = JspCompletionItem.constructHelp(this.getHelpURL())) != null) {
                text = text.substring(text.indexOf("<h2>"));
                text = text.substring(0, text.lastIndexOf("<h4>"));
                return text;
            }
            return JspCompletionItem.constructHelp(this.tagInfo);
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            return this.substituteText(c, offset, len, "%@ " + this.getItemText() + "  %>", 3);
        }

        public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
            return super.substituteCommonText(c, offset += 2, len -= 2, subLen);
        }

        public Component getPaintComponent(boolean isSelected) {
            if (component == null) {
                component = new ResultItemPaintComponent.JspDirectivePaintComponent();
            }
            component.setSelected(isSelected);
            component.setString(this.getItemText());
            return component;
        }
    }

    public static class Tag
    extends JspResultItem {
        protected static ResultItemPaintComponent.JspTagPaintComponent component = null;
        private TagInfo ti = null;

        public Tag(String text) {
            super(text);
        }

        public Tag(String text, TagInfo ti) {
            this(text);
            this.ti = ti;
            if (ti != null) {
                this.setHelp(ti.getInfoString());
            }
        }

        public boolean hasHelp() {
            return true;
        }

        public TagInfo getTagInfo() {
            return this.ti;
        }

        public CharSequence getInsertPrefix() {
            return this.getItemText();
        }

        public String getHelp() {
            URL url = super.getHelpURL();
            if (url != null) {
                String surl = url.toString();
                int first = surl.indexOf(35) + 1;
                String help = JspCompletionItem.constructHelp(url);
                if (first > 0) {
                    int last = surl.lastIndexOf(35) + 1;
                    String from = surl.substring(first, last - 1);
                    String to = surl.substring(last);
                    first = help.indexOf(from);
                    if (first > 0 && (first = first + from.length() + 2) < help.length()) {
                        help = help.substring(first);
                    }
                    if ((last = help.indexOf(to)) > 0) {
                        help = help.substring(0, last);
                    }
                    return help;
                }
                help = help.substring(help.indexOf("<h2>"));
                help = help.substring(0, help.lastIndexOf("<h4>"));
                return help;
            }
            return JspCompletionItem.constructHelp(this.ti);
        }

        public Component getPaintComponent(boolean isSelected) {
            if (component == null) {
                component = new ResultItemPaintComponent.JspTagPaintComponent(false);
            }
            component.setSelected(isSelected);
            component.setString(this.text);
            return component;
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            if (!this.getItemText().startsWith("/")) {
                return this.substituteText(c, offset, len, this.getItemText() + " ", 0);
            }
            return this.substituteText(c, offset, len, this.getItemText().substring(1) + ">", 0);
        }

        public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
            if (!this.getItemText().startsWith("/")) {
                return this.substituteText(c, offset, len, this.getItemText().substring(subLen), 0);
            }
            return this.substituteText(c, offset, len, this.getItemText().substring(1, subLen), 0);
        }
    }

    public static abstract class TagDirective
    extends JspResultItem {
        protected static ResultItemPaintComponent component = null;

        TagDirective(String text) {
            super(text);
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            return this.substituteText(c, offset, len, this.getItemText() + " ", 0);
        }

        public boolean instantSubstitutionEnabled(JTextComponent c) {
            return true;
        }

        public Component getPaintComponent(boolean isSelected) {
            if (component == null) {
                component = new ResultItemPaintComponent.JspTagPaintComponent(false);
            }
            component.setSelected(isSelected);
            component.setString(this.text);
            return component;
        }
    }

    public static class PrefixTag
    extends JspResultItem {
        private TagInfo tagInfo;
        private boolean isEmpty = false;
        private boolean hasAttributes = false;
        private static ResultItemPaintComponent.JspTagPaintComponent component = null;
        private static ResultItemPaintComponent.JspTagPaintComponent componentEmpty = null;

        PrefixTag(String text) {
            super(text);
        }

        PrefixTag(String prefix, TagInfo ti, SyntaxElement.Tag set) {
            this(prefix + ":" + ti.getTagName());
            this.tagInfo = ti;
            if (this.tagInfo != null && this.tagInfo.getBodyContent().equalsIgnoreCase("empty")) {
                this.isEmpty = true;
            }
            if (this.tagInfo != null) {
                this.setHelp(this.tagInfo.getInfoString());
            }
            if (set != null) {
                this.hasAttributes = set.getAttributes().size() != 0;
            }
        }

        PrefixTag(String prefix, TagInfo ti) {
            this(prefix, ti, null);
        }

        public CharSequence getInsertPrefix() {
            return this.getItemText();
        }

        public boolean hasHelp() {
            return true;
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }

        public String getHelp() {
            URL url = super.getHelpURL();
            if (url != null) {
                String surl = url.toString();
                int first = surl.indexOf(35) + 1;
                String help = JspCompletionItem.constructHelp(url);
                if (first > 0) {
                    int last = surl.lastIndexOf(35) + 1;
                    String from = surl.substring(first, last - 1);
                    String to = surl.substring(last);
                    first = help.indexOf(from);
                    if (first > 0 && (first = first + from.length() + 2) < help.length()) {
                        help = help.substring(first);
                    }
                    if ((last = help.indexOf(to)) > 0) {
                        help = help.substring(0, last);
                    }
                    return help;
                }
                help = help.substring(help.indexOf("<h2>"));
                help = help.substring(0, help.lastIndexOf("<h4>"));
                return help;
            }
            return JspCompletionItem.constructHelp(this.tagInfo);
        }

        public Component getPaintComponent(boolean isSelected) {
            ResultItemPaintComponent.JspTagPaintComponent comp;
            ResultItemPaintComponent.JspTagPaintComponent jspTagPaintComponent = comp = this.isEmpty ? componentEmpty : component;
            if (comp == null) {
                comp = new ResultItemPaintComponent.JspTagPaintComponent(this.isEmpty);
            }
            comp.setSelected(isSelected);
            comp.setString(this.text);
            return comp;
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            String suffix;
            String string = suffix = this.isEmpty ? "/>" : ">";
            if (this.hasAttributes) {
                suffix = "";
            }
            if (!this.getItemText().startsWith("/")) {
                if (!shift) {
                    return this.substituteText(c, offset, len, this.getItemText(), 0);
                }
                boolean hasAttrs = true;
                if (this.tagInfo != null) {
                    TagAttributeInfo[] tAttrs = this.tagInfo.getAttributes();
                    boolean bl = tAttrs != null ? tAttrs.length > 0 : (hasAttrs = true);
                }
                if (hasAttrs) {
                    return this.substituteText(c, offset, len, this.getItemText() + (this.hasAttributes ? "" : " ") + suffix, suffix.length());
                }
                return this.substituteText(c, offset, len, this.getItemText() + suffix, 0);
            }
            return this.substituteText(c, offset, len, this.getItemText().substring(1) + ">", 0);
        }
    }

    public static abstract class JspResultItem
    extends ResultItem {
        protected String help;
        protected String text;
        private static ResultItemPaintComponent component = null;

        public JspResultItem(String text) {
            this.text = text;
            this.help = null;
        }

        public JspResultItem(String text, String help) {
            this(text);
            this.help = help;
        }

        public String getItemText() {
            return this.text;
        }

        protected Object getAssociatedObject() {
            return this.text;
        }

        public int getSortPriority() {
            return 10;
        }

        public CharSequence getInsertPrefix() {
            return this.getItemText();
        }

        public Component getPaintComponent(boolean isSelected) {
            if (component == null) {
                component = new ResultItemPaintComponent.StringPaintComponent();
            }
            component.setSelected(isSelected);
            component.setString(this.text);
            return component;
        }

        public URL getHelpURL() {
            if (this.help == null || this.help.equals("")) {
                return null;
            }
            try {
                return new URL(this.help);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public String getHelp() {
            return this.help;
        }

        public boolean hasHelp() {
            return this.help != null && this.help.length() > 0;
        }

        public void setHelp(String help) {
            this.help = help;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean substituteText(JTextComponent c, int offset, int len, String fill, int moveBack) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            try {
                doc.atomicLock();
                try {
                    String currentText = doc.getText(offset, doc.getLength() - offset < fill.length() ? doc.getLength() - offset : fill.length());
                    if (!fill.substring(0, fill.length() - 1).equals(currentText)) {
                        doc.remove(offset, len);
                        doc.insertString(offset, fill, null);
                    } else {
                        c.setCaretPosition(c.getCaret().getDot() + fill.length() - len);
                    }
                    ExtFormatter f = (ExtFormatter)doc.getFormatter();
                    int[] fmtBlk = f.getReformatBlock(c, fill);
                    if (fmtBlk != null) {
                        fmtBlk[0] = Utilities.getRowStart((BaseDocument)doc, (int)fmtBlk[0]);
                        fmtBlk[1] = Utilities.getRowEnd((BaseDocument)doc, (int)fmtBlk[1]);
                        f.reformat(doc, fmtBlk[0], fmtBlk[1], true);
                    }
                }
                finally {
                    doc.atomicUnlock();
                }
                if (moveBack != 0) {
                    Caret caret = c.getCaret();
                    int dot = caret.getDot();
                    caret.setDot(dot - moveBack);
                }
            }
            catch (BadLocationException exc) {
                return false;
            }
            catch (IOException exc) {
                return false;
            }
            return true;
        }

        public String getPaintText() {
            return this.getItemText();
        }
    }
}

