/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.swing.text.Document;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.openide.ErrorManager;

public class ELFunctions {
    public static List getFunctions(JspSyntaxSupport sup, String start) {
        ArrayList<Function> functions = new ArrayList<Function>();
        JspParserAPI.ParseResult result = JspUtils.getCachedParseResult((Document)sup.getDocument(), sup.getFileObject(), false, false);
        if (result != null) {
            Map libraries = result.getPageInfo().getTagLibraries();
            Map prefixes = result.getPageInfo().getJspPrefixMapper();
            for (String prefix : prefixes.keySet()) {
                TagLibraryInfo library = (TagLibraryInfo)libraries.get(prefixes.get(prefix));
                FunctionInfo[] fun = ELFunctions.getValidFunctions(library);
                for (int i = 0; i < fun.length; ++i) {
                    if (!(prefix + ":" + fun[i].getName()).startsWith(start)) continue;
                    functions.add(new Function(prefix, fun[i]));
                }
            }
        }
        return functions;
    }

    private static FunctionInfo[] getValidFunctions(TagLibraryInfo tli) {
        ArrayList<FunctionInfo> fis = new ArrayList<FunctionInfo>();
        for (FunctionInfo fi : tli.getFunctions()) {
            String msg = null;
            if (fi.getFunctionClass() == null || fi.getFunctionClass().length() == 0) {
                msg = "Invalid function class '" + fi.getFunctionClass() + "' in " + tli.getShortName() + " tag library.";
            } else if (fi.getName() == null || fi.getName().length() == 0) {
                msg = "Invalid function name '" + fi.getName() + "' in " + tli.getShortName() + " tag library.";
            } else if (fi.getFunctionSignature() == null || fi.getFunctionSignature().length() == 0) {
                msg = "Invalid function signature '" + fi.getFunctionSignature() + "' in " + tli.getShortName() + " tag library.";
            } else if (fi.getFunctionSignature().indexOf(fi.getName()) == -1) {
                msg = "Invalid function signature '" + fi.getFunctionSignature() + "' (doesn't contain function name) in " + tli.getShortName() + " tag library.";
            }
            if (msg == null) {
                fis.add(fi);
                continue;
            }
            ErrorManager.getDefault().log(1, msg);
        }
        return fis.toArray(new FunctionInfo[0]);
    }

    public static class Function {
        private String prefix;
        private FunctionInfo info;

        public Function(String prefix, FunctionInfo info) {
            this.info = info;
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public FunctionInfo getFunctionInfo() {
            return this.info;
        }

        public String getName() {
            return this.info.getName();
        }

        public String getReturnType() {
            int index;
            String signature = this.info.getFunctionSignature().trim();
            String type = null;
            if (!(signature == null && signature.equals("") || (index = signature.indexOf(this.info.getName())) <= -1)) {
                type = signature.substring(0, index).trim();
            }
            return type;
        }

        public String getParameters() {
            int index;
            String parameters = "";
            String signature = this.info.getFunctionSignature().trim();
            if (!(signature == null && signature.equals("") || (index = signature.indexOf(this.info.getName())) <= -1)) {
                parameters = signature.substring(index + 1).trim();
                if (parameters.indexOf(40) > -1) {
                    parameters = parameters.substring(parameters.indexOf(40) + 1);
                }
                if (parameters.indexOf(41) > -1) {
                    parameters = parameters.substring(0, parameters.indexOf(41));
                }
                StringTokenizer st = new StringTokenizer(parameters, ",");
                StringBuffer sb = new StringBuffer();
                while (st.hasMoreTokens()) {
                    String type = st.nextToken();
                    if (type.lastIndexOf(46) > -1) {
                        type = type.substring(type.lastIndexOf(46) + 1);
                    }
                    sb.append(type);
                    if (!st.hasMoreTokens()) continue;
                    sb.append(", ");
                }
                parameters = sb.toString();
            }
            return parameters;
        }
    }
}

