/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.editors.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.DDTableModel;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.DDTableModelEditor;

public class SortableDDTableModel
extends AbstractTableModel
implements DDTableModel {
    private DDTableModel modelDelegate;
    private boolean needsSorting;
    private List modelIndex;
    private Comparator comp;
    private int sortColumn;

    public SortableDDTableModel(DDTableModel model) {
        this.modelDelegate = model;
        this.modelIndex = new ArrayList(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.modelIndex.add(new DelegateReference(i));
        }
        this.comp = new Comparator(){

            public boolean equals(Object other) {
                return this == other;
            }

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof DelegateReference) || !(o2 instanceof DelegateReference)) {
                    throw new ClassCastException();
                }
                DelegateReference d1 = (DelegateReference)o1;
                DelegateReference d2 = (DelegateReference)o2;
                Comparable compo1 = (Comparable)SortableDDTableModel.this.modelDelegate.getValueAt(d1.ref, SortableDDTableModel.this.getSortColumn());
                Object comp2 = SortableDDTableModel.this.modelDelegate.getValueAt(d2.ref, SortableDDTableModel.this.getSortColumn());
                if (compo1 == null && comp2 == null) {
                    return 0;
                }
                if (compo1 == null) {
                    return -1;
                }
                if (comp2 == null) {
                    return 1;
                }
                return compo1.compareTo(comp2);
            }
        };
        this.setSortColumn(-1);
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public boolean isSortable() {
        return Comparable.class.isAssignableFrom(this.getColumnClass(this.getSortColumn()));
    }

    public void setSortColumn(int col) {
        if (col < 0 || col >= this.getColumnCount()) {
            this.sortColumn = col;
            return;
        }
        if (this.sortColumn != col || this.needsSorting) {
            this.sortColumn = col;
            this.sort();
            this.needsSorting = false;
        }
    }

    private void sort() {
        Collections.sort(this.modelIndex, this.comp);
        this.fireTableDataChanged();
    }

    private int getInd(int row) {
        return ((DelegateReference)this.modelIndex.get((int)row)).ref;
    }

    public int getColumnCount() {
        return this.modelDelegate.getColumnCount();
    }

    public String getColumnName(int col) {
        return this.modelDelegate.getColumnName(col);
    }

    public DDTableModelEditor getEditor() {
        return this.modelDelegate.getEditor();
    }

    public boolean isEditValid(Object value, int row) {
        return this.modelDelegate.isEditValid(value, row);
    }

    public List canRemoveRow(int row) {
        return this.modelDelegate.canRemoveRow(row);
    }

    public List isValueValid(Object value, int fromRow) {
        return this.modelDelegate.isValueValid(value, fromRow == -1 ? -1 : this.getInd(fromRow));
    }

    public Object getValueAt(int row, int col) {
        return this.modelDelegate.getValueAt(this.getInd(row), col);
    }

    public String getModelName() {
        return this.modelDelegate.getModelName();
    }

    public Object[] getValue() {
        Object[] rv = this.modelDelegate.getValue();
        return rv;
    }

    public int getRowCount() {
        return this.modelDelegate.getRowCount();
    }

    public Class getColumnClass(int col) {
        return this.modelDelegate.getColumnClass(col);
    }

    public boolean isCellEditable(int row, int col) {
        return this.modelDelegate.isCellEditable(this.getInd(row), col);
    }

    public Object getValueAt(int row) {
        return this.modelDelegate.getValueAt(this.getInd(row));
    }

    public void setValueAt(int row, Object value) {
        this.modelDelegate.setValueAt(this.getInd(row), value);
        this.needsSorting = true;
        this.setSortColumn(this.getSortColumn());
    }

    public void setValueAt(Object value, int row, int col) {
        this.modelDelegate.setValueAt(value, this.getInd(row), col);
        this.needsSorting = true;
        this.setSortColumn(this.getSortColumn());
    }

    public Object makeNewElement() {
        return this.modelDelegate.makeNewElement();
    }

    public void newElementCancelled(Object obj) {
        this.modelDelegate.newElementCancelled(obj);
    }

    public void editsCancelled() {
        this.modelDelegate.editsCancelled();
    }

    public void addRowAt(int row, Object newVal, Object editVal) {
        row = row == -1 ? this.getRowCount() : ++row;
        this.modelIndex.add(row, new DelegateReference(this.getRowCount()));
        this.modelDelegate.addRowAt(-1, newVal, editVal);
        this.fireTableRowsInserted(row, row);
        this.needsSorting = true;
        this.setSortColumn(this.getSortColumn());
    }

    public void removeRowAt(int row) {
        int delegateRow = this.getInd(row);
        this.modelDelegate.removeRowAt(delegateRow);
        this.modelIndex.remove(row);
        Iterator it = this.modelIndex.iterator();
        while (it.hasNext()) {
            DelegateReference del = (DelegateReference)it.next();
            if (del.ref >= delegateRow) {
                --del.ref;
            }
            this.fireTableRowsDeleted(row, row);
        }
    }

    private static class DelegateReference {
        public int ref;

        public DelegateReference(int ref) {
            this.ref = ref;
        }
    }
}

