/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualArchiveIncludesSupport;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualClassPathItem;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualClasspathSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VisualPropertySupport {
    private EarProjectProperties earProperties;
    private Map<Object, String> component2property;
    private ComponentListener componentListener;
    private int comboType = -1;
    private String[] comboValues;

    public VisualPropertySupport(EarProjectProperties earProperties) {
        this.earProperties = earProperties;
        this.component2property = new HashMap<Object, String>(10);
        this.componentListener = new ComponentListener();
    }

    public void register(JCheckBox component, String propertyName) {
        Boolean value = VisualPropertySupport.getAsType(this.earProperties, propertyName, Boolean.class);
        this.component2property.put(component, propertyName);
        component.setSelected(value != null && value != false);
        component.removeActionListener(this.componentListener);
        component.addActionListener(this.componentListener);
    }

    public void register(JTextField component, String propertyName) {
        String value = VisualPropertySupport.getAsType(this.earProperties, propertyName, String.class);
        this.component2property.put(component.getDocument(), propertyName);
        component.setText(value != null ? value : "");
        component.getDocument().addDocumentListener(this.componentListener);
    }

    public void register(VisualClasspathSupport component, String propertyName) {
        List<VisualClassPathItem> value = VisualPropertySupport.getAsType(this.earProperties, propertyName, List.class);
        this.component2property.put(component, propertyName);
        component.setVisualClassPathItems(value != null ? value : Collections.emptyList());
        component.removeActionListener(this.componentListener);
        component.addActionListener(this.componentListener);
    }

    public void register(VisualArchiveIncludesSupport component, String propertyName) {
        List<VisualClassPathItem> value = VisualPropertySupport.getAsType(this.earProperties, propertyName, List.class);
        this.component2property.put(component, propertyName);
        component.setVisualWarItems(value != null ? value : Collections.emptyList());
        component.removeActionListener(this.componentListener);
        component.addActionListener(this.componentListener);
    }

    public void register(JComboBox component, String[] items, String propertyName) {
        this.checkJComboBoxRegistered();
        this.comboType = 0;
        String value = VisualPropertySupport.getAsType(this.earProperties, propertyName, String.class);
        this.component2property.put(component, propertyName);
        component.removeAllItems();
        int selectedIndex = -1;
        for (int i = 0; i < items.length; ++i) {
            component.addItem(items[i]);
            if (!items[i].equals(value)) continue;
            selectedIndex = i;
        }
        if (selectedIndex > -1) {
            component.setSelectedIndex(selectedIndex);
        }
        component.removeActionListener(this.componentListener);
        component.addActionListener(this.componentListener);
    }

    public void register(JComboBox component, String[] displayNames, String[] values, String propertyName) {
        this.checkJComboBoxRegistered();
        this.comboType = 1;
        this.comboValues = values;
        String value = VisualPropertySupport.getAsType(this.earProperties, propertyName, String.class);
        this.component2property.put(component, propertyName);
        component.removeAllItems();
        int selectedIndex = 0;
        for (int i = 0; i < displayNames.length; ++i) {
            component.addItem(displayNames[i]);
            if (!values[i].equals(value)) continue;
            selectedIndex = i;
        }
        if (selectedIndex < component.getItemCount()) {
            component.setSelectedIndex(selectedIndex);
        }
        component.removeActionListener(this.componentListener);
        component.addActionListener(this.componentListener);
    }

    private void checkJComboBoxRegistered() {
        assert (this.comboType == -1) : "JComboBox already registered and only one instance per VisualPropertySupport is supported. Another VisualPropertySupport instance may be used.";
    }

    private static Boolean readValue(JCheckBox checkBox) {
        return checkBox.isSelected();
    }

    private static String readValue(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            assert (false) : e;
            return "";
        }
    }

    private static String readValue(JComboBox comboBox) {
        return (String)comboBox.getSelectedItem();
    }

    private static <T> T getAsType(EarProjectProperties earProperties, String propertyName, Class<T> expectedType) {
        return VisualPropertySupport.getAsType(earProperties, propertyName, expectedType, true);
    }

    private static <T> T getAsType(EarProjectProperties earProperties, String propertyName, Class<T> expectedType, boolean throwException) {
        Object result = null;
        Object value = earProperties.get(propertyName);
        if (value == null || expectedType.isInstance(value)) {
            result = value;
        } else if (throwException) {
            throw new IllegalArgumentException("Value of property: " + propertyName + " exbected to be: " + expectedType.getClass().getName() + " but was: " + value.getClass().getName() + "!");
        }
        return (T)result;
    }

    private class ComponentListener
    implements ActionListener,
    DocumentListener {
        private ComponentListener() {
        }

        public void actionPerformed(ActionEvent e) {
            block7: {
                String propertyName;
                Object source;
                block10: {
                    block9: {
                        block8: {
                            source = e.getSource();
                            propertyName = (String)VisualPropertySupport.this.component2property.get(source);
                            if (propertyName == null) break block7;
                            if (!(source instanceof JCheckBox)) break block8;
                            VisualPropertySupport.this.earProperties.put(propertyName, VisualPropertySupport.readValue((JCheckBox)source));
                            break block7;
                        }
                        if (!(source instanceof VisualClasspathSupport)) break block9;
                        VisualPropertySupport.this.earProperties.put(propertyName, ((VisualClasspathSupport)source).getVisualClassPathItems());
                        break block7;
                    }
                    if (!(source instanceof JComboBox)) break block10;
                    if (((JComboBox)source).getItemCount() == 0) {
                        return;
                    }
                    switch (VisualPropertySupport.this.comboType) {
                        case 0: {
                            VisualPropertySupport.this.earProperties.put(propertyName, VisualPropertySupport.readValue((JComboBox)source));
                            break block7;
                        }
                        case 1: {
                            VisualPropertySupport.this.earProperties.put(propertyName, VisualPropertySupport.this.comboValues[((JComboBox)source).getSelectedIndex()]);
                            break block7;
                        }
                        default: {
                            assert (false) : "Unknown comboType: " + VisualPropertySupport.access$400(VisualPropertySupport.this);
                            break block7;
                        }
                    }
                }
                if (source instanceof VisualArchiveIncludesSupport) {
                    VisualPropertySupport.this.earProperties.put(propertyName, ((VisualArchiveIncludesSupport)source).getVisualWarItems());
                }
            }
        }

        public void changedUpdate(DocumentEvent e) {
            Document document = e.getDocument();
            String propertyName = (String)VisualPropertySupport.this.component2property.get(document);
            if (propertyName != null) {
                VisualPropertySupport.this.earProperties.put(propertyName, VisualPropertySupport.readValue(document));
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }
    }
}

