# Configure paths for libuta
# stolen from Sam Lantinga 
# stolen from Manish Singh
# stolen back from Frank Belew
# stolen from Manish Singh
# Shamelessly stolen from Owen Taylor      

dnl AM_PATH_UTA([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for libuta, and define UTA_CFLAGS and UTA_LIBS
dnl
AC_DEFUN(AM_PATH_UTA,
[dnl
dnl Get the cflags and libraries from the uta-config script
dnl
AC_ARG_WITH(uta-prefix,[  --with-uta-prefix=PFX   Prefix where libuta is installed (optional)],
            uta_prefix="$withval", uta_prefix="")
AC_ARG_WITH(uta-exec-prefix,[  --with-uta-exec-prefix=PFX Exec prefix where libuta is installed
 (optional)],
            uta_exec_prefix="$withval", uta_exec_prefix="")    
  if test x$uta_exec_prefix != x ; then
     uta_args="$uta_args --exec-prefix=$uta_exec_prefix"
     if test x${UTA_CONFIG+set} != xset ; then
        UTA_CONFIG=$uta_exec_prefix/bin/uta-config
     fi
  fi
  if test x$uta_prefix != x ; then
     uta_args="$uta_args --prefix=$uta_prefix"
     if test x${UTA_CONFIG+set} != xset ; then
        UTA_CONFIG=$uta_prefix/bin/uta-config
     fi
  fi
 
  AC_PATH_PROG(UTA_CONFIG, uta-config, no)
  min_uta_version=ifelse([$1], ,0.3.32,$1)
  AC_MSG_CHECKING(for libuta - version >= $min_uta_version)
  no_uta=""
  if test "$UTA_CONFIG" = "no" ; then
    no_uta=yes
    AC_MSG_RESULT(no)
    ifelse([$3], , :, [$3])
  else
    UTA_CFLAGS=`$UTA_CONFIG $utaconf_args --cflags`
    UTA_LIBS=`$UTA_CONFIG $utaconf_args --libs`
 
    uta_major_version=`$UTA_CONFIG $uta_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    uta_minor_version=`$UTA_CONFIG $uta_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    uta_micro_version=`$UTA_CONFIG $uta_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    ac_save_CFLAGS="$CFLAGS"
    ac_save_LIBS="$LIBS"
    CFLAGS="$CFLAGS $UTA_CFLAGS"
    LIBS="$LIBS $UTA_LIBS"

    rm -f conf.utatest
    AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char*
my_strdup (char *str)
{
  char *new_str;
  
  if (str)
    {
      new_str = (char *)malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;
  
  return new_str;
}

int main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.utatest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_uta_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_uta_version");
     exit(1);
   }

   if (($uta_major_version > major) ||
      (($uta_major_version == major) && ($uta_minor_version > minor)) ||
      (($uta_major_version == major) && ($uta_minor_version == minor) && ($uta_micro_version >= micro)))
    {
      return 0;
    }
  else
    {
      printf("\n*** 'uta-config --version' returned %d.%d.%d, but the minimum version\n", $uta_major_version, $uta_minor_version, $uta_micro_version);
      printf("*** of libuta required is %d.%d.%d.\n", major, minor, micro);
      printf("*** If uta-config was wrong, set the environment variable UTA_CONFIG\n");
      printf("*** to point to the correct copy of uta-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
      return 1;
    }
}

],,no_uta=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       
    CFLAGS="$ac_save_CFLAGS"
    LIBS="$ac_save_LIBS"
    if test "x$no_uta" = x ; then
      AC_MSG_RESULT(yes)	
      ifelse([$2], , :, [$2])
    else
      AC_MSG_RESULT(no)
      ifelse([$3], , :, [$3])	
    fi
   fi
  AC_SUBST(UTA_CFLAGS)
  AC_SUBST(UTA_LIBS)
 
]) 
