/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class ComponentView
extends View {
    private Component comp;

    protected Component createComponent() {
        return StyleConstants.getComponent(this.getElement().getAttributes());
    }

    public float getAlignment(int n) {
        float f;
        if (n == 0) {
            f = this.getComponent().getAlignmentX();
        } else if (n == 1) {
            f = this.getComponent().getAlignmentY();
        } else {
            throw new IllegalArgumentException();
        }
        return f;
    }

    public final Component getComponent() {
        if (this.comp == null) {
            this.comp = this.createComponent();
        }
        return this.comp;
    }

    public float getMaximumSpan(int n) {
        float f;
        if (n == 0) {
            f = this.getComponent().getMaximumSize().width;
        } else if (n == 1) {
            f = this.getComponent().getMaximumSize().height;
        } else {
            throw new IllegalArgumentException();
        }
        return f;
    }

    public float getMinimumSpan(int n) {
        float f;
        if (n == 0) {
            f = this.getComponent().getMinimumSize().width;
        } else if (n == 1) {
            f = this.getComponent().getMinimumSize().height;
        } else {
            throw new IllegalArgumentException();
        }
        return f;
    }

    public float getPreferredSpan(int n) {
        float f;
        if (n == 0) {
            f = this.getComponent().getPreferredSize().width;
        } else if (n == 1) {
            f = this.getComponent().getPreferredSize().height;
        } else {
            throw new IllegalArgumentException();
        }
        return f;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Element element = this.getElement();
        if (n < element.getStartOffset() || n >= element.getEndOffset()) {
            throw new BadLocationException("Illegal offset for this view", n);
        }
        Rectangle rectangle = shape.getBounds();
        Component component = this.getComponent();
        return new Rectangle(rectangle.x, rectangle.y, component.getWidth(), component.getHeight());
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.getComponent().setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setParent(final View view) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setParentImpl(view);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public final void run() {
                    ComponentView.this.setParentImpl(view);
                }
            });
        }
    }

    private final void setParentImpl(View view) {
        super.setParent(view);
        if (view != null) {
            Component component = this.getComponent();
            view.getContainer().add(component);
        } else {
            Component component = this.getComponent();
            Container container = component.getParent();
            container.remove(component);
            this.comp = null;
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Element element = this.getElement();
        return element.getStartOffset();
    }

    public ComponentView(Element element) {
        super(element);
    }
}

