/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public final class PrivateCredentialPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 5284372143517237068L;
    private final String credentialClass;
    private final Set principals;
    private final boolean testing;

    public final boolean equals(Object object) {
        if (!(object instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)object;
        if (!privateCredentialPermission.getActions().equals(this.getActions())) {
            return false;
        }
        if (!privateCredentialPermission.getCredentialClass().equals(this.getCredentialClass())) {
            return false;
        }
        String[][] stringArray = this.getPrincipals();
        String[][] stringArray2 = privateCredentialPermission.getPrincipals();
        if (stringArray2 == null) {
            return false;
        }
        if (stringArray2.length != stringArray.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n][0].equals(stringArray2[n][0]) || !stringArray[n][1].equals(stringArray2[n][1])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final String getActions() {
        return "read";
    }

    public final String getCredentialClass() {
        return this.credentialClass;
    }

    public final String[][] getPrincipals() {
        String[][] stringArray = new String[this.principals.size()][];
        Iterator iterator = this.principals.iterator();
        int n = 0;
        while (n < this.principals.size() && iterator.hasNext()) {
            CredOwner credOwner = (CredOwner)iterator.next();
            stringArray[n] = new String[]{credOwner.getPrincipalClass(), credOwner.getPrincipalName()};
            ++n;
        }
        return stringArray;
    }

    public final int hashCode() {
        return this.credentialClass.hashCode() + this.principals.hashCode();
    }

    public final boolean implies(Permission permission) {
        if (!(permission instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)permission;
        if (!this.credentialClass.equals("*") && !this.credentialClass.equals(privateCredentialPermission.getCredentialClass())) {
            return false;
        }
        String[][] stringArray = this.getPrincipals();
        String[][] stringArray2 = privateCredentialPermission.getPrincipals();
        if (stringArray2 == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray[n][0].equals(stringArray2[n2][0]) && (stringArray[n][1].equals("*") || stringArray[n][1].equals(stringArray2[n2][1]))) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public final PermissionCollection newPermissionCollection() {
        return null;
    }

    public PrivateCredentialPermission(String string, String string2) {
        super(string);
        string2 = string2.trim().toLowerCase();
        if (!"read".equals(string2)) {
            throw new IllegalArgumentException("actions must be \"read\"");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"'");
        this.principals = new HashSet();
        if (stringTokenizer.countTokens() < 3 || (stringTokenizer.countTokens() & 1) == 0) {
            throw new IllegalArgumentException("badly formed credential name");
        }
        this.credentialClass = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            this.principals.add(new CredOwner(stringTokenizer.nextToken(), stringTokenizer.nextToken()));
        }
        this.testing = false;
    }

    private static class CredOwner
    implements Serializable {
        private final String principalClass;
        private final String principalName;

        public boolean equals(Object object) {
            if (!(object instanceof CredOwner)) {
                return false;
            }
            boolean bl = false;
            if (this.principalClass.equals(((CredOwner)object).getPrincipalClass()) && this.principalName.equals(((CredOwner)object).getPrincipalName())) {
                bl = true;
            }
            return bl;
        }

        public int hashCode() {
            return this.principalClass.hashCode() + this.principalName.hashCode();
        }

        public String getPrincipalClass() {
            return this.principalClass;
        }

        public String getPrincipalName() {
            return this.principalName;
        }

        CredOwner(String string, String string2) {
            this.principalClass = string;
            this.principalName = string2;
        }
    }
}

