/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.util.Arrays;
import javax.naming.RefAddr;

public class BinaryRefAddr
extends RefAddr {
    static final long serialVersionUID = -3415254970957330361L;
    private static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final byte[] buf;

    public Object getContent() {
        return this.buf;
    }

    public boolean equals(Object object) {
        if (object instanceof BinaryRefAddr) {
            BinaryRefAddr binaryRefAddr = (BinaryRefAddr)object;
            if (this.getType().equals(binaryRefAddr.getType())) {
                byte[] byArray = (byte[])this.getContent();
                byte[] byArray2 = (byte[])binaryRefAddr.getContent();
                return Arrays.equals(byArray, byArray2);
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        byte[] byArray = (byte[])this.getContent();
        int n2 = 0;
        while (n2 < byArray.length) {
            n ^= byArray[n2];
            ++n2;
        }
        return this.getType().hashCode() + n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[RefAddr type: ");
        stringBuffer.append(this.getType());
        stringBuffer.append(" content: 0x");
        byte[] byArray = (byte[])this.getContent();
        int n = 0;
        while (n < byArray.length && n < 32) {
            stringBuffer.append(hex[(byArray[n] & 0xF0) >> 4]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        if (byArray.length > 32) {
            stringBuffer.append("...");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public BinaryRefAddr(String string, byte[] byArray) {
        this(string, byArray, 0, byArray.length);
    }

    public BinaryRefAddr(String string, byte[] byArray, int n, int n2) {
        super(string);
        this.buf = new byte[n2];
        System.arraycopy(byArray, n, this.buf, 0, n2);
    }
}

