/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.TimerTask;

public class Timer {
    private static int nr;
    private TaskQueue queue = new TaskQueue();
    private Scheduler scheduler = new Scheduler(this.queue);
    private Thread thread;
    private boolean canceled = false;

    public void cancel() {
        this.canceled = true;
        this.queue.stop();
    }

    private final void schedule(TimerTask timerTask, long l, long l2, boolean bl) {
        if (l < 0L) {
            throw new IllegalArgumentException("negative time");
        }
        if (timerTask.scheduled != 0L || timerTask.lastExecutionTime != (long)-1) {
            throw new IllegalStateException("task was already scheduled or canceled");
        }
        timerTask.scheduled = l;
        timerTask.period = l2;
        timerTask.fixed = bl;
        if (this.canceled || this.thread == null) {
            throw new IllegalStateException("timer was canceled or scheduler thread has died");
        }
        this.queue.enqueue(timerTask);
    }

    private static final void positiveDelay(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("delay is negative");
        }
    }

    private static final void positivePeriod(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("period is negative");
        }
    }

    public void schedule(TimerTask timerTask, Date date) {
        long l = date.getTime();
        this.schedule(timerTask, l, -1, false);
    }

    public void schedule(TimerTask timerTask, Date date, long l) {
        Timer.positivePeriod(l);
        long l2 = date.getTime();
        this.schedule(timerTask, l2, l, false);
    }

    public void schedule(TimerTask timerTask, long l) {
        Timer.positiveDelay(l);
        long l2 = System.currentTimeMillis() + l;
        this.schedule(timerTask, l2, -1, false);
    }

    public void schedule(TimerTask timerTask, long l, long l2) {
        Timer.positiveDelay(l);
        Timer.positivePeriod(l2);
        long l3 = System.currentTimeMillis() + l;
        this.schedule(timerTask, l3, l2, false);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, Date date, long l) {
        Timer.positivePeriod(l);
        long l2 = date.getTime();
        this.schedule(timerTask, l2, l, true);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, long l, long l2) {
        Timer.positiveDelay(l);
        Timer.positivePeriod(l2);
        long l3 = System.currentTimeMillis() + l;
        this.schedule(timerTask, l3, l2, true);
    }

    protected void finalize() throws Throwable {
        this.queue.setNullOnEmpty(true);
    }

    public int purge() {
        return this.queue.purge();
    }

    public Timer() {
        this(false);
    }

    public Timer(boolean bl) {
        this(bl, 5);
    }

    public Timer(String string) {
        this(false, 5, string);
    }

    public Timer(String string, boolean bl) {
        this(bl, 5, string);
    }

    private Timer(boolean bl, int n) {
        this(bl, n, "Timer-" + ++nr);
    }

    private Timer(boolean bl, int n, String string) {
        this.thread = new Thread(this.scheduler, string);
        this.thread.setDaemon(bl);
        this.thread.setPriority(n);
        this.thread.start();
    }

    private static final class TaskQueue {
        private static final int DEFAULT_SIZE = 32;
        private boolean nullOnEmpty = false;
        private TimerTask[] heap = new TimerTask[32];
        private int elements = 0;

        private final void add(TimerTask timerTask) {
            ++this.elements;
            if (this.elements == this.heap.length) {
                TimerTask[] timerTaskArray = new TimerTask[this.heap.length * 2];
                System.arraycopy(this.heap, 0, timerTaskArray, 0, this.heap.length);
                this.heap = timerTaskArray;
            }
            this.heap[this.elements] = timerTask;
        }

        private final void remove() {
            this.heap[this.elements] = null;
            --this.elements;
            if (this.elements + 16 <= this.heap.length / 4) {
                TimerTask[] timerTaskArray = new TimerTask[this.heap.length / 2];
                System.arraycopy(this.heap, 0, timerTaskArray, 0, this.elements + 1);
                this.heap = timerTaskArray;
            }
        }

        public final synchronized void enqueue(TimerTask timerTask) {
            if (this.heap == null) {
                throw new IllegalStateException("cannot enqueue when stop() has been called on queue");
            }
            this.heap[0] = timerTask;
            this.add(timerTask);
            int n = this.elements;
            int n2 = n / 2;
            while (this.heap[n2].scheduled > timerTask.scheduled) {
                this.heap[n] = this.heap[n2];
                n = n2;
                n2 = n / 2;
            }
            this.heap[n] = timerTask;
            this.heap[0] = null;
            this.notify();
        }

        private final TimerTask top() {
            if (this.elements == 0) {
                return null;
            }
            return this.heap[1];
        }

        public final synchronized TimerTask serve() {
            TimerTask timerTask = null;
            while (timerTask == null) {
                timerTask = this.top();
                if (this.heap == null || timerTask == null && this.nullOnEmpty) {
                    return null;
                }
                if (timerTask != null) {
                    long l = timerTask.scheduled - System.currentTimeMillis();
                    if (l <= 0L) continue;
                    timerTask = null;
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            TimerTask timerTask2 = this.heap[this.elements];
            this.remove();
            int n = 1;
            int n2 = 2;
            this.heap[1] = timerTask2;
            while (n2 <= this.elements) {
                if (n2 < this.elements && this.heap[n2].scheduled > this.heap[n2 + 1].scheduled) {
                    ++n2;
                }
                if (timerTask2.scheduled <= this.heap[n2].scheduled) break;
                this.heap[n] = this.heap[n2];
                n = n2;
                n2 = n * 2;
            }
            this.heap[n] = timerTask2;
            return timerTask;
        }

        public final synchronized void setNullOnEmpty(boolean bl) {
            this.nullOnEmpty = bl;
            this.notify();
        }

        public final synchronized void stop() {
            this.heap = null;
            this.elements = 0;
            this.notify();
        }

        public final synchronized int purge() {
            int n = 0;
            int n2 = this.elements;
            while (n2 > 0) {
                if (this.heap[n2].scheduled < 0L) {
                    ++n;
                    int n3 = n2;
                    while (this.heap[n3] != null) {
                        int n4 = 2 * n3;
                        if (n4 >= this.heap.length) {
                            this.heap[n3] = null;
                            break;
                        }
                        if (n4 + 1 < this.heap.length && this.heap[n4 + 1] != null && (this.heap[n4] == null || this.heap[n4].scheduled > this.heap[n4 + 1].scheduled)) {
                            ++n4;
                        }
                        this.heap[n3] = this.heap[n4];
                        n3 = n4;
                    }
                }
                --n2;
            }
            n2 = this.heap.length;
            while (this.elements - n + 16 <= n2 / 4) {
                n2 /= 2;
            }
            if (n2 != this.heap.length) {
                TimerTask[] timerTaskArray = new TimerTask[n2];
                System.arraycopy(this.heap, 0, timerTaskArray, 0, this.elements + 1);
                this.heap = timerTaskArray;
            }
            return n;
        }
    }

    private static final class Scheduler
    implements Runnable {
        private TaskQueue queue;

        public final void run() {
            TimerTask timerTask;
            while ((timerTask = this.queue.serve()) != null) {
                if (timerTask.scheduled >= 0L) {
                    timerTask.lastExecutionTime = timerTask.scheduled;
                    if (timerTask.period < 0L) {
                        timerTask.scheduled = -1;
                    }
                    try {
                        timerTask.run();
                    }
                    catch (ThreadDeath threadDeath) {
                        this.queue.stop();
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        this.queue.stop();
                    }
                }
                if (timerTask.scheduled < 0L) continue;
                timerTask.scheduled = timerTask.fixed ? (timerTask.scheduled += timerTask.period) : timerTask.period + System.currentTimeMillis();
                try {
                    this.queue.enqueue(timerTask);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }

        public Scheduler(TaskQueue taskQueue) {
            this.queue = taskQueue;
        }
    }
}

