/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Pattern;

public final class String
implements Serializable,
Comparable,
CharSequence {
    static final int STRINGBUFFER_SLOP = 32;
    private static final long serialVersionUID = -6849794470754667710L;
    public static final Comparator CASE_INSENSITIVE_ORDER = new ICComp();
    final char[] value;
    final int offset;
    final int count;
    private boolean interned;
    private int hash;

    public final char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException("index = " + n + ", length=" + this.count);
        }
        return this.value[this.offset + n];
    }

    public final int compareTo(Object object) {
        return this.compareTo((String)object);
    }

    public final int compareTo(String string) {
        int n = Math.min(this.count, string.count);
        int n2 = 0;
        while (n2 < n) {
            char c = this.value[this.offset + n2];
            char c2 = string.value[string.offset + n2];
            if (c != c2) {
                return c - c2;
            }
            ++n2;
        }
        return this.count - string.count;
    }

    public final int compareToIgnoreCase(String string) {
        return this.toUpperCase().toLowerCase().compareTo(string.toUpperCase().toLowerCase());
    }

    public final String concat(String string) {
        if (string.count == 0) {
            return this;
        }
        char[] cArray = new char[this.count + string.count];
        this.getChars(0, this.count, cArray, 0);
        string.getChars(0, string.count, cArray, this.count);
        return new String(0, cArray.length, cArray);
    }

    public static final String copyValueOf(char[] cArray) {
        return String.copyValueOf(cArray, 0, cArray.length);
    }

    public static final String copyValueOf(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray2 = new char[n2];
        if (n2 > 0) {
            System.arraycopy(cArray, n, cArray2, 0, n2);
        }
        return new String(0, n2, cArray2);
    }

    public final boolean endsWith(String string) {
        return this.regionMatches(false, this.count - string.count, string, 0, string.count);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof String)) {
            return false;
        }
        String string = (String)object;
        if (this.count != string.count) {
            return false;
        }
        int n = this.offset;
        int n2 = string.offset;
        int n3 = n + this.count;
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        while (n < n3) {
            if (cArray[n] != cArray2[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public final boolean equalsIgnoreCase(String string) {
        if (string == null || this.count != string.count) {
            return false;
        }
        int n = this.offset;
        int n2 = string.offset;
        int n3 = n + this.count;
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        while (n < n3) {
            if (cArray[n] != cArray2[n2] && Character.toUpperCase(cArray[n]) != Character.toUpperCase(cArray2[n2])) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public final byte[] getBytes() {
        try {
            return this.getBytes(System.getProperty("file.encoding"));
        }
        catch (Exception var1_1) {
            var2_2 = new byte[this.count];
            var3_3 = 0;
            ** while (var3_3 < this.count)
        }
lbl-1000:
        // 1 sources

        {
            var2_2[var3_3] = (byte)(this.value[this.offset + var3_3] <= '\u00ff' ? this.value[this.offset + var3_3] : 63);
            ++var3_3;
            continue;
        }
lbl10:
        // 1 sources

        return var2_2;
    }

    public final byte[] getBytes(String string) throws UnsupportedEncodingException {
        try {
            CharsetEncoder charsetEncoder = Charset.forName(string).newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(this.value, this.offset, this.count));
            if (byteBuffer.hasArray()) {
                return byteBuffer.array();
            }
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            return byArray;
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new UnsupportedEncodingException("Encoding: " + string + " not found.");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new UnsupportedEncodingException("Encoding: " + string + " not found.");
        }
        catch (CharacterCodingException characterCodingException) {
            throw (InternalError)new InternalError().initCause(characterCodingException);
        }
    }

    public final void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (n < 0 || n > n2 || n3 < 0 || n3 + (n2 - n) > byArray.length || n2 > this.offset + this.count) {
            throw new IndexOutOfBoundsException("");
        }
        int n4 = n2 - n;
        int n5 = 0;
        while (n5 < n4) {
            byArray[n3 + n5] = (byte)this.value[this.offset + n + n5];
            ++n5;
        }
    }

    public final void getChars(int n, int n2, char[] cArray, int n3) {
        System.arraycopy(this.value, this.offset + n, cArray, n3, n2 - n);
    }

    public final int hashCode() {
        if (this.hash == 0 && this.count > 0) {
            int n = 0;
            int n2 = this.offset + this.count;
            int n3 = this.offset;
            while (n3 < n2) {
                n = 31 * n + this.value[n3];
                ++n3;
            }
            this.hash = n;
        }
        return this.hash;
    }

    public final int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public final native int indexOf(String var1, int var2);

    public final int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public final int indexOf(int n, int n2) {
        char c = (char)n;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        while (n3 < this.count) {
            if (this.value[this.offset + n3] == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public final int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    /*
     * Unable to fully structure code
     */
    public final int lastIndexOf(String var1_1, int var2_2) {
        var3_3 = var1_1.offset + var1_1.count - 1;
        var4_4 = this.offset + var2_2 + var1_1.count - 1;
        var5_5 = 0;
        if (var4_4 >= this.offset + this.count) {
            var4_4 = this.offset + this.count - 1;
        }
        if (var1_1.count != 0) ** GOTO lbl18
        return var2_2 < 0 ? -1 : (var2_2 < this.count ? var2_2 : this.count);
lbl-1000:
        // 1 sources

        {
            if (this.value[var4_4] == var1_1.value[var3_3]) {
                --var3_3;
                if (++var5_5 == var1_1.count) {
                    return var4_4 - this.offset;
                }
            } else if (var5_5 > 0) {
                ++var4_4;
                var5_5 = 0;
                var3_3 = var1_1.offset + var1_1.count - 1;
            }
            --var4_4;
lbl18:
            // 2 sources

            ** while (var4_4 >= this.offset)
        }
lbl19:
        // 1 sources

        return -1;
    }

    public final int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public final int lastIndexOf(int n, int n2) {
        char c = (char)n;
        if (c != n) {
            return -1;
        }
        if (n2 >= this.count) {
            n2 = this.count - 1;
        }
        if (n2 < 0) {
            return -1;
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (this.value[this.offset + n3] == c) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public final int length() {
        return this.count;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean regionMatches(boolean var1_1, int var2_2, String var3_3, int var4_4, int var5_5) {
        block5: {
            if (var2_2 < 0 || var2_2 + var5_5 > this.count || var4_4 < 0 || var4_4 + var5_5 > var3_3.count) {
                return false;
            }
            var6_6 = this.offset + var2_2;
            var7_7 = var3_3.offset + var4_4;
            if (var1_1) ** GOTO lbl17
            while (var5_5-- > 0) {
                if (this.value[var6_6] != var3_3.value[var7_7]) {
                    return false;
                }
                ++var6_6;
                ++var7_7;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                if (Character.toLowerCase(this.value[var6_6]) != Character.toLowerCase(var3_3.value[var7_7]) && Character.toUpperCase(this.value[var6_6]) != Character.toUpperCase(var3_3.value[var7_7])) {
                    return false;
                }
                ++var6_6;
                ++var7_7;
lbl17:
                // 2 sources

                ** while (var5_5-- > 0)
            }
        }
        return true;
    }

    public final boolean regionMatches(int n, String string, int n2, int n3) {
        return this.regionMatches(false, n, string, n2, n3);
    }

    public final String replace(char c, char c2) {
        if (c == c2) {
            return this;
        }
        char[] cArray = new char[this.count];
        boolean bl = false;
        int n = 0;
        while (n < this.count) {
            char c3 = this.value[this.offset + n];
            if (c3 == c) {
                bl = true;
                cArray[n] = c2;
            } else {
                cArray[n] = c3;
            }
            ++n;
        }
        if (!bl) {
            return this;
        }
        return new String(0, this.count, cArray);
    }

    public final boolean startsWith(String string) {
        return this.regionMatches(false, 0, string, 0, string.count);
    }

    public final boolean startsWith(String string, int n) {
        return this.regionMatches(false, n, string, 0, string.count);
    }

    public final String substring(int n) {
        return this.substring(n, this.count);
    }

    public final String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        if (n == 0 && n2 == this.count) {
            return this;
        }
        return new String(this.offset + n, this.offset + n2, this.value);
    }

    public final CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public final char[] toCharArray() {
        char[] cArray = new char[this.count];
        if (this.count > 0) {
            this.getChars(0, this.count, cArray, 0);
        }
        return cArray;
    }

    public final String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public final String toLowerCase(Locale locale) {
        char[] cArray = new char[this.count];
        int n = 0;
        while (n < this.count) {
            cArray[n] = Character.toLowerCase(this.value[this.offset + n]);
            ++n;
        }
        return new String(0, this.count, cArray);
    }

    public final String toString() {
        return this;
    }

    public final String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public final String toUpperCase(Locale locale) {
        char[] cArray = new char[this.count];
        int n = 0;
        while (n < this.count) {
            cArray[n] = Character.toUpperCase(this.value[this.offset + n]);
            ++n;
        }
        return new String(0, this.count, cArray);
    }

    /*
     * Unable to fully structure code
     */
    public final String trim() {
        var1_1 = this.offset;
        var2_2 = this.offset + this.count - 1;
        while (var1_1 <= var2_2 && this.value[var1_1] <= ' ') {
            ++var1_1;
        }
        if (var1_1 <= var2_2) ** GOTO lbl9
        return "";
lbl-1000:
        // 1 sources

        {
            --var2_2;
lbl9:
            // 2 sources

            ** while (var2_2 > var1_1 && this.value[var2_2] <= ' ')
        }
lbl10:
        // 1 sources

        return this.substring(var1_1 - this.offset, var2_2 + 1 - this.offset);
    }

    public static final String valueOf(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static final String valueOf(char[] cArray) {
        return String.valueOf(cArray, 0, cArray.length);
    }

    public static final String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2, false);
    }

    public static final String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    public static final String valueOf(char c) {
        return new String(new char[]{c}, 0, 1, true);
    }

    public static final String valueOf(int n) {
        return Integer.toString(n, 10);
    }

    public static final String valueOf(long l) {
        return Long.toString(l);
    }

    public static final String valueOf(float f) {
        return Float.toString(f);
    }

    public static final String valueOf(double d) {
        return Double.toString(d);
    }

    public final String intern() {
        return this.interned ? this : String.intern0(this);
    }

    private static final synchronized native String intern0(String var0);

    static final char[] zeroBasedStringValue(String string) {
        char[] cArray;
        if (string.offset == 0 && string.count == string.value.length) {
            cArray = string.value;
        } else {
            int n = string.count;
            cArray = new char[n];
            System.arraycopy(string.value, string.offset, cArray, 0, n);
        }
        return cArray;
    }

    public final boolean matches(String string) {
        return Pattern.matches(string, this);
    }

    public final String replaceFirst(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceFirst(string2);
    }

    public final String replaceAll(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceAll(string2);
    }

    public final String[] split(String string, int n) {
        return Pattern.compile(string).split(this, n);
    }

    public final String[] split(String string) {
        return Pattern.compile(string).split(this, 0);
    }

    public final boolean contains(CharSequence charSequence) {
        boolean bl = false;
        if (this.indexOf(charSequence.toString()) != -1) {
            bl = true;
        }
        return bl;
    }

    public final String replace(CharSequence charSequence, CharSequence charSequence2) {
        String string = charSequence.toString();
        String string2 = charSequence2.toString();
        int n = charSequence.length();
        int n2 = charSequence2.length();
        int n3 = this.indexOf(string);
        StringBuilder stringBuilder = new StringBuilder(this);
        while (n3 != -1) {
            stringBuilder.replace(n3, n3 + n, string2);
            n3 = stringBuilder.indexOf(string, n3 + n2);
        }
        return stringBuilder.toString();
    }

    public final int offsetByCodePoints(int n, int n2) {
        if (n < 0 || n > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePoints(this.value, this.offset, this.count, this.offset + n, n2);
    }

    public String() {
        this.value = new char[0];
        this.offset = 0;
        this.count = 0;
    }

    public String(String string) {
        this.value = string.value;
        this.offset = string.offset;
        this.count = string.count;
        this.hash = string.hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            block4: {
                block3: {
                    if (stringBuffer.value.length <= stringBuffer.count + 32) break block3;
                    this.value = new char[stringBuffer.count];
                    this.offset = 0;
                    this.count = stringBuffer.count;
                    stringBuffer.getChars(0, this.count, this.value, 0);
                    break block4;
                }
                this.value = stringBuffer.value;
                this.offset = 0;
                this.count = stringBuffer.count;
                stringBuffer.shared = true;
            }
            return;
        }
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    public String(byte[] var1_1, int var2_2, int var3_3) {
        block6: {
            super();
            if (var2_2 < 0 || var3_3 < 0 || var2_2 + var3_3 > var1_1.length) {
                throw new StringIndexOutOfBoundsException();
            }
            try {
                var7_4 = System.getProperty("file.encoding");
                var8_5 = Charset.forName(var7_4).newDecoder();
                var8_5.onMalformedInput(CodingErrorAction.REPLACE);
                var8_5.onUnmappableCharacter(CodingErrorAction.REPLACE);
                var9_7 = var8_5.decode(ByteBuffer.wrap(var1_1, var2_2, var3_3));
                if (var9_7.hasArray()) {
                    var6_9 = var9_7.array();
                    var4_10 = var9_7.position();
                    var5_11 = var9_7.remaining();
                } else {
                    var6_9 = new char[var9_7.remaining()];
                    var9_7.get(var6_9);
                    var4_10 = 0;
                    var5_11 = var6_9.length;
                }
                break block6;
            }
            catch (Exception var8_6) {
                var6_9 = new char[var3_3];
                var4_10 = 0;
                var5_11 = var3_3;
                var9_8 = 0;
                ** while (var9_8 < var3_3)
            }
lbl-1000:
            // 1 sources

            {
                var6_9[var9_8] = (char)var1_1[var2_2 + var9_8];
                ++var9_8;
                continue;
            }
        }
        this.value = var6_9;
        this.offset = var4_10;
        this.count = var5_11;
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new StringIndexOutOfBoundsException();
        }
        try {
            CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder();
            charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(byArray, n, n2));
            if (charBuffer.hasArray()) {
                this.value = charBuffer.array();
                this.offset = charBuffer.position();
                this.count = charBuffer.remaining();
            } else {
                this.value = new char[charBuffer.remaining()];
                charBuffer.get(this.value);
                this.offset = 0;
                this.count = this.value.length;
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new UnsupportedEncodingException("Encoding: " + string + " not found.");
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new UnsupportedEncodingException("Encoding: " + string + " not found.");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new UnsupportedEncodingException("Encoding: " + string + " not found.");
        }
    }

    public String(byte[] byArray, int n, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.value = new char[n3];
        this.offset = 0;
        this.count = n3;
        n = (n & 0xFF) << 8;
        int n4 = 0;
        while (n4 < n3) {
            this.value[n4] = (char)(n | byArray[n4 + n2] & 0xFF);
            ++n4;
        }
    }

    public String(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public String(char[] cArray, int n, int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        this.value = new char[n2];
        this.offset = 0;
        this.count = n2;
        System.arraycopy(cArray, n, this.value, 0, n2);
    }

    String(int n, int n2, char[] cArray) {
        this.value = cArray;
        this.offset = n;
        this.count = n2 - n;
    }

    public String(StringBuilder stringBuilder) {
        this(stringBuilder.value, 0, stringBuilder.count);
    }

    String(char[] cArray, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (bl) {
            this.value = cArray;
            this.offset = n;
        } else {
            this.value = new char[n2];
            System.arraycopy(cArray, n, this.value, 0, n2);
            this.offset = 0;
        }
        this.count = n2;
    }

    private static class ICComp
    implements Comparator,
    Serializable {
        public int compare(Object object, Object object2) {
            return ((String)object).compareToIgnoreCase((String)object2);
        }

        private ICComp() {
        }
    }
}

