/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BufferedInputStream
extends FilterInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos;
    protected int marklimit;
    private final int bufferSize;

    public synchronized int available() throws IOException {
        return this.count - this.pos + super.available();
    }

    public void close() throws IOException {
        this.buf = null;
        this.count = 0;
        this.pos = 0;
        this.markpos = -1;
        super.close();
    }

    public synchronized void mark(int n) {
        this.marklimit = n;
        this.markpos = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() throws IOException {
        if (this.pos >= this.count && !this.refill()) {
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || byArray.length - n < n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.pos >= this.count && !this.refill()) {
            return -1;
        }
        int n3 = Math.min(this.count - this.pos, n2);
        System.arraycopy(this.buf, this.pos, byArray, n, n3);
        this.pos += n3;
        n += n3;
        n2 -= n3;
        while (n2 > 0 && super.available() > 0 && this.refill()) {
            int n4 = Math.min(this.count - this.pos, n2);
            System.arraycopy(this.buf, this.pos, byArray, n, n4);
            this.pos += n4;
            n += n4;
            n2 -= n4;
            n3 += n4;
        }
        return n3;
    }

    public synchronized void reset() throws IOException {
        if (this.markpos == -1) {
            throw new IOException(this.buf == null ? "Stream closed." : "Invalid mark.");
        }
        this.pos = this.markpos;
    }

    public synchronized long skip(long l) throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed.");
        }
        long l2 = l;
        while (l > 0L) {
            if (this.pos >= this.count && !this.refill()) break;
            int n = (int)Math.min((long)(this.count - this.pos), l);
            this.pos += n;
            l -= (long)n;
        }
        return l2 - l;
    }

    private final boolean refill() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed.");
        }
        if (this.markpos == -1 || this.count - this.markpos >= this.marklimit) {
            this.markpos = -1;
            this.count = 0;
            this.pos = 0;
        } else {
            byte[] byArray = this.buf;
            if (this.markpos < this.bufferSize) {
                byArray = new byte[this.count - this.markpos + this.bufferSize];
            }
            System.arraycopy(this.buf, this.markpos, byArray, 0, this.count - this.markpos);
            this.buf = byArray;
            this.count -= this.markpos;
            this.pos -= this.markpos;
            this.markpos = 0;
        }
        int n = super.read(this.buf, this.count, this.bufferSize);
        if (n <= 0) {
            return false;
        }
        this.count += n;
        return true;
    }

    private final /* synthetic */ void this() {
        this.markpos = -1;
    }

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, 2048);
    }

    public BufferedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.this();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[n];
        this.count = this.bufferSize = n;
        this.pos = this.bufferSize;
    }
}

